/*******************************************************************************
 Replication programs for 
 
 "Are there no wage returns to compulsory schooling in Germany? A reassessment"	 
																		     	 																			 	 
 by		Kamila Cygan-Rehm                               				
		Friedrich-Alexander University Erlangen-Nürnberg
			
		Email: kamila.cygan-rehm@fau.de			 	 
																			 	 
											 	 
 February, 2021								 	 
																			 	 
*******************************************************************************/
clear all
version 15
set more off

capture log close
*set paths for the log file
global logfile ""
log using "${logfile}\returns.log", replace

*set paths for original data
global logfile " "
global data79 " "
global data85 " "
global data92 " "
global data99 " "

*put here names of the original files from the BIBB 
global file79 " "
global file85 " "
global file92 " "
global file99 " "

*set paths for temporary samples and the final estimation sample 
global sample " "

*set paths for do-files
global dofile " "

*generate the results
*** 1: data preparation 
do "$dofile\1_data_preparation.do"

*** 2: replication (Appendix Tables C.1, C.2, C.3 and Figure B.1) 
do "$dofile\2_replication.do"

*** 3: results for wage returns (Table 1 and Appendix Figure C.1)
do "$dofile\3_wages.do"

*** 4: results for completed degree (Appendix Table C.4)
do "$dofile\4_degree.do"

log close
