%--------------------------------------------------------------------------
%
% Sample code to generate Bayesian posterior credible sets from the estimated 
% likelihood in each sample path for different specifications of the
% solution and filtering algorithm described in the paper: "Likelihood 
% Evaluation of DSGE Models with Occassionally Binding Constraints" 
% 
% The draws are constructed with a Uniform prior for the parameter of
% gamma over the range from 0 through 4.5. 
% 
% See Readme.txt for implementation details.
%
% Pablo Cuba-Borda, Luca Guerrieri, Matteo Iacoviello and Molin Zhong
% Federal Reserve Board. Washington, D.C. 
%
% Created: 11/01/2017.
% Last modified: 04/23/2019.
%--------------------------------------------------------------------------

clear; clc;

basepath = '';              %Adjust based on local configuration
basename = 'MC100GAM1_';    % Do not change
basesample = 'sample100';
specname = 'VFI_ME20_';
M = dlmread([basepath basename num2str(1) '_' specname basesample '.txt'],',');
gammagrid = M(:,2);

nburn = 10000;
ndraws = 10000;
nsamp = 1;
gammadraws = zeros(ndraws,nsamp);
credsetdraws = zeros(2,nsamp);
acceptind = zeros(ndraws,nsamp);
gammaout = zeros(ndraws,nsamp);

for iDraw=0:99
    iDraw

    %--------------------------------------------------------------------------
    % VFI + PF
    %--------------------------------------------------------------------------

    M = dlmread([basepath basename num2str(iDraw) '_' specname basesample '.txt'],',');
    keep_temp = M(:,3)';
    LIKIMAT.VFI.ME5(iDraw+1,:) = keep_temp;
    [~,i]= max(keep_temp);
    
    % Let's take 10000 draws from the distribution
    gammaold = 2 + 0.2*randn(1);
    likiold = interp1(gammagrid,keep_temp',gammaold);
    
    for i = 1:nburn
        gammadraw = gammaold + 0.5*randn(1);
        likinew = interp1(gammagrid,keep_temp',gammadraw);
        sampunif = rand(1);
        if sampunif < exp(likinew-likiold)
            likiold = likinew;
            gammaold = gammadraw;
        end
    end
    
    for i = 1:ndraws
        gammadraw = gammaold + 0.5*randn(1);
        if gammadraw > 4.5 || gammadraw < 0.1
            if gammadraw > 4.5
                gammaout(i,iDraw+1) = 1;
            end
            %These are the draws we are really worried about            
            if gammadraw > 0 && gammadraw < 0.1
                gammaout(i,iDraw+1) = 1;
            end
        else
            likinew = interp1(gammagrid,keep_temp',gammadraw);
            sampunif = rand(1);
            if sampunif < exp(likinew-likiold)
                likiold = likinew;
                gammaold = gammadraw;
                acceptind(i,iDraw+1) = 1;
            else
                acceptind(i,iDraw+1) = 0;
            end
            gammaout(i,iDraw+1) = 0;            
        end
        gammadraws(i,iDraw+1) = gammaold;
    end
    %What do the 80% credible sets look like?
    credsetdraws(1,iDraw+1) = quantile(gammadraws(:,iDraw+1),0.1);
    credsetdraws(2,iDraw+1) = quantile(gammadraws(:,iDraw+1),0.9);
end

savefilename = ['distdraws_' basename specname basesample '.mat'];
save(savefilename,'gammadraws','credsetdraws','acceptind','gammaout');