function[simC,simZ,simB,simEC] = simulate_global(M,B,P,Z,Bdec,Cdec,T,R,GAMMAC,BETA,RHO,STD_U,makeplots)
%This function takes in a starting value: M, B states in decision matrix, Transition matrix: P, income states Z, Decision
%rules: Bdec,Cdec, Length of simulation T, Interest rate R, params of
%income process RHO and STD_U
% Returns simulations for consumption simC, income simZ, borrowing simB,
% expected consumption simEC



% Simulate decision rules of agents in Deaton-Huggett-Aiyagari model

bss = M;

N=1;
simC    = ones(1,T)-(R-1)*bss  ;
simZ    = ones(1,T)  ;
simB    = ones(1,T)*bss ;
simEC   = simC;

ECdec=(P*Cdec);

%--------------------------------------------------------------------
% Generate random numbers
%--------------------------------------------------------------------

if exist('r')==0
  rand_process=randn(1,T);
  r=rand_process;
end

if exist('bstock')==1
  simZ(1) = 1  ;
  simB1 = bss*(1+bstock(ibstock));
  simB(1) = lininterpn(Z,B,Bdec,simZ(1),simB1);
  simC(1) = simZ(1) + simB(1) - R*simB1;
  simEC(1) = lininterpn(Z,B,ECdec,simZ(1),simB1) ;
end

if exist('r')==1 && abs(numel(r)-T)>0
  rand_process=randn(N,T);
  r=rand_process;
end


%--------------------------------------------------------------------
% For each agent, generate a sequence of income realizations
% Do agents first, then time
%--------------------------------------------------------------------
% wait_time = waitbar(0,'Please wait, generating income realizations and calculating decision rules');


for t = 2:T
  
  simZ(t) = exp(RHO*log(simZ(t-1)) + STD_U*r(t)) ;
  
  warning off
  simB(t) = lininterpn(Z,B,Bdec,simZ(t),simB(t-1)) ;
  simB(t) = min(simB(t),M*simZ(t));
  simEC(t) = lininterpn(Z,B,ECdec,simZ(t),simB(t-1)) ;
  
end







%-------------------------------------------------------------------
% Once simulated income and savings are calculated
% generate consumption and a bunch of nice plots
%--------------------------------------------------------------------

simC(2:T) = simZ(2:T) + simB(2:T) - R*simB(1:T-1);
BB=mean(simB);
BB_std=std(simB);

simLB = 1./simC.^GAMMAC - BETA*R./simEC.^GAMMAC ;

% makeplots=0;

if makeplots==1
figure
subplot(2,2,1) ; plot(simZ,'Linewidth',2); title('Simulated income')
subplot(2,2,2) ; plot(simB,'Linewidth',2); title('Simulated borrowing')
% hold on; plot(simB*0+bmin,'y','Linewidth',2); hold on; 
% hold on; plot(simZ*M,'r','Linewidth',2); 
% legend('actual','min','max')

subplot(2,2,3) ; plot(simC,'r','Linewidth',2); 
legend('Consumption')

subplot(2,2,4) ; title('Simulated borrowing to income')
hold on; plot(simB./simZ,'m','Linewidth',2); hold on; 
hold on; plot(simZ.^0*M,'k','Linewidth',2); 
legend('actual','max')

end
