#include "fintrf.h"
    !======================================================================
#if 0
    !
    !     myparticlefilter_global.F
    !     .F file needs to be preprocessed to generate .for equivalent
    !
#endif
    !
    !     myparticlefilter_global.F Implements the bootstrap particle filter
    !     for the consumptions-savings problem of Guerrieri and Iacoviello (2016)
    !
    !     The model is solved using VFI over a discrete grid of 15x200
    !
    !     Written by: Pablo Cuba-Borda.
    !                 Federal Reserve Board, Washington D.C.
    !
    !     This Version: November 27, 2017
    !======================================================================

C TO DO: [11/20/2017]
C-------------------------------------------------------------------------------
C       1. Draw shocks from normal distribution (Might need to pass shocks to test code)
C           Done but with some glitches
C-------------------------------------------------------------------------------


    !--------------------------
    !     Gateway routine
    !--------------------------

      subroutine mexFunction(nlhs, plhs, nrhs, prhs)

      implicit none

C    ! Real Kind ->  Ask for 15 digits of precision
      integer, parameter :: rk = selected_real_kind(15, 307)

C    !     mexFunction arguments:
      mwPointer plhs(*), prhs(*)
      integer nlhs, nrhs

C    !     Function declarations:

      mwPointer mxCreateDoubleMatrix, mxGetPr
      integer mxIsNumeric
      mwSize mxGetM, mxGetN
      real*8  mxGetScalar

C    !     INPUT/OUTPUT POINTERS ( IN ORDER!!!)

      mwPointer L_pr, B_pr, P_pr, Z_pr, Bd_pr, Cd_pr, obs_pr
      mwPointer errval_pr, errmat_pr

C    !     CONSTANTS FOR ARRAYS SIZE:
      mwsize nz, nb, nobs, np

C    !     DECLARATIONS FOR TYPES FOR I/O OF COMPUTATIONAL ROUTINE
      integer*4 numel_mat, numel_vec    ! Maximum sife of array (m*n)<= numel
      parameter(numel_mat = 10000000)    ! Set numel for matrix and vectors
      parameter(numel_vec = 10000)
      real(kind = rk) L_out(numel_vec)


C    ! Pointers for inputs
      real(kind = rk) B_in(numel_vec)
      real(kind = rk) P_in(numel_mat)
      real(kind = rk) Z_in(numel_vec)
      real(kind = rk) Bd_in(numel_mat)
      real(kind = rk) Cd_in(numel_mat)
      real(kind = rk) obs_in(numel_vec)
      real(kind = rk) errval_in(numel_mat)    !Shocks for initialization
      real(kind = rk) errmat_in(numel_mat)    !Shocks for filtering
      real(kind = rk) sigm


C    ! ### GET ARRAYS SIZES ###
      nz        = mxGetM(prhs(4))	   ! rows of Bdec (z-grid points)
      nb        = mxGetN(prhs(4))	   ! columns Bdec (B-grid points)
      nobs      = mxGetM(prhs(6))    ! rows of obs
      np        = mxGetN(prhs(7))    ! number of particles

C    ! --------------------------------------------------------------
C    ! ### MAP INPUTS AND OUTPUTS OF FUNCTION TO FORTRAN OBJECTS ###
C    ! --------------------------------------------------------------

C    !     ASSIGN INPUT AND OUTPUT ARGUMENTS
      plhs(1)  = mxCreateDoubleMatrix(nobs,1,0)

C    !     ASSOCIATE POINTERS OF RHS ARGUMENTS
      B_pr  = mxGetPr(prhs(1))
      P_pr  = mxGetPr(prhs(2))
      Z_pr  = mxGetPr(prhs(3))
      Bd_pr = mxGetPr(prhs(4))
      Cd_pr = mxGetPr(prhs(5))
      obs_pr = mxGetPr(prhs(6))
      errval_pr = mxGetPr(prhs(7))
      errmat_pr = mxGetPr(prhs(8))
      sigm  = mxGetScalar(prhs(9))


C    !	  ASSOCIATE POINTER OF RHS
      L_pr = mxGetPr(plhs(1))

C    !    PASS POINTERS TO OBJECTS (Pointer, Variable, Number of elements)
      call mxCopyPtrToReal8(B_pr, B_in, nb)
      call mxCopyPtrToReal8(P_pr, P_in, nz*nz)
      call mxCopyPtrToReal8(Z_pr, Z_in, nz)
      call mxCopyPtrToReal8(Bd_pr,Bd_in, nz*nb)
      call mxCopyPtrToReal8(Cd_pr,Cd_in, nz*nb)
      call mxCopyPtrToReal8(obs_pr,obs_in, nobs)
      call mxCopyPtrToReal8(errval_pr,errval_in, 50*np)
      call mxCopyPtrToReal8(errmat_pr,errmat_in, nobs*np)
C    !     CALL COMPUTATIONAL ROUTINE
      call particlefilter(L_out, B_in, P_in, Z_in, Bd_in, Cd_in, obs_in,
     + errval_in, errmat_in, sigm, nz, nb, nobs, np)

C       PASS OUTPUT POINTER TO VARIABLE, THIS IS THE OUTPUT FOR MATLAB
      call mxCopyReal8ToPtr(L_out,L_pr,nobs)            ! Write output to lhs pointer

      return
      end
C    !------------------------- END GATEWAY -------------------------------


C!---------------------------------------------------------------------
C!                       AUXILIAR FUNCTIONS
C!---------------------------------------------------------------------

C SMALL FUNCTIONS

      module small_functions

       implicit none
       contains

C!---------------------------------------------------------------------
C!                       LINEAR INTERPOLATION
C!---------------------------------------------------------------------


        function fastrap(nx1,nx2,x1,x2,x1i,x2i,z)

         implicit none
          integer :: nx1,nx2
          double precision :: x1i,x2i,fastrap
          double precision, dimension(nx1) :: x1
          double precision, dimension(nx2) :: x2
          double precision, dimension(nx1,nx2) :: z

          integer*4, external :: mexPrintf
          integer*4 pm
          character*80 line

          double precision :: s1, s2
          double precision :: x1i_min, x2i_min
          integer:: loc1, loc2
          double precision, dimension(2) :: xi, xi_left, xi_right
          double precision, dimension(2) :: w1, w2, w_2, w_1
          mwsize m1, m2

          s1 = x1(2) - x1(1)
          x1i_min = x1i - x1(1)
          loc1 = min(nx1-1,max(1,floor(x1i_min/s1) + 1));

          s2 = x2(2) - x2(1)
          x2i_min = x2i - x2(1)
          loc2 = min(nx2-1,max(1,floor(x2i_min/s2) + 1));

          xi = [x1i, x2i]
          xi_left = [x1(loc1), x2(loc2)]
          xi_right = [x1(loc1+1), x2(loc2+1)]

          w_2 = (xi - xi_left)/(xi_right - xi_left)
          w_1 = 1 - w_2
          w1 = [w_1(1), w_2(1)]
          w2 = [w_1(2), w_2(2)]

          fastrap = 0

          do m2 = 0, 1
           do m1 = 0, 1
            fastrap = fastrap + w1(m1+1)*w2(m2+1)*z(loc1+m1,loc2+m2)
           end do
          end do

        end function fastrap

c*********************************************************************72
cc DETERMINISTIC RESAMPLING
c*********************************************************************72

        function deterministicR(inIndex,q,np)

          implicit none

          integer, parameter :: rk = selected_real_kind(15, 307)	! Ask for 15 digits of precision

          mwSize np
          real(kind = rk) inIndex(np,4)
          real(kind = rk) q(np)
          real(kind = rk) deterministicR(np,4)
          integer i, j

          real(kind=rk),dimension(np) :: cdf, uu              ! vector to store Loglh
          double precision :: randu

C         Fix draw from uniform distribution
          randu=0.4532D0

          uu = ( randu -1.0d0 + real((/ (i, i=1,np) /) ,8)) / real(np,8)

          cdf(1) = q(1)
          ! Cumulate distribution of particles
          DO i=2,np
            cdf(i) = cdf(i-1) + q(i)
          END DO

          j=1
          DO i=1,np
            DO WHILE (uu(i)>cdf(j))
              j = j+1
            END DO
            deterministicR(i,:) = inIndex(j,:)
          END DO

        end function deterministicR


c*********************************************************************72
cc C8_NORMAL_01 returns a unit pseudonormal C8.
c  Parameters:
c    Input/output, integer SEED, a seed for the random number generator.c
c    Output, double complex C8_NORMAL_01, a sample of the PDF.
c*********************************************************************72

       function r8_normal_01(seed)

          implicit none

            double precision r1
            double precision r2
            double precision r8_normal_01
            double precision r8_pi
            parameter ( r8_pi = 3.141592653589793D+00 )
            double precision r8_uniform_01
            integer seed
            double precision x

            CALL RANDOM_NUMBER (HARVEST = r1)
            CALL RANDOM_NUMBER (r2)
C            r1 = rand( )
C            r2 = rand( )
            x = sqrt ( - 2.0D+00 * log ( r1 ) )
     +       * cos ( 2.0D+00 * r8_pi * r2 )

            r8_normal_01 = x

         end function r8_normal_01

       end module
!--------------------- END SMALL FUNCTIONS ---------------------------


C    !--------------------- COMPUTATIONAL SUBROUTINE ----------------------
      SUBROUTINE particlefilter(L_out, B_in, P_in, Z_in, Bd_in, Cd_in,
     + obs_in, errval_in, errmat_in, sigm, nz, nb, nobs, np)

      use small_functions               ! Call small functions

      implicit none

      integer, parameter :: rk = selected_real_kind(15, 307)	! Ask for 15 digits of precision

C    !**********************************************
C    ! DECLARE TYPES FOR INPUTS AND COUNTERS
C    !**********************************************
      mwSize nz, nb, nobs, np
      real(kind = rk) B_in(nb)
      real(kind = rk) P_in(nz,nz)
      real(kind = rk) Z_in(nz)
      real(kind = rk) Bd_in(nz,nb)
      real(kind = rk) Cd_in(nz,nb)
      real(kind = rk) obs_in(nobs)
      real(kind = rk) errval_in(50,np)
      real(kind = rk) errmat_in(nobs,np)
      real(kind = rk) sigm
      real(kind = rk) L_out(nobs)
      integer ip, it, q, count,I,n

      integer*4, external :: mexPrintf
      integer*4 pm
      character*80 line

C    !**********************************************
C    ! DECLARE OBJECTS FOR COMPUTATION
C    !**********************************************
      real(kind=rk),dimension(nobs) :: loglh              ! vector to store Loglh
      real(kind=rk),dimension(np) :: p_w_old, p_w_new, p_w_temp    ! vector for particle weights
      real(kind=rk),dimension(np,4) :: p_v_new, pv      ! matrix for particles
      real(kind=rk),dimension(np,4) :: p_v, p_v_old      ! matrix for particles
      real(kind=rk),dimension(1,4) :: sstate, init
      real(kind=rk),dimension(1) :: current_obs,errsim,me
      real(kind=rk), dimension(1) :: Zlag,Blag
      real(kind=rk), dimension(1) :: simZ,simB,simC
      real(kind=rk), dimension(1) :: yy_e, p_w
      double precision :: err2, var_me_inv, ESS, pw0
      integer, allocatable :: seed(:)

C    !====================================================================
C    !                DEFINE PARAMETERS AND CONSTANTS
C    !====================================================================

      real(kind = rk), parameter :: PI = 4.D0*DATAN(1.D0)
      real(kind = rk), parameter :: STD_U = 0.01D0
      real(kind = rk), parameter :: RHO   = 0.90D0
      real(kind = rk), parameter :: M   = 1.00D0
      real(kind = rk), parameter :: R   = 1.05D0
C      real(kind = rk), parameter :: sigm=0.008497404426219000D0

C      CALL RANDOM_SEED(size=n)
C      allocate(seed(n))
C      CALL RANDOM_SEED (GET = seed)

C      write(line,*) 'seed: ', seed
C      pm = mexPrintf(line//achar(10))

C    !====================================================================
C    !                BEGIN COMPUTATIONAL ROUTINE
C    !====================================================================

C     Compute inverse of measurement error variance
      var_me_inv = (1/sigm)**2

C     state vector is: [Z(-1) B(-1) errsim me]
      sstate(1,1:4) = (/ 1.0D0, M*1.0D0, 0.0D0, 0.0D0 /)

C     Initialize particle weights = 1/Number of particles
      pw0 = 1.0D0/dble(np)

      p_w_old = (/ (pw0, I = 1,np) /)

      DO ip=1, np

        Zlag = sstate(1,1)
        Blag = M*1.0D0

C        SIMULATE MODEL 50 PERIODS
          DO it=1,50

C           Draw shocks
            errsim = errval_in(it,ip) !STD_U*r8_normal_01(123456)  !errval_in(it,ip)

C           Simulate model
            simZ = EXP(RHO*LOG(Zlag) + errsim)
            simB = fastrap(nz,nb,Z_in,B_in,Blag(1),simZ(1),Bd_in)
            simB = MIN(simB,M*simZ);
            simC = simZ + simB - R*Blag;

C           Update state
            Zlag = simZ
            Blag = simB
            me   = 0.D0

          END DO
C Store initial particles
          pv(ip,1:4) = (/simZ, simB, errsim, me /)

      END DO

C--------------------------
C Start particle filtering
C--------------------------
      p_v_old = pv

C LOOP OVER OBSERVATIONS

      DO it=1,nobs

        current_obs(1) = obs_in(it)

C LOOP OVER PARTICLES
        DO ip=1, np

C Get particle values
          init(1,1:4)   = p_v_old(ip,1:4)

C Draw shocks to simulate model
          errsim = errmat_in(it,ip) !STD_U*r8_normal_01(123456) ! errmat_in(it,ip) !STD_U*r8_normal_01(123456) !errmat_in(it,ip)

          Zlag = init(1,1)
          Blag = init(1,2)

C--------------------------
C Simulate Model Forward
C--------------------------

          simZ = EXP(RHO*LOG(Zlag) + errsim) ;
          simB = fastrap(nz,nb,Z_in,B_in,Blag(1),simZ(1),Bd_in)
          simB = min(simB,M*simZ);
          simC = simZ + simB - R*Blag;

C--------------------------------
C Construct and weight particles
C--------------------------------

C Prediction error
          yy_e = current_obs - simC

C Collect particle elements
          p_v(1,1:4) = (/ simZ(1), simB(1), errsim(1), yy_e(1) /)

C Store new particles
          p_v_new(ip,1:4) = p_v(1,1:4)

C Compute raw incremental weight of particle
          p_w = (2*PI)**(-0.5)*(var_me_inv)**(0.5)
     +    *exp(-0.5*yy_e*var_me_inv*yy_e)*p_w_old(ip)

C Store incremental particle weights
          p_w_new(ip) = p_w(1)

        END DO

C--------------------------------
C APPROXIMATE LIKELIHOOD
C--------------------------------
      loglh(it) = log(sum(p_w_new)/sum(p_w_old))

C Normalized Weights
      p_w_temp = p_w_new
      p_w_temp = p_w_temp/MAXVAL(p_w_temp)
      p_w_temp = p_w_temp/SUM(p_w_temp)
      ESS = 1/(NORM2(p_w_temp)**2)

C      write(line,*) 'ESS: ', ESS
C      pm = mexPrintf(line//achar(10))

      IF (ESS.LE.np/3.0D0) THEN
C        write(line,*) 'Resampling in period: ', it
C        pm = mexPrintf(line//achar(10))
        p_v_new = deterministicR(p_v_new,p_w_temp,np)
        p_w_temp = (/ (pw0, I = 1,np) /)
      END IF

C--------------------------------
C RESAMPLING STEP
C--------------------------------


C--------------------------------
C STORE PARTICLES FOR NEXT PERIOD
C--------------------------------
      p_w_new = p_w_temp

      p_v_old = p_v_new

      p_w_old = p_w_new

      END DO

C-------------------------------
C OUTPUT RESULTS
C-------------------------------

      L_out(1:nobs) = loglh(1:nobs) !p_w_old(1:nobs)

      RETURN

      END

C !************** END OF CODE ******************************************
