% Simulate decision rules 
bss = M;

simC    = ones(1,T)-(R-1)*bss  ;
simZ    = ones(1,T)  ;
simB    = ones(1,T)*bss ;
simEB   = simB;
simLB   = ones(1,T)*0 ;
simEC   = simC;
simEZ   = simZ;

simC_plus = simC;
simZ_plus = simZ;
simB_plus = simB;
simEB_plus = simEB;
simLB_plus = simLB ;
simEC_plus = simEC;
simEZ_plus = simZ;



simB0 = bss;

simZ(1) = exp(shockssequence(1));
simB(1) = lininterpn(Z,B,Bdec,simZ(1),simB0);
simC(1) = simZ(1) + simB(1) - R*simB0;

eps0=0.0001;
simZ_plus(1) = exp(shockssequence(1)+eps0);
simB_plus(1) = lininterpn(Z,B,Bdec,simZ_plus(1),simB0);
simC_plus(1) = simZ_plus(1) + simB_plus(1) - R*simB0;

simEZ(1) = exp(RHO*log(simZ(1)));
simEB(1) = lininterpn(Z,B,Bdec,simEZ(1),simB(1));
simEC(1) = simEZ(1) + simEB(1) - R*simB(1);
simLB(1) = 1/simC(1)^GAMMAC - BETA*R/simEC(1)^GAMMAC ;
simEZ_plus(1) = exp(RHO*log(simZ(1))+eps0);
simEB_plus(1) = lininterpn(Z,B,Bdec,simEZ_plus(1),simB(1));
simEC_plus(1) = simEZ_plus(1) + simEB(1) - R*simB(1);
simLB_plus(1) = 1/simC_plus(1)^GAMMAC - BETA*R/simEC_plus(1)^GAMMAC ;
simEE = zeros(T,1);
warning off

% This method zeroes out Euler errors
methodsolve=2;

for t = 2:T
  
  simZ(t) = exp(RHO*log(simZ(t-1)) + shockssequence(t)) ;
  simB(t) = lininterpn(Z,B,Bdec,simZ(t),simB(t-1)) ;
  simB(t) = min(simB(t),M*simZ(t));
  simC(t) = simZ(t) + simB(t) - R*simB(t-1);
  
  
  [n_nodes,epsi_nodes,weight_nodes] = GH_Quadrature(3,1,[STD_U^2]);

  for j=1:n_nodes
      simZprime(j) = exp(RHO*log(simZ(t))+epsi_nodes(j));
      simBprime(j) = lininterpn(Z,B,Bdec,simZprime(j),simB(t));
      simCprime(j) = simZprime(j) + simBprime(j) - R*simB(t);
  end
   simEC(t) = simCprime*weight_nodes ;
  
  if methodsolve==1
   simLB(t) = max(0,1/simC(t)^GAMMAC - BETA*R*(simCprime.^-GAMMAC)*weight_nodes) ;
   simEB(t) = simBprime*weight_nodes ;
  end

  if methodsolve==2
      
   impl_C(t) = (BETA*R*(simCprime.^-GAMMAC)*weight_nodes)^(-1/GAMMAC) ;
   impl_B(t) = impl_C(t) - simZ(t) + R*simB(t-1) ;
    
   if impl_B(t)<M*simZ(t)
    simLB(t)=0;
   else
    sim_B(t) = M*simZ(t);
    sim_C(t) = simZ(t) + sim_B(t) - R*simB(t-1);
    simLB(t)= 1/sim_C(t)^GAMMAC - BETA*R*(simCprime.^-GAMMAC)*weight_nodes;
    
   end
   
  end
  % Euler Error 
 simEE(t,1) = 1 - ((BETA*R*(simCprime.^-GAMMAC)*weight_nodes + simLB(t))^(-1/GAMMAC))/simC(t);

   
  for j=1:n_nodes
      simZprime_plus(j) = exp(RHO*log(simZ(t))+epsi_nodes(j)+eps0);
      simBprime_plus(j) = lininterpn(Z,B,Bdec,simZprime_plus(j),simB(t));
      simCprime_plus(j) = simZprime_plus(j) + simBprime_plus(j) - R*simB(t);
  end
    simLB_plus(t) = 1/simC(t)^GAMMAC - BETA*R*(simCprime_plus.^-GAMMAC)*weight_nodes ;
    simEC_plus(t) = simCprime_plus*weight_nodes ;
    simEB_plus(t) = simBprime_plus*weight_nodes ;
      
  % Hold B(t-1) fixed
  simZ_plus(t) = exp(RHO*log(simZ(t-1)) + (shockssequence(t)+eps0)) ;
  simB_plus(t) = lininterpn(Z,B,Bdec,simZ_plus(t),simB(t-1)) ;
  simB_plus(t) = min(simB_plus(t),M*simZ_plus(t));
  simC_plus(t) = simZ_plus(t) + simB_plus(t) - R*simB(t-1);


end







%-------------------------------------------------------------------
% Once simulated income and savings are calculated
% generate consumption and a bunch of nice plots
%--------------------------------------------------------------------


makeplots=1;

if makeplots==1

BB=mean(simB);
BB_std=std(simB);
    
figure
subplot(2,2,1) ; plot(simZ,'Linewidth',2); title('Simulated income')
subplot(2,2,2) ; plot(simB,'Linewidth',2); title('Simulated borrowing')
hold on; plot(simB*0+bmin,'y','Linewidth',2); hold on; 
hold on; plot(simZ*M,'y','Linewidth',2); 
legend('actual','min','max')

subplot(2,2,3) ; plot(simC,'r','Linewidth',2); 
legend('Consumption')

subplot(2,2,4) ; title('Simulated borrowing to income')
hold on; plot(simB./simZ,'m','Linewidth',2); hold on; 
hold on; plot(simZ.^0*M,'k','Linewidth',2); 
legend('actual','max')

end

if min(simB)<bmin
    warning('Simulation outside Solution Bounds')
end

% keyboard;

disp('------------------')
disp('Model statistics similar to those reported in Table D here https://www2.bc.edu/matteo-iacoviello/research_files/JME_TA_2015.pdf')
disp('mean log C')
disp(mean(log(simC)))
disp('std log C')
disp(std(log(simC)))
disp('mean log Y')
disp(mean(log(simZ)))
disp('std log Y')
disp(std(log(simZ)))
disp('frequency of hitting constraint, within 1%')
disp(numel(find(simB./simZ>M-0.01))/T)

% figure;
% plot(simEE(t));


% keyboard;
[ Zm Bm ] = ndgrid(Z,B);
