[ P, logz, probst, alambda, asigmay ] = markovappr(RHO,STD_U,widthz,nz) ;
Z=exp(logz);

bmin=0.75*M;
simB1=M;
bmax=M*Z(end) ;

B=linspace(bmin,bmax,nb);


%-----------------------------------------------------
% Initialization of value functionb
%-----------------------------------------------------

v=ones(nz,nb);
c=ones(1,nb);

V = ones(nz,nb)/(1-BETA);

%-----------------------------------------------------
% Iterate on value function until convergence
%-----------------------------------------------------

diffV   = 1;
iter    = 1;

% Initialize choices and value
newV = V;
EV = V;
BPRIME = B ;

Bdec_old = V*1;

Bdec = V*0;

diffB = 1;



options = optimset('MaxFunEvals',100000,'MaxIter',1000000,'TolFun',1e-6,...
  'TolX',1e-10,'Display','none');

format long 

while (iter <= 50) && (diffB > 0.000001)
  disp([ iter diffB ])

    % Calculate expected future value
    VPP=interp1(B,V','*spline','pp');
         
    for iz = 1:nz
        for ib = 1:nb
            
            coh=Z(iz)-R*B(ib) ;
            bold=B(ib);

            f = @(x)vincent_value(x,coh,BETA,GAMMAC,Z,M,iz,P,VPP) ;

            % "c", "v", EV(iz,:) are vectors of size [1,nb] 
            % We look in each state for the BPRIME that maximizes v

            [ Bdec(iz,ib), newminusV(iz,ib) ] = fminbnd(f,B(1),B(end),options);
            bdecold=Bdec(iz,ib);
            newV(iz,ib)=-newminusV(iz,ib);

        end
    end

    vincent_hwd_continuum
    diffB = max(abs((Bdec(:)-Bdec_old(:))));
    Bdec_old = Bdec ;
    iter  = iter + 1;
    V     = newV ;
    
end

format short

%-----------------------------------------------------
% Calculate Decision Rules
%-----------------------------------------------------
Cdec = NaN*Bdec;

% Calculate policy function for C: Cdec
for iz = 1:nz
  for ib = 1:nb
    Cdec(iz,ib) = max( 1e-200, Z(iz) + Bdec(iz,ib) - R*B(ib) )  ;
  end
end

clear Cdecinterp ECdec ECdec_old INV* newV  Cd Cm U newVPRIME*