function outsim = simulate_global(err_vals,init,M,B,P,Z,Bdec,Cdec,R,GAMMAC,BETA,RHO,STD_U,n_nodes,epsi_nodes,weight_nodes)
%This function takes in a starting value: M, B states in decision matrix, Transition matrix: P, income states Z, Decision
%rules: Bdec,Cdec, Length of simulation T, Interest rate R, params of
%income process RHO and STD_U
% Returns simulations for consumption simC, income simZ, borrowing simB,
% expected consumption simEC



% Simulate decision rules of agents in Deaton-Huggett-Aiyagari model

Blag = init.Blag; % b(-1);
Zlag = init.Zlag; % z(-1);
ECdec=(P*Cdec);

%--------------------------------------------------------------------
% Generate random numbers
%--------------------------------------------------------------------

r=err_vals;
T = length(r);

simZ = zeros(T,1);
simB = zeros(T,1);
simEC= zeros(T,1);
simC = zeros(T,1);
simLB= zeros(T,1);
simEZ= zeros(T,1);


%--------------------------------------------------------------------
% For each agent, generate a sequence of income realizations
% Do agents first, then time
%--------------------------------------------------------------------
% wait_time = waitbar(0,'Please wait, generating income realizations and calculating decision rules');

for t = 1:T
  simZ(t,1) = exp(RHO*log(Zlag) + r(t)) ;
  warning off
  simB(t,1) =  lininterpn(Z,B,Bdec,simZ(t,1),Blag) ;

  %lininterpn_mex(Z',B',Bdec,simZ(t,1),Blag);

  % lininterpn(Z,B,Bdec,simZ(t,1),Blag) ;


  %
  simB(t,1) = min(simB(t),M*simZ(t));
  simC(t,1) = simZ(t,1) + simB(t,1) - R*Blag;

  for j=1:n_nodes
      simZprime(j) = exp(RHO*log(simZ(t))+epsi_nodes(j));
      simBprime(j) = lininterpn(Z,B,Bdec,simZprime(j),simB(t));

      %lininterpn_mex(Z',B',Bdec,simZprime(j),simB(t));

      %lininterpn(Z,B,Bdec,simZprime(j),simB(t));

      simCprime(j) = simZprime(j) + simBprime(j) - R*simB(t);
  end

  simEC(t,1) = simCprime*weight_nodes ;

  % Compute Implied Consumption and Borrowing
  impl_C(t) = (BETA*R*(simCprime.^-GAMMAC)*weight_nodes)^(-1/GAMMAC) ;
  impl_B(t) = impl_C(t) - simZ(t) + R*Blag ;

  if impl_B(t)<M*simZ(t)
      simLB(t)=0;
  else
      sim_B(t) = M*simZ(t);
      sim_C(t) = simZ(t) + sim_B(t) - R*Blag;
      simLB(t,1)= 1/sim_C(t)^GAMMAC - BETA*R*(simCprime.^-GAMMAC)*weight_nodes;
  end


  simEZ(t,1) = exp(RHO*log(simZ(t)));

  % Update states
  Blag = simB(t);
  Zlag = simZ(t);

end


outsim(:,1) = simB;
outsim(:,2) = M*simZ;
outsim(:,3) = simC;
outsim(:,4) = simEC;
outsim(:,5) = simLB;
outsim(:,6) = simB - M*simZ;
outsim(:,7) = simZ;
