# The following code replicates the results in Crespo Cuaresma and
# Feldkircher "Spatial Filtering, Model Uncertainty and the Speed of
# Income Convergence", JAE, forthcoming.

# This is an R-script, we assume that you have R installed
# (www.r-project.org) as well as the libraries BMS, spdep and the add-on
# library spatBMS, which is available at:
#  http://bms.zeugner.eu/blog/2010-10-27/an-illustration-of-spatial-filtering-model-uncertainty-and-the-s

# We strongly recommend going through the spatBMS tutorial before
# trying to replicate our results

# to get started load the libraries

  library(BMS);library(spdep)
  library(spatBMS)

# load the data
  load("DataList.rda")
# DataList is a list object, the names of its entries can be accessed by typing
  names(DataList)
  X.data=DataList$X.data # is the data matrix, first entry is the dependent variable
                         # followed by 50 regressors, for variable names see the appendix of the paper
                         
  WList=DataList$EVList   # this is a list object with 40 slots, each slots gives the eigenvectors
                          # corresponding to one original weight matrix stored in DataList$Wmatrices
                          # to see how we have extracted the EVs from the DataList$Wmatrices please consider the
                          # tutorial at http://bms.zeugner.eu/blog/2010-10-27/an-illustration-of-spatial-filtering-model-uncertainty-and-the-s
                          # that contains a hello world example (using a different data set)

  # estimate Table 5, original estimation is based on 15 million posterior draws (iterNr=14e06) and 5 mil burn-ins (burnNr=5e06)
  
  burnNr=1e05; iterNr=1e06;K=(ncol(X.data) - 1) # K=50
  
  # store results in a list
  
  resList=list()
  
  resList$fullModel=spatFilt.bms(X.data = X.data, WList = WList, burn = burnNr, iter = iterNr,
                             nmodel = 500, mcmc = "bd", g = "bric", mprior = "random",
                             mprior.size = K/2, start.value = rep(1, K))

  resList$queenModel=spatFilt.bms(X.data = X.data, WList = WList[1:10], burn = burnNr, iter = iterNr,
                             nmodel = 500, mcmc = "bd", g = "bric", mprior = "random",
                             mprior.size = K/2, start.value = rep(1, K))
  resList$knnModel=spatFilt.bms(X.data = X.data, WList = WList[11:20], burn = burnNr, iter = iterNr,
                             nmodel = 500, mcmc = "bd", g = "bric", mprior = "random",
                             mprior.size = K/2, start.value = rep(1, K))
  resList$invWModel=spatFilt.bms(X.data = X.data, WList = WList[21:30], burn = burnNr, iter = iterNr,
                             nmodel = 500, mcmc = "bd", g = "bric", mprior = "random",
                             mprior.size = K/2, start.value = rep(1, K))

  resList$distModel=spatFilt.bms(X.data = X.data, WList = WList[31:40], burn = burnNr, iter = iterNr,
                             nmodel = 500, mcmc = "bd", g = "bric", mprior = "random",
                             mprior.size = K/2, start.value = rep(1, K))
                             
  resList$nullModel=bms(X.data = X.data,burn = burnNr, iter = iterNr,
                             nmodel = 500, mcmc = "bd", g = "bric", mprior = "random",
                             mprior.size = K/2, start.value = rep(1, K))

