clear all
set more off
pause on
capture log close

*Prepares data in-line with approach taken by Skinner (1989)
*requires the psiduse stata command 

local fullyrlist 1999 2001 2003 2005 2007 2009 2011 2013

**********************************************************************************
* 						FIRST GENERATE CONSUMPTION DATA 						 *
**********************************************************************************

*spending data (not including education or healtchare - food utilties, fuel and motoring costs) (additional variables for clothing and entertainment spending are added below)
#delimit ;
psid use 
|| foodhme_nostmp [99]ER14295 [01]ER18431 [03]ER21696 [05]ER25698 [07]ER36716 [09]ER42722 [11]ER48038 [13]ER53735
|| foodhme_stmp [99]ER14288 [01]ER18421 [03]ER21686 [05]ER25688 [07]ER36706 [09]ER42712 [11]ER48028 [13]ER53725
|| foodstmp_ind [99]ER14287 [01]ER18420 [03]ER21685 [05]ER25687 [07]ER36705 [09]ER42711 [11]ER48027 [13]ER53724
|| foodout_nostmp [99]ER14300 [01]ER18438 [03]ER21703 [05]ER25705 [07]ER36723 [09]ER42729 [11]ER48045 [13]ER53742
|| foodout_stmp [99]ER14293 [01]ER18428 [03]ER21693 [05]ER25695 [07]ER36713 [09]ER42719 [11]ER48035 [13]ER53732
|| fooddlv_nostmp [99]ER14298 [01]ER18435 [03]ER21700 [05]ER25702 [07]ER36720 [09]ER42726 [11]ER48042 [13]ER53739
|| fooddlv_stmp [99]ER14291 [01]ER18425 [03]ER21690 [05]ER25692 [07]ER36710 [09]ER42716 [11]ER48032 [13]ER53729
|| elec2 [99]ER13086 [01]ER17097 [03]ER21086 [05]ER25082 [07]ER36085 [09]ER42114 [11]ER47417 [13]ER53117
|| gaselec_comb [07]ER36087 [09]ER42116 [11]ER47419 [13]ER53119
|| heat1 [99]ER13088 [01]ER17099 [03]ER21088 [05]ER25080 [07]ER36083 [09]ER42112 [11]ER47415 [13]ER53115
|| wat_sew2 [99]ER13090 [01]ER17101 [03]ER21090 [05]ER25084 [07]ER36089 [09]ER42118 [11]ER47421 [13]ER53121
|| phon [05]ER25086 [07]ER36091 [09]ER42120 [11]ER47423 [13]ER53123
|| car_insur [99]ER13191 [01]ER17202 [03]ER21838 [05]ER25794 [07]ER36812 [09]ER42803 [11]ER48125 [13]ER53819
|| car_rep [99]ER13195 [01]ER17206 [03]ER21842 [05]ER25798 [07]ER36816 [09]ER42807 [11]ER48129 [13]ER53823
|| car_gas [99]ER13196 [01]ER17207 [03]ER21843 [05]ER25799 [07]ER36817 [09]ER42808 [11]ER48130 [13]ER53824
|| car_taxi [99]ER13199 [01]ER17210 [03]ER21846 [05]ER25802 [07]ER36820 [09]ER42811 [11]ER48133 [13]ER53827
|| car_park [99]ER13197 [01]ER17208 [03]ER21844 [05]ER25800 [07]ER36818 [09]ER42809 [11]ER48131 [13]ER53825
|| car_pub [99]ER13198 [01]ER17209 [03]ER21845 [05]ER25801 [07]ER36819 [09]ER42810 [11]ER48132 [13]ER53826
|| car_misc [99]ER13200 [01]ER17211 [03]ER21847 [05]ER25803 [07]ER36821 [09]ER42812 [11]ER48134 [13]ER53828
|| fam_wt [99]ER16518 [01]ER20394 [03]ER24179 [05]ER28078 [07]ER41069 [09]ER47012 [11]ER52436 [13]ER58257
|| ind_wt [99]ER33546 [01]ER33637 [03]ER33740 [05]ER33848 [07]ER33950 [09]ER34045 [11]ER34154 [13]ER34268
using "M:\PSID\stata", keepnotes;

#delimit cr

foreach yr in `fullyrlist' {

	local utilmth  elec2`yr' gaselec_comb`yr' heat1`yr' wat_sew2`yr' phon`yr'
	local utilyr oil1`yr'  gas1`yr' wat_sew1`yr' 

	local conweek foodhme_nostmp`yr' foodhme_stmp`yr' foodout_nostmp`yr' foodout_stmp`yr' fooddlv_nostmp`yr' fooddlv_stmp`yr'
	local conmth car_taxi`yr' car_pub`yr' car_park`yr' car_misc`yr' car_gas`yr' car_rep`yr' elec2`yr' gaselec_comb`yr' heat1`yr' wat_sew2`yr' phon`yr'
	*local conyr car_insur`yr' elec1`yr'
	local conyr car_insur`yr' 

	*Generate variables for missing years
	*This uses psid vardoc which requires access to the internet
	gen con`yr'=0

	foreach vweek in `conweek' {
	
	cap gen `vweek'=0
	cap psid vardoc `vweek', addvaluelabel(`vweek'labels)
	}

	 //end the loop on the weekly values
	 
	foreach vmth in `conmth' {
		cap gen `vmth'=0
		cap psid vardoc `vmth', addvaluelabel(`vmth'labels)
	}
	
	 //end the loop on the monthly values
	 
	 
	foreach vyr in `conyr' {
		cap gen `vyr'=0
		cap psid vardoc `vyr', addvaluelabel(`vyr'labels)
	}
	
	*Now need to properly label missings
	foreach vweek in `conweek' {

		cap decode `vweek', gen(`vweek'labs) // converts the value labels associated with the variable vmth into a string variable
		cap gen `vweek'labs=""
		*strmatch generates logical for the matching strings. Use wild cards to evaluate sequence of OR conditions. DK, NA or
		*N/A in the variable value label. Then creates exclude 1 or 0. 1 if to be excluded
		gen `vweek'xcld=(strmatch(`vweek'labs,"*DK*")| strmatch(`vweek'labs,"*NA*")|strmatch(`vweek'labs,"*N/A*")) 
		*recursively update the total consumption value IFF value isn't assigned as non reported. NOTE: IMPLICITLY ASSIGN NON REPORTS TO 0 IN TOTAL CONSUMPTION CALCULATION
		
		*TEMPORARY FIX FOR NA/DK ANSWERS (while vardoc doesn't seem to be working)
		replace `vweek'xcld=1 if inlist(`vweek',99998,99999)
		
		replace con`yr'=con`yr'+52*`vweek' if `vweek'xcld~=1
		
		drop `vweek'labs `vweek'xcld
	}
	 //end the loop on the weekly values
	 
	 
	foreach vmth in `conmth' {

		cap decode `vmth', gen(`vmth'labs) // converts the value labels associated with the variable vmth into a string variable
		cap gen `vmth'labs=""
		*strmatch generates logical for the matching strings. Use wild cards to evaluate sequence of OR conditions. DK, NA or
		*N/A in the variable value label. Then creates exclude 1 or 0. 1 if to be excluded
		
		gen `vmth'xcld=(strmatch(`vmth'labs,"*DK*")| strmatch(`vmth'labs,"*NA*")|strmatch(`vmth'labs,"*N/A*")|strmatch(`vmth'labs,"One or more of the component variables above contain missing data")) 
		
		*TEMPORARY FIX FOR NA/DK ANSWERS (while vardoc doesn't seem to be working)
		if ("`vmth'" == "car_taxi`yr'" | "`vmth'" =="car_pub`yr'" | "`vmth'" =="car_park`yr'" | "`vmth'" =="car_misc`yr'" | "`vmth'" =="car_gas`yr'" | "`vmth'" =="car_rep`yr'") {
			replace `vmth'xcld=1 if inlist(`vmth',99998,99999)
		}
		if ("`vmth'" == "elec2`yr'" | "`vmth'" =="gaselec_comb`yr'" | "`vmth'" =="heat1`yr'" | "`vmth'" =="wat_sew2`yr'" | "`vmth'" =="phon`yr'") {
			replace `vmth'xcld=1 if inlist(`vmth',9998,9999)
		}

		*recursively update the total consumption value IFF value isn't assigned as non reported. NOTE: IMPLICITLY ASSIGN NON REPORTS TO 0 IN TOTAL CONSUMPTION CALCULATION
		replace con`yr'=con`yr'+12*`vmth' if `vmth'xcld~=1

		drop `vmth'labs `vmth'xcld

	}

	 //end the loop on the monthly values

	 
	foreach vyr in `conyr' {

		cap decode `vyr', gen(`vyr'labs) // converts the value labels associated with the variable vmth into a string variable
		cap gen `vyr'labs=""
		*strmatch generates logical for the matching strings. Use wild cards to evaluate sequence of OR conditions. DK, NA or
		*N/A in the variable value label. Then creates exclude 1 or 0. 1 if to be excluded

		gen `vyr'xcld=(strmatch(`vyr'labs,"*DK*")| strmatch(`vyr'labs,"*NA*")|strmatch(`vyr'labs,"*N/A*")) 
		
		*TEMPORARY FIX FOR NA/DK ANSWERS (while vardoc doesn't seem to be working)
		replace `vyr'xcld=1 if inlist(`vyr',999998,999999)

		*recursively update the total consumption value IFF value isn't assigned as non reported. NOTE: IMPLICITLY ASSIGN NON REPORTS TO 0 IN TOTAL CONSUMPTION CALCULATION
		replace con`yr'=con`yr'+`vyr' if `vyr'xcld~=1
		
		drop `vyr'labs `vyr'xcld

	}
	 //end the loop on the yearly values
}


#delimit ;
psid add
|| clothing    		  [05]ER25818 [07]ER36836 [09]ER42827 [11]ER48149 [13]ER53843 
|| entains  	      [05]ER25828 [07]ER36846 [09]ER42837 [11]ER48159 [13]ER53853
|| vacation  		  [05]ER25823 [07]ER36841 [09]ER42832 [11]ER48154 [13]ER53848
|| dur_hh_furnishings [05]ER25813 [07]ER36831 [09]ER42822 [11]ER48144 [13]ER53838
using "M:\PSID\stata", keepnotes;

#delimit cr

*don't include dur_hh_furnishings here as this durable expenditure
foreach yr in 2005 2007 2009 2011 2013 {
	foreach vyr in clothing`yr' entains`yr' vacation`yr'  {

		*FIX don't knows and N/As
		qui replace `vyr' = .a if `vyr'==999998
		qui replace `vyr' = .b if `vyr'==999999
		
		*recursively update the total consumption value IFF value isn't assigned as non reported. NOTE: IMPLICITLY ASSIGN NON REPORTS TO 0 IN TOTAL CONSUMPTION CALCULATION
		replace con`yr'=con`yr'+`vyr' if `vyr'<.

	}
}

*variables on cars
*downpayments and leases already exclude cars purchased 2 years before the current interview 
*car repairs are monthly
#delimit ;
psid add 
|| veh1_howacquired 	[99]ER13107 [01]ER17118 [03]ER21757 [05]ER25716 [07]ER36734 [09]ER42738 [11]ER48056 [13]ER53753
|| veh2_howacquired 	[99]ER13137 [01]ER17148 [03]ER21786 [05]ER25744 [07]ER36762 [09]ER42761 [11]ER48081 [13]ER53777
|| veh3_howacquired 	[99]ER13167 [01]ER17178 [03]ER21815 [05]ER25772 [07]ER36790 [09]ER42784 [11]ER48106 [13]ER53801
|| veh1_leasepayment 	[99]ER13127 [01]ER17138 [03]ER21776 [05]ER25734 [07]ER36752 [09]ER42753 [11]ER48071 [13]ER53767
|| veh2_leasepayment 	[99]ER13157 [01]ER17168 [03]ER21805 [05]ER25762 [07]ER36780 [09]ER42776 [11]ER48096 [13]ER53791
|| veh3_leasepayment 	[99]ER13187 [01]ER17198 [03]ER21834 [05]ER25790 [07]ER36808 [09]ER42799 [11]ER48121 [13]ER53815
|| veh1_leaseperiod 	[99]ER13128 [01]ER17139 [03]ER21777 [05]ER25735 [07]ER36753 [09]ER42754 [11]ER48072 [13]ER53768
|| veh2_leaseperiod		[99]ER13158 [01]ER17169 [03]ER21806 [05]ER25763 [07]ER36781 [09]ER42777 [11]ER48097 [13]ER53792
|| veh3_leaseperiod 	[99]ER13188 [01]ER17199 [03]ER21835 [05]ER25791 [07]ER36809 [09]ER42800 [11]ER48122 [13]ER53816
|| veh1_leaseinitoutlay [99]ER13126 [01]ER17137 [03]ER21775 [05]ER25733 [07]ER36751 [09]ER42752 [11]ER48070 [13]ER53766
|| veh2_leaseinitoutlay [99]ER13156 [01]ER17167 [03]ER21804 [05]ER25761 [07]ER36779 [09]ER42775 [11]ER48095 [13]ER53790
|| veh3_leaseinitoutlay [99]ER13186 [01]ER17197 [03]ER21833 [05]ER25789 [07]ER36807 [09]ER42798 [11]ER48120 [13]ER53814
|| ownscar 				[99]ER13099 [01]ER17110 [03]ER21749 [05]ER25708 [07]ER36726 [09]ER42732 [11]ER48048 [13]ER53745
|| ncars 				[99]ER13100 [01]ER17111 [03]ER21750 [05]ER25709 [07]ER36727 [09]ER42733 [11]ER48049 [13]ER53746
|| veh1_downpayment 	[99]ER13118 [01]ER17129 [03]ER21768 [05]ER25726 [07]ER36744 [09]ER42745 [11]ER48063 [13]ER53759
|| veh2_downpayment 	[99]ER13148 [01]ER17159 [03]ER21797 [05]ER25754 [07]ER36772 [09]ER42768 [11]ER48088 [13]ER53783
|| veh3_downpayment 	[99]ER13178 [01]ER17189 [03]ER21826 [05]ER25782 [07]ER36800 [09]ER42791 [11]ER48113 [13]ER53807
|| otherpayments 		[99]ER13194 [01]ER17205 [03]ER21841 [05]ER25797 [07]ER36815 [09]ER42806 [11]ER48128 [13]ER53822
using "M:\PSID\stata", keepnotes;
#delimit cr

**********************************************************************************
* 						       SOME DEMOGRAPHICS	    						 *
**********************************************************************************

#delimit ;
psid add
|| sex_hd [99]ER13011 [01]ER17014 [03]ER21018 [05]ER25018 [07]ER36018 [09]ER42018 [11]ER47318 [13]ER53018
|| age_hd [99]ER13010 [01]ER17013 [03]ER21017 [05]ER25017 [07]ER36017 [09]ER42017 [11]ER47317 [13]ER53017
|| age_wf [99]ER13012 [01]ER17015 [03]ER21019 [05]ER25019 [07]ER36019 [09]ER42019 [11]ER47319 [13]ER53019
|| totwlth [09]ER46970 [11]ER52394 [13]ER58211 
|| totwlth_exclhme [09]ER46968 [11]ER52392 [13]ER58209
|| emply_hd [99]ER13205 [01]ER17216 [03]ER21123 [05]ER25104 [07]ER36109 [09]ER42140 [11]ER47448 [13]ER53148
|| emply_wf [99]ER13717 [01]ER17786 [03]ER21373 [05]ER25362 [07]ER36367 [09]ER42392 [11]ER47705 [13]ER53411
|| hours_tot_prev_hd [99]ER13363 [01]ER17393 [03]ER21176 [05]ER25165 [07]ER36170 [09]ER42203 [11]ER47516 [13]ER53216
|| hours_tot_prev_wf [99]ER13875 [01]ER17963 [03]ER21426 [05]ER25423 [07]ER36428 [09]ER42455 [11]ER47773 [13]ER53479
|| self_hd [99]ER13210 [01]ER17221 [03]ER21147 [05]ER25129 [07]ER36134 [09]ER42169 [11]ER47482 [13]ER53182
|| self_wf [99]ER13722 [01]ER17791 [03]ER21397 [05]ER25387 [07]ER36392 [09]ER42421 [11]ER47739 [13]ER53445
|| relhd [99]ER33503 [01]ER33603 [03]ER33703 [05]ER33803 [07]ER33903 [09]ER34003 [11]ER34103 [13]ER34203
|| fam_wt [99]ER16518 [01]ER20394 [03]ER24179 [05]ER28078 [07]ER41069 [09]ER47012 [11]ER52436 [13]ER58257
|| ind_wt [99]ER33546 [01]ER33637 [03]ER33740 [05]ER33848 [07]ER33950 [09]ER34045 [11]ER34154 [13]ER34268
|| marstat1 [99]ER16423 [01]ER20369 [03]ER24150 [05]ER28049 [07]ER41039 [09]ER46983 [11]ER52407 [13]ER58225
|| marstat2 [99]ER13021 [01]ER17024 [03]ER21023 [05]ER25023 [07]ER36023 [09]ER42023 [11]ER47323 [13]ER53023
|| Total_fam_inc [99]ER16462 [01]ER20456 [03]ER24099 [05]ER28037 [07]ER41027 [09]ER46935 [11]ER52343 [13]ER58152
|| grades_educ_hd [99]ER16516 [01]ER20457 [03]ER24148 [05]ER28047 [07]ER41037 [09]ER46981 [11]ER52405 [13]ER58223
|| grades_educ_wf [99]ER16517 [01]ER20458 [03]ER24149 [05]ER28048 [07]ER41038 [09]ER46982 [11]ER52406 [13]ER58224
|| lab_income_hd [99]ER16463 [01]ER20443 [03]ER24116 [05]ER27931 [07]ER40921 [09]ER46829 [11]ER52237 [13]ER58038
|| lab_income_wf [99]ER16465 [01]ER20447 [03]ER24135 [05]ER27943 [07]ER40933 [09]ER46841 [11]ER52249 [13]ER58050
|| wage_salary_hd [99]ER16493 [01]ER20425 [03]ER24117 [05]ER27913 [07]ER40903 [09]ER46811 [11]ER52219 [13]ER58020
|| cross_ind_wt [99]ER33547 [01]ER33639 [03]ER33742 [05]ER33849 [07]ER33951 [09]ER34046 [11]ER34155 [13]ER34269
|| cross_fam_wt [99]ER16519 [01]ER20459 [03]ER24180
|| housevalue   [99]ER13041 [01]ER17044 [03]ER21043 [05]ER25029 [07]ER36029 [09]ER42030 [11]ER47330 [13]ER53030
|| tenure 		[99]ER13040 [01]ER17043 [03]ER21042 [05]ER25028 [07]ER36028 [09]ER42029 [11]ER47329 [13]ER53029
|| age 			[99]ER33504 [01]ER33604 [03]ER33704 [05]ER33804 [07]ER33904 [09]ER34004 [11]ER34104 [13]ER34204
|| nkids 		[99]ER13013 [01]ER17016 [03]ER21020 [05]ER25020 [07]ER36020 [09]ER42020 [11]ER47320 [13]ER53020
|| industry 	[03]ER21146 [05]ER25128 [07]ER36133 [09]ER42168 [11]ER47480 [13]ER53180
|| state 		[99]ER13004 [01]ER17004 [03]ER21003 [05]ER25003 [07]ER36003 [09]ER42003 [11]ER47303 [13]ER53003
|| moved        [99]ER13077 [01]ER17088 [03]ER21117 [05]ER25098 [07]ER36103 [09]ER42132 [11]ER47440 [13]ER53140
|| int_mo       [99]ER13006 [01]ER17009 [03]ER21012 [05]ER25012 [07]ER36012 [09]ER42012 [11]ER47312 [13]ER53012
|| int_yr 		[99]ER13008 [01]ER17011 [03]ER21014 [05]ER25014 [07]ER36014 [09]ER42014 [11]ER47314 [13]ER53014	
|| moved_mo 	[99]ER13078 [01]ER17089 [03]ER21118 [05]ER25099 [07]ER36104 [09]ER42133 [11]ER47441 [13]ER53141
|| moved_yr     [99]ER13079 [01]ER17090 [03]ER21119 [05]ER25100 [07]ER36105 [09]ER42134 [11]ER47442 [13]ER53142
|| monthlyrent   [99]ER13065 [01]ER17074 [03]ER21072 [05]ER25063 [07]ER36065 [09]ER42080 [11]ER47387 [13]ER53087
using "M:\PSID\stata", keepnotes;

#delimit cr

/*
*Do some cleaning

*Some things to know about the labour income
*lab_income_hd uses...
*1999 Head's 1998 Labor Income, Excluding Farm and Unincorporated Business Income

*The income reported here is the sum of several labor income components from the raw data, including, in addition to wages and salaries (ER16493), 
*any separate reports of bonuses (ER16495), overtime (ER16497), tips (ER16499), commissions (ER16501), professional practice or trade (ER16503), 
*market gardening (ER16505), miscellaneous labor income (ER16507), and extra job income (ER16509).

*Note that farm income (ER16448) and the labor portion of business income (ER16490) are NOT included here.
*All missing data were assigned.

*lab_income_wf uses...
*1999 Wife/"Wife's" 1998 Labor Income, Excluding Farm and Unincorporated Business Income
*Note that farm income (ER16448) and the labor portion of business income (ER16511) are NOT included here.
*All missing data were assigned.

*IMPORTANT NOTE: wage_salary_hd uses..
*1999 Head's Income from Wages and Salaries in 1998

*generate variables to indicate employment status and unemployment
*first generate participation
*/

foreach yr in `fullyrlist' {
	foreach g in hd wf {
		qui psid vardoc emply_`g'`yr', addvaluelabel(emply_`g'`yr'labels)
		cap decode emply_`g'`yr', gen(emply_`g'`yr'labs) 
		*converts the value labels associated with the variable vmth into a string variable
		cap gen emply_`g'`yr'labs=""
		*strmatch generates logical for the matching strings. Use wild cards to evaluate sequence of OR conditions. DK, NA or
		*N/A in the variable value label. Then creates exclude 1 or 0. 1 if to be excluded

		gen labfrce_`g'`yr'=(strmatch(emply_`g'`yr'labs,"*unemployed*")|strmatch(emply_`g'`yr'labs,"*Working now*")|strmatch(emply_`g'`yr'labs,"*temporarily laid off*"))
		gen inwrk_`g'`yr'=(strmatch(emply_`g'`yr'labs,"*Working now*"))

		*drop emply_`g'`yr'
		cap label drop emply_`g'`yr'labels

		*Use the previous years hours question
		psid vardoc hours_tot_prev_`g'`yr', addvaluelabel(hoursprev_`g'`yr'labels)

		cap decode hours_tot_prev_`g'`yr', gen(hoursprev_`g'`yr'labs) 
		*converts the value labels associated with the variable vmth into a string variable
		cap gen hoursprev_`g'`yr'labs=""
		*NO need to use cap gen as questions asked in every edition
		gen nohours_`g'`yr'=(strmatch(hoursprev_`g'`yr'labs,"*Inap.:*")) 
		*generates an indicator for "innappropriate" responses, i.e. if there was no wife or head/wife didn't work
		*take care of absence of wife related issues below
		gen hourswldcard_`g'`yr'=(strmatch(hoursprev_`g'`yr'labs,"*Wild code*"))
		gen hourslatsamp_`g'`yr'=(strmatch(hoursprev_`g'`yr'labs,"*Latino sample family*"))

		*Grades educated
		psid vardoc grades_educ_`g'`yr', addvaluelabel(grades_educ_`g'`yr'labels)

		cap decode grades_educ_`g'`yr', gen(grades_educ_`g'`yr'labs) // converts the value labels associated with the variable vmth into a string variable
		cap gen grades_educ_`g'`yr'labs=""
		*NO need to use cap gen as questions asked in every edition
		gen norecorded_educ_`g'`yr'=(strmatch(grades_educ_`g'`yr'labs,"*DK*")|strmatch(grades_educ_`g'`yr'labs,"*NA*")|strmatch(grades_educ_`g'`yr'labs,"*N/A*")) 
		*generates an indicator for "innappropriate" responses, i.e. if there was no wife or head/wife didn't work
		}

}

*generate marriage labels
foreach yr in `fullyrlist' {

	foreach x in 1 2 {

	qui psid vardoc marstat`x'`yr', addvaluelabel(marstat`x'`yr'labels)

	cap decode marstat`x'`yr', gen(marstat`x'`yr'labs) 
	*converts the value labels associated with the variable vmth into a string variable
	cap gen marstat`x'`yr'labs=""


	*Marital status=1 always refers to somebody who is currently married
	gen married`x'`yr'=(marstat`x'`yr'==1)
	gen single`x'`yr'=(strmatch(marstat`x'`yr'labs,"*Single*")|strmatch(marstat`x'`yr'labs,"Never married*"))
	gen divorce`x'`yr'=(strmatch(marstat`x'`yr'labs,"*Divorced*"))
	gen widow`x'`yr'=(strmatch(marstat`x'`yr'labs,"*Widowed*"))
	gen separated`x'`yr'=(strmatch(marstat`x'`yr'labs,"*Separated*"))

	gen wldcrd`x'`yr'=(strmatch(marstat`x'`yr'labs,"*DK*")|strmatch(marstat`x'`yr'labs,"*NA*"))

	}

}

*Decode Total_fam_inc
foreach yr in `fullyrlist' {

	qui psid vardoc Total_fam_inc`yr', addvaluelabel(Total_fam_inc`yr'labels)

	cap decode Total_fam_inc`yr', gen(Total_fam_inc`yr'labs) 
	*converts the value labels associated with the variable vmth into a string variable
	cap gen Total_fam_inc`yr'labs=""
	gen Total_fam_inc_lat`yr'=(strmatch(Total_fam_inc`yr'labs,"*Latino sample family*")| strmatch(Total_fam_inc`yr'labs,"*latino sample family*")|strmatch(Total_fam_inc`yr'labs,"*Latino*")|strmatch(Total_fam_inc`yr'labs,"*latino*"))
	*In principle only the first of these is necessary, but it wasn't working
	replace Total_fam_inc`yr'=. if Total_fam_inc_lat`yr'==1
	*Commands generating the appropriate classification are performed in wage_resid.do to allow for option chanegs
}

local extractvars1 "foodhme_nostmp foodhme_stmp foodstmp_ind foodout_nostmp foodout_stmp fooddlv_nostmp fooddlv_stmp elec2 gaselec_comb heat1 wat_sew2 phon car_insur car_rep car_gas car_taxi car_park car_pub car_misc fam_wt ind_wt con"
local extractvars2 "sex_hd age_hd age_wf totwlth totwlth_exclhme emply_hd emply_wf hours_tot_prev_hd hours_tot_prev_wf self_hd self_wf relhd fam_wt ind_wt marstat1 marstat2 Total_fam_inc grades_educ_hd grades_educ_wf lab_income_hd lab_income_wf wage_salary_hd cross_ind_wt cross_fam_wt"

drop *labs*

qui psid long

*create spending variables 
gen utilities = 0 
foreach var in elec2 gaselec_comb heat1 wat_sew2 phon {
	replace utilities = utilities + `var' if !inlist(`var',9998,9999)
}
*put in annual terms
replace utilities = utilities*12

gen foodin = 0 

foreach var in foodhme_nostmp foodhme_stmp fooddlv_nostmp fooddlv_stmp {
	replace foodin = foodin + `var' if !inlist(`var',99998,99999)
}

*put in annual terms
replace foodin = foodin*52

gen foodout = 0 
foreach var in foodout_nostmp foodout_stmp { 
	replace foodout = foodout + `var' if !inlist(`var',99998,99999)
}
*put in annual terms
replace foodout = foodout*52

rename x11101ll id
rename x11102 intno
rename xsqnr seqnumber

*some further cleaning

*A note on heads - from the 2013 CODEBOOK
*"Note that these relationships are those to the 2011 Head for any individual whose 2013 sequence number (ER34202) is greater than 50; that is, individual has moved out of the FU. 
*Thus, for example, if the 2011 Head is no longer present at the time of the 2013 interview, his or her relationship to Head is coded 10; the new 2013 Head also is coded 10. 
*Therefore, to select current Heads, the user must select those coded 10 in this variable whose sequence numbers (ER34202) are coded 01."

gen hhhead = (relhd==10 & seqnumber==1)

gen newtenure = 1 if tenure==1
replace newtenure =2 if tenure==5
replace newtenure =3 if tenure==8
replace newtenure =4 if tenure==9

replace housevalue = .a if housevalue==9999998
replace housevalue = .b if housevalue==9999999

#delimit ;
label define newtenure
1 "Owns"
2 "Rents"
3 "Neither owns nor rents"
4 "Wild card (2007)";
label values newtenure newtenure;

label define missings
.a "Don't know"
.b "NA";
label values housevalue missings;
label values clothing missings;
label values entains missings;
label values vacation missings;
#delimit cr

*Need to be careful as children are not always interviewed (but over 14s always are)
gen over14  =age>=14
*nkids describes newborns to those 17 year olds
gen age1417 = inrange(age,14,17)

egen sum1417 = sum(age1417), by(intno wave)
gen sumunder14 = nkids - sum1417
egen sumover14 = sum(over14), by(intno wave)

bys intno wave: gen numpeeps = _N

*adults are those 18 and over
egen nadults = sum(age>17), by(intno wave)

gen eqscale = 1 + (sumover14-1)*0.5 + sumunder14*0.3
drop sumunder14 sumover14 sum1417 over14

egen spinhh = sum(inlist(relhd,20,22)), by(intno wave)
label var spinhh "Spouse is in household"

keep if hhhead==1

*Work out if moved since the previous wave (the PSID asks if people moved since January 1st of the previous survey year. As a result it might double count movers.
*This introduces the possibility of doublecounting a move which occurs at the start of a survey year (if people are interviewed after) - See the Coulson and Grieco mortgage paper
*So following them we work if if the date of the household's most recent move occurs after their last interview
gen intdate = int_yr*100 + int_mo
gen movedate = moved_yr*100 + moved_mo
*one observation is coded as not having moved but changed state - fixing this here.
bys id (wave): replace moved= 1 if moved==5 & state!=state[_n-1] & wave==wave[_n-1]+2 & movedate>0
assert movedate==0 if moved==5 
*since those who don't know their move date will have moved_mo==99 or moved_yr==9999/9998 this command implicity assumes that people who don't know know when they moved are movers
bys id (wave): gen MovedSinceLastWave = movedate>intdate[_n-1] if wave==wave[_n-1]+2
*assume people who moved in the same month as their last interview moved after the interview is moved==1
bys id (wave): replace MovedSinceLastWave = 1 if moved==1 & movedate==intdate[_n-1] & wave==wave[_n-1]+2
replace MovedSinceLastWave = 0 if moved==5
drop moved intdate movedate

*Sample selection
keep if wave>=1999

gen year = wave
merge m:1 year using "cpi"
assert _merge!=1
keep if _merge==3
drop _merge

*nondurable consumption in 2016 terms
gen rcon = con/cpi
gen eqrcon = rcon/eqscale
gen lnrcon = ln(rcon)
gen lneqrcon = ln(eqrcon)

*income in 2016 terms 
gen rhhinc = Total_fam_inc/cpi
gen eqrhhinc = rhhinc/eqscale
gen lnrhhinc = ln(rhhinc)
gen lneqrhhinc = ln(eqrhhinc) 

gen allfood = foodin+foodout

foreach var in foodin foodout utilities allfood {
	gen r`var'= `var'/cpi
	gen lnr`var' = ln(r`var')
}

replace ncars = . if inlist(ncars,98,99)
gen bandedncars = max(ncars,2)
replace bandedncars = . if ncars==.

label var con "cash consumption spending"
label var rcon "consumption deflated with cpi-u"
label var eqrcon "equivalised real consumption spending"

label var rhhinc "Total Family Income deflated with cpi-u"
label var eqrhhinc "equivalised real household income"

gen rhousevalue = housevalue/cpi
gen lnrhousevalue = ln(rhousevalue)

label var housevalue "cash value of home"
label var rhousevalue "house value deflated with the CPI"

gen renter = newtenure==2
gen owner = newtenure==1

bys id (wave): gen lnrhhinc_lag3   = lnrhhinc[_n-3] if (wave==wave[_n-3]+6)
bys id (wave): gen lnrhhinc_lag2   = lnrhhinc[_n-2] if (wave==wave[_n-2]+4)
bys id (wave): gen lnrhhinc_lag1   = lnrhhinc[_n-1] if (wave==wave[_n-1]+2)
bys id (wave): gen lnrhhinc_lead1  = lnrhhinc[_n+1] if (wave==wave[_n+1]-2)

gen age2 = age^2

egen everrenter9905 = max(renter) if inrange(year,1999,2005), by(id) 
egen everrenter0513 = max(renter) if inrange(year,2005,2013), by(id) 
egen everrenter9913 = max(renter) if inrange(year,1999,2013), by(id) 

gen incomezero = Total_fam_inc==0

egen everincomezero9905 = max(incomezero) if inrange(year,1999,2005), by(id) 
egen everincomezero0513 = max(incomezero) if inrange(year,2005,2013), by(id) 
egen everincomezero9913 = max(incomezero) if inrange(year,1999,2013), by(id) 

gen earnings_head = lab_income_hd
gen rearnings_head = lab_income_hd/cpi
gen lnrearnings_head = ln(rearnings_head)
gen rearnings_head_zero = rearnings_head==0

replace lnrearnings_head = 0 if rearnings_head_zero==1

egen evermoved9913 = max(MovedSinceLastWave) if inrange(year,1999,2013), by(id) 

replace sex = 0 if sex==2

*drop redundant variables
drop foodhme_nostmp foodhme_stmp foodstmp_ind foodout_nostmp foodout_stmp fooddlv_nostmp fooddlv_stmp elec2 gaselec_comb heat1 wat_sew2 phon car_insur car_rep car_gas car_taxi car_park car_pub car_misc veh1_howacquired veh2_howacquired veh3_howacquired veh1_leasepayment veh2_leasepayment veh3_leasepayment veh1_leaseperiod veh2_leaseperiod veh3_leaseperiod veh1_leaseinitoutlay veh2_leaseinitoutlay veh3_leaseinitoutlay veh1_downpayment veh2_downpayment veh3_downpayment relhd totwlth_exclhme totwlth emply_hd emply_wf hours_tot_prev_hd hours_tot_prev_wf self_hd self_wf marstat1 marstat2 grades_educ_hd grades_educ_wf lab_income_hd lab_income_wf wage_salary_hd industry hourswldcard_hd hourslatsamp_hd norecorded_educ_hd labfrce_wf inwrk_wf nohours_wf hourswldcard_wf hourslatsamp_wf norecorded_educ_wf married1 single1 divorce1 widow1 separated1 wldcrd1 married2 single2 divorce2 widow2 separated2 wldcrd2 Total_fam_inc_lat dur_hh_furnishings otherpayments

export delimited "psiddata.csv", replace




