clear all
capture log close
pause on 

import delimited "cexdata.csv"
save "cexdata", replace

gen year2007 = int_yr==2007 
gen year2009 = int_yr==2009 
gen year2011 = int_yr==2011 

*don't use 2013 - we don't have the lead of income for that year in the psid
log using "log\cexresults.txt", text replace

reg lnrnondurable_psid lnrallfood lnrutilities $npcovariates if owner==1 & inlist(int_yr,2005,2007,2009,2011)
estimate save "estimates\first", replace

reg lnrnondurable_psid lnrallfood  $npcovariates if owner==1 & inlist(int_yr,2005,2007,2009,2011)
estimate save "estimates\first_food", replace

reg lnrnondurable_psid lnrutilities $npcovariates if owner==1 & inlist(int_yr,2005,2007,2009,2011)
estimate save "estimates\first_utilities", replace

gen insample = e(sample)
*residualise variables
foreach var in  lnrnondurable_psid lnrallfood lnrutilities lnrfoodout lnrfoodin {
	reg `var' $npcovariates if insample==1
	predict fwl_`var' if insample==1, res 
}

reg fwl_lnrnondurable_psid fwl_lnrallfood fwl_lnrutilities if insample==1
estimates store fwl_first
estimate save "estimates\fwl_first", replace

reg fwl_lnrnondurable_psid fwl_lnrallfood if owner==1 & inlist(int_yr,2005,2007,2009,2011)
estimate save "estimates\fwl_first_food", replace

reg fwl_lnrnondurable_psid fwl_lnrutilities if owner==1 & inlist(int_yr,2005,2007,2009,2011)
estimate save "estimates\fwl_first_utilities", replace

*obtain gammas through reverse regressions 
foreach var in lnrallfood lnrutilities lnrfoodin lnrfoodout {
	reg fwl_`var' fwl_lnrnondurable_psid
	estimates save "results\reverse_fwl_`var'", replace
}

esttab fwl_first using "results\fwl_sample1.txt", se(%5.3f) b(%5.3f) replace
esttab fwl_first using "results\fwl_sample1.tex", se(%5.3f) b(%5.3f) replace tex

drop insample

*predict consumption on a year by year basis for homeowners
foreach Y in 2005 2007 2009 2011 2013 {
	reg lnrnondurable_psid lnrallfood lnrutilities $npcovariates if year==`Y' & owner==1
	estimates save "estimates\first_`Y'", replace
	 
	gen insample = e(sample)
	
	foreach var in lnrnondurable_psid lnrallfood lnrutilities {
		qui reg `var' $npcovariates if year==`Y' & owner==1
		predict fwl_`var'_ybyy if insample==1, res 
	}
		
	reg fwl_lnrnondurable_psid_ybyy fwl_lnrallfood_ybyy fwl_lnrutilities_ybyy  if year==`Y' & owner==1
	estimates store fwl_first_`Y'
	estimate save "estimates\fwl_first_`Y'", replace
	drop fwl_lnrnondurable_psid_ybyy fwl_lnrallfood_ybyy fwl_lnrutilities_ybyy 
	drop insample
}

log close

esttab fwl_first_2005 fwl_first_2007 fwl_first_2009 fwl_first_2011 fwl_first_2013 fwl_first using "T:\imputation\do\results\fwl_sample1.txt", se(%5.3f) b(%5.3f) r2 replace
esttab fwl_first_2005 fwl_first_2007 fwl_first_2009 fwl_first_2011 fwl_first_2013 fwl_first using "T:\imputation\do\results\fwl_sample1.tex", se(%5.3f) b(%5.3f) r2 replace tex

*predict consumption on a year by year basis for all households
foreach Y in 2005 2007 2009 2011 2013 {
	reg lnrnondurable_psid lnrallfood lnrutilities $npcovariates if year==`Y'
	estimates save "estimates\allfirst_`Y'", replace
	
	foreach var in lnrnondurable_psid lnrallfood lnrutilities {
		reg `var' $npcovariates if year==`Y'
		predict fwl_`var'_ybyy if e(sample)==1, res 
	}
		
	reg fwl_lnrnondurable_psid_ybyy fwl_lnrallfood_ybyy fwl_lnrutilities_ybyy  if year==`Y'
	estimate save "estimates\all_fwl_first_`Y'", replace
	
	drop fwl_lnrnondurable_psid_ybyy fwl_lnrallfood_ybyy fwl_lnrutilities_ybyy 
}
