/*

This do file cleans the raw data for 

Measurement Error in Discrete Health Facility Choice Models:an Example from Urban Senegal
Authors: Christopher J. Cronin, David K. Guilkey, Ilene S. Speizer

Original data files can be obtained from the Carolina Population Center, after signing a data use agreement. Use the following link: https://data.cpc.unc.edu/projects/14/view 
and request the "MLE Senegal Baseline" data files. The following files are needed:

women_public.dta
hhld_public.dta
Senegal_Prenatal_Match.dta
Senegal_ChildCare_Match.dta
Senegal_FamilyPlanning_Match.dta
Senegal_Immunizations_Match.dta
Senegal_MaternalCare_Match.dta
Senegal_HIV_Match.dta
Senegal_Pharmacy_Match.dta
public_senegal_facility_v2.dta
public_senegal_pharmacy_v2
cluster_fac_distance_updated.dta
SDP_all_1k.dta

*/

*PUT ORIGINAL DATA FILES HERE:
cd "XXX"

* NUISANCE DATA FILES AND THE ESTIMATION DATA FILE WILL BE STORED HERE:
global path "XXX"





















*********************************************************************************************************
********************************SENEGAL INDIVIDUAL FILE**************************************************
*********************************************************************************************************

use "women_public.dta", clear
set more off
set seed 123456

di _N 

******************************
****ORGANIZE IDENTIFIERS******
******************************

order hhidx location_code hhnum line urban city iday imon iyear
sort city hhidx line

*generate individual id
gen str7 hhid= string(city) + string(hhidx,"%06.0f")
label var hhid "Household ID"
gen str2 iline=string(line,"%02.0f")
gen indid = hhid + iline
label var indid "Individual ID"
drop hhidx line iline

*make only 1 city variable
label define cityname 1 "1.Dakar" 2 "2.Guédiawaye" 3 "3.Pikine" 4 "4.Mbao" 5 "5.Mbour" 6 "6.Kaolack"
label values city cityname
label var city "City"
drop urban

order indid hhid city location_code hhnum ieastat iday imon iyear
label var location_code "Cluster Number"
label var iday "Interview Day"
label var imon "Interview Month"
label var iyear "Interview Year"
label var ieastat "Cluster Status?"

drop inttype result resulto intnum numvis ilangq ilang ilango iinterp sup fed oed keyer /*
*/ starth startm

*********************************
****BACKGROUD CHARACTERISTICS****
*********************************

di _N

*Age
su w102
forvalues i=1/7{
  gen age`i'=0
}
replace age1=1 if w102<=19
replace age2=1 if w102>19 & w102<=24
replace age3=1 if w102>24 & w102<=29
replace age4=1 if w102>29 & w102<=34
replace age5=1 if w102>34 & w102<=39
replace age6=1 if w102>39 & w102<=44
replace age7=1 if w102>44
label var age1 "15-19"  
label var age2 "20-24"  
label var age3 "25-29"  
label var age4 "30-34"  
label var age5 "35-39"  
label var age6 "40-44"  
label var age7 "45-49"  
su age1-age7
rename w102 age
drop w101m w101y w103

gen year12=2011-age+12
ta year12

order indid hhid city location_code hhnum ieastat iday imon iyear age age1-age7 year12

*Education
ta w104 
ta w105
ta w106

forvalues i=0/4{
  gen eduL`i'=0
}
replace eduL0=1 if w104==2
replace eduL1=1 if w104==1 & w105==1
replace eduL2=1 if w104==1 & w105==2
replace eduL3=1 if w104==1 & w105==3
replace eduL4=1 if w104==1 & w105==4
su eduL0-eduL4

label var eduL0 "No Education"
label var eduL1 "Primary School"
label var eduL2 "Middle School"
label var eduL3 "High School"
label var eduL4 "College"

replace w106=. if w106>8
gen edu_cont=.
replace edu_cont=0 if w104==2
replace edu_cont=w106 if w104==1 & w105==1 
replace edu_cont=w106+6 if w104==1 & w105==2
replace edu_cont=w106+10 if w104==1 & w105==3
replace edu_cont=w106+13 if w104==1 & w105==4
su edu_cont, detail
replace edu_cont=int(r(mean)) if edu_cont==.

label var edu_cont "continuous measure of education"

drop w104 w105 w106

ta w109
gen read=0
replace read=1 if eduL2==1|eduL3==1|eduL4==1
replace read=1 if read==0 & w109==3
label var read "Able to Read"

drop w107 w109 w109o

order indid -year12 eduL0-eduL4 edu_cont read

*Religion
ta w110, nol
gen muslim=0
replace muslim=1 if w110==3
label var muslim "muslim"

drop w110 w110o w111

*Nationality and Ethnicity
ta wsq1
ta wsq1, nol
ta w112
ta w112, nol
recode w112 (96=7) (99=8)

gen sennat=0 if wsq1!=9
replace sennat=1 if wsq1==1
label var sennat "Senegalese National"

forvalues i=1/7{
  gen ethn`i'=0 if wsq1!=9
}
replace ethn1=1 if w112==1
replace ethn2=1 if w112==2
replace ethn3=1 if w112==3
replace ethn4=1 if w112==4
replace ethn5=1 if w112==5
replace ethn6=1 if w112==6
replace ethn7=1 if w112==7
replace ethn7=1 if w112==8
su ethn1-ethn7
label var ethn1 "Wolof"
label var ethn2 "Poular"
label var ethn3 "Serer"
label var ethn4 "Diola"
label var ethn5 "Mandingue"
label var ethn6 "Soninke"
label var ethn7 "Other/missing Senegal Ethnicity"

drop wsq1 w112 w112o

order indid - read muslim sennat ethn1-ethn7

su indid-ethn7

*********************************
**********REPRODUCTION***********
*********************************

*Number of Kids (none missing)
ta w201 
ta w202 
su w203b w203g 
ta w204 
su w205b w205g
ta w206
su w207b w207g

gen homekids=0
gen awaykids=0
gen deadkids=0
replace homekids=w203b+w203g if w201==1 & w202==1
replace awaykids=w205b+w205g if w201==1 & w204==1
replace deadkids=w207b+w207g if w206==1
su homekids awaykids deadkids
label var homekids "# Kids Living at Home"
label var awaykids "# Kids Living Away"
label var deadkids "# Kids Who Have Passed"

drop w201 w202 w203b w203g w204 w205b w205g w206 w207b w207g w208

*Miscarraige, Abortion, or Stillbirth
ta w210, nol
ta w212, nol
gen nobirth=1 if w210==1|w212==1
*replace nobirth=0 if nobirth==.
replace nobirth=0 if nobirth==. & w210!=9 & w212!=9
ta nobirth
label var nobirth "Miscarraige/Abortion/Stillbirth"
drop w210-w234o 

order indid - ethn7 homekids awaykids deadkids nobirth

*Pregnant
ta w235, nol
gen prego=0
replace prego=1 if w235==1
ta prego
label var prego "Currently Pregnant"

drop w235-w242o

*Understands the Rhythm Method
ta w244
ta w245
gen undrstd_rthm=0
replace undrstd_rthm=1 if w244==1 & w245==4
ta undrstd_rthm
label var undrstd_rthm "Woman correctly understands Rhythm Method"

drop w243-w247o

order indid - nobirth prego undrstd_rthm

*********************************
**********CONTRACEPTION**********
*********************************

*have you heard of the following:

forvalues i=1/9{
  ta w301_0`i'
  gen hrdof`i'=.
  replace hrdof`i'=1 if w301_0`i'==1|w301_0`i'==2
  replace hrdof`i'=0 if w301_0`i'==3
  replace hrdof`i'=1 if hrdof`i'==. & w302_0`i'!=9
  ta hrdof`i'
  drop w301_0`i'
}
forvalues i=10/13{
  ta w301_`i'
  gen hrdof`i'=.
  replace hrdof`i'=1 if w301_`i'==1|w301_`i'==2
  replace hrdof`i'=0 if w301_`i'==3
  replace hrdof`i'=1 if hrdof`i'==. & w302_`i'!=9
  ta hrdof`i'
  drop w301_`i'
}
drop w301_14
drop w301_15
drop w301_14o
drop w301_15o

label var hrdof1 "Heard of Female Sterilization"
label var hrdof2 "Heard of Male Sterilization"
label var hrdof3 "Heard of Pill"
label var hrdof4 "Heard of IUCD"
label var hrdof5 "Heard of Injection"
label var hrdof6 "Heard of Arm Implant"
label var hrdof7 "Heard of Male Condom"
label var hrdof8 "Heard of Female Condom"
label var hrdof9 "Heard of Rhythm Method"
label var hrdof10 "Heard of Withdraw"
label var hrdof11 "Heard of Morning After Pill"
label var hrdof12 "Heard of Lactational Amenorrhea"
label var hrdof13 "Heard of Spermicide"

gen hrdofany=w303
recode hrdofany 2=0
label var hrdofany "Heard of Any Contraceptive Methods"

*have you ever used the following:

gen eusedany=0
forvalues i=1/9{
  replace eusedany=1 if w302_0`i'==1
}
forvalues i=10/15{
  replace eusedany=1 if w302_`i'==1
}

label var eusedany "Ever used Any Contraceptive Method"

forvalues i=1/9{
  ta w302_0`i'
  gen eused`i'=0 if hrdof`i'==0
  replace eused`i'=0 if hrdof`i'==1 & w302_0`i'==2
  replace eused`i'=1 if hrdof`i'==1 & w302_0`i'==1
  ta eused`i'
  drop w302_0`i'
}
forvalues i=10/13{
  ta w302_`i'
  gen eused`i'=0 if hrdof`i'==0
  replace eused`i'=0 if hrdof`i'==1 & w302_`i'==2
  replace eused`i'=1 if hrdof`i'==1 & w302_`i'==1
  ta eused`i'
  drop w302_`i'
}
drop w302_14
drop w302_15

label var eused1 "Ever used Female Sterilization"
label var eused2 "Ever used Male Sterilization"
label var eused3 "Ever used Pill"
label var eused4 "Ever used IUCD"
label var eused5 "Ever used Injection"
label var eused6 "Ever used Arm Implant"
label var eused7 "Ever used Male Condom"
label var eused8 "Ever used Female Condom"
label var eused9 "Ever used Rhythm Method"
label var eused10 "Ever used Withdraw"
label var eused11 "Ever used Morning After Pill"
label var eused12 "Ever used Lactational Amenorrhea"
label var eused13 "Ever used Spermicide"

order indid - undrstd_rthm hrdofany hrdof1 - hrdof13 eusedany eused1 - eused13

*Family Planning Messages
forvalues i=1/9{
  ta w304_0`i', nol
  gen fpmes`i'=0 if w303==2
  replace fpmes`i'=1 if w304_0`i'==1
  replace fpmes`i'=0 if w304_0`i'==2
  ta fpmes`i'
  drop w304_0`i'
}
forvalues i=10/29{
  ta w304_`i', nol
  gen fpmes`i'=0 if w303==2
  replace fpmes`i'=1 if w304_`i'==1
  replace fpmes`i'=0 if w304_`i'==2
  ta fpmes`i'
  drop w304_`i'
}
gen fpmesany=0 if w303==2
replace fpmesany=1 if w304_30==2
replace fpmesany=0 if w304_30==1
ta fpmesany

drop w303 w304_30 w304_31 w304o

label var fpmesany "saw an fp mess in past year"
label var fpmes1 "fp mess on radio in past year"
label var fpmes2 "fp mess on tv in past year"
label var fpmes3 "fp mess in newspaper in past year"
label var fpmes4 "fp mess in magazine in past year"
label var fpmes5 "fp mess on billboard in past year"
label var fpmes6 "fp mess in a play in past year"
label var fpmes7 "fp mess during comm event in past year"
label var fpmes8 "fp mess in pub hosp in past year"
label var fpmes9 "fp mess in pub hlth cntr in past year"
label var fpmes10 "fp mess in hlth post in past year"
label var fpmes11 "fp mess from mobile hlth team in past year"
label var fpmes12 "fp mess in teen hlth cntr in past year"
label var fpmes13 "fp mess at hlth chck-up in past year"
label var fpmes14 "fp mess at other public in past year"
label var fpmes15 "fp mess at priv hosp/clnc in past year"
label var fpmes16 "fp mess at priv pharmacy in past year"
label var fpmes17 "fp mess at relig clinic in past year"
label var fpmes18 "fp mess at other priv med clinic in past year"
label var fpmes19 "fp mess at informal doctor in past year"
label var fpmes20 "fp mess from midwife in past year"
label var fpmes21 "fp mess from informal nurse in past year"
label var fpmes22 "fp mess from ?matrone? in past year"
label var fpmes23 "fp mess from trad healer in past year"
label var fpmes24 "fp mess at school in past year"
label var fpmes25 "fp mess at church in past year"
label var fpmes26 "fp mess at a bar in past year"
label var fpmes27 "fp mess from parents in past year"
label var fpmes28 "fp mess from NGO in past year"
label var fpmes29 "fp mess from other source in past year"

drop w305 - w308c

order indid - eused13 fpmesany fpmes1 - fpmes29

*Current Contraceptive Use

/*
gen any_trad=0
replace any_trad=1 if w311_11==1 | w311_12==1
gen any_mod=0
replace any_mod=1 if w311_01==1|w311_02==1|w311_03==1|w311_04==1|w311_05==1|w311_06==1|w311_07==1|w311_08==1|w311_09==1|w311_10==1
ta any_trad any_mod

*/


ta eusedany
ta w309
ta w310
gen ccontra2=1 if w310==1
replace ccontra2=0 if w310==2
replace ccontra2=0 if eusedany==0 & w310!=3 & prego!=1
ta ccontra2

drop w309 w310

gen ccontra5=0 if ccontra2==0
replace ccontra5=4 if w311_01==1|w311_02==1|w311_03==1|w311_04==1
replace ccontra5=3 if ccontra5==. & w311_05==1| ccontra5==. & w311_06==1
replace ccontra5=2 if ccontra5==. & w311_11==1| ccontra5==. & w311_12==1
replace ccontra5=1 if ccontra5==. & ccontra2==1
su ccontra2 ccontra5
ta ccontra5

gen ccontra3=0 if ccontra5==0
replace ccontra3=1 if ccontra5==2
replace ccontra3=2 if ccontra5==1|ccontra5==3|ccontra5==4
ta ccontra3, missing

label var ccontra2 "Currently Using contraceptives"
label var ccontra3 "Contraceptive method used (3) "
label define contra3 0 "None" 1 "Traditional" 2 "Modern"
label values ccontra3 contra3
label var ccontra5 "Contraceptive method used (5) "
label define contra5 0 "None" 1 "moring_after/condom/spermicide/other/NS" 2 "Traditional" 3 "Short-term" 4 "Long-term"
label values ccontra5 contra5

ta ccontra2
ta ccontra3
ta ccontra5

gen askedFPloc=0
replace askedFPloc=1 if w319==1

order indid - fpmes29 ccontra2 ccontra3 ccontra5 askedFPloc

drop w312 - w354o

*Beliefs about male condoms
ta w372
gen mcondom1=w372
recode mcondom1 4=8
recode mcondom1 9=.
ta mcondom1
drop w372
label var mcondom1 "Male condoms work: most times=1, sometimes=2, never=3, don't know=4"

ta w373, nol
gen mcondom2=w373
recode mcondom2 9=8
recode mcondom2 2=0
ta mcondom2
drop w373
label var mcondom2 "Male condoms reduce male pleasure"

ta w374, nol
gen mcondom3=w374
recode mcondom3 9=8
recode mcondom3 2=0
ta mcondom3
drop w374
label var mcondom3 "Male condoms reduce female pleasure"

ta w375, nol
gen mcondom4=w375
recode mcondom4 9=8
recode mcondom4 2=0
ta mcondom4
drop w375
label var mcondom4 "Male condoms signify cheating"

*Feelings about Family Planning Providers
ta w376, nol 
ta w377, nol 
ta w378, nol 
rename w376 fppq1
rename w377 fppq2
rename w378 fppq3
label var fppq1 "FPP treat clients poorly"
label var fppq2 "Women don't like the way they are treated by FPPs around here"
label var fppq3 "FPP make women feel bad when obtaining contraceptives"

*Beliefs about Contraceptives
ta w379, nol
ta w380, nol
ta w381, nol
ta w382, nol
ta w383, nol
ta w384, nol
ta w385, nol
rename w379 bcbelief1
rename w380 bcbelief2
rename w381 bcbelief3
rename w382 bcbelief4
rename w383 bcbelief5
rename w384 bcbelief6
rename w385 bcbelief7
label var bcbelief1 "Contraceptive injection can make a woman permanetly infertile"
label var bcbelief2 "People who use family planning end up with health problems"
label var bcbelief3 "Contraceptives can harm your womb"
label var bcbelief4 "Contraceptives reduce women's sexual urge"
label var bcbelief5 "Contraceptives can cause cancer"
label var bcbelief6 "Contraceptives can give you deformed babies"
label var bcbelief7 "Contraceptives are dangerous to your health"

order indid - ccontra5 mcondom1-mcondom4 fppq1-fppq3 bcbelief1-bcbelief7

*********************************************
**********MATERNAL AND CHILD HEALTH**********
*********************************************

* has had birth since 2009 (2601)
ta w401
gen child2009=0
replace child2009=1 if w401==1

*Vaccine visit for new children
su e15w_1 - e15w_9
ta e15w_1
gen vacvisit1=0 if w401==1
forvalues i=1/7 {
  replace vacvisit1=1 if e15w_`i'==1
}
ta vacvisit1

gen vacvisit2=0
replace vacvisit2=1 if e15w_8!=1 & e15w_8!=.

ta e21w
gen vacfpmes=e21w
recode vacfpmes 2=0
recode vacfpmes 8=.
recode vacfpmes 9=.
replace vacfpmes=. if vacvisit1==0
ta vacfpmes

label var vacvisit1 "took child for vaccinations"
label var vacfpmes "Heard family planning message at vaccine visit"

drop w401 - e22w

*Health visit for child
ta w408 
gen livingchild=0
replace livingchild=1 if w408==1

ta w409
gen chvisit=w409
recode chvisit 2=0
recode chvisit 9=.
ta chvisit

ta w414
gen chfpmes=w414
recode chfpmes 2=0
recode chfpmes 9=.
ta chfpmes

label var livingchild "has a living child"
label var chvisit "Child health visit in the last 3 months"
label var chfpmes "Heard family planning message at child health visit"

drop w408 - w415

*Maternal Health visit (for prenatal and/or postpartum care)
ta w416
gen mhvisit= w416
recode mhvisit 2=0
recode mhvisit 9=.
ta mhvisit

ta w420
gen mhfpmes=w420
recode mhfpmes 2=0
recode mhfpmes 9=.
ta mhfpmes

label var mhvisit "Maternal health visit in the last 12 months"
label var mhfpmes "Heard family planning message at Maternal health visit"

drop w416 - w421

*HIV test visit (in last 12 months)
ta w422
gen hivvisit=w422
recode hivvisit 2=0
recode hivvisit 9=.
ta hivvisit

ta w425
gen hivfpmes=w425
recode hivfpmes 2=0
recode hivfpmes 9=.
ta hivfpmes

label var hivvisit "HIV visit in the last 12 months"
label var hivfpmes "Heard family planning message at HIV health visit"

drop w422 - w426

*Pharmacy visit (asked about last one, assumed everyone has been)

ta w428
gen rxfpmes=w428
recode rxfpmes 2=0
recode rxfpmes 9=.
ta rxfpmes

label var rxfpmes "Heard family planning message at pharmacy"

drop w428

order indid - bcbelief7 child2009 vacvisit1 vacvisit2 vacfpmes livingchild chvisit chfpmes mhvisit mhfpmes hivvisit hivfpmes rxfpmes

************************************************
**********SEXUAL ACTIVITY AND MARRAIGE**********
************************************************

*Early sexual history
ta w501, nol
gen eversex=0 if w501==0
replace eversex=1 if eversex==. & w501<98
replace eversex=. if w501>.
ta eversex
gen sexage=w501 if w501>0 & w501<98
label var eversex "Have you ever hax sex?"
label var sexage "Age first time she had sex"

*Current sexual activity
ta w506, nol
gen sexfreq0=.
gen sexfreq1=.
gen sexfreq2=.
gen sexfreq3=.
gen sexfreq4=.

replace sexfreq0=1 if w506==.
replace sexfreq0=1 if w506==0
replace sexfreq0=1 if w506o=="LE MARI A VOYAGE"
replace sexfreq0=1 if w506o=="LE MARI EST UN IMMIGRE, ABSENT 3 MOIS"
replace sexfreq0=1 if w506o=="MARI ABSENT"
replace sexfreq0=1 if w506o=="MARI EN ITALIE"
replace sexfreq0=1 if w506o=="MARI EN VOYAGE"
replace sexfreq0=1 if w506o=="MARI ETAIT EN VOYAGE"
replace sexfreq0=1 if w506o=="MARI VIT AILLEUR"
replace sexfreq0=1 if w506o=="MARI VIT AILLEURS"
replace sexfreq0=1 if w506o=="PAS DE RAPPORT DANS LES 3 MOIS"
replace sexfreq0=1 if w506o=="PAS DE RAPPORT PENDANT 3 MOIS MARI ABSEN"
replace sexfreq0=1 if w506o=="SON MARI VIT AU CONGO"
replace sexfreq0=1 if w506o=="VIENT D ACCOUCHER"
replace sexfreq0=1 if w506o=="VIENT JUSTE D ACCOUCHER"

replace sexfreq1=1 if w506>=1 & w506<=10
replace sexfreq1=1 if w506==993
replace sexfreq1=1 if w506o=="1 FOIS LES 3 MOIS"
replace sexfreq1=1 if w506o=="1 FOIS TOUS LES 15 JOURS"
replace sexfreq1=1 if w506o=="2 A 3 FOIS PAR SEMAINE"
replace sexfreq1=1 if w506o=="2 FOIS PAR MOIS"
replace sexfreq1=1 if w506o=="2PAR MOIS"
replace sexfreq1=1 if w506o=="2X PAR MOIS"
replace sexfreq1=1 if w506o=="3 JRS PAR MOIS"
replace sexfreq1=1 if w506o=="TOUTES LES 15 JOURS"
replace sexfreq1=1 if w506o=="UNE FOIS PAR MOIS"

replace sexfreq2=1 if w506>10 & w506<=20
replace sexfreq2=1 if w506==992
replace sexfreq2=1 if w506o=="2 FOIS PAR 15 JOURS"
replace sexfreq2=1 if w506o=="2 FOIS TOUS LES 15 JOURS"
replace sexfreq2=1 if w506o=="2 X TOUS LES 15 JOURS"
replace sexfreq2=1 if w506o=="3 FOIS PAR MOIS"
replace sexfreq2=1 if w506o=="3 FOIS TOUS LES 15 JOURS"
replace sexfreq2=1 if w506o=="TIUS LES 4 JOURS"

replace sexfreq3=1 if w506>20 & w506<=30
replace sexfreq3=1 if w506o=="2 A 3 FOIS/SEMAINES"
replace sexfreq3=1 if w506o=="2 FOIS DANS LA SEMAINE"
replace sexfreq3=1 if w506o=="2 FOIS PAR SEMAINE"
replace sexfreq3=1 if w506o=="2 FOIS PAR SEMAINES"
replace sexfreq3=1 if w506o=="2 FOIS SEMAINES"
replace sexfreq3=1 if w506o=="2 FOIS TOUTES LES SEMAINES"
replace sexfreq3=1 if w506o=="2 FOIS/SEMAINES"
replace sexfreq3=1 if w506o=="2 X PAR SEMAINE"
replace sexfreq3=1 if w506o=="2FOIS PAR SEMAINE"
replace sexfreq3=1 if w506o=="2X PAR SEMAINE"
replace sexfreq3=1 if w506o=="DEUX FOIS PAR SEMAINE"
replace sexfreq3=1 if w506o=="DEUX FOIS TOUS LES SEMAINES"
replace sexfreq3=1 if w506o=="DEUX FOIS TOUTES LES SEMAINES"
replace sexfreq3=1 if w506o=="TOUS LES DEUX SEMAINES"

replace sexfreq4=1 if w506>30 & w506<991
replace sexfreq4=1 if w506==991
replace sexfreq4=1 if w506o=="1 FOIS TOUS LES JOURS"
replace sexfreq4=1 if w506o=="3 FOIS PAR SEMAINE"
replace sexfreq4=1 if w506o=="3 FOIS PAR SEMAINES"
replace sexfreq4=1 if w506o=="3 FOIS PAS SEMAINE"
replace sexfreq4=1 if w506o=="3 FOIS SEMAINE"
replace sexfreq4=1 if w506o=="3 X PAR SEMAINES"
replace sexfreq4=1 if w506o=="3A4 FOIS PAR SEMAINE"
replace sexfreq4=1 if w506o=="4 FOIS PAR SEMAINE"
replace sexfreq4=1 if w506o=="4 FOIS\SEMINES"
replace sexfreq4=1 if w506o=="4OU 5 FOIS PAR SEMAINE"
replace sexfreq4=1 if w506o=="5 FOIS PAR SEMAINE"
replace sexfreq4=1 if w506o=="5 FOIS/SEMAINE"
replace sexfreq4=1 if w506o=="5FOIS PAR SEMAINE"
replace sexfreq4=1 if w506o=="TOUS LES 2 JOURS"
replace sexfreq4=1 if w506o=="TOUS LES JOURS"
replace sexfreq4=1 if w506o=="TROIS FOIS PAR SEMAINE"
replace sexfreq4=1 if w506o=="TROIS FOIS SEMAINE"

replace sexfreq0=0 if sexfreq1==1|sexfreq2==1|sexfreq3==1|sexfreq4==1
replace sexfreq1=0 if sexfreq0==1|sexfreq2==1|sexfreq3==1|sexfreq4==1
replace sexfreq2=0 if sexfreq0==1|sexfreq1==1|sexfreq3==1|sexfreq4==1
replace sexfreq3=0 if sexfreq0==1|sexfreq1==1|sexfreq2==1|sexfreq4==1
replace sexfreq4=0 if sexfreq0==1|sexfreq1==1|sexfreq2==1|sexfreq3==1

label var sexfreq0 "No sex in last 3 months"
label var sexfreq1 "Sex between 1 and 10 times in last 3 months"
label var sexfreq2 "Sex between 10 and 20 times in last 3 months"
label var sexfreq3 "Sex between 20 and 30 in last 3 months"
label var sexfreq4 "Sex between >30 times in last 3 months"

ta w509
gen lastsxbc=w509
recode lastsxbc 2=0
replace lastsxbc=. if lastsxbc>1
ta lastsxbc

label var lastsxbc "did you use BC during your last sexual encounter?"

forvalues i=1/9{
  ta w510_0`i'
  gen lastsxmth`i'=.
  replace lastsxmth`i'=1 if w510_0`i'==1
  replace lastsxmth`i'=0 if w510_0`i'==2
  ta lastsxmth`i'
  drop w510_0`i'
}
forvalues i=10/13{
  ta w510_`i'
  gen lastsxmth`i'=.
  replace lastsxmth`i'=1 if w510_`i'==1
  replace lastsxmth`i'=0 if w510_`i'==2
  ta lastsxmth`i'
  drop w510_`i'
}

label var lastsxmth1 "Used Female Sterilization for last sex"
label var lastsxmth2 "Used Male Sterilization for last sex"
label var lastsxmth3 "Used Arm Implant for last sex"
label var lastsxmth4 "Used IUCD for last sex"
label var lastsxmth5 "Used Injection for last sex"
label var lastsxmth6 "Used Pill for last sex"
label var lastsxmth7 "Used Morning After Pill for last sex"
label var lastsxmth8 "Used Male Condom for last sex"
label var lastsxmth9 "Used Female Condom for last sex"
label var lastsxmth10 "Used Spermicide for last sex"
label var lastsxmth11 "Used Rhythm Method for last sex"
label var lastsxmth12 "Used Rhythm/Withdraw for last sex"
label var lastsxmth13 "Used Lactational Amenorrhea for last sex"

drop w501 - w510o

order indid - rxfpmes eversex sexage sexfreq0-sexfreq4 lastsxbc lastsxmth1-lastsxmth13

* Current Marraige Status
ta w511
ta w512
gen nevmar=0 if w511!=9
replace nevmar=1 if w511==3

gen married=0
replace married=1 if w512==1|w512==5
replace married=. if w512==9
gen cohabit=0
replace cohabit=1 if w512==1|w512==2
replace cohabit=. if w512==9
ta married
ta cohabit

gen partner=0
replace partner=1 if married==1 | cohabit==1
replace partner=. if married==. & cohabit==.

label var married "Woman is married"
label var cohabit "Woman lives with a man"
label var partner "Woman is married or lives with a man"

ta w514
gen otherwives=w514
recode otherwives 2=0 
recode otherwives 8=. 
recode otherwives 9=. 
ta otherwives

label var otherwives "Man has other wives"

drop w511 - w519

order indid - lastsxmth13 married cohabit partner otherwives

*****************************************
**********FERTILITY PREFERENCES**********
*****************************************

*Pregnancy possible
ta w601
ta w602, nol
gen pregpos=.
replace pregpos=1 if w602==1|w602==2|w602==8
replace pregpos=0 if w602==3|w601==2
ta pregpos

label var pregpos "Pregnancy is possible"

*Child Preferences
gen morchld=1 if w602==1
replace morchld=0 if w602==2|w602==8
gen nomorchld=1 if w602==2
replace nomorchld=0 if w602==1|w602==8
gen undchld=1 if w602==8
replace undchld=0 if w602==1|w602==2
ta morchld
ta nomorchld
ta undchld

label var morchld "Want to have more children"
label var nomorchld "Don't want to have any more children"
label var undchld "Undecided as to whether or not want to have more children"

ta prego
ta w601
ta w602
ta w604 
ta w605, nol

gen pregprob=w605
recode pregprob 9=.
label var pregprob "How big of a problem would it be if you got pregnant in the next few weeks?"
label define problems 1 "Big Problem" 2 "Small Problem" 3 "No Problem" 4 "Not Having Sex"
label values pregprob problems
ta pregprob

drop w601 - w606o

order indid - otherwives pregpos morchld nomorchld undchld pregprob

ta w607
ta w608, nol

gen pmorchld=1 if w608==1
replace pmorchld=0 if w608==2|w608==8
gen pnomorchld=1 if w608==2
replace pnomorchld=0 if w608==1|w608==8
gen pundchld=1 if w608==8
replace pundchld=0 if w608==1|w608==2
ta pmorchld
ta pnomorchld
ta pundchld

label var pmorchld "Partner wants to have more children"
label var pnomorchld "Partner doesn't want to have any more children"
label var pundchld "Don't know partners preferences on more children"

drop w607 - w611o

*Ideal number of Kids
ta w612, nol
gen idealkids=w612
recode idealkids 99=.
ta idealkids
label var idealkids "Ideal number of children"
label define idealbl 96 "non-numeric"
label values idealkids ideallbl

replace idealkids=homekids+awaykids if w612o=="CE QUE J AI ME CONVIENT"
replace idealkids=homekids+awaykids if w612o=="LE NOMBRE ACTUEL SUFFIT"
replace idealkids=homekids+awaykids-1 if w612o=="MOINS DE CE QUE J'AI ACTUELLEMENT"

replace idealkids=0 if w612o=="ELLE NE VOULAIT D ENFANTS"
replace idealkids=0 if w612o=="N AVAIS PAS RIEN VOULU"

gen uptogod=0 
replace uptogod=1 if w612o=="A DEPEND DE DIEU"
replace uptogod=1 if w612o=="AUTANT QUE LE BON DIEU VOULU M EN DONNER"
replace uptogod=1 if w612o=="C EST A DIEU DE DECIDER LE NOMBRE"
replace uptogod=1 if w612o=="C EST DIEU QUI DECIDE"
replace uptogod=1 if w612o=="C'EST DIEU QUI DECIDE"
replace uptogod=1 if w612o=="CA DEPEND DE DIEU"
replace uptogod=1 if w612o=="CE  QUE DIEU ME DONNA"
replace uptogod=1 if w612o=="CE DEPEND DE DIEU"
replace uptogod=1 if w612o=="CE DIEU ME DONNERA"
replace uptogod=1 if w612o=="CE QUE DIEU DECIDA"
replace uptogod=1 if w612o=="CE QUE DIEU DECIDE"
replace uptogod=1 if w612o=="CE QUE DIEU DECIDERA"
replace uptogod=1 if w612o=="CE QUE DIEU DONNE"
replace uptogod=1 if w612o=="CE QUE DIEU DONNERA"
replace uptogod=1 if w612o=="CE QUE DIEU FERA"
replace uptogod=1 if w612o=="CE QUE DIEU M'A DONNE"
replace uptogod=1 if w612o=="CE QUE DIEU ME  DONNERA"
replace uptogod=1 if w612o=="CE QUE DIEU ME DONNE"
replace uptogod=1 if w612o=="CE QUE DIEU ME DONNE J'AI JAMAIS PENSE A"
replace uptogod=1 if w612o=="CE QUE DIEU ME DONNERA"
replace uptogod=1 if w612o=="CE QUE DIEU NOUS DONNE"
replace uptogod=1 if w612o=="CE QUE DIEU TE DONNE"
replace uptogod=1 if w612o=="CE QUE ME DIEU ME DONNERA"
replace uptogod=1 if w612o=="CELA DEPEND DE DIEU"
replace uptogod=1 if w612o=="CELA DEPEND DE DIEY"
replace uptogod=1 if w612o=="CELA DEPEND DIEU"
replace uptogod=1 if w612o=="DEPEN DE DIEU"
replace uptogod=1 if w612o=="DEPEND DE CE QUE DIEU ME DONNERA"
replace uptogod=1 if w612o=="DEPEND DE DIEU"
replace uptogod=1 if w612o=="DEPEND DE LA VOLONTE DE DIEU"
replace uptogod=1 if w612o=="DEPEND DE LA VOLONTE DIVINE"
replace uptogod=1 if w612o=="DEPEND DIEU"
replace uptogod=1 if w612o=="DEPENDAIS DE DIEU"
replace uptogod=1 if w612o=="DEPENDANCE DE DIEU"
replace uptogod=1 if w612o=="DEPENDANCE DIVINE"
replace uptogod=1 if w612o=="DEPENDE DE DIEU"
replace uptogod=1 if w612o=="DEPENDENCE DIVINE"
replace uptogod=1 if w612o=="DEPENDRA DE DIEU"
replace uptogod=1 if w612o=="DEPENF DE DIEU"
replace uptogod=1 if w612o=="DEPNDRA DE LA VOLONTE DIVINE"
replace uptogod=1 if w612o=="DIEU"
replace uptogod=1 if w612o=="DIEU  DECIDE"
replace uptogod=1 if w612o=="DIEU DECIDE"
replace uptogod=1 if w612o=="DIEU ME DONNERA"
replace uptogod=1 if w612o=="DIEU MERCI"
replace uptogod=1 if w612o=="DIEU QUI DECIDE"
replace uptogod=1 if w612o=="DIEU SAIT"
replace uptogod=1 if w612o=="DIEU SEIL SAIT"
replace uptogod=1 if w612o=="DIEU SEUL"
replace uptogod=1 if w612o=="DIEU SEUL DECIDE"
replace uptogod=1 if w612o=="DIEU SEUL LE SAIT"
replace uptogod=1 if w612o=="DIEU SEUL QUI DECIDE"
replace uptogod=1 if w612o=="DIEU SEUL SAIS"
replace uptogod=1 if w612o=="DIEU SEUL SAIT EPOUX IBADOU IDEM FEMME"
replace uptogod=1 if w612o=="DIEUR DECIDE"
replace uptogod=1 if w612o=="DIEUR SEUL SAIT"
replace uptogod=1 if w612o=="ELLE N A PAS LE CHOIX"
replace uptogod=1 if w612o=="FATALISME"
replace uptogod=1 if w612o=="FATALISME DEPEND DE DIEU"
replace uptogod=1 if w612o=="FATALISTE"
replace uptogod=1 if w612o=="FATALISTE DEPEND DE DIEU"
replace uptogod=1 if w612o=="FATALITE"
replace uptogod=1 if w612o=="FATLISME DEPEND DE DIEU"
replace uptogod=1 if w612o=="JE N'AI AUCUN CHOIX LA DESSUS"
replace uptogod=1 if w612o=="JE N'AVAIS PAS LE CHOIX"
replace uptogod=1 if w612o=="JE PRENDRAIS CE QUE DIEU ME DONNERA"
replace uptogod=1 if w612o=="JE PRENDRAIS TOUT CE QUE DIEU ME DONNERA"
replace uptogod=1 if w612o=="JE PRENDRAS CE QUE DIEU ME DONNERA"
replace uptogod=1 if w612o=="JE REMETS A DIEU"
replace uptogod=1 if w612o=="LE NOMBRE IMPORTE C EST DIEU QUI DECIDE"
replace uptogod=1 if w612o=="LE NOMBRE QUE DIEU ME DONNERA"
replace uptogod=1 if w612o=="N A JAMAIS PENSER AU NOMBRE CE QUE DIEU"
replace uptogod=1 if w612o=="N A PAS DE CHOIX"
replace uptogod=1 if w612o=="N Y A JAMAIS PENSE TOUT DEPEND DE DIEU"
replace uptogod=1 if w612o=="PAS DE CHOIX"
replace uptogod=1 if w612o=="PLUSIEURS, TOUT CE QUE DIEU ME DONNE"
replace uptogod=1 if w612o=="S EN REMET A DIEU"
replace uptogod=1 if w612o=="SEUL DIEU DECIDE"
replace uptogod=1 if w612o=="SEUL DIEU LE SAIT"
replace uptogod=1 if w612o=="SEUL DIEU SAIT"
replace uptogod=1 if w612o=="TANT QUE DIEU ME DONNE"
replace uptogod=1 if w612o=="TOUT CE QUE DIEU LA DONNE"
replace uptogod=1 if w612o=="TOUT CE QUE DIEU LA DONNE COMME ENFANTS"
replace uptogod=1 if w612o=="TOUT CE QUE DIEU LA DONNE ELLE ACCEPTERA"
replace uptogod=1 if w612o=="TOUT CE QUE DIEU LUI DONNE"
replace uptogod=1 if w612o=="TOUT CE QUE DIEU ME DONNE"
replace uptogod=1 if w612o=="TOUT CE QUE DIEU ME DONNERA"
replace uptogod=1 if w612o=="TOUT CE QUE DIEU NOUS DONNE"
replace uptogod=1 if w612o=="TOUT DE DEPEND DE DIEU"
replace uptogod=1 if w612o=="TOUT DEPEND DE DIEU"
replace uptogod=1 if w612o=="TOUT DEPEND DIEU"
replace uptogod=1 if w612o=="VOLONTE DE DIEU"
replace uptogod=1 if w612o=="VOLONTE DEVINE"
replace uptogod=1 if w612o=="VOLONTE DIVINE"
replace uptogod=1 if w612o=="VOLONTEDIVINE"
replace uptogod=1 if w612o=="VONLONTE DIVINE"
replace uptogod=1 if w612o=="çA DEPEND DE DIEU"

label var uptogod "total number of children is up to God"

gen lotsofkids=0
replace lotsofkids=1 if w612o=="AUTANT QUE POSSIBLE"
replace lotsofkids=1 if w612o=="BEAUCOU D'ENFANTS"
replace lotsofkids=1 if w612o=="BEAUCOUP"
replace lotsofkids=1 if w612o=="BEAUCOUP D ENFANT"
replace lotsofkids=1 if w612o=="BEAUCOUP D ENFANTS"
replace lotsofkids=1 if w612o=="BEAUCOUP D'ENFANTS"
replace lotsofkids=1 if w612o=="LE MAXIMUN POSSIBLE"
replace lotsofkids=1 if w612o=="PAS DE LIMITE"
replace lotsofkids=1 if w612o=="SOUHAITE AVOIR AUTANT D ENFANTS POSSIBLE"

label var lotsofkids "wants LOTS (non-specific number) of kids"

replace idealkids=. if idealkids==96 & uptogod==0 & lotsofkids==0 

replace uptogod=. if idealkids==.
replace lotsofkids=. if idealkids==.

di _N

su idealkids uptogod lotsofkids

drop w612 - w618o

*Partners influence on health?
ta w619
ta w620
ta w621,nol

gen paccomphf1=0 if w619==1 & w620!=9
gen paccomphf2=0 if w619==1 & w620!=9
gen paccomphf3=0 if w619==1 & w620!=9
gen paccomphf4=0 if w619==1 & w620!=9
gen paccomphf5=0 if w619==1 & w620!=9

replace paccomphf1=1 if w620==2
replace paccomphf2=1 if w621==1
replace paccomphf3=1 if w621==2
replace paccomphf4=1 if w621==3
replace paccomphf5=1 if w621==4

ta paccomphf1 
ta paccomphf2 
ta paccomphf3 
ta paccomphf4 
ta paccomphf5

label var paccomphf1 "Partner NEVER accompanies to health facility"
label var paccomphf2 "Partner RARELY accompanies to health facility"
label var paccomphf3 "Partner SOMETIMES accompanies to health facility"
label var paccomphf4 "Partner OFTEN accompanies to health facility"
label var paccomphf5 "Partner ALWAYS accompanies to health facility"

drop w619 - w621

order indid - pregprob pmorchld pnomorchld pundchld idealkids uptogod lotsofkids paccomphf1 - paccomphf5

***********************************************************
**********SPOUSAL AND INTERPERSONAL COMMUNICATION**********
***********************************************************

*partner discussions
ta w701
ta w702

gen pdisnk=w702
recode pdisnk 9=.
recode pdisnk 2=0
ta pdisnk

label var pdisnk "Discussed number of kids with partner"

ta w704
ta w707, nol

gen pdisfp=w704
recode pdisfp 9=.
recode pdisfp 2=0
ta pdisfp

label var pdisfp "Discussed family planning methods with partner"

*Others influence on FP
ta w709_01
forvalues i=1/6 {
gen fpinflu`i'=0 if w709_01!=9
}
replace fpinflu1=1 if w709_01==1|w709_03==1
replace fpinflu2=1 if w709_02==1|w709_04==1
replace fpinflu3=1 if w709_05==1|w709_06==1|w709_10==1|w709_11==1|w709_13==1
replace fpinflu4=1 if w709_07==1
replace fpinflu5=1 if w709_08==1|w709_09==1
replace fpinflu6=1 if w709_12==1
su fpinflu1-fpinflu6

label var fpinflu1 "FATHERS influence family planning"
label var fpinflu2 "MOTHERS influence family planning"
label var fpinflu3 "OTHER FAMILY MEMBERS influence family planning"
label var fpinflu4 "FRIENDS influence family planning"
label var fpinflu5 "COMMUNITY WORKERS influence family planning"
label var fpinflu6 "RELIGIOUS LEADERS influence family planning"

drop w701 - w709o

order indid - paccomphf5 pdisnk pdisfp fpinflu1 - fpinflu6 

* Need permission for BC
ta w710
ta w711_1 

gen ptnrperm=0 if w710!=9 & w711_1!=9
gen prntperm=0 if w710!=9 & w711_1!=9
replace ptnrperm=1 if w711_1==1
replace prntperm=1 if w711_2==1|w711_3==1|w711_4==1|w711_5==1
ta ptnrperm
ta prntperm

label var ptnrperm "need PARTNERS permission for Birth Control"
label var prntperm "need PARENTS permission for Birth Control"

*family planning opinions of others
ta w713
gen govfpneg=w713
recode govfpneg 9=.
recode govfpneg 8=2
recode govfpneg 2=0
ta govfpneg

label var govfpneg "have heard gov speak publically AGAINST family planning"

ta w714
gen govfppos=w714
recode govfppos 9=.
recode govfppos 8=2
recode govfppos 2=0
ta govfppos

label var govfppos "have heard gov speak publically IN FAVOR OF family planning"

ta w716
gen rlfpneg=w716
recode rlfpneg 9=.
recode rlfpneg 8=2
recode rlfpneg 2=0
ta rlfpneg

label var rlfpneg "have heard religious leader speak publically AGAINST family planning"

ta w717
gen rlfppos=w717
recode rlfppos 9=.
recode rlfppos 8=2
recode rlfppos 2=0
ta rlfppos

label var rlfppos "have heard religious leader speak publically IN FAVOR OF family planning"

ta w718, nol
forvalues i=1/5{
gen fpothers`i'=0 if w718!=9
}
replace fpothers1=1 if w718==1
replace fpothers2=1 if w718==2
replace fpothers3=1 if w718==3
replace fpothers4=1 if w718==4
replace fpothers5=1 if w718==8
ta fpothers1
ta fpothers2
ta fpothers3
ta fpothers4
ta fpothers5

label var fpothers1 "NONE of my close friends or family use family planning"
label var fpothers2 "SOME of my close friends or family use family planning"
label var fpothers3 "MOST of my close friends or family use family planning"
label var fpothers4 "ALL of my close friends or family use family planning"
label var fpothers5 "DK about my close friends and families family planning use"

ta w719
gen fpcommneg=w719
recode fpcommneg 9=.
recode fpcommneg 8=2
recode fpcommneg 2=0
ta fpcommneg

label var fpcommneg "Community will treat you BAD for using FP"

ta w720
gen fpcommpos=w720
recode fpcommpos 9=.
recode fpcommpos 8=2
recode fpcommpos 2=0
ta fpcommpos

label var fpcommpos "Community will treat you BETTER for using FP"

drop w710 - w720

order indid - fpinflu6 ptnrperm prntperm govfpneg /*
*/ govfppos rlfpneg rlfppos fpothers1-fpothers5 fpcommneg fpcommpos

*Family Planning Access
ta w721
rename w721 fpaccess1
label var fpaccess1 "You can start a conversation with your partner about FP"  
label define help1 1 "Strongly Agree" 2 "Agree" 3 "Disagree" 4 "Strongly Disagree" 9 "Missing"  
label values fpaccess1 help1
ta fpaccess1

ta w722
rename w722 fpaccess2
label var fpaccess2 "You can convince your partner that your should use an FP method"  
label define help2 1 "Strongly Agree" 2 "Agree" 3 "Disagree" 4 "Strongly Disagree" 9 "Missing"  
label values fpaccess2 help2
ta fpaccess2

ta w723
rename w723 fpaccess3
label var fpaccess3 "You can get to a place that offers FP"  
label define help3 1 "Strongly Agree" 2 "Agree" 3 "Disagree" 4 "Strongly Disagree" 9 "Missing"  
label values fpaccess3 help3
ta fpaccess3

ta w724
rename w724 fpaccess4
label var fpaccess4 "You could obtain a FP method"  
label define help4 1 "Strongly Agree" 2 "Agree" 3 "Disagree" 4 "Strongly Disagree" 9 "Missing"  
label values fpaccess4 help4
ta fpaccess4

ta w725
rename w725 fpaccess5
label var fpaccess5 "You could use an FP method even if your partner did not want you to"  
label define help5 1 "Strongly Agree" 2 "Agree" 3 "Disagree" 4 "Strongly Disagree" 9 "Missing"  
label values fpaccess5 help5
ta fpaccess5

ta w726
rename w726 fpaccess6
label var fpaccess6 "You could use an FP method even if your family/friends didn't use them"  
label define help6 1 "Strongly Agree" 2 "Agree" 3 "Disagree" 4 "Strongly Disagree" 9 "Missing"  
label values fpaccess6 help6
ta fpaccess6

ta w727
rename w727 fpaccess7
label var fpaccess7 "You could use an FP method even if your religious leader did not want you to"  
label define help7 1 "Strongly Agree" 2 "Agree" 3 "Disagree" 4 "Strongly Disagree" 9 "Missing"  
label values fpaccess7 help7
ta fpaccess7

ta w728
rename w728 fpaccess8
label var fpaccess8 "You could use an FP method even if you experience some side-effects"  
label define help8 1 "Strongly Agree" 2 "Agree" 3 "Disagree" 4 "Strongly Disagree" 9 "Missing"  
label values fpaccess8 help8
ta fpaccess8

drop w729 - w735_3

order indid - fpcommpos fpaccess1-fpaccess8

**********************************************
**********Gender Inequality Measures**********
**********************************************

*Partner demographics
ta w801
ta w802, nol
gen page=w802
recode page 98=0
recode page 99=0
gen page_mis=0
replace page_mis=1 if w802==98
replace page_mis=1 if w802==99
ta page 
ta page_mis

label var page "Partners age"
label var page_mis "missing partners age"

ta w803 
ta w804

gen peduL0=w803
recode peduL0 9=.
recode peduL0 1=0
recode peduL0 2=1
ta peduL0

gen peduL1=0 if peduL0!=.
replace peduL1=1 if w804==1 & peduL0!=.

gen peduL2=0 if peduL0!=.
replace peduL2=1 if w804==2 & peduL0!=.

gen peduL3=0 if peduL0!=.
replace peduL3=1 if w804==3 & peduL0!=.

gen peduL4=0 if peduL0!=.
replace peduL4=1 if w804==4 & peduL0!=.

gen peduL5=0 if peduL0!=.
replace peduL5=1 if w804==8 & peduL0!=.
replace peduL5=1 if w804==9 & peduL0!=.

su peduL0 - peduL5

label var peduL0 "Partner attended NO school"
label var peduL1 "Partner attended ELEMENTARY school"
label var peduL2 "Partner attended MIDDLE school"
label var peduL3 "Partner attended HIGH school"
label var peduL4 "Partner attended COLLEGE"
label var peduL5 "Partner attended school, but DK level"

ta w807
gen pwork=w807
recode pwork 2=0
recode pwork 8=.
recode pwork 9=.
ta pwork

label var pwork "Partner is currently working"

drop w801 - w811

order indid - fpaccess8 page page_mis peduL0 - peduL5 pwork

*Womans working
ta w812 
ta w813
gen worknow=w812
recode worknow 2=0
recode worknow 9=.
ta worknow

label var worknow "Woman has worked in last 7 days"

gen workpast=w813
replace workpast=1 if worknow==1
recode workpast 2=0
recode workpast 9=.
ta workpast

label var workpast "Woman has worked in last 12 months"

*Partner prohibits
ta w824_1
ta w824_2
ta w824_3
ta w824_4
ta w824_5
ta w824_6

gen pprohibit1=w824_1
recode pprohibit1 2=0
recode pprohibit1 9=.
gen pprohibit2=w824_2
recode pprohibit2 2=0
recode pprohibit2 9=.
gen pprohibit3=w824_3
recode pprohibit3 2=0
recode pprohibit3 9=.
gen pprohibit4=w824_4
recode pprohibit4 2=0
recode pprohibit4 9=.
gen pprohibit5=w824_5
recode pprohibit5 2=0
recode pprohibit5 9=.
gen pprohibit6=w824_6
recode pprohibit6 2=0
recode pprohibit6 9=.

su pprohibit1 - pprohibit6

label var pprohibit1 "partner prohibits WORKING OUTSIDE HOUSE"
label var pprohibit2 "partner prohibits HAVING VISITS FROM PEOPLE"
label var pprohibit3 "partner prohibits VISITING YOUR FRIENDS"
label var pprohibit4 "partner prohibits VISITING YOUR FAMILY"
label var pprohibit5 "partner prohibits USING CONTRACEPTIVES"
label var pprohibit6 "partner prohibits USING A MOBILE PHONE"

drop w812 - sq25

order indid - pwork worknow workpast pprohibit1 - pprohibit6 

**********************************
**********Media Exposure**********
**********************************

*Magazine and Newspaper
ta w902 
ta w904
ta w906
gen newsmag=w902
replace newsmag=1 if w904==1
recode newsmag 9=.
recode newsmag 2=0
ta newsmag 

label var newsmag "reads newspapers or magazines"

ta w907
gen newsmagmes=w907
replace newsmagmes=2 if newsmag==0
recode newsmagmes 2=0
recode newsmagmes 9=.
ta newsmagmes

label var newsmagmes "has seen a fp message in newspaper/magazine in last 3 months"

drop w901_01 - w908o

*Radio
ta w909
gen radio=w909
recode radio 9=.
recode radio 2=0
ta radio

label var radio "listens to radio"

ta w914
gen radiomes=w914
replace radiomes=2 if radio==0
recode radiomes 2=0
recode radiomes 9=.
ta radiomes

label var radiomes "has heard a fp message on radio in last 3 months"

drop w909 - w916_5

*Television
ta w917
gen tv=w917
recode tv 2=0
recode tv 9=.
ta tv

label var tv "watches television"

ta w924
gen tvmes=w924
replace tvmes=2 if tv==0
recode tvmes 2=0
recode tvmes 9=.
ta tvmes

label var tvmes "has seen a fp message on TV in the last 3 months"

drop w917 - w926_5

*Movies
ta w927
gen movie=w927
recode movie 2=0
recode movie 9=.
ta movie

label var movie "goes to the movies"

*Cell Phone
ta w930, nol
gen cphone=w930
recode cphone 2=0
recode cphone 8=0
recode cphone 9=.
ta cphone

label var cphone "has own personal cell phone"

ta w934
ta w935
gen cphonetxt=w935
recode cphonetxt 2=0
recode cphonetxt .=0
recode cphonetx 9=.
ta cphonetxt

label var cphonetxt "has received a fp message on cell phone in last 3 months"

drop w927 - w935

*Internet
ta w936_1
ta w936_2
gen internet=0
replace internet=1 if w936_1==1|w936_2==1
replace internet=. if w936_1==9 & w936_2==9
ta internet

label var internet "has access to internet either via phone or computer"

order indid - pprohibit6 /*
*/ newsmag newsmagmes radio radiomes tv tvmes movie cphone /*
*/ cphonetxt internet ses1 ses2 ses3 women_weight_1 women_weight_2 /*
*/ women_weight_3 women_weight_4 women_weight_5 women_weight_6 /*
*/ women_weight_4_city women_weight_6_city   

label var ses1 "socio-economic status 1"
label var ses2 "socio-economic status 2"
label var ses3 "socio-economic status 3"

label var women_weight_1 "?"
label var women_weight_2 "?"
label var women_weight_3 "?"
label var women_weight_4 "?"
label var women_weight_5 "?"
label var women_weight_6 "?"
label var women_weight_4_city "?"
label var women_weight_6_city "?"

**************************************
** Where was woman at age 12 and 20 **
**************************************

gen years_in_home=.
replace years_in_home=1 if w1001>=100 & w1001<=112
replace years_in_home=2 if w1001>=113 & w1001<=124
replace years_in_home=3 if w1001>=125 & w1001<=199
replace years_in_home=w1001-200 if w1001>=201 & w1001<298
replace years_in_home=age if w1001==995
su years_in_home

gen age_at_last_move=age-years_in_home
ta age_at_last_move, missing

*12
gen years_12=max(0,age_at_last_move-12) if age_at_last_move!=.
ta years_12,missing
gen status_12=.
replace status_12=1 if 12>=age_at_last_move & age_at_last_move!=.
replace status_12=2 if 12<age_at_last_move & age_at_last_move!=. & city==1 & w1002==4
replace status_12=2 if 12<age_at_last_move & age_at_last_move!=. & city==2 & w1002==2
replace status_12=2 if 12<age_at_last_move & age_at_last_move!=. & city==3 & w1002==3
replace status_12=2 if 12<age_at_last_move & age_at_last_move!=. & city==4 & w1002==1
replace status_12=2 if 12<age_at_last_move & age_at_last_move!=. & city==5 & w1002==5
replace status_12=2 if 12<age_at_last_move & age_at_last_move!=. & city==6 & w1002==6
replace status_12=3 if 12<age_at_last_move & age_at_last_move!=. & status_12==. & w1002<7
replace status_12=4 if 12<age_at_last_move & age_at_last_move!=. & status_12==.
ta years_12 if years_12!=0, missing
su years_12 if years_12!=0
ta status_12, missing

gen location_12=w1002 if status_12!=1
replace location_12=1 if city==4 & status_12==1
replace location_12=2 if city==2 & status_12==1
replace location_12=3 if city==3 & status_12==1
replace location_12=4 if city==1 & status_12==1
replace location_12=5 if city==5 & status_12==1
replace location_12=6 if city==6 & status_12==1
recode location_12 99=9
ta location_12, missing

*15
gen years_15=max(0,age_at_last_move-15) if age_at_last_move!=.
ta years_15,missing
gen status_15=.
replace status_15=1 if 15>=age_at_last_move & age_at_last_move!=.
replace status_15=2 if 15<age_at_last_move & age_at_last_move!=. & city==1 & w1002==4
replace status_15=2 if 15<age_at_last_move & age_at_last_move!=. & city==2 & w1002==2
replace status_15=2 if 15<age_at_last_move & age_at_last_move!=. & city==3 & w1002==3
replace status_15=2 if 15<age_at_last_move & age_at_last_move!=. & city==4 & w1002==1
replace status_15=2 if 15<age_at_last_move & age_at_last_move!=. & city==5 & w1002==5
replace status_15=2 if 15<age_at_last_move & age_at_last_move!=. & city==6 & w1002==6
replace status_15=3 if 15<age_at_last_move & age_at_last_move!=. & status_15==. & w1002<7
replace status_15=4 if 15<age_at_last_move & age_at_last_move!=. & status_15==.
ta years_15 if years_15!=0, missing
su years_15 if years_15!=0
ta status_15, missing

gen location_15=w1002 if status_15!=1
replace location_15=1 if city==4 & status_15==1
replace location_15=2 if city==2 & status_15==1
replace location_15=3 if city==3 & status_15==1
replace location_15=4 if city==1 & status_15==1
replace location_15=5 if city==5 & status_15==1
replace location_15=6 if city==6 & status_15==1
recode location_15 99=9
ta location_15, missing

label var years_12 "years between age 12 and last move"
label var years_15 "years between age 15 and last move"
label var status_12 "migration status at age 12"
label var status_15 "migration status at age 15"
label define name_status 1 "1.at current location" 2 "2. same city, different home" 3 "3. different studied city" 4 "4. different unstudied city"
label values status_12 name_status
label values status_15 name_status

label var location_12 "location at age 12"
label var location_15 "location at age 15"
label define loc_name 1 "1.Mbao" 2 "2.Guediawaye" 3 "3.Pikine" 4 "4.Dakar" 5 "5.Mbour" 6 "6.Kaolack" 7 "7.Other city" 8 "8.Rural zone" 9 "9.other country/missing"
label values location_12 loc_name
label values location_15 loc_name
ta location_12
ta location_15

order indid - women_weight_6_city years_12 status_12 location_12 years_15 /*
*/ status_15 location_15

drop w311_01 - age_at_last_move

save "$path/Senegal_Individual_File.dta", replace
clear
*
*
*
*
*
*
*
*
*
*********************************
*********************************
*********************************
********HOUSEHOLD FILE***********
*********************************
*********************************
*********************************
*
*
*
*
*
*
*
*
*
/* All information on a woman's/household's assets and consumption
are found in the household file. I will clean up this information 
for each household and then merge it into the individual file.*/
*
*
*
*
*
*
*
*
*
set more off
use "hhld_public.dta", clear
di _N

*generate individual id
tostring hhid, replace
label var hhid "Household ID"
order hhid

drop urban - hnumvis eligw - hstartm

**************************************
***** Information about the home *****
**************************************

*number of people in household
ta hhtot

*home ownership
ta h13, nol
forvalues i=1/5{
gen home`i'=0
}
replace home1=1 if h13==1
replace home2=1 if h13==2
replace home3=1 if h13==3
replace home4=1 if h13==4
replace home5=1 if h13==6|h13==9
su home1-home5

label var home1 "OWNS home"
label var home2 "RENTS home"
label var home3 "pays no rent for home, LEGALLY"
label var home4 "pays no rent for home, SQUATTER"
label var home5 "home ownership is MISSING/NONTRADIIONAL"

drop h13-h15
order hhid hhtot home1-home5

*home characteristics
ta h16, nol 
gen bedrooms=h16
recode bedrooms 99=.
ta bedrooms

label var bedrooms "number of bedrooms in the home"

drop h16

ta h17, nol
gen powercook=0 if h17!=9
replace powercook=1 if h17==1|h17==2
ta powercook

label var powercook "cooks with electric or gas"

drop h17-h17o

ta h18
gen kitchen=h18
recode kitchen 9=.
recode kitchen 2=0
ta kitchen

label var kitchen "has a separate room which is used as a kitchen"

drop h18

ta h19, nol
forvalues i=0/3{
  gen roof`i'=0
}
replace roof0=1 if h19>=96
replace roof1=1 if h19<20
replace roof2=1 if h19>20 & h19<30
replace roof3=1 if h19>30 & h19<=40
su roof0-roof3

label var roof0 "roofing material is MISSING/NONSTANDARD"
label var roof1 "roofing material is NATURAL"
label var roof2 "roofing material is RUDIMENTARY"
label var roof3 "roofing material is FINISHED"

drop h19-h19o

ta h20, nol
forvalues i=0/3{
  gen floor`i'=0
}
replace floor0=1 if h20>=96
replace floor1=1 if h20<20
replace floor2=1 if h20>20 & h20<30
replace floor3=1 if h20>30 & h20<=40
su floor0-floor3

label var floor0 "flooring material is MISSING/NONSTANDARD"
label var floor1 "flooring material is NATURAL"
label var floor2 "flooring material is RUDIMENTARY"
label var floor3 "flooring material is FINISHED"

drop h20-h20o

ta h21, nol
forvalues i=0/3{
  gen walls`i'=0
}
replace walls0=1 if h21>=96
replace walls1=1 if h21<20
replace walls2=1 if h21>20 & h21<30
replace walls3=1 if h21>30 & h21<=40
su walls0-walls3

label var walls0 "wall material is MISSING/NONSTANDARD"
label var walls1 "wall material is NATURAL"
label var walls2 "wall material is RUDIMENTARY"
label var walls3 "wall material is FINISHED"

drop h21-h21o

order hhid hhtot home1-home5 bedrooms powercook kitchen roof0-roof3 /*
*/ floor0-floor3 walls0-walls3

ta h22
gen electric=h22
recode electric 2=0
recode electric 9=.
ta electric

label var electric "home has electricity"

drop h22

ta h24, nol
gen waterhome=0 if h24!=99
replace waterhome=1 if h24==11
ta waterhome

label var waterhome "water is piped INTO the home"

drop h24 - h30o

ta h31
gen indoortoilet=0 if h31!=99
replace indoortoilet=1 if h31==1
ta indoortoilet

label var indoortoilet "home has an indoor toilet"

drop h31

ta h32, nol
gen sharetoilet=0 if h32<8
replace sharetoilet=1 if h32==1
ta sharetoilet

label var sharetoilet "shares a toilet with other households"

drop h32 - h33

order hhid hhtot home1-home5 bedrooms powercook kitchen roof0-roof3 /*
*/ floor0-floor3 walls0-walls3 electric waterhome indoortoilet /*
*/ sharetoilet

*assets owned
ta h37_01
ta h37_10
ta h37_23
forvalues i=1/9{
  gen own`i'=h37_0`i'
  recode own`i' 2=0
  recode own`i' 9=.
}
forvalues i=10/23{
  gen own`i'=h37_`i'
  recode own`i' 2=0
  recode own`i' 9=.
}
su own1-own23

label var own1 "owns a clock"
label var own2 "owns a radio"
label var own3 "owns a tv"
label var own4 "has antenna TV service"
label var own5 "has satilite TV service"
label var own6 "owns a home phone"
label var own7 "owns a cell phone"
label var own8 "owns a refrigerator"
label var own9 "owns a stove"
label var own10 "owns a foyer ameliore"
label var own11 "owns a VCR/DVD player"
label var own12 "owns an airconditioner"
label var own13 "owns a computer"
label var own14 "has internet at the home"
label var own15 "owns a car"
label var own16 "owns a cart (for horses?)"
label var own17 "owns a scooter/motorcycle"
label var own18 "owns a bicycle"
label var own19 "owns a mattress"
label var own20 "owns mosquito nets"
label var own21 "owns a bed"
label var own22 "owns a table"
label var own23 "owns chairs"

drop h37_01 - h37_23

ta h39
gen emphelp=h39
recode emphelp 2=0
recode emphelp 9=.
ta emphelp

label var emphelp "employs help for the home"

drop h39

order hhid hhtot home1-home5 bedrooms powercook kitchen roof0-roof3 /*
*/ floor0-floor3 walls0-walls3 electric waterhome indoortoilet /*
*/ sharetoilet own1-own23 emphelp

*finances
ta h41, nol
gen savings=h41
recode savings 9999992=0
recode savings 9999998=.
recode savings 9999999=.
su savings

label var savings "amount of money saved in the last 30 days"

drop h41

ta h42
gen missmeal=h42
recode missmeal 2=0
recode missmeal 9=.
ta missmeal

label var missmeal "someone missed a meal in the last 3 months"

drop h42

order hhid hhtot home1-home5 bedrooms powercook kitchen roof0-roof3 /*
*/ floor0-floor3 walls0-walls3 electric waterhome indoortoilet /*
*/ sharetoilet own1-own23 emphelp savings missmeal

drop hstoph - ses3

*Weekly Consumption
forvalues i=1/9{
su h43a_0`i' 
gen consweek`i'=h43a_0`i'
recode consweek`i' 9999998=.
recode consweek`i' 9999988=.
recode consweek`i' 9999992=.
drop h43a_0`i'
}
forvalues i=10/22{
su h43a_`i' 
gen consweek`i'=h43a_`i'
recode consweek`i' 9999998=.
recode consweek`i' 9999992=.
drop h43a_`i'
}

label var consweek1 "value of GRAIN consumed in the last WEEK"
label var consweek2 "value of BREAD consumed in the last WEEK"
label var consweek3 "value of POTATOES consumed in the last WEEK"
label var consweek4 "value of PASTA consumed in the last WEEK"
label var consweek5 "value of BEANS consumed in the last WEEK"
label var consweek6 "value of PEANUTS consumed in the last WEEK"
label var consweek7 "value of OILS consumed in the last WEEK"
label var consweek8 "value of FRESH VEGGIES consumed in the last WEEK"
label var consweek9 "value of CANNED VEGGIES consumed in the last WEEK"
label var consweek10 "value of FRESH FRUIT consumed in the last WEEK"
label var consweek11 "value of CANNED FRUIT consumed in the last WEEK"
label var consweek12 "value of DAIRY consumed in the last WEEK"
label var consweek13 "value of EGGS consumed in the last WEEK"
label var consweek14 "value of SEAFOOD consumed in the last WEEK"
label var consweek15 "value of MEATS consumed in the last WEEK"
label var consweek16 "value of SUGAR consumed in the last WEEK"
label var consweek17 "value of SUGARY DRINKS consumed in the last WEEK"
label var consweek18 "value of HOT DRINKS consumed in the last WEEK"
label var consweek19 "value of BOOZE consumed in the last WEEK"
label var consweek20 "value of TOBACCO consumed in the last WEEK"
label var consweek21 "value of NEWS/MAGS consumed in the last WEEK"
label var consweek22 "value of CELL PHONE consumed in the last WEEK"

su consweek1 - consweek22

*Monthly Consumption
forvalues i=1/9{
su h43b_0`i' 
gen consmon`i'=h43b_0`i'
recode consmon`i' 999999=.
recode consmon`i' 9999998=.
recode consmon`i' 9999988=.
recode consmon`i' 9999992=.
drop h43b_0`i'
}
forvalues i=10/16{
su h43b_`i' 
gen consmon`i'=h43b_`i'
recode consmon`i' 9999998=.
recode consmon`i' 9999992=.
drop h43b_`i'
}

label var consmon1 "value of RENT consumed in the last WEEK"
label var consmon2 "value of ENERGY consumed in the last WEEK"
label var consmon3 "value of BUTANE GAS consumed in the last WEEK"
label var consmon4 "value of ELECTRIC BILL consumed in the last WEEK"
label var consmon5 "value of WATER consumed in the last WEEK"
label var consmon6 "value of CELL PHONE BILL consumed in the last WEEK"
label var consmon7 "value of HOME PHONE BILL consumed in the last WEEK"
label var consmon8 "value of TRANSPORTATION consumed in the last WEEK"
label var consmon9 "value of HOME HELP consumed in the last WEEK"
label var consmon10 "value of CHARITY consumed in the last WEEK"
label var consmon11 "value of TITHE consumed in the last WEEK"
label var consmon12 "value of CLEANING PRODUCTS consumed in the last WEEK"
label var consmon13 "value of MAKE-UP/TOILETRIES consumed in the last WEEK"
label var consmon14 "value of INSECTICIDES consumed in the last WEEK"
label var consmon15 "value of TOILET PAPER consumed in the last WEEK"
label var consmon16 "value of MOVIES consumed in the last WEEK"

su consmon1 - consmon16

*Annual Consumption
forvalues i=1/6{
su h43c_`i' 
gen consyear`i'=h43c_`i'
replace consyear`i'=. if consyear`i'>=9999999
drop h43c_`i'
}

label var consyear1 "value of BAPTISM consumed in the last WEEK"
label var consyear2 "value of RELIGIOUS CEREMONY consumed in the last WEEK"
label var consyear3 "value of FUNERAL consumed in the last WEEK"
label var consyear4 "value of CLOTHING consumed in the last WEEK"
label var consyear5 "value of SHOES consumed in the last WEEK"
label var consyear6 "value of FURNITURE consumed in the last WEEK"

su consyear1 - consyear6

su

save "$path/Senegal_Household_File.dta", replace
*
*
*
*
*
*
*
*
*
***************************************
***************************************
***************************************
********Facility Match Files***********
***************************************
***************************************
***************************************
*
*
*
*
*
*
*
*
*
/* This section cleans up the match files, or the files 
that link the individual women to the facilities they 
visit for different services. I need each final file to 
contain an individual identification number (indid) and
a faciliti identification number (facid). Both should
be string variables.
*/
*
*
*
*
*
*
*
*
*
/* I have access to the following files:
Senegal_Prenatal_Match.dta
Senegal_ChildCare_Match.dta
Senegal_FamilyPlanning_Match.dta
Senegal_Immunizations_Match.dta
Senegal_MaternalCare_Match.dta
Senegal_HIV_Match.dta
Senegal_Pharmacy_Match.dta
*/
*
*
*
*
*
*
*
*
*
/* Note the following:
994 -> Informal medical office or agent
995 -> Not in the database
997 -> Outside the study sites
998 -> Don't know
999 -> Missing
*/
*
*
*
*
*
*
*
*
*
*Prenatal
use "Senegal_Prenatal_Match.dta", clear
set more off

di _N
ta urban
su cluster
su hhnum
su line

gen str9 indid = string(urban) + string(cluster,"%03.0f") + string(hhnum,"%03.0f") + string(line,"%02.0f") 

ta codeprenatal 

gen str5 facid = string(urban) + "0" + codeprenatal if codeprenatal!=""

replace facid = "99" + codeprenatal if codeprenatal=="994"|codeprenatal=="995"| /*
*/ codeprenatal=="997"|codeprenatal=="998"|codeprenatal=="999"

replace facid = "99999" if w237==1 & facid==""	/* those who went but facility isn't recorded*/
replace facid = "99991" if w237==2 				/* those who choose not to visit a facility */
replace facid = "99992" if facid=="" 			/* those who are not asked */

order urban cluster hhnum line codeprenatal indid facid

keep indid facid

rename facid pnid

save "$path/Senegal_Prenatal_Match_Clean.dta", replace

*Child Care
use "Senegal_ChildCare_Match.dta", clear
set more off

di _N
ta urban
su cluster
su hhnum
su line

gen str9 indid = string(urban) + string(cluster,"%03.0f") + string(hhnum,"%03.0f") + string(line,"%02.0f") 

ta codechild 

gen str5 facid = string(urban) + "0" + codechild if codechild!=""

replace facid = "99" + codechild if codechild=="994"|codechild=="995"| /*
*/ codechild=="997"|codechild=="998"|codechild=="999"

order urban cluster hhnum line codechild indid facid

keep indid facid

rename facid ccid

save "$path/Senegal_ChildCare_Match_Clean.dta", replace

*Family Planning
use "Senegal_FamilyPlanning_Match.dta", clear
set more off

drop var13-var42

rename position1facility2pharmacie f_or_p

di _N
ta urban
su cluster
su hhnum
su line

gen str9 indid = string(urban) + string(cluster,"%03.0f") + string(hhnum,"%03.0f") + string(line,"%02.0f") 

ta codepf 
ta f_or_p

gen str5 facid = string(urban) + "0" + codepf if codepf!="" & f_or_p==.
replace facid = string(urban) + "5" + codepf if codepf!="" & f_or_p==2

replace facid = "99" + codepf if codepf=="994"|codepf=="995"| /*
*/ codepf=="997"|codepf=="998"|codepf=="999"

order urban cluster hhnum line codepf f_or_p indid facid

keep indid facid

rename facid fpid

save "$path/Senegal_FamilyPlanning_Match_Clean.dta", replace

*Immunizations
use "Senegal_Immunizations_Match.dta", clear
set more off

di _N
ta urban
su cluster
su hhnum
su line

gen str9 indid = string(urban) + string(cluster,"%03.0f") + string(hhnum,"%03.0f") + string(line,"%02.0f") 

ta codeimmunization 
destring codeimmunization, replace
gen codeim = string(codeimmunization,"%03.0f")
replace codeim = "" if codeim=="."
ta codeim

ta e20wo
replace e20wo="994" if e20wo=="A DOMICILE"
replace e20wo="994" if e20wo=="A LA MAISON"
replace e20wo="994" if e20wo=="CHEZ ELLE"
replace e20wo="994" if e20wo=="DOMICILE VOISINE MATRON"
replace e20wo="994" if e20wo=="ONG"
replace e20wo="994" if e20wo=="PEDIATRIE"

replace codeim=e20wo if codeim=="" & e20wo!=""
ta codeim

gen str5 facid = string(urban) + "0" + codeim if codeim!=""

replace facid = "99" + codeim if codeim=="994"|codeim=="995"| /*
*/ codeim=="997"|codeim=="998"|codeim=="999"

order urban cluster hhnum line codeim indid facid

keep indid facid

rename facid imid

save "$path/Senegal_Immunizations_Match_Clean.dta", replace

*Maternal Care
use "Senegal_MaternalCare_Match.dta", clear
set more off

di _N
ta urban
su cluster
su hhnum
su line

gen str9 indid = string(urban) + string(cluster,"%03.0f") + string(hhnum,"%03.0f") + string(line,"%02.0f") 

ta codematernal
replace codematernal="050" if codematernal=="'050"
replace codematernal="044" if codematernal=="44"
replace codematernal="056" if codematernal=="56"

gen str5 facid = string(urban) + "0" + codematernal if codematernal!=""

replace facid = "99" + codematernal if codematernal=="994"|codematernal=="995"| /*
*/ codematernal=="997"|codematernal=="998"|codematernal=="999"

order urban cluster hhnum line codematernal indid facid

keep indid facid

rename facid mcid

save "$path/Senegal_MaternalCare_Match_Clean.dta", replace

*HIV
use "Senegal_HIV_Match.dta", clear
set more off

di _N
ta urban
su cluster
su hhnum
su line

gen str9 indid = string(urban) + string(cluster,"%03.0f") + string(hhnum,"%03.0f") + string(line,"%02.0f") 

ta codehiv
replace codehiv="994" if codehiv=="CME"
replace codehiv="994" if codehiv=="ECOLE"

gen str5 facid = string(urban) + "0" + codehiv if codehiv!=""

replace facid = "99" + codehiv if codehiv=="994"|codehiv=="995"| /*
*/ codehiv=="997"|codehiv=="998"|codehiv=="999"

order urban cluster hhnum line codehiv indid facid

keep indid facid

rename facid hivid

save "$path/Senegal_HIV_Match_Clean.dta", replace

*Pharmacy
use "Senegal_Pharmacy_Match.dta", clear
set more off

rename position1outsidesdp2withinasdp f_or_p
rename codesdpifposition2 codesdp

di _N
ta urban
su cluster
su hhnum
su line

replace cluster=93 if cluster==. & urban==2
replace line=2 if line==. & urban==4

gen str9 indid = string(urban) + string(cluster,"%03.0f") + string(hhnum,"%03.0f") + string(line,"%02.0f") 

ta codepharmacie
replace codepharmacie="999" if codepharmacie==" "

ta f_or_p
ta codesdp

replace codesdp=codepharmacie if codesdp=="" & f_or_p==2
replace codepharmacie="" if f_or_p==2
replace codepharmacie="" if f_or_p==. & codepharmacie=="998"
replace f_or_p=1 if f_or_p==. & codepharmacie=="247"
replace codesdp="" if codesdp=="GUEDIAWAYE NOT PIKINE"

ta codepharmacie
ta f_or_p
ta codesdp

gen str5 facid = string(urban) + "5" + codesdp if f_or_p==2
replace facid = string(urban) + "5" + codepharmacie if f_or_p==1

replace facid = "99" + codesdp if codesdp=="994"|codesdp=="995"| /*
*/ codesdp=="997"|codesdp=="998"|codesdp=="999"

replace facid = "99" + codepharmacie if codepharmacie=="994"|codepharmacie=="995"| /*
*/ codepharmacie=="997"|codepharmacie=="998"|codepharmacie=="999"

order urban cluster hhnum line codepharmacie codesdp f_or_p indid facid

keep indid facid

rename facid rxid

drop if indid=="...."
save "$path/Senegal_Pharmacy_Match_Clean.dta", replace

********************************************************
*********MERGE INDIVIDUAL AND HOUSEHOLD FILE************
********************************************************

use "$path/Senegal_Individual_File.dta", clear
merge m:1 hhid using "$path/Senegal_Household_File.dta"
keep if _merge==3
drop _merge

merge 1:1 indid using "$path/Senegal_Prenatal_Match_Clean.dta"
drop _merge

merge 1:1 indid using "$path/Senegal_ChildCare_Match_Clean.dta"
drop _merge

replace ccid = "99999" if chvisit==1 & ccid==""			/* those who report a child visit, but no facility is recorded*/
replace ccid = "99991" if livingchild==1 & ccid==""		/* those who have child (asked question), but choose not to visit a facility */
replace ccid = "99992" if ccid=="" 						/* those who are not asked */

merge 1:1 indid using "$path/Senegal_FamilyPlanning_Match_Clean.dta"
drop _merge

replace fpid = "99999" if askedFPloc==1 & fpid==""		/* those who use modern FP (not steralized or natural), but no facility is recorded */
replace fpid = "99991" if fpid==""						/* assume all others choose not to use FP*/


merge 1:1 indid using "$path/Senegal_Immunizations_Match_Clean.dta"
drop _merge

replace imid = "99999" if vacvisit1==1 & imid==""		/* those who vaccinated child, but didn't provide location */
replace imid = "99991" if child2009==1 & imid==""		/* those who had child since 2009, but did not vaccinate*/
replace imid = "99992" if imid==""						/* those for which question is not relevant */

merge 1:1 indid using "$path/Senegal_MaternalCare_Match_Clean.dta"
drop _merge

replace mcid = "99999" if mhvisit==1 & mcid==""			/* those who visited a facility, but no facility is recorded*/
replace mcid = "99991" if mcid == ""					/* assume all others chose not to visit for maternal care */

merge 1:1 indid using "$path/Senegal_HIV_Match_Clean.dta"
drop _merge

replace hivid = "99999" if hivvisit==1 & hivid=="" 		/* those who visited a facility, but no facility is recorded*/
replace hivid = "99991" if hivid == ""					/* assume all others chose not to visit for hiv test */


merge 1:1 indid using "$path/Senegal_Pharmacy_Match_Clean.dta"
drop _merge

replace rxid = "99991" if rxid == ""					/* assume that all those with no facility reported have never gone*/

label var pnid "PRENATAL facility identification number"
label var ccid "CHILD CARE facility identification number"
label var fpid "FAMILY PLANNING facility identification number"
label var imid "IMMUNIZATIONS facility identification number"
label var mcid "MATERNAL CARE facility identification number"
label var hivid "HIV facility identification number"

di _N
su

save "$path/Senegal_Women_Final_temp.dta", replace

*********************************************
** Edit individual level variables for use **
*********************************************

*city
ta city, generate(city)
rename city1 Dakar
rename city2 Guediawaye
rename city3 Pikine
rename city4 Mbao
rename city5 Mbour
rename city6 Kaolack
drop city

*page (put in average)
su page 
replace page=. if page==0 
su page
replace page=r(mean) if married==1 & page==.

*peducation
su peduL0-peduL5
replace peduL0=0 if peduL0==. & married==1
replace peduL1=0 if peduL1==. & married==1
replace peduL2=0 if peduL2==. & married==1
replace peduL3=0 if peduL3==. & married==1
replace peduL4=0 if peduL4==. & married==1
replace peduL5=1 if peduL5==. & married==1

*own15 (car)
rename own15 owncar

*own17 (scooter)
rename own17 ownscooter

*own18 (bicycle)
rename own18 ownbicycle

*owntrans
gen owntrans=0
replace owntrans=1 if owncar==1|ownscooter==1|ownbicycle==1

save "$path/Senegal_Women_Final.dta", replace






























*********************************************************************************************************
********************************SENEGAL FACILITY FILE**************************************************
*********************************************************************************************************

*****************************************************************************************************************
** This do file condenses the following two data files for use: 1) Facility Audit data and 2) Pharmacy Audit. 
** These files will be condensed to 1 file than can be merged with
** individual level data on which facilities families visit.
*****************************************************************************************************************

clear all 

***********************************************************************************************************
** Facility audit data
***********************************************************************************************************

use "public_senegal_facility_v2.dta", clear
set more off
set seed 654321

di _N

*Keep only facilities that still exist
ta result, nol
drop if result==2		/* moved/destroyed*/
drop if resulto=="FERME DEPUIS 2008"
drop if resulto=="FERMETURE DE LA STRUCTURE"
drop if resulto=="FUSION AVEC LA 136"
drop if resulto=="FUSIONNER AU POSTE DE SANTE"
drop if resulto=="LA STRUCTURE N EXISTE PAS"
drop if resulto=="MEME PPS QUE 049"
drop if resulto=="POSTE FERME DEPUIS 2 ANS"

di _N
		*Dropped(15): 046,048,052,099,122,030,057,073,140,132,151,167,180,192,202

*identifiers
label var facid "Facility ID"
rename site city
label var city "city"
rename type facvol
label var facvol "facility volume"
ta facvol, missing
label define vol_level 1 "high volume public" 2 "high volume private" 3 "low volume public" 4 "low volume private" 5 "pharmacy"
label values facvol vol_level
ta facvol
label var factype "facility type"
ta factype, nol
label define ltype 11 "Public Hospital" 12 "Public Health Center" 13 "Public Health Post" /*
                */ 14 "Public Health Check" 16 "other public" 21 "Private Clinic" 22 "Denominational Clinic" /*
				*/ 26 "Other Private" 31 "NGO Clinic" 41 "Pharmacy" 96 "Other" 99 "Missing"
label values factype ltype
ta factype
rename fday iday
label var iday "interview day"
rename fmon imon
label var imon "interview month"
gen iyear=fyear
label var iyear "interview year" 

order facid facnum city facvol factype iday imon iyear

gen participate=1
replace participate=0 if f1h==.
label var participate "actually participated in the interview"
ta participate

order facid facnum city facvol factype iday imon iyear participate

drop ds - f1m

*General Facility Information
ta f2y, nol missing
ta f2a, nol missing
gen fage=2011-f2y if f2y<9998
replace fage=f2a if fage==.
ta fage, missing
label var fage "Facility Age"

gen openy=f2y
recode openy 9998=.
recode openy 9999=.
replace openy=2011-f2a if openy==. & f2a!=.
ta openy, missing

label var openy "year opened"

ta f3, nol
gen openall=.
replace openall=1 if f3==7
replace openall=0 if f3==5|f3==6
ta openall, missing
label var openall "open every day of the week"

ta f4, nol
ta f5, nol
replace f4=2500 if f4==0
gen hours=24 if f4==9991
replace hours=(f5-f4)/100 if hours==. & f5!=9999
ta hours, missing
replace hours=. if hours<0
label var hours "average number of hours open in a day"

ta f6
gen fpsocial=.
replace fpsocial=1 if f6==1
replace fpsocial=0 if f6==2
ta fpsocial, missing
label var fpsocial "Affiliated social with program that supplies discounted FP products"

ta f7_01, missing
gen ngdoc=f7_01
recode ngdoc 99=.
label var ngdoc "# general doctors"

ta f7_02, missing
gen nsdoc=f7_02
recode nsdoc 99=.
label var nsdoc "# specialized doctors"

replace ngdoc=0 if ngdoc==. & participate==1
replace nsdoc=0 if nsdoc==. & participate==1
gen ndoc=ngdoc+nsdoc
label var ndoc "# doctors"

ta f7_03, missing
gen nnurse=f7_03
recode nnurse 99=.
label var nnurse "# nurses"

ta f7_04, missing
gen nmidw=f7_04
recode nmidw 99=.
label var nmidw "# midwives"

ta f7_05, missing
gen ncareg=f7_05
recode ncare 99=.
label var ncareg "# care givers"

ta f7_06, missing
gen nhedu=f7_06
recode nhedu 99=.
label var nhedu "# health educators"

ta f7_07, missing
gen nhsw=f7_07
recode nhsw 99=.
label var nhsw "# health social workers"

replace nhsw=0 if nhsw==. & participate==1
replace nhedu=0 if nhedu==. & participate==1
replace nhsw=nhsw+nhedu
ta nhsw

gen ahsw=0 if participate==1
replace ahsw=1 if nhsw>0 & nhsw!=.
ta ahsw

label var ahsw "Any social worker"

ta f7_08, missing
gen nmatron=f7_08
recode nmatron 99=.
label var nmatron "# matrons"

rename numstaff nstaff

order facid facnum city facvol factype iday imon iyear participate fage openy openall hours /*
*/ fpsocial ndoc nnurse nmidw ahsw nstaff

drop f2y - numselect ngdoc nsdoc nhedu nhsw nmatron ncareg

* General Family Planning Services Offered and Volumes 

forvalues i=1/9 {

ta f9a_0`i'
gen offers`i'=f9a_0`i'
recode offers`i' 2=0
recode offers`i' 9=.
ta offers`i',missing

su f9c_0`i'
gen vols`i'=f9c_0`i'
recode vols`i' 99993=.
recode vols`i' 99999=.
su vols`i'

}
drop vols2 vols7 vols8 vols9
replace offers7=0 if offers6==0
replace offers8=0 if offers6==0
replace offers9=0 if offers6==0

forvalues i=10/22 {

ta f9a_`i'
gen offers`i'=f9a_`i'
recode offers`i' 2=0
recode offers`i' 9=.
ta offers`i',missing

su f9c_`i'
gen vols`i'=f9c_`i'
recode vols`i' 99993=.
recode vols`i' 99998=.
recode vols`i' 99999=.
su vols`i'

}
drop vols10 vols11 vols13
replace offers10=0 if offers6==0
replace offers11=0 if offers6==0
replace offers13=0 if offers12==0

label var offers1 "offers MATERNITY/DELIVERY"
label var offers2 "offers BREAST-FEEDING COUNSELING"
label var offers3 "offers EMERGENCY LABOR SERVICES"
label var offers4 "offers CONSULTATION FOR INFERTILITY"
label var offers5 "offers POST-ABORTION CARE"
label var offers6 "offers PRE-NATAL"
label var offers7 "offers VACCINATIONS DURING PREGNANCY"
label var offers8 "offers SYPHILLIS SCREENING DURING PREGNANCY"
label var offers9 "offers IRON SUPP DURING PREGNANCY"
label var offers10 "offers PREVENTATIVE MALARIA TREATMENT"
label var offers11 "offers NUTRITION COUNSELING FOR PREGNANT"
label var offers12 "offers POST-NATAL"
label var offers13 "offers VIT A AFTER PREGNANCY"
label var offers14 "offers CHILD IMMUNIZATION"
label var offers15 "offers CHILD GROWTH MONITORING"
label var offers16 "offers CHILD RESPITORY DISEASE"
label var offers17 "offers ORAL REHYDRATION"
label var offers18 "offers STDS"
label var offers19 "offers HIV TEST"
label var offers20 "offers MOTHER-CHILD TRANSMISSION PREVENTION"
label var offers21 "offers HIV CARE"
label var offers22 "offers FAMILY PLANNING"

label var vols1 "3 month volume of MATERNITY/DELIVERY"
label var vols3 "3 month volume of EMERGENCY LABOR SERVICES"
label var vols4 "3 month volume of CONSULTATION FOR INFERTILITY"
label var vols5 "3 month volume of POST-ABORTION CARE"
label var vols6 "3 month volume of PRE-NATAL"
label var vols12 "3 month volume of POST-NATAL" 
label var vols14 "3 month volume of CHILD IMMUNIZATION"
label var vols15 "3 month volume of CHILD GROWTH MONITORING"
label var vols16 "3 month volume of CHILD RESPITORY DISEASE"
label var vols17 "3 month volume of ORAL REHYDRATION"
label var vols18 "3 month volume of STDS"
label var vols19 "3 month volume of HIV TEST"
label var vols20 "3 month volume of MOTHER-CHILD TRANSMISSION PREVENTION"
label var vols21 "3 month volume of HIV CARE"
label var vols22 "3 month volume of FAMILY PLANNING"

order facid - nstaff offers1 /*
*/ offers2 offers3 offers4 offers5 offers6 offers7 offers8 offers9 offers10 /*
*/ offers11 offers12 offers13 offers14 offers15 offers16 offers17 offers18 /*
*/ offers19 offers20 offers21 offers22 vols1 vols3 vols4 vols5 vols6 vols12 /*
*/ vols14 vols15 vols16 vols17 vols18 vols19 vols20 vols21 vols22

gen offernum=0 if participate==1
foreach x of varlist offers1 - offers22 {
replace offernum=offernum+1 if `x'==1
}

ta offernum

label var offernum "number of services offered out of 22"

order facid - vols22 offernum
 
drop f9a_01 - f33

* Specific Family Planning Services and Products
forvalues i=1/9 {
ta f34a_0`i',missing
gen consultfp`i'=f34a_0`i'
recode consultfp`i' 2=0 
recode consultfp`i' 9=. 
ta consultfp`i', missing
}
ta f34a_10,missing
gen consultfp10=f34a_10
recode consultfp10 2=0 
recode consultfp10 9=. 
ta consultfp10, missing

label var consultfp1 "will consult on BC pills"
label var consultfp2 "will consult on progestative only pills"
label var consultfp3 "will consult on emergency contraceptives"
label var consultfp4 "will consult on male condom"
label var consultfp5 "will consult on female condom"
label var consultfp6 "will consult on injectables"
label var consultfp7 "will consult on implants"
label var consultfp8 "will consult on IUD"
label var consultfp9 "will consult on female sterilization"
label var consultfp10 "will consult on male sterilization"

gen totconsult=0 if participate==1
forvalues i=1/10 {
replace totconsult=totconsult+1 if consultfp`i'==1
}
ta totconsult

forvalues i=1/9 {
ta f34b_0`i',missing
gen daysfp`i'=f34b_0`i'
replace daysfp`i'=0 if consultfp`i'==0
recode daysfp`i' 9=.
ta daysfp`i', missing
}
ta f34b_10,missing
gen daysfp10=f34b_10
replace daysfp10=0 if consultfp10==0
recode daysfp10 9=.
ta daysfp10, missing

label var daysfp1 "days a week consultation on BC pills is available"
label var daysfp2 "days a week consultation on progestative only pills is available"
label var daysfp3 "days a week consultation on emergency contraceptives is available"
label var daysfp4 "days a week consultation on male condom is available"
label var daysfp5 "days a week consultation on female condom is available"
label var daysfp6 "days a week consultation on injectables is available"
label var daysfp7 "days a week consultation on implants is available"
label var daysfp8 "days a week consultation on IUDis available"
label var daysfp9 "days a week consultation on female sterilization is available"
label var daysfp10 "days a week consultation on male sterilization is available"

forvalues i=1/9 {
ta f34c_0`i',missing
gen sellfp`i'=f34c_0`i'
replace sellfp`i'=0 if consultfp`i'==0
recode sellfp`i' 9=.
recode sellfp`i' 2=0
ta sellfp`i', missing
}
ta f34c_10,missing
gen sellfp10=f34c_10
replace sellfp10=0 if consultfp10==0
recode sellfp10 9=.
recode sellfp10 2=0
ta sellfp10, missing

label var sellfp1 "facility sells BC pills"
label var sellfp2 "facility sells progestative only pills"
label var sellfp3 "facility sells emergency contraceptives"
label var sellfp4 "facility sells male condoms"
label var sellfp5 "facility sells female condoms"
label var sellfp6 "facility sells injectables"
label var sellfp7 "facility sells implants"
label var sellfp8 "facility sells IUDs "
label var sellfp9 "facility performs female sterilization"
label var sellfp10 "facility performs male sterilization"

gen sellt1=0
gen sellt2=0
gen sellt3=0
replace sellt1=1 if sellfp3==1|sellfp4==1|sellfp5==1
replace sellt2=1 if sellfp1==1|sellfp2==1|sellfp6==1
replace sellt3=1 if sellfp7==1|sellfp8==1|sellfp9==1|sellfp10==1

label var sellt1 "facility sells short-term BC methods"
label var sellt2 "facility sells medium-term BC methods"
label var sellt3 "facility sells long-term BC methods"

su sellt1 sellt2 sellt3

gen totsell=0 if participate==1
forvalues i=1/10 {
replace totsell=totsell+1 if sellfp`i'==1
}
ta totsell

label var totsell "total family planning methods distributed by HF"

forvalues i=1/9 {
ta f34d_0`i',missing
gen consentfp`i'=f34d_0`i'
recode consentfp`i' 2=0
recode consentfp`i' 9=.
ta consentfp`i', missing
}
ta f34d_10,missing
gen consentfp10=f34d_10
recode consentfp10 2=0
recode consentfp10 9=.
ta consentfp10, missing

label var consentfp1 "consent needed from partner to get BC pills"
label var consentfp2 "consent needed from partner to get progestative only pills"
label var consentfp3 "consent needed from partner to get emergency contraceptives"
label var consentfp4 "consent needed from partner to get male condom"
label var consentfp5 "consent needed from partner to get female condom"
label var consentfp6 "consent needed from partner to get injectables"
label var consentfp7 "consent needed from partner to get implants"
label var consentfp8 "consent needed from partner to get IUD"
label var consentfp9 "consent needed from partner to get female sterilization"
label var consentfp10 "consent needed from partner to get male sterilization"

gen noconsent=1 if participate==1
forvalues i=1/10 {
replace noconsent=0 if consentfp`i'==1
}
replace noconsent=0 if totsell==0
ta noconsent

label var noconsent "woman needs to consent from partnet to obtain ANY 1 FP method (=0 if totsell==1)"

order facid - offernum consultfp1-consultfp10 totconsult daysfp1-daysfp10 /*
*/ sellfp1-sellfp10 sellt1 sellt2 sellt3 totsell consentfp1-consentfp10 noconsent 
 
drop f34a_01-f35b_4

* Service Statistics
ta f36a,missing nol
gen fppats=f36a
recode fppats .=0 if participate==1
recode fppats 99993=.
recode fppats 99999=.
ta fppats
label var fppats "# family planning patients in last 6 months"

order facid - noconsent fppats

drop f36a - f42y

*Materials and Outreach activities

forvalues i=1/8 {
ta f43_`i', nol
recode f43_`i' 9=8
gen iecobs`i'=0 if participate==1
gen iecrnobs`i'=0 if participate==1
gen iecna`i'=0 if participate==1
gen iecmis`i'=0 if participate==1

replace iecobs`i'=1 if f43_`i'==1
replace iecrnobs`i'=1 if f43_`i'==2
replace iecna`i'=1 if f43_`i'==3
replace iecna`i'=1 if f43_`i'==. & participate==1
replace iecmis`i'=1 if f43_`i'==8

ta iecobs`i', missing
ta iecrnobs`i', missing
ta iecna`i', missing
ta iecmis`i', missing
}

label var iecobs1 "IEC posters can be observed"
label var iecrnobs1 "IEC posters are reported, but not observed"
label var iecna1 "IEC posters are not available"
label var iecmis1 "IEC posters response is missing"

label var iecobs2 "IEC informational flip chart can be observed"
label var iecrnobs2 "IEC informational flip chart are reported, but not observed"
label var iecna2 "IEC informational flip chart are not available"
label var iecmis2 "IEC informational flip chart response is missing"

label var iecobs3 "IEC brochures can be observed"
label var iecrnobs3 "IEC brochures are reported, but not observed"
label var iecna3 "IEC brochures are not available"
label var iecmis3 "IEC brochures response is missing"

label var iecobs4 "IEC informational sheets can be observed"
label var iecrnobs4 "IEC informational sheets are reported, but not observed"
label var iecna4 "IEC informational sheets are not available"
label var iecmis4 "IEC informational sheets response is missing"

label var iecobs5 "IEC job aids can be observed"
label var iecrnobs5 "IEC job aids are reported, but not observed"
label var iecna5 "IEC job aids are not available"
label var iecmis5 "IEC job aids response is missing"

label var iecobs6 "IEC demo models can be observed"
label var iecrnobs6 "IEC demo models are reported, but not observed"
label var iecna6 "IEC demo models are not available"
label var iecmis6 "IEC demo models response is missing"

label var iecobs7 "IEC counseling cards can be observed"
label var iecrnobs7 "IEC counseling cards are reported, but not observed"
label var iecna7 "IEC counseling cards are not available"
label var iecmis7 "IEC counseling cards response is missing"

label var iecobs8 "IEC samples can be observed"
label var iecrnobs8 "IEC samples are reported, but not observed"
label var iecna8 "IEC samples are not available"
label var iecmis8 "IEC samples response is missing"

gen iecntt=0 if participate==1
replace iecntt=1 if iecobs1==1|iecobs3==1|iecobs4==1

gen iectt=0 if participate==1
replace iectt=1 if iecobs2==1|iecobs5==1|iecobs6==1|iecobs7==1

gen anyiec=0 if participate==1
replace anyiec=1 if iecntt==1|iectt==1|iecobs8==1
ta anyiec

gen numiec=0 if participate==1
forvalues i=1/8 {
replace numiec=numiec+1 if iecobs`i'==1
}
ta numiec

label var anyiec "Any IEC materials can be observed"
label var numiec "Number of IEC materials that can be observed"

ta f44
gen iecprogram=0 if participate==1
replace iecprogram=1 if f44==1
ta iecprogram,missing
label var iecprogram "facility has an IEC program or one is nearby"

ta f48,nol
gen commtlk=0 if participate==1 & f48!=9
replace commtlk=1 if f48==1
ta commtlk,missing
label var commtlk "facility has ever organized health talks for the community"

order facid - fppats iecobs1-iecmis8 iecntt iectt anyiec numiec iecprogram commtlk 

drop f43_1 - f53o

*family planning protocol
ta f54, nol

gen fp_protocol1=0 if participate==1 & f54<8
replace fp_protocol1=1 if f54==1
ta fp_protocol1, missing
label var fp_protocol1 "facility has a family planning protocol (observed)"

gen fp_protocol2=0 if participate==1 & f54<8
replace fp_protocol2=1 if f54==1|f54==2
ta fp_protocol2, missing
label var fp_protocol2 "facility has a family planning protocol (observed or just stated)"

*Physical Infrastructure, Equipment, and consumables

ta f65, nol
gen electric=1 if f65==2|f65==3
replace electric=0 if f65==1
ta electric, missing
label var electric "facility has electricity"

ta f66, nol
gen backgen=1 if f65==2|f65==3
replace backgen=0 if f65==1
ta backgen, missing
label var backgen "facility has backup generator"

ta f67, nol
gen pwater=1 if f67==2|f67==3
replace pwater=0 if f67==1
ta pwater, missing
label var pwater "facility has piped water"

ta f68, nol
gen toilet=1 if f68==2|f68==3
replace toilet=0 if f68==1
ta toilet
label var toilet "facility has a toilet"

ta f69, nol
gen phone=1 if f69==3
replace phone=0 if f69==1|f69==2
ta phone
label var phone "facility has a phone"

ta f73, nol
gen privrm=1 if f73==2|f73==3
replace privrm=0 if f73==1
ta privrm,missing
label var privrm "facility has private rooms available"

ta f76, nol
gen delvrm=1 if f76==2|f76==3
replace delvrm=0 if f76==1
ta delvrm,missing
label var delvrm "facility has a delivery room"

ta f77, nol
gen oprm=1 if f77==2|f77==3
replace oprm=0 if f77==1
ta oprm,missing
label var oprm "facility has an operating room"

ta f97, nol
gen surgkit=1 if f97==2|f97==3
replace surgkit=0 if f97==1
ta surgkit,missing
label var surgkit "facility has a minor surgery kit"

ta f98, nol
gen evac=1 if f98==2|f98==3
replace evac=0 if f98==1
ta evac,missing
label var evac "facility has an extraction vacuum"

ta f106, nol
gen antiseptic=1 if f106==3
replace antiseptic=0 if f106==2|f106==1
ta antiseptic, missing
label var antiseptic "facility has antiseptics"

ta f116, nol
gen sedative=1 if f116==3
replace sedative=0 if f116==2|f116==1
ta sedative, missing
label var sedative "facility has sedatives"

ta f117, nol
gen atropine=1 if f117==3
replace atropine=0 if f117==2|f117==1
ta atropine, missing
label var atropine "facility has atropine"

ta f118, nol
gen morphine=1 if f118==3
replace morphine=0 if f118==2|f118==1
ta morphine, missing
label var morphine "facility has morphine"

ta f119, nol
gen locana=1 if f119==3
replace locana=0 if f119==2|f119==1
ta locana, missing
label var locana "facility has local anasthetics"

order facid - commtlk fp_protocol1 fp_protocol2 electric backgen pwater toilet phone privrm delvrm oprm /*
*/ surgkit evac antiseptic sedative atropine morphine locana

drop f64 - f135

* More Specific Family Planning Services and Products

rename f136amin8 f136amin_8
rename f136amin9 f136amin_9
rename f136amin10 f136amin_10

rename f136b8 f136b_8
rename f136b9 f136b_9
rename f136b10 f136b_10

forvalues i=1/10 {

ta sellfp`i'
ta f136amin_`i',nol
ta f136b_`i'

recode f136amin_`i' 99994=9994
recode f136amin_`i' 99995=9995
recode f136amin_`i' 99998=9998
recode f136amin_`i' 99999=9999
recode f136amin_`i' 999994=9994
recode f136amin_`i' 999995=9995
recode f136amin_`i' 999998=9998
recode f136amin_`i' 999999=9999

recode f136amin_`i' 9994=.
recode f136amin_`i' 9995=0
recode f136amin_`i' 9998=.
recode f136amin_`i' 9999=.

gen pricefp`i'=f136amin_`i'

ta pricefp`i', missing

}
label var pricefp1 "(minimum) Price of BC pills"
label var pricefp2 "(minimum) Price of progestative pills"
label var pricefp3 "(minimum) Price of energency contra"
label var pricefp4 "(minimum) Price of male condoms"
label var pricefp5 "(minimum) Price of female condoms"
label var pricefp6 "(minimum) Price of injectables"
label var pricefp7 "(minimum) Price of implants"
label var pricefp8 "(minimum) Price of IUD"
label var pricefp9 "(minimum) Price of female sterilization"
label var pricefp10 "(minimum) Price of male sterilization"

order facid - locana pricefp1 - pricefp10

drop f136amin_1 - f144h_9 

forvalues i=1/8 {
ta f145a_`i',nol
gen currentfp`i'=0 if participate==1 & f145a_`i'!=9
replace currentfp`i'=1 if f145a_`i'==1
ta currentfp`i',missing
}

label var currentfp1 "BC pills are currently available"
label var currentfp2 "Progestative pills are currently available"
label var currentfp3 "Emergency contraceptives are currently available"
label var currentfp4 "Male condoms are currently available"
label var currentfp5 "Female Condoms are currently available"
label var currentfp6 "Injections are currently available"
label var currentfp7 "Implants are currently available"
label var currentfp8 "IUDs are currently available"

forvalues i=1/8 {
ta f145b_`i',nol
gen soutyfp`i'=f145b_`i'
recode soutyfp`i' 2=0
recode soutyfp`i' 9=.
ta soutyfp`i', missing
}

label var soutyfp1 "has had a 24hr BC pill stock out in past YEAR"
label var soutyfp2 "has had a 24hr progestative pill stock out in past YEAR"
label var soutyfp3 "has had a 24hr emergency contraceptive stock out in past YEAR"
label var soutyfp4 "has had a 24hr male condom stock out in past YEAR"
label var soutyfp5 "has had a 24hr female condom stock out in past YEAR"
label var soutyfp6 "has had a 24hr injection stock out in past YEAR"
label var soutyfp7 "has had a 24hr implant stock out in past YEAR"
label var soutyfp8 "has had a 24hr IUD stock out in past YEAR"

forvalues i=1/8 {
ta f145f_`i',nol
gen soutmfp`i'=f145f_`i'
recode soutmfp`i' 2=0
recode soutmfp`i' 9=.
replace soutmfp`i'=0 if f145b_`i'==2
ta soutmfp`i', missing
}

label var soutmfp1 "has had a 24hr BC pill stock out in past MONTH"
label var soutmfp2 "has had a 24hr progestative pill stock out in past MONTH"
label var soutmfp3 "has had a 24hr emergency contraceptive stock out in past MONTH"
label var soutmfp4 "has had a 24hr male condom stock out in past MONTH"
label var soutmfp5 "has had a 24hr female condom stock out in past MONTH"
label var soutmfp6 "has had a 24hr injection stock out in past MONTH"
label var soutmfp7 "has had a 24hr implant stock out in past MONTH"
label var soutmfp8 "has had a 24hr IUD stock out in past MONTH"

gen any_sout=0 if participate==1
replace any_sout=1 if soutmfp1==1|soutmfp2==1|soutmfp3==1|soutmfp4==1|soutmfp5==1|soutmfp6==1|soutmfp7==1|soutmfp8==1 
ta any_sout

label var any_sout "Any 24 hour stock out in the past month"

order facid - pricefp10 currentfp1-currentfp8 soutyfp1-soutyfp8 soutmfp1-soutmfp8 any_sout 

drop f145a_1-f146m

save "$path/Senegal_HF_Audit.dta", replace
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
***********************************************************************************************************
** Pharmacy audit data
***********************************************************************************************************
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
use "public_senegal_pharmacy_v2.dta", clear
set more off

di _N

*Keep only facilities that still exist
ta result, nol
drop if result==2		/* moved/destroyed*/
drop if resulto=="?"
drop if resulto=="DEMANAGE"
drop if resulto=="DEMENAGEE"
drop if resulto=="DOUBLON"
drop if resulto=="DOUBLON AVEC 147"
drop if resulto=="DOUBLON AVEC 316"
drop if resulto=="DOUBLON AVEC 387"
drop if resulto=="DOUBLON AVEC 50"
drop if resulto=="DOUBLON AVEC 67"
drop if resulto=="DOUBLON AVEC 86"
drop if resulto=="FERMEE"
drop if resulto=="FERMER"
drop if resulto=="N HESITE PAS"
drop if resulto=="N HESITE PAS OU NON RETROUVE"

di _N
		*Dropped(26): 002,056,068,085,093,105,165,174,269,275,295,313,327,
		*             337,343,350,352,357,363,388,432,447,467,488,492,509 

* Identifiers
label var facid "Facility ID"
rename site city
label var city "city"
rename type facvol
label var facvol "facility volume"
ta facvol, missing
label define vol_level 1 "high volume public" 2 "high volume private" 3 "low volume public" 4 "low volume private" 5 "pharmacy"
label values facvol vol_level
ta facvol
gen factype=41
label var factype "facility type"
ta factype, nol
label define ltype 11 "Public Hospital" 12 "Public Health Center" 13 "Public Health Post" /*
                */ 14 "Public Health Check" 16 "other public" 21 "Private Clinic" 22 "Denominational Clinic" /*
				*/ 26 "Other Private" 31 "NGO Clinic" 41 "Pharmacy" 96 "Other" 99 "Missing"
label values factype ltype
ta factype
rename phday iday
label var iday "interview day"
rename phmon imon
label var imon "interview month"
gen iyear=phyear
label var iyear "interview year" 

order facid city facvol factype iday imon iyear

gen participate=1
replace participate=0 if ph2h==.
label var participate "actually participated in the interview"
ta participate

order facid city facvol factype iday imon iyear participate

drop ds - ph2m

*General Pharmacy Information
ta ph3y,nol missing
ta ph3a,nol missing
gen fage=2011-ph3y if ph3y<9998
replace fage=ph3a if fage==.
ta fage,missing
label var fage "Facility Age"

gen openy=ph3y
recode openy 9998=.
recode openy 9999=.
replace openy=2011-ph3a if openy==. & ph3a!=.
ta openy, missing

label var openy "year opened"

ta ph4,nol
ta ph5,nol
replace ph4=700 if ph4==7
replace ph4=800 if ph4==8
replace ph4=900 if ph4==9
replace ph5=1700 if ph5==17
replace ph5=1900 if ph5==19
replace ph5=2000 if ph5==20
replace ph5=2100 if ph5==21
replace ph5=2200 if ph5==22
replace ph5=2300 if ph5==23
replace ph5=2800 if ph5==300
replace ph5=2500 if ph5==0
gen hours=24 if ph4==9991
replace hours=(ph5-ph4)/100 if hours==. & ph5!=9999 & ph4!=9999
ta hours, missing
replace hours=24 if hours==25
label var hours "average number of hours open in a day"

ta ph6, nol
gen openall=1 if ph6==7
replace openall=0 if ph6==6|ph6==5
ta openall, missing
label var openall "open every day of the week"

ta ph8
ta ph9
gen multphar=0 if participate==1
replace multphar=1 if ph9>1 & ph9!=99 & ph9!=.
ta multphar,missing
label var multphar "indicates multiple pharmacists at the facility"

ta ph10, nol missing
gen pharhours=ph10
recode pharhours 999=.
label var pharhours "number of hours per week at least one pharmacist is there"

ta p15, nol
gen anyiec=p15
recode anyiec 2=0
recode anyiec 9=.
ta anyiec,missing
label var anyiec "Any IEC materials can be observed"

order facid city facvol factype iday imon iyear participate fage openy openall hours /*
*/ multphar pharhours anyiec 

drop ph3y - ph18o

* Specific Information on Contraceptives

forvalues i=1/9{

*sell at all
ta ph19a`i'
gen sellfp`i'=ph19a`i'
recode sellfp`i' 2=0
ta sellfp`i',missing

*price
su ph19c`i'_1 ph19c`i'_2 ph19c`i'_3
recode ph19c`i'_1 .=9999
recode ph19c`i'_2 .=9999
recode ph19c`i'_3 .=9999
gen pricefp`i'=min(ph19c`i'_1, ph19c`i'_2, ph19c`i'_3)
recode pricefp`i' 9999=.
su pricefp`i'

*Currently available
ta ph19e`i'_1,nol
ta ph19e`i'_2,nol
ta ph19e`i'_3,nol
ta ph19e`i'_3,nol
gen currentfp`i'=0 if ph19e`i'_1==2 |ph19e`i'_2==2|ph19e`i'_3==2 
replace currentfp`i'=0 if sellfp`i'==0|sellfp`i'==0|sellfp`i'==0
replace currentfp`i'=1 if ph19e`i'_1==1|ph19e`i'_2==1|ph19e`i'_3==1
ta currentfp`i',missing

*Stock out in past year
ta ph19f`i'_1,nol
ta ph19f`i'_2,nol
ta ph19f`i'_3,nol
gen soutyfp`i'=0 if ph19f`i'_1==2|ph19f`i'_2==2|ph19f`i'_3==2
replace soutyfp`i'=1 if ph19f`i'_1==1|ph19f`i'_2==1|ph19f`i'_3==1
ta soutyfp`i',missing

*Stock out in past month
ta ph19h`i'_1,nol
ta ph19h`i'_2,nol
ta ph19h`i'_3,nol
gen soutmfp`i'=0 if ph19h`i'_1==2|ph19h`i'_2==2|ph19h`i'_3==2
replace soutmfp`i'=1 if ph19h`i'_1==1|ph19h`i'_2==1|ph19h`i'_3==1
ta soutmfp`i',missing
*/
}
drop sellfp6 pricefp6 currentfp6 soutyfp6 soutmfp6

rename sellfp7 sellfp6
rename pricefp7 pricefp6
rename currentfp7 currentfp6
rename soutyfp7 soutyfp6
rename soutmfp7 soutmfp6

rename sellfp8 sellfp7
rename pricefp8 pricefp7
rename currentfp8 currentfp7
rename soutyfp8 soutyfp7
rename soutmfp8 soutmfp7

rename sellfp9 sellfp8
rename pricefp9 pricefp8
rename currentfp9 currentfp8
rename soutyfp9 soutyfp8
rename soutmfp9 soutmfp8

label var sellfp1 "Pharmacy sells BC pills"
label var pricefp1 "Minimum price of BC pills"
label var currentfp1 "BC pills is currently available"
label var soutyfp1 "There has been a 24 hour stock out of BC pills in the last year"
label var soutmfp1 "There has been a 24 hour stock out of BC pills in the last month"
label var sellfp2 "Pharmacy sells Progestative Pills"
label var pricefp2 "Minimum price of Progestative Pills"
label var currentfp2 "Progestative Pills is currently available"
label var soutyfp2 "There has been a 24 hour stock out of Progestative Pills in the last year"
label var soutmfp2 "There has been a 24 hour stock out of Progestative Pills in the last month"
label var sellfp3 "Pharmacy sells Emergency Contraceptives"
label var pricefp3 "Minimum price of Emergency Contraceptives"
label var currentfp3 "Emergency Contraceptives is currently available"
label var soutyfp3 "There has been a 24 hour stock out of Emergency Contraceptives in the last year"
label var soutmfp3 "There has been a 24 hour stock out of Emergency Contraceptives in the last month"
label var sellfp4 "Pharmacy sells Male Condoms"
label var pricefp4 "Minimum price of Male Condoms"
label var currentfp4 "Male Condoms is currently available"
label var soutyfp4 "There has been a 24 hour stock out of Male Condoms in the last year"
label var soutmfp4 "There has been a 24 hour stock out of Male Condoms in the last month"
label var sellfp5 "Pharmacy sells Female Condoms"
label var pricefp5 "Minimum price of Female Condoms"
label var currentfp5 "Female Condoms is currently available"
label var soutyfp5 "There has been a 24 hour stock out of Female Condoms in the last year"
label var soutmfp5 "There has been a 24 hour stock out of Female Condoms in the last month"
label var sellfp6 "Pharmacy sells Injectables"
label var pricefp6 "Minimum price of Injectables"
label var currentfp6 "Injectables is currently available"
label var soutyfp6 "There has been a 24 hour stock out of Injectables in the last year"
label var soutmfp6 "There has been a 24 hour stock out of Injectables in the last month"
label var sellfp7 "Pharmacy sells Implants"
label var pricefp7 "Minimum price of Implants"
label var currentfp7 "Implants is currently available"
label var soutyfp7 "There has been a 24 hour stock out of Implants in the last year"
label var soutmfp7 "There has been a 24 hour stock out of Implants in the last month"
label var sellfp8 "Pharmacy sells IUDs"
label var pricefp8 "Minimum price of IUDs"
label var currentfp8 "IUDs is currently available"
label var soutyfp8 "There has been a 24 hour stock out of IUDs in the last year"
label var soutmfp8 "There has been a 24 hour stock out of IUDs in the last month"

gen any_sout=0 if participate==1
replace any_sout=1 if soutmfp1==1|soutmfp2==1|soutmfp3==1|soutmfp4==1|soutmfp5==1|soutmfp6==1|soutmfp7==1|soutmfp8==1 
ta any_sout

label var any_sout "Any 24 hour stock out in the past month"

gen totsell=0 if participate==1
forvalues i=1/8 {
replace totsell=1+totsell if sellfp`i'==1
}
ta totsell 

label var totsell "total number of FP methods sold"

gen sellt1=0
gen sellt2=0
gen sellt3=0
replace sellt1=1 if sellfp3==1|sellfp4==1|sellfp5==1
replace sellt2=1 if sellfp1==1|sellfp2==1|sellfp6==1
replace sellt3=1 if sellfp7==1|sellfp8==1

label var sellt1 "rx sells SHORT-term BC methods"
label var sellt2 "rx sells MEDIUM-term BC methods"
label var sellt3 "rx sells LONG-term BC methods"

su sellt1 sellt2 sellt3

order facid - anyiec /*
*/ sellfp1 sellfp2 sellfp3 sellfp4 sellfp5 sellfp6 sellfp7 sellfp8 sellt1 sellt2 sellt3 /*
*/ pricefp1 pricefp2 pricefp3 pricefp4 pricefp5 pricefp6 pricefp7 pricefp8 /*
*/ currentfp1 currentfp2 currentfp3 currentfp4 currentfp5 currentfp6 currentfp7 currentfp8 /*
*/ soutyfp1 soutyfp2 soutyfp3 soutyfp4 soutyfp5 soutyfp6 soutyfp7 soutyfp8 /*
*/ soutmfp1 soutmfp2 soutmfp3 soutmfp4 soutmfp5 soutmfp6 soutmfp7 soutmfp8 any_sout totsell  

drop ph19a1 - ph20bo_10

*Affiliation with outside organizations
ta ph23, nol
gen fpsocial=ph23
recode fpsocial 9=.
recode fpsocial 2=0
ta fpsocial,missing
label var fpsocial "Affiliated social with program that supplies discounted FP products"

*Interview with main FP person
ta ph39, nol
gen fptrained=ph39
recode fptrained 2=0
recode fptrained 9=.
ta fptrained, missing
label var fptrained "Person helping people with FP has recieved formal training"

ta ph43, nol
gen fpstaff=ph43
recode fpstaff 2=0
recode fpstaff 9=.
ta fpstaff, missing
label var fpstaff "Staff at the Pharmacy is capable of giving FP advice"

forvalues i=1/9 {
ta ph45_0`i',nol
gen rxnneed`i'=ph45_0`i'
recode rxnneed`i' 1=0
recode rxnneed`i' 2=1
recode rxnneed`i' 7=. 
recode rxnneed`i' 9=. 
ta rxnneed`i',missing
}
drop rxnneed6
rename rxnneed7 rxnneed6
rename rxnneed8 rxnneed7
rename rxnneed9 rxnneed8

label var rxnneed1 "Prescription NOT needed for BC pills"
label var rxnneed2 "Prescription NOT needed for Progestative Pills"
label var rxnneed3 "Prescription NOT needed for Emergency Contraceptives"
label var rxnneed4 "Prescription NOT needed for Male Condoms"
label var rxnneed5 "Prescription NOT needed for Female Condoms"
label var rxnneed6 "Prescription NOT needed for Injectables"
label var rxnneed7 "Prescription NOT needed for Implants"
label var rxnneed8 "Prescription NOT needed for IUDs"

gen totnorx=0 if participate==1
forvalues i=1/8 {
replace totnorx=totnorx+1 if rxnneed`i'==1
}
ta totnorx

label var totnorx "total number of methods available without a prescription"

order facid - totsell fpsocial fptrained fpstaff rxnneed1-rxnneed8 totnorx


drop ph21 - ph50m

save "$path/Senegal_Pharm_Audit.dta", replace


*******************************************************************
** Merge all files together into 1 usable facility/pharmacy file
*******************************************************************

use "$path/Senegal_HF_Audit.dta", clear
append using "$path/Senegal_Pharm_Audit.dta"

sort facid

tostring facid, replace
replace facid = string(city) + "0" + string(facnum,"%03.0f") if factype!=41
order facid

drop facnum
di _N
su

save "$path/Senegal_Facility.dta", replace

































******************************************************************************************************
********************************SENEGAL CLUSTER FILE**************************************************
******************************************************************************************************



******************************************************************
** This file creates variables for each cluster that describe the
** health facilities w/in 1km of the central cluster point
******************************************************************

set more off
set seed 67890

***************
***************
***************
** one km clean
***************
***************
***************

*Cluster FILE
use "cluster_fac_distance_updated", clear

rename loccode location_code

tostring facid, replace
replace facid = substr(facid,2,4)
replace facid = "0" + substr(facid,2,3) if substr(facid,1,1)=="1"|substr(facid,1,1)=="2"|substr(facid,1,1)=="3"|substr(facid,1,1)=="4"

gen hf=1
replace hf=0 if substr(facid,1,1)=="5"

	*remove any non-existant facilities (removed from facility file)
drop if facid=="0046" 
drop if facid=="0048" 
drop if facid=="0052" 
drop if facid=="0099" 
drop if facid=="0122" 
drop if facid=="0030" 
drop if facid=="0057" 
drop if facid=="0073" 
drop if facid=="0140" 
drop if facid=="0132" 
drop if facid=="0151" 
drop if facid=="0167" 
drop if facid=="0180" 
drop if facid=="0192" 
drop if facid=="0202" 
drop if facid=="0292"
drop if facid=="0297"
drop if facid=="0302"
drop if facid=="0372"   
drop if facid=="0373" 
drop if facid=="0390"
drop if facid=="0399" 
drop if facid=="0428"
drop if facid=="0436"
drop if facid=="0450" 
drop if facid=="0452" 
drop if facid=="0467" 
drop if facid=="0475" 
drop if facid=="0485" 
drop if facid=="0488"
drop if facid=="0493" 
drop if facid=="0497" 
drop if facid=="0519" 
drop if facid=="0521" 
drop if facid=="0523" 
drop if facid=="0531" 
drop if facid=="0532" 
drop if facid=="0545"
drop if facid=="0548" 
drop if facid=="0907" 
drop if facid=="0912"  
drop if facid=="5002"
drop if facid=="5056"
drop if facid=="5068"
drop if facid=="5085"
drop if facid=="5093"
drop if facid=="5105"
drop if facid=="5165"
drop if facid=="5174"
drop if facid=="5269"
drop if facid=="5275"
drop if facid=="5295"
drop if facid=="5313"
drop if facid=="5327"
drop if facid=="5337"
drop if facid=="5343"
drop if facid=="5350"
drop if facid=="5352"
drop if facid=="5357"
drop if facid=="5363"
drop if facid=="5388"
drop if facid=="5432"
drop if facid=="5447"
drop if facid=="5467"
drop if facid=="5488"
drop if facid=="5492"
drop if facid=="5509"

save "$path/location_fac_distance.dta", replace 

*Senegal: 1 KM buffer

*Original buffer data
use "SDP_buffers_all/SDP_all_1k.dta", clear

rename loccode location_code

*260 of 263 location codes, 3 have no facility within 1 km (all are present with 2km)
*683 of 845 facilities. No GPS data for 63. Other 99 do not fall within 1 KM of centroid.
*When buffer is extended to 2km, there are 768 facilities (still missing 14).

sort location_code facid

tostring facid, replace

rename facid facido
gen str1 helper=substr(facido,2,2)

gen str2 letter=""
replace letter="STR" if helper!="5"
replace letter="PHA" if helper=="5"

gen str5 facid = ""
replace facid = substr(facido,1,1) + "0" + substr(facido,3,5) if helper!="5"
replace facid = substr(facido,1,1) + "5" + substr(facido,3,5) if helper=="5"

order location_code facid facido letter

keep facid location_code letter

rename facid facidd
gen facid=substr(facidd,2,5)

*merge in distance information
merge 1:1 location_code facid using "$path/location_fac_distance.dta"
drop if _merge==2

drop facid
rename facidd facid

order location_code facid letter distance
keep location_code - distance

save "$path/buffer1km.dta", replace

*merge facility:
* This merging file contains:
* - 254 of the 269 original health facilities and 
* - 550 of the 576 original pharmacies
* - 804 of the 845 total

merge m:1 facid using "$path/Senegal_Facility.dta"

replace factype=16 if factype==96 & facvol==3
replace factype=26 if factype==96 & facvol==4
replace factype=16 if factype==99 & facvol==1
replace factype=16 if factype==99 & facvol==3
replace factype=26 if factype==99 & facvol==4
recode factype 14=16

gen n_factype=.
replace n_factype=1 if factype==11
replace n_factype=2 if factype==12
replace n_factype=2 if factype==13
replace n_factype=2 if factype==16
replace n_factype=3 if factype==21
replace n_factype=3 if factype==26
replace n_factype=4 if factype==22
replace n_factype=4 if factype==31
replace n_factype=5 if factype==41

label define types 1 "1.Public Hospital" 2 "2.Other Public" 3 "3.Private" 4 "4.Denom/NGO" 5 "5.Pharmacy"
label values n_factype types

ta n_factype

keep if _merge==3
drop _merge

* 100 units in buffer file do not find a match. These are facilities that no longer exist. 
*   (verified by not dropping these facilities) 
* 141 units in facilities file do not match. These are all facilities that either 
*   (1) have no GPS data (63) - or -
*   (2) have GPS data, but are not within 1KM of any centroid (78)

order location_code facid
sort location_code facid

replace factype=26 if factype==96|factype==99

*quick fixes

replace iecobs1=. if iecmis1==1
replace iecrnobs1=. if iecmis1==1
replace iecna1=. if iecmis1==1
drop iecmis1
replace iecobs2=. if iecmis2==1
replace iecrnobs2=. if iecmis2==1
replace iecna2=. if iecmis2==1
drop iecmis2
replace iecobs3=. if iecmis3==1
replace iecrnobs3=. if iecmis3==1
replace iecna3=. if iecmis3==1
drop iecmis3
replace iecobs4=. if iecmis4==1
replace iecrnobs4=. if iecmis4==1
replace iecna4=. if iecmis4==1
drop iecmis4
replace iecobs5=. if iecmis5==1
replace iecrnobs5=. if iecmis5==1
replace iecna5=. if iecmis5==1
drop iecmis5
replace iecobs6=. if iecmis6==1
replace iecrnobs6=. if iecmis6==1
replace iecna6=. if iecmis6==1
drop iecmis6
replace iecobs7=. if iecmis7==1
replace iecrnobs7=. if iecmis7==1
replace iecna7=. if iecmis7==1
drop iecmis7
replace iecobs8=. if iecmis8==1
replace iecrnobs8=. if iecmis8==1
replace iecna8=. if iecmis8==1
drop iecmis8

foreach i of numlist 1 3/6 12 14/22 {
replace vols`i'=0 if offers`i'==0 & vols`i'==.
su vols`i'
}
*********create number of each facility type
gen num_public=0
gen num_private=0
gen num_pharmacy=0
gen num_lowvol=0
gen num_highvol=0
gen num_Pub_Hos=0
gen num_Pub_Oth=0
gen num_Private=0
gen num_Dnm_NGO=0


forvalues i=-60/60{
replace num_public=num_public+1 if location_code==location_code[_n+`i'] & n_factype[_n+`i']==1
replace num_public=num_public+1 if location_code==location_code[_n+`i'] & n_factype[_n+`i']==2
replace num_private=num_private+1 if location_code==location_code[_n+`i'] & n_factype[_n+`i']==3
replace num_private=num_private+1 if location_code==location_code[_n+`i'] & n_factype[_n+`i']==4
replace num_pharmacy=num_pharmacy+1 if location_code==location_code[_n+`i'] & n_factype[_n+`i']==5
replace num_highvol=num_highvol+1 if location_code==location_code[_n+`i'] & facvol[_n+`i']==1
replace num_highvol=num_highvol+1 if location_code==location_code[_n+`i'] & facvol[_n+`i']==2
replace num_lowvol=num_lowvol+1 if location_code==location_code[_n+`i'] & facvol[_n+`i']==3
replace num_lowvol=num_lowvol+1 if location_code==location_code[_n+`i'] & facvol[_n+`i']==4
replace num_Pub_Hos=num_Pub_Hos+1 if location_code==location_code[_n+`i'] & n_factype[_n+`i']==1
replace num_Pub_Oth=num_Pub_Oth+1 if location_code==location_code[_n+`i'] & n_factype[_n+`i']==2
replace num_Private=num_Private+1 if location_code==location_code[_n+`i'] & n_factype[_n+`i']==3
replace num_Dnm_NGO=num_Dnm_NGO+1 if location_code==location_code[_n+`i'] & n_factype[_n+`i']==4
}
label var location_code "cluster label"
label var letter "health facility or num_pharmacy indicator"
label var num_public "number of public health facilities in cluster"
label var num_private "number of private health facilities in cluster"
label var num_pharmacy "number of pharmacies in cluster"
label var num_highvol "number of high volume facilities"
label var num_lowvol "number of low volume facilities"
label var num_Pub_Hos "number of Public Hospitals"
label var num_Pub_Oth "number of Other Public Facilities"
label var num_Private "number of Private Facilities"
label var num_Dnm_NGO "number of Denominational and NGO facilities"

drop n_factype

gsort location_code -letter

*******split data sets
save "$path/temp_cluster.dta", replace

sort letter location_code
drop if letter=="STR"
save "$path/temp_pharm_cluster.dta", replace

use "$path/temp_cluster.dta", clear
sort letter location_code
drop if letter=="PHA"
save "$path/temp_fac_cluster.dta", replace

************************
** work on facility file
************************

use "$path/temp_fac_cluster.dta", clear

*******drop variables
order location_code letter num_public num_private num_pharmacy participate facvol factype distance
drop facid - iyear
drop vols3 - vols6
drop vols16 - vols21
drop daysfp1 - daysfp10
drop consentfp1 - consentfp10
drop backgen oprm - locana
drop soutyfp1 - soutmfp8
drop pricefp9 - pricefp10
drop f54 - rxnneed8

su

*******identify locations with all non-participating health facilities
gen allnonpat=1
forvalues i=-15/15{
replace allnonpat=0 if location_code==location_code[_n+`i'] & participate[_n+`i']==1
}
ta allnonpat

gen pub_hf=0
replace pub_hf=1 if factype==11|factype==12|factype==13|factype==14|factype==16
ta pub_hf if allnonpat==1    /* all public facilities */

*******fill continuous variables according to public/private for those missing all

su fage if pub_hf==1
replace fage=r(mean) if fage==. & pub_hf==1 & participate==1
su fage if pub_hf==0
replace fage=r(mean) if fage==. & pub_hf==0 & participate==1

replace commtlk=round(runiform()) if commtlk==. & participate==1

replace fp_protocol2=round(runiform()+.2) if fp_protocol2==. & participate==1

replace phone=1 if phone==. & participate==1

drop factype participate pub_hf facvol

*******reshape data
order location_code letter num_public num_private num_pharmacy allnonpat num_lowvol-num_Dnm_NGO distance

gsort location_code -letter
gen helper=0
replace helper=1 if location_code!=location_code[_n-1] 

order location_code letter helper num_public num_private num_pharmacy allnonpat num_lowvol-num_Dnm_NGO distance

forvalues i=1/60{
replace helper=1+`i' if helper[_n-`i']==1 & location_code==location_code[_n-`i']
}
ta helper

forvalues i=1/9 {
rename offers`i' offers0`i'
}
rename vols1 vols01

reshape wide distance - any_sout, i(location_code) j(helper)

*******create variables
order location_code letter num_public num_private num_pharmacy allnonpat num_lowvol-num_Dnm_NGO

di _N

egen ave_hf_dist = rowmean(distance1 distance2 distance3 distance4 distance5 distance6 /*
*/ distance7 distance8 distance9 distance10 distance11 distance12 distance13)
su ave_hf_dist
label var ave_hf_dist "Average distance to HF in buffer"
order location_code - num_lowvol ave_hf_dist
drop distance1 distance2 distance3 distance4 distance5 distance6 /*
*/ distance7 distance8 distance9 distance10 distance11 distance12 distance13

*Average facility age
egen ave_hf_age = rowmean(fage1 fage2 fage3 fage4 fage5 fage6 fage7 fage8 fage9 fage10 /*
*/ fage11 fage12 fage13)
su ave_hf_age 
label var ave_hf_age "Average HF age"
order location_code - ave_hf_dist ave_hf_age
drop fage1 fage2 fage3 fage4 fage5 fage6 fage7 fage8 fage9 fage10 fage11 fage12 fage13

*Number facilities open every day of the week
egen num_hf_opn7=rowtotal(openall1 openall2 openall3 openall4 openall5 openall6 openall7 /*
*/ openall8 openall9 openall10 openall11 openall12 openall13 ), missing
ta num_hf_opn7
label var num_hf_opn7 "Number of HF open all 7 days of the week"
order location_code - ave_hf_age num_hf_opn7
drop openall1 openall2 openall3 openall4 openall5 openall6 openall7 /*
*/ openall8 openall9 openall10 openall11 openall12 openall13

*Average number of hours a facility is open in a day
egen ave_hf_hrs=rowmean(hours1 hours2 hours3 hours4 hours5 hours6 hours7 hours8 hours9 /*
*/ hours10 hours11 hours12 hours13)
ta ave_hf_hrs
label var ave_hf_hrs "Average # hours a HF is open"
order location_code - num_hf_opn7 ave_hf_hrs
drop hours1 hours2 hours3 hours4 hours5 hours6 hours7 hours8 hours9 /*
*/ hours10 hours11 hours12 hours13

*Number of HF affiliated with social program that provides contraceptives for discount
egen num_hf_socfp=rowtotal(fpsocial1 fpsocial2 fpsocial3 fpsocial4 fpsocial5 fpsocial6 /*
*/ fpsocial7 fpsocial8 fpsocial9 fpsocial10 fpsocial11 fpsocial12 fpsocial13), missing
ta num_hf_socfp 
label var num_hf_socfp "Number of HF with FP discounted by social program"
order location_code - ave_hf_hrs num_hf_socfp 
drop fpsocial1 fpsocial2 fpsocial3 fpsocial4 fpsocial5 fpsocial6 /*
*/ fpsocial7 fpsocial8 fpsocial9 fpsocial10 fpsocial11 fpsocial12 fpsocial13

*Average number of general doctors at the health facilities
egen ave_hf_doc=rowmean(ndoc1 ndoc2 ndoc3 ndoc4 ndoc5 ndoc6 ndoc7 ndoc8 /*
*/ ndoc9 ndoc10 ndoc11 ndoc12 ndoc13)
su ave_hf_doc
label var ave_hf_doc "Average number of doctors in HFs"
order location_code - num_hf_socfp  ave_hf_doc 
drop ndoc1 ndoc2 ndoc3 ndoc4 ndoc5 ndoc6 ndoc7 ndoc8 /*
*/ ndoc9 ndoc10 ndoc11 ndoc12 ndoc13

*Average number of nurses at the health facilities
egen ave_hf_nurs=rowmean(nnurse1 nnurse2 nnurse3 nnurse4 nnurse5 nnurse6 nnurse7 /*
*/ nnurse8 nnurse9 nnurse10 nnurse11 nnurse12 nnurse13)
su ave_hf_nurs
label var ave_hf_nurs "Average number of nurses in HFs"
order location_code - ave_hf_doc ave_hf_nurs
drop nnurse1 nnurse2 nnurse3 nnurse4 nnurse5 nnurse6 nnurse7 /*
*/ nnurse8 nnurse9 nnurse10 nnurse11 nnurse12 nnurse13

*Average number of midwives at the health facilities
egen ave_hf_midw=rowmean(nmidw1 nmidw2 nmidw3 nmidw4 nmidw5 nmidw6 nmidw7 nmidw8 nmidw9 /*
*/ nmidw10 nmidw11 nmidw12 nmidw13)
su ave_hf_midw
label var ave_hf_midw "Average number of midwives in HFs"
order location_code - ave_hf_nurs ave_hf_midw
drop nmidw1 nmidw2 nmidw3 nmidw4 nmidw5 nmidw6 nmidw7 nmidw8 nmidw9 /*
*/ nmidw10 nmidw11 nmidw12 nmidw13

*Average number of staff at the health facilities
egen ave_hf_staff=rowmean(nstaff1 nstaff2 nstaff3 nstaff4 nstaff5 nstaff6 nstaff7 nstaff8 nstaff9 /*
*/ nstaff10 nstaff11 nstaff12 nstaff13)
su ave_hf_staff
label var ave_hf_staff "Average number of staff in HFs"
order location_code - ave_hf_midw ave_hf_staff
drop nstaff1 nstaff2 nstaff3 nstaff4 nstaff5 nstaff6 nstaff7 nstaff8 nstaff9 /*
*/ nstaff10 nstaff11 nstaff12 nstaff13

*number of health facilities with a health educator or health social worker
egen num_hf_hsw=rowtotal(ahsw1 ahsw2 ahsw3 ahsw4 ahsw5 ahsw6 ahsw7 ahsw8 ahsw9 ahsw10 /*
*/ ahsw11 ahsw12 ahsw13), missing
su num_hf_hsw
label var num_hf_hsw "Total number of health educators in HFs in cluster"
order location_code - ave_hf_staff num_hf_hsw
drop ahsw1 ahsw2 ahsw3 ahsw4 ahsw5 ahsw6 ahsw7 ahsw8 ahsw9 ahsw10 /*
*/ ahsw11 ahsw12 ahsw13

*probability of facility offering family planning services
egen prb_hf_offfp=rowmean(offers221 offers222 offers223 offers224 offers225 offers226 /*
*/ offers227 offers228 offers229 offers2210 offers2211 offers2212 offers2213)
su prb_hf_offfp, detail
label var prb_hf_offfp "probability of facility offering family planning services"

order location_code - num_hf_hsw prb_hf_offfp

*Number of HF offering particular services
forvalues i=1/9 {
egen num_hf_offer`i'=rowtotal(offers0`i'1 offers0`i'2 offers0`i'3 offers0`i'4 offers0`i'5 /*
*/ offers0`i'6 offers0`i'7 offers0`i'8 offers0`i'9 offers0`i'10 offers0`i'11 offers0`i'12 /*
*/ offers0`i'13), missing
ta num_hf_offer`i'
drop offers0`i'1 offers0`i'2 offers0`i'3 offers0`i'4 offers0`i'5 /*
*/ offers0`i'6 offers0`i'7 offers0`i'8 offers0`i'9 offers0`i'10 offers0`i'11 offers0`i'12 /*
*/ offers0`i'13
}
order location_code - prb_hf_offfp /*
*/ num_hf_offer1 num_hf_offer2 num_hf_offer3 num_hf_offer4 num_hf_offer5 num_hf_offer6 /*
*/ num_hf_offer7 num_hf_offer8 num_hf_offer9 
label var num_hf_offer1 "Number of HF offering MATERNITY/DELIVERY"  
label var num_hf_offer2 "Number of HF offering BREAST-FEEDING COUNSELING" 
label var num_hf_offer3 "Number of HF offering EMERGENCY LABOR SERVICES" 
label var num_hf_offer4 "Number of HF offering CONSULTATION FOR INFERTILITY" 
label var num_hf_offer5 "Number of HF offering POST-ABORTION CARE" 
label var num_hf_offer6 "Number of HF offering PRE-NATAL" 
label var num_hf_offer7 "Number of HF offering VACCINATIONS DURING PREGNANCY" 
label var num_hf_offer8 "Number of HF offering SYPHILLIS SCREENING DURING PREGNANCY" 
label var num_hf_offer9 "Number of HF offering IRON SUPP DURING PREGNANCY" 

foreach i of numlist 10/22 {
egen num_hf_offer`i'=rowtotal(offers`i'1 offers`i'2 offers`i'3 offers`i'4 offers`i'5 /*
*/ offers`i'6 offers`i'7 offers`i'8 offers`i'9 offers`i'10 offers`i'11 offers`i'12 /*
*/ offers`i'13), missing
ta num_hf_offer`i'
drop offers`i'1 offers`i'2 offers`i'3 offers`i'4 offers`i'5 offers`i'6 offers`i'7 /*
*/ offers`i'8 offers`i'9 offers`i'10 offers`i'11 offers`i'12 offers`i'13
}
order location_code - num_hf_offer9 num_hf_offer10 num_hf_offer11 num_hf_offer12 /*
*/ num_hf_offer13 num_hf_offer14 num_hf_offer15 num_hf_offer16 num_hf_offer17 num_hf_offer18 /*
*/ num_hf_offer19 num_hf_offer20 num_hf_offer21 num_hf_offer22 
label var num_hf_offer10 "Number of HF offering PREVENTATIVE CARE"
label var num_hf_offer11 "Number of HF offering NUTRITION COUNSELING FOR PREGNANT" 
label var num_hf_offer12 "Number of HF offering POST-NATAL" 
label var num_hf_offer13 "Number of HF offering VIT A AFTER PREGNANCY" 
label var num_hf_offer14 "Number of HF offering CHILD IMMUNIZATION" 
label var num_hf_offer15 "Number of HF offering CHILD GROWTH MONITORING" 
label var num_hf_offer16 "Number of HF offering CHILD RESPITORY DISEASE"
label var num_hf_offer17 "Number of HF offering ORAL REHYDRATION" 
label var num_hf_offer18 "Number of HF offering STDS" 
label var num_hf_offer19 "Number of HF offering HIV TEST" 
label var num_hf_offer20 "Number of HF offering MOTHER-CHILD TRANSMISSION PREVENTION"  
label var num_hf_offer21 "Number of HF offering HIV CARE" 
label var num_hf_offer22 "Number of HF offering FAMILY PLANNING" 

*Average number of services offered at HF
egen ave_hf_offnum=rowmean(offernum1 offernum2 offernum3 offernum4 offernum5 offernum6 /*
*/ offernum7 offernum8 offernum9 offernum10 offernum11 offernum12 offernum13)
su ave_hf_offnum
order location_code - num_hf_offer22 ave_hf_offnum
label var ave_hf_offnum "Average number of services offered at HF"
drop offernum1 offernum2 offernum3 offernum4 offernum5 offernum6 /*
*/ offernum7 offernum8 offernum9 offernum10 offernum11 offernum12 offernum13

*Average volume of select services at HF
egen ave_hf_vol1=rowmean(vols011 vols012 vols013 vols014 vols015 vols016 /*
*/ vols017 vols018 vols019 vols0110 vols0111 vols0112 vols0113 )
su ave_hf_vol1
drop vols011 vols012 vols013 vols014 vols015 vols016 vols017 vols018 vols019 vols0110 /*
*/ vols0111 vols0112 vols0113

foreach i of numlist 12 14 15 22 {
egen ave_hf_vol`i'=rowmean(vols`i'1 vols`i'2 vols`i'3 vols`i'4 vols`i'5 vols`i'6 /*
*/ vols`i'7 vols`i'8 vols`i'9 vols`i'10 vols`i'11 vols`i'12 vols`i'13 )
su ave_hf_vol`i'
drop vols`i'1 vols`i'2 vols`i'3 vols`i'4 vols`i'5 vols`i'6 vols`i'7 vols`i'8 vols`i'9 /*
*/ vols`i'10 vols`i'11 vols`i'12 vols`i'13 
}
order location_code - ave_hf_offnum ave_hf_vol1 ave_hf_vol12 /*
*/ ave_hf_vol14 ave_hf_vol15 ave_hf_vol22
label var ave_hf_vol1 "Average 3 month volume of MATERNITY/DELIVERY patients for HF that offer service" 
label var ave_hf_vol12 "Average 3 month volume of POST-NATAL patients for HF that offer service" 
label var ave_hf_vol14 "Average 3 month volume of CHILD IMMUNIZATION patients for HF that offer service" 
label var ave_hf_vol15 "Average 3 month volume of CHILD GROWTH MONITORING patients for HF that offer service" 
label var ave_hf_vol22 "Average 3 month volume of FAMILY PLANNING patients for HF that offer service" 

*Number of facilities that consult on FP method ....
forvalues i=1/10{
egen num_hf_cons`i'=rowtotal(consultfp`i'1 consultfp`i'2 consultfp`i'3 consultfp`i'4 consultfp`i'5 /*
*/ consultfp`i'6 consultfp`i'7 consultfp`i'8 consultfp`i'9 consultfp`i'10 consultfp`i'11 /*
*/ consultfp`i'12 consultfp`i'13 ), missing
ta num_hf_cons`i'
drop consultfp`i'1 consultfp`i'2 consultfp`i'3 consultfp`i'4 consultfp`i'5 /*
*/ consultfp`i'6 consultfp`i'7 consultfp`i'8 consultfp`i'9 consultfp`i'10 consultfp`i'11 /*
*/ consultfp`i'12 consultfp`i'13 
}
order location_code - ave_hf_vol22 num_hf_cons1 num_hf_cons2 num_hf_cons3 num_hf_cons4 /*
*/ num_hf_cons5 num_hf_cons6 num_hf_cons7 num_hf_cons8 num_hf_cons9 num_hf_cons10
label var num_hf_cons1 "Number of HF that consult on BC PILLS"
label var num_hf_cons2 "Number of HF that consult on PROGESTATIVE ONLY PILLS"
label var num_hf_cons3 "Number of HF that consult on EMERGENCY CONTRACEPTIVES"
label var num_hf_cons4 "Number of HF that consult on MALE CONDOMS"
label var num_hf_cons5 "Number of HF that consult on FEMALE CONDOMS"
label var num_hf_cons6 "Number of HF that consult on INJECTABLES"
label var num_hf_cons7 "Number of HF that consult on IMPLANTS"
label var num_hf_cons8 "Number of HF that consult on IUD"
label var num_hf_cons9 "Number of HF that consult on FEMALE STERILIZATION"
label var num_hf_cons10 "Number of HF that consult on MALE STERILIZATION"

*Number of facilities that sell FP method ....
forvalues i=1/10{
egen num_hf_sell`i'=rowtotal(sellfp`i'1 sellfp`i'2 sellfp`i'3 sellfp`i'4 sellfp`i'5 sellfp`i'6 /*
*/ sellfp`i'7 sellfp`i'8 sellfp`i'9 sellfp`i'10 sellfp`i'11 sellfp`i'12 sellfp`i'13), missing
ta num_hf_sell`i'
drop sellfp`i'1 sellfp`i'2 sellfp`i'3 sellfp`i'4 sellfp`i'5 sellfp`i'6 /*
*/ sellfp`i'7 sellfp`i'8 sellfp`i'9 sellfp`i'10 sellfp`i'11 sellfp`i'12 sellfp`i'13
}
order location_code - num_hf_cons10 num_hf_sell1 num_hf_sell2 num_hf_sell3 num_hf_sell4 /*
*/ num_hf_sell5 num_hf_sell6 num_hf_sell7 num_hf_sell8 num_hf_sell9 num_hf_sell10
label var num_hf_sell1 "Number of HF that sell on BC PILLS"
label var num_hf_sell2 "Number of HF that sell on PROGESTATIVE ONLY PILLS"
label var num_hf_sell3 "Number of HF that sell on EMERGENCY CONTRACEPTIVES"
label var num_hf_sell4 "Number of HF that sell on MALE CONDOMS"
label var num_hf_sell5 "Number of HF that sell on FEMALE CONDOMS"
label var num_hf_sell6 "Number of HF that sell on INJECTABLES"
label var num_hf_sell7 "Number of HF that sell on IMPLANTS"
label var num_hf_sell8 "Number of HF that sell on IUD"
label var num_hf_sell9 "Number of HF that sell on FEMALE STERILIZATION"
label var num_hf_sell10 "Number of HF that sell on MALE STERILIZATION"

*Average number of FP methods sold at HF
egen ave_hf_tsell=rowmean(totsell1 totsell2 totsell3 totsell4 totsell5 totsell6 /*
*/ totsell7 totsell8 totsell9 totsell10 totsell11 totsell12 totsell13)
ta ave_hf_tsell
drop totsell1 totsell2 totsell3 totsell4 totsell5 totsell6 /*
*/ totsell7 totsell8 totsell9 totsell10 totsell11 totsell12 totsell13
order location_code - num_hf_sell10 ave_hf_tsell
label var ave_hf_tsell "average number of FP methods sold at HFs"

*Number of facilities selling FP types
forvalues i=1/3{
egen num_hf_sellt`i'=rowtotal(sellt`i'1 sellt`i'2 sellt`i'3 sellt`i'4 sellt`i'5 sellt`i'6 /*
*/ sellt`i'7 sellt`i'8 sellt`i'9 sellt`i'10 sellt`i'11 sellt`i'12 sellt`i'13), missing
ta num_hf_sellt`i'
drop sellt`i'1 sellt`i'2 sellt`i'3 sellt`i'4 sellt`i'5 sellt`i'6 /*
*/ sellt`i'7 sellt`i'8 sellt`i'9 sellt`i'10 sellt`i'11 sellt`i'12 sellt`i'13
}
order location_code - ave_hf_tsell num_hf_sellt1 num_hf_sellt2 num_hf_sellt3
label var num_hf_sellt1 "Number of HF that sell SHORT-term bc methods"
label var num_hf_sellt2 "Number of HF that sell MEDIUM-term bc methods"
label var num_hf_sellt3 "Number of HF that sell LONG-term bc methods"

*Average (minimum) price of method at facilities
forvalues i=1/8{
egen ave_hf_price`i'=rowmean(pricefp`i'1 pricefp`i'2 pricefp`i'3 pricefp`i'4 pricefp`i'5 /*
*/ pricefp`i'6 pricefp`i'7 pricefp`i'8 pricefp`i'9 pricefp`i'10 pricefp`i'11 pricefp`i'12 /*
*/ pricefp`i'13 )
su ave_hf_price`i'
drop pricefp`i'1 pricefp`i'2 pricefp`i'3 pricefp`i'4 pricefp`i'5 pricefp`i'6 pricefp`i'7 /*
*/ pricefp`i'8 pricefp`i'9 pricefp`i'10 pricefp`i'11 pricefp`i'12 pricefp`i'13
}
order location_code - num_hf_sellt3 ave_hf_price1 ave_hf_price2 ave_hf_price3 ave_hf_price4 /*
*/ ave_hf_price5 ave_hf_price6 ave_hf_price7 ave_hf_price8 
label var ave_hf_price1 "Average (minimum) HF price of BC PILLS"
label var ave_hf_price2 "Average (minimum) HF price of PROGESTATIVE ONLY PILLS"
label var ave_hf_price3 "Average (minimum) HF price of EMERGENCY CONTRACEPTIVES"
label var ave_hf_price4 "Average (minimum) HF price of MALE CONDOMS"
label var ave_hf_price5 "Average (minimum) HF price of FEMALE CONDOMS"
label var ave_hf_price6 "Average (minimum) HF price of INJECTABLES"
label var ave_hf_price7 "Average (minimum) HF price of IMPLANTS"
label var ave_hf_price8 "Average (minimum) HF price of IUD"

*Number of facilities where FP method is currently available....
forvalues i=1/8{
egen num_hf_crnt`i'=rowtotal(currentfp`i'1 currentfp`i'2 currentfp`i'3 currentfp`i'4 currentfp`i'5 /*
*/ currentfp`i'6 currentfp`i'7 currentfp`i'8 currentfp`i'9 currentfp`i'10 currentfp`i'11 /*
*/ currentfp`i'12 currentfp`i'13), missing
ta num_hf_crnt`i'
drop currentfp`i'1 currentfp`i'2 currentfp`i'3 currentfp`i'4 currentfp`i'5 /*
*/ currentfp`i'6 currentfp`i'7 currentfp`i'8 currentfp`i'9 currentfp`i'10 currentfp`i'11 /*
*/ currentfp`i'12 currentfp`i'13
}
order location_code - ave_hf_price8 num_hf_crnt1 num_hf_crnt2 num_hf_crnt3 num_hf_crnt4 /*
*/ num_hf_crnt5 num_hf_crnt6 num_hf_crnt7 num_hf_crnt8
label var num_hf_crnt1 "Number of HF that currently have BC PILLS in stock"
label var num_hf_crnt2 "Number of HF that currently have PROGESTATIVE ONLY PILLS in stock"
label var num_hf_crnt3 "Number of HF that currently have EMERGENCY CONTRACEPTIVES in stock"
label var num_hf_crnt4 "Number of HF that currently have MALE CONDOMS in stock"
label var num_hf_crnt5 "Number of HF that currently have FEMALE CONDOMS in stock"
label var num_hf_crnt6 "Number of HF that currently have INJECTABLES in stock"
label var num_hf_crnt7 "Number of HF that currently have IMPLANTS in stock"
label var num_hf_crnt8 "Number of HF that currently have IUD in stock"

*Share of facilities experiencing at least one BC outage in the past month
egen prb_hf_sout=rowmean(any_sout1 any_sout2 any_sout3 any_sout4 any_sout5 any_sout6 any_sout7 /*
*/ any_sout8 any_sout9 any_sout10 any_sout11 any_sout12 any_sout13)
su prb_hf_sout 
label var prb_hf_sout "Share of hf with stock outage in last month"
order location_code - num_hf_crnt8 prb_hf_sout
drop any_sout1 any_sout2 any_sout3 any_sout4 any_sout5 any_sout6 any_sout7 /*
*/ any_sout8 any_sout9 any_sout10 any_sout11 any_sout12 any_sout13

*Average number of family planning patients in the last 6 months
egen ave_hf_fppat=rowmean(fppats1 fppats2 fppats3 fppats4 fppats5 fppats6 fppats7 fppats8 /*
*/ fppats9 fppats10 fppats11 fppats12 fppats13)
su ave_hf_fppat
label var ave_hf_fppat "Average number of family planning patients in last 6 mons" 
order location_code - prb_hf_sout ave_hf_fppat
drop fppats1 fppats2 fppats3 fppats4 fppats5 fppats6 fppats7 fppats8 /*
*/ fppats9 fppats10 fppats11 fppats12 fppats13

*likelihood/number of facility having various IEC materials
forvalues i=1/8 {
egen prb_hf_iecob`i'=rowmean(iecobs`i'1 iecobs`i'2 iecobs`i'3 iecobs`i'4 iecobs`i'5 iecobs`i'6  /*
*/ iecobs`i'7 iecobs`i'8 iecobs`i'9 iecobs`i'10 iecobs`i'11 iecobs`i'12 iecobs`i'13) 
egen prb_hf_iecrno`i'=rowmean(iecrnobs`i'1 iecrnobs`i'2 iecrnobs`i'3 iecrnobs`i'4 iecrnobs`i'5 /*
*/ iecrnobs`i'6  iecrnobs`i'7 iecrnobs`i'8 iecrnobs`i'9 iecrnobs`i'10 iecrnobs`i'11 iecrnobs`i'12 /*
*/ iecrnobs`i'13) 
egen prb_hf_iecna`i'=rowmean(iecna`i'1 iecna`i'2 iecna`i'3 iecna`i'4 iecna`i'5 iecna`i'6  /*
*/ iecna`i'7 iecna`i'8 iecna`i'9 iecna`i'10 iecna`i'11 iecna`i'12 iecna`i'13) 
su prb_hf_iecob`i' prb_hf_iecrno`i' prb_hf_iecna`i'
egen num_hf_iecob`i'=rowtotal(iecobs`i'1 iecobs`i'2 iecobs`i'3 iecobs`i'4 iecobs`i'5 iecobs`i'6  /*
*/ iecobs`i'7 iecobs`i'8 iecobs`i'9 iecobs`i'10 iecobs`i'11 iecobs`i'12 iecobs`i'13), missing
egen num_hf_iecrno`i'=rowtotal(iecrnobs`i'1 iecrnobs`i'2 iecrnobs`i'3 iecrnobs`i'4 iecrnobs`i'5 /*
*/ iecrnobs`i'6  iecrnobs`i'7 iecrnobs`i'8 iecrnobs`i'9 iecrnobs`i'10 iecrnobs`i'11 iecrnobs`i'12 /*
*/ iecrnobs`i'13), missing 
egen num_hf_iecna`i'=rowtotal(iecna`i'1 iecna`i'2 iecna`i'3 iecna`i'4 iecna`i'5 iecna`i'6  /*
*/ iecna`i'7 iecna`i'8 iecna`i'9 iecna`i'10 iecna`i'11 iecna`i'12 iecna`i'13), missing 
su num_hf_iecob`i' num_hf_iecrno`i' num_hf_iecna`i'
drop iecobs`i'1 iecobs`i'2 iecobs`i'3 iecobs`i'4 iecobs`i'5 iecobs`i'6  /*
*/ iecobs`i'7 iecobs`i'8 iecobs`i'9 iecobs`i'10 iecobs`i'11 iecobs`i'12 iecobs`i'13
drop iecrnobs`i'1 iecrnobs`i'2 iecrnobs`i'3 iecrnobs`i'4 iecrnobs`i'5 /*
*/ iecrnobs`i'6  iecrnobs`i'7 iecrnobs`i'8 iecrnobs`i'9 iecrnobs`i'10 iecrnobs`i'11 iecrnobs`i'12 /*
*/ iecrnobs`i'13
drop iecna`i'1 iecna`i'2 iecna`i'3 iecna`i'4 iecna`i'5 iecna`i'6  /*
*/ iecna`i'7 iecna`i'8 iecna`i'9 iecna`i'10 iecna`i'11 iecna`i'12 iecna`i'13
}
label var prb_hf_iecob1 "Probability that IEC POSTERS can be observed"
label var prb_hf_iecrno1 "Probability that IEC POSTERS are reported, but not observed"
label var prb_hf_iecna1 "Probability that IEC POSTERS are not available"
label var prb_hf_iecob2 "Probability that IEC INFOMATIONAL FLIP CHART can be observed"
label var prb_hf_iecrno2 "Probability that IEC INFOMATIONAL FLIP CHART are reported, but not observed"
label var prb_hf_iecna2 "Probability that IEC INFOMATIONAL FLIP CHART are not available"
label var prb_hf_iecob3 "Probability that IEC BROCHURES can be observed"
label var prb_hf_iecrno3 "Probability that IEC BROCHURES are reported, but not observed"
label var prb_hf_iecna3 "Probability that IEC BROCHURES are not available"
label var prb_hf_iecob4 "Probability that IEC INFORMATIONAL SHEETS can be observed"
label var prb_hf_iecrno4 "Probability that IEC INFORMATIONAL SHEETS are reported, but not observed"
label var prb_hf_iecna4 "Probability that IEC INFORMATIONAL SHEETS are not available"
label var prb_hf_iecob5 "Probability that IEC JOB AIDS can be observed"
label var prb_hf_iecrno5 "Probability that IEC JOB AIDS are reported, but not observed"
label var prb_hf_iecna5 "Probability that IEC JOB AIDS are not available"
label var prb_hf_iecob6 "Probability that IEC DEMO MODELS can be observed"
label var prb_hf_iecrno6 "Probability that IEC DEMO MODELS are reported, but not observed"
label var prb_hf_iecna6 "Probability that IEC DEMO MODELS are not available"
label var prb_hf_iecob7 "Probability that IEC COUNSELING CARDS can be observed"
label var prb_hf_iecrno7 "Probability that IEC COUNSELING CARDS are reported, but not observed"
label var prb_hf_iecna7 "Probability that IEC COUNSELING CARDS are not available"
label var prb_hf_iecob8 "Probability that IEC SAMPLES can be observed"
label var prb_hf_iecrno8 "Probability that IEC SAMPLES are reported, but not observed"
label var prb_hf_iecna8 "Probability that IEC SAMPLES are not available"

label var num_hf_iecob1 "Number of HF where IEC POSTERS can be observed"
label var num_hf_iecrno1 "Number of HF where IEC POSTERS are reported, but not observed"
label var num_hf_iecna1 "Number of HF where IEC POSTERS are not available"
label var num_hf_iecob2 "Number of HF where IEC INFOMATIONAL FLIP CHART can be observed"
label var num_hf_iecrno2 "Number of HF where IEC INFOMATIONAL FLIP CHART are reported, but not observed"
label var num_hf_iecna2 "Number of HF where IEC INFOMATIONAL FLIP CHART are not available"
label var num_hf_iecob3 "Number of HF where IEC BROCHURES can be observed"
label var num_hf_iecrno3 "Number of HF where IEC BROCHURES are reported, but not observed"
label var num_hf_iecna3 "Number of HF where IEC BROCHURES are not available"
label var num_hf_iecob4 "Number of HF where IEC INFORMATIONAL SHEETS can be observed"
label var num_hf_iecrno4 "Number of HF where IEC INFORMATIONAL SHEETS are reported, but not observed"
label var num_hf_iecna4 "Number of HF where IEC INFORMATIONAL SHEETS are not available"
label var num_hf_iecob5 "Number of HF where IEC JOB AIDS can be observed"
label var num_hf_iecrno5 "Number of HF where IEC JOB AIDS are reported, but not observed"
label var num_hf_iecna5 "Number of HF where IEC JOB AIDS are not available"
label var num_hf_iecob6 "Number of HF where IEC DEMO MODELS can be observed"
label var num_hf_iecrno6 "Number of HF where IEC DEMO MODELS are reported, but not observed"
label var num_hf_iecna6 "Number of HF where IEC DEMO MODELS are not available"
label var num_hf_iecob7 "Number of HF where IEC COUNSELING CARDS can be observed"
label var num_hf_iecrno7 "Number of HF where IEC COUNSELING CARDS are reported, but not observed"
label var num_hf_iecna7 "Number of HF where IEC COUNSELING CARDS are not available"
label var num_hf_iecob8 "Number of HF where IEC SAMPLES can be observed"
label var num_hf_iecrno8 "Number of HF where IEC SAMPLES are reported, but not observed"
label var num_hf_iecna8 "Number of HF where IEC SAMPLES are not available"

order location_code - ave_hf_fppat prb_hf_iecob1 - num_hf_iecna8

*number of facilities having iec_types
egen num_hf_iecntt=rowtotal(iecntt1 iecntt2 iecntt3 iecntt4 iecntt5 iecntt6 iecntt7 iecntt8 /*
*/ iecntt9 iecntt10 iecntt11 iecntt12 iecntt13), missing
su num_hf_iecntt
drop iecntt1 iecntt2 iecntt3 iecntt4 iecntt5 iecntt6 iecntt7 iecntt8 /*
*/ iecntt9 iecntt10 iecntt11 iecntt12 iecntt13
label var num_hf_iecntt "Number of facilities with non-teaching IEC tool"

egen num_hf_iectt=rowtotal(iectt1 iectt2 iectt3 iectt4 iectt5 iectt6 iectt7 iectt8 /*
*/ iectt9 iectt10 iectt11 iectt12 iectt13), missing
su num_hf_iectt
drop iectt1 iectt2 iectt3 iectt4 iectt5 iectt6 iectt7 iectt8 /*
*/ iectt9 iectt10 iectt11 iectt12 iectt13
label var num_hf_iectt "Number of facilities with IEC teaching tool"

*Average number of iec methods used at facilities
egen ave_hf_numiec=rowmean(numiec1 numiec2 numiec3 numiec4 numiec5 numiec6 numiec7 /*
*/ numiec8 numiec9 numiec10 numiec11 numiec12 numiec13)
su ave_hf_numiec
drop numiec1 numiec2 numiec3 numiec4 numiec5 numiec6 numiec7 /*
*/ numiec8 numiec9 numiec10 numiec11 numiec12 numiec13
label var ave_hf_numiec "Average number of IEC tools per facility"

order location_code - num_hf_iecna8 num_hf_iecntt num_hf_iectt ave_hf_numiec

*Number of HF that have ever given a FP talk to the community
egen num_hf_etlk=rowtotal(commtlk1 commtlk2 commtlk3 commtlk4 commtlk5 commtlk6 /*
*/ commtlk7 commtlk8 commtlk9 commtlk10 commtlk11 commtlk12 commtlk13), missing
ta num_hf_etlk
label var num_hf_etlk "Number of HF that have EVER given a FP talk to community"
order location_code - ave_hf_numiec num_hf_etlk
drop commtlk1 commtlk2 commtlk3 commtlk4 commtlk5 commtlk6 /*
*/ commtlk7 commtlk8 commtlk9 commtlk10 commtlk11 commtlk12 commtlk13

*Likelihood that facility has a FP protocol (stated in hf audit, protocol observed)
egen prb_hf_fpp1=rowmean(fp_protocol11 fp_protocol12 fp_protocol13 fp_protocol14 fp_protocol15 /*
*/ fp_protocol16 fp_protocol17 fp_protocol18 fp_protocol19 fp_protocol110 fp_protocol111 /*
*/ fp_protocol112 fp_protocol113)
su prb_hf_fpp1
label var prb_hf_fpp1 "Likelihood of HF having family planning program (HF Audit, observed)"
order location_code - num_hf_etlk prb_hf_fpp1
drop fp_protocol11 fp_protocol12 fp_protocol13 fp_protocol14 fp_protocol15 /*
*/ fp_protocol16 fp_protocol17 fp_protocol18 fp_protocol19 fp_protocol110 fp_protocol111 /*
*/ fp_protocol112 fp_protocol113  

*Likelihood that facility has a FP protocol (stated in hf audit, protocol not observed)
egen prb_hf_fpp2=rowmean(fp_protocol21 fp_protocol22 fp_protocol23 fp_protocol24 fp_protocol25 /*
*/ fp_protocol26 fp_protocol27 fp_protocol28 fp_protocol29 fp_protocol210 fp_protocol211 /*
*/ fp_protocol212 fp_protocol213)
su prb_hf_fpp2
label var prb_hf_fpp2 "Likelihood of HF having family planning program (HF Audit, not observed)"
order location_code - prb_hf_fpp1 prb_hf_fpp2
drop fp_protocol21 fp_protocol22 fp_protocol23 fp_protocol24 fp_protocol25 /*
*/ fp_protocol26 fp_protocol27 fp_protocol28 fp_protocol29 fp_protocol210 fp_protocol211 /*
*/ fp_protocol212 fp_protocol213 

*liklihood that facility has electricity
egen prb_hf_electric = rowmean(electric1 electric2 electric3 electric4 electric5 electric6 /*
*/ electric7 electric8 electric9 electric10 electric11 electric12 electric13)
su prb_hf_electric
label var prb_hf_electric "Liklihood that HF has electricity"
order location_code - prb_hf_fpp2 prb_hf_electric
drop electric1 electric2 electric3 electric4 electric5 electric6 /*
*/ electric7 electric8 electric9 electric10 electric11 electric12 electric13

*liklihood that facility has piped water
egen prb_hf_pwater = rowmean(pwater1 pwater2 pwater3 pwater4 pwater5 pwater6 /*
*/ pwater7 pwater8 pwater9 pwater10 pwater11 pwater12 pwater13)
su prb_hf_pwater
label var prb_hf_pwater "Liklihood that HF has piped water"
order location_code - prb_hf_electric prb_hf_pwater
drop pwater1 pwater2 pwater3 pwater4 pwater5 pwater6 /*
*/ pwater7 pwater8 pwater9 pwater10 pwater11 pwater12 pwater13

*liklihood that facility has phone
egen prb_hf_phone = rowmean(phone1 phone2 phone3 phone4 phone5 phone6 /*
*/ phone7 phone8 phone9 phone10 phone11 phone12 phone13)
su prb_hf_phone
label var prb_hf_phone "Liklihood that HF has phone"
order location_code - prb_hf_pwater prb_hf_phone
drop phone1 phone2 phone3 phone4 phone5 phone6 /*
*/ phone7 phone8 phone9 phone10 phone11 phone12 phone13

*liklihood that facility has private rooms
egen prb_hf_privrm = rowmean(privrm1 privrm2 privrm3 privrm4 privrm5 privrm6 /*
*/ privrm7 privrm8 privrm9 privrm10 privrm11 privrm12 privrm13)
su prb_hf_privrm
label var prb_hf_privrm "Liklihood that HF has private room"
order location_code - prb_hf_phone prb_hf_privrm
drop privrm1 privrm2 privrm3 privrm4 privrm5 privrm6 /*
*/ privrm7 privrm8 privrm9 privrm10 privrm11 privrm12 privrm13

*Likelihood of HF having a delivery room
egen prb_hf_delv=rowmean(delvrm1 delvrm2 delvrm3 delvrm4 delvrm5 delvrm6 delvrm7 /*
*/ delvrm8 delvrm9 delvrm10 delvrm11 delvrm12 delvrm13 )
su prb_hf_delv
label var prb_hf_delv "Likelihood of HF having a delivery room"
order location_code - prb_hf_privrm prb_hf_delv
drop delvrm1 delvrm2 delvrm3 delvrm4 delvrm5 delvrm6 delvrm7 /*
*/ delvrm8 delvrm9 delvrm10 delvrm11 delvrm12 delvrm13

order location_code - num_hf_hsw ave_hf_offnum ave_hf_tsell prb_hf_sout ave_hf_numiec /*
*/ num_hf_etlk prb_hf_fpp2 - prb_hf_privrm 

drop prb_hf_offfp - totnorx num_hf_socfp

su
di _N


save "$path/Senegal_Cluster_HF_KM1.dta", replace
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
************************
** work on Pharmacy file
************************
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
*
use "$path/temp_pharm_cluster.dta", clear
set more off

*******drop variables
order location_code letter num_public num_private num_pharmacy num_lowvol-num_Dnm_NGO /*
*/ distance fage hours openall totsell any_sout multphar participate

drop facid - totnorx

su

******* fix missings
su fage if participate==1
replace fage=r(mean) if fage==. & participate==1

su hours if participate==1
replace hours=r(mean) if hours==. & participate==1

su

*******reshape data
gsort location_code -letter
gen helper=0
replace helper=1 if location_code!=location_code[_n-1] 

order location_code letter helper num_public num_private num_pharmacy num_lowvol-num_Dnm_NGO

forvalues i=1/60{
replace helper=1+`i' if helper[_n-`i']==1 & location_code==location_code[_n-`i'] 
}
ta helper

drop participate

reshape wide distance - multphar, i(location_code) j(helper)

*******create variables
order location_code letter num_public num_private num_pharmacy num_lowvol-num_Dnm_NGO

di _N

*Average distance
egen ave_rx_dist = rowmean(distance1 distance2 distance3 distance4 distance5 distance6 /*
*/ distance7 distance8 distance9 distance10 distance11 distance12 distance13 distance14 /*
*/ distance15 distance16 distance17 distance18 distance19 distance20 distance21 distance22 /*
*/ distance23 distance24 distance25 distance26 distance27 distance28 distance29 distance30 /*
*/ distance31 distance32 distance33 distance34 distance35 distance36)
su ave_rx_dist
label var ave_rx_dist "Average distance to RX in buffer"
order location_code - num_lowvol ave_rx_dist
drop distance1 distance2 distance3 distance4 distance5 distance6 /*
*/ distance7 distance8 distance9 distance10 distance11 distance12 distance13 distance14 /*
*/ distance15 distance16 distance17 distance18 distance19 distance20 distance21 distance22 /*
*/ distance23 distance24 distance25 distance26 distance27 distance28 distance29 distance30 /*
*/ distance31 distance32 distance33 distance34 distance35 distance36

*Average Pharmacy age
egen ave_rx_age = rowmean(fage1 fage2 fage3 fage4 fage5 fage6 fage7 fage8 fage9 fage10 /*
*/ fage11 fage12 fage13 fage14 fage15 fage16 fage17 fage18 fage19 fage20 fage21 fage22 /*
*/ fage23 fage24 fage25 fage26 fage27 fage28 fage29 fage30 fage31 fage32 fage33 fage34 /*
*/ fage35 fage36)
su ave_rx_age 
label var ave_rx_age "Average RX age"
order location_code - ave_rx_dist ave_rx_age
drop fage1 fage2 fage3 fage4 fage5 fage6 fage7 fage8 fage9 fage10 /*
*/ fage11 fage12 fage13 fage14 fage15 fage16 fage17 fage18 fage19 fage20 fage21 fage22 /*
*/ fage23 fage24 fage25 fage26 fage27 fage28 fage29 fage30 fage31 fage32 fage33 fage34 /*
*/ fage35 fage36

*Number of Pharmacies open every day of the week
egen num_rx_opn7=rowtotal(openall1 openall2 openall3 openall4 openall5 openall6 openall7 /*
*/ openall8 openall9 openall10 openall11 openall12 openall13 openall14 openall15 openall16 /*
*/ openall17 openall18 openall19 openall20 openall21 openall22 openall23 openall24 openall25 /*
*/ openall26 openall27 openall28 openall29 openall30 openall31 openall32 openall33 openall34 /*
*/ openall35 openall36), missing
ta num_rx_opn7
label var num_rx_opn7 "Number of RX open all 7 days of the week"
order location_code - ave_rx_age num_rx_opn7
drop openall1 openall2 openall3 openall4 openall5 openall6 openall7 /*
*/ openall8 openall9 openall10 openall11 openall12 openall13 openall14 openall15 openall16 /*
*/ openall17 openall18 openall19 openall20 openall21 openall22 openall23 openall24 openall25 /*
*/ openall26 openall27 openall28 openall29 openall30 openall31 openall32 openall33 openall34 /*
*/ openall35 openall36

*Average number of hours a Pharmacy is open in a day
egen ave_rx_hrs=rowmean(hours1 hours2 hours3 hours4 hours5 hours6 hours7 hours8 hours9 /*
*/ hours10 hours11 hours12 hours13 hours14 hours15 hours16 hours17 hours18 hours19 /*
*/ hours20 hours21 hours22 hours23 hours24 hours25 hours26 hours27 hours28 /*
*/ hours29 hours30 hours31 hours32 hours33 hours34 hours35 hours36)
ta ave_rx_hrs
label var ave_rx_hrs "Average # hours a RX is open"
order location_code - num_rx_opn7 ave_rx_hrs
drop hours1 hours2 hours3 hours4 hours5 hours6 hours7 hours8 hours9 /*
*/ hours10 hours11 hours12 hours13 hours14 hours15 hours16 hours17 hours18 hours19 /*
*/ hours20 hours21 hours22 hours23 hours24 hours25 hours26 hours27 hours28 /*
*/ hours29 hours30 hours31 hours32 hours33 hours34 hours35 hours36

*Average number of FP methods sold at HF
egen ave_rx_tsell=rowmean(totsell1 totsell2 totsell3 totsell4 totsell5 totsell6 /*
*/ totsell7 totsell8 totsell9 totsell10 totsell11 totsell12 totsell13 /*
*/ totsell14 totsell15 totsell16 totsell17 totsell18 totsell19 totsell20 /*
*/ totsell21 totsell22 totsell23 totsell24 totsell25 totsell26 totsell27 /*
*/ totsell28 totsell29 totsell30 totsell31 totsell32 totsell33 totsell34 /*
*/ totsell35 totsell36)
ta ave_rx_tsell
drop totsell1 totsell2 totsell3 totsell4 totsell5 totsell6 /*
*/ totsell7 totsell8 totsell9 totsell10 totsell11 totsell12 totsell13 /*
*/ totsell14 totsell15 totsell16 totsell17 totsell18 totsell19 totsell20 /*
*/ totsell21 totsell22 totsell23 totsell24 totsell25 totsell26 totsell27 /*
*/ totsell28 totsell29 totsell30 totsell31 totsell32 totsell33 totsell34 /*
*/ totsell35 totsell36
order location_code - ave_rx_hrs ave_rx_tsell
label var ave_rx_tsell "average number of FP methods sold at RXs"

*Share of facilities experiencing at least one BC outage in the past month
egen prb_rx_sout=rowmean(any_sout1 any_sout2 any_sout3 any_sout4 any_sout5 any_sout6 any_sout7 /*
*/ any_sout8 any_sout9 any_sout10 any_sout11 any_sout12 any_sout13 any_sout14 any_sout15 any_sout16/*
*/ any_sout17 any_sout18 any_sout19 any_sout20 any_sout21 any_sout22 any_sout23 any_sout24 any_sout25 /*
*/ any_sout26 any_sout27 any_sout28 any_sout29 any_sout30 any_sout31 any_sout32 any_sout33 any_sout34 /*
*/ any_sout35 any_sout36)
su prb_rx_sout 
label var prb_rx_sout "Share of rx with stock outage in last month"
order location_code - ave_rx_tsell prb_rx_sout
drop any_sout1 any_sout2 any_sout3 any_sout4 any_sout5 any_sout6 any_sout7 /*
*/ any_sout8 any_sout9 any_sout10 any_sout11 any_sout12 any_sout13 any_sout14 any_sout15 any_sout16/*
*/ any_sout17 any_sout18 any_sout19 any_sout20 any_sout21 any_sout22 any_sout23 any_sout24 any_sout25 /*
*/ any_sout26 any_sout27 any_sout28 any_sout29 any_sout30 any_sout31 any_sout32 any_sout33 any_sout34 /*
*/ any_sout35 any_sout36

*Share of Pharmacies with multiple pharmacists
egen prb_rx_mult=rowmean(multphar1 multphar2 multphar3 multphar4 multphar5 multphar6 /*
*/ multphar7 multphar8 multphar9 multphar10 multphar11 multphar12 multphar13 multphar14 /*
*/ multphar15 multphar16 multphar17 multphar18 multphar19 multphar20 multphar21 multphar22 /*
*/ multphar23 multphar24 multphar25 multphar26 multphar27 multphar28 multphar29 multphar30 /*
*/ multphar31 multphar32 multphar33 multphar34 multphar35 multphar36)
su prb_rx_mult
label var prb_rx_mult "Share of RX with multiple pharmacists"
order location_code - prb_rx_sout prb_rx_mult
drop multphar1 multphar2 multphar3 multphar4 multphar5 multphar6 /*
*/ multphar7 multphar8 multphar9 multphar10 multphar11 multphar12 multphar13 multphar14 /*
*/ multphar15 multphar16 multphar17 multphar18 multphar19 multphar20 multphar21 multphar22 /*
*/ multphar23 multphar24 multphar25 multphar26 multphar27 multphar28 multphar29 multphar30 /*
*/ multphar31 multphar32 multphar33 multphar34 multphar35 multphar36

drop letter

su
di _N

save "$path/Senegal_Cluster_RX_KM1.dta", replace

***************************
** Bring HF and RX together
***************************

use "$path/Senegal_Cluster_HF_KM1.dta", clear
merge 1:1 location_code using "$path/Senegal_Cluster_RX_KM1.dta"

* 4 locations have no facilities at all
* 6 locations have at least 1 HF, but no pharmacy
* 12 locations have at least 1 pharmacy, but no HF 
* 6 locations have pharmacy AND HF, but HF refuses to answer questions.

drop _merge
di _N
su

recode allnonpat .= 0

save "$path/Senegal_Cluster_KM1.dta", replace







































*********************************************************************************************************
********************************SENEGAL MERGE FILE**************************************************
*********************************************************************************************************


*********************************
** Merge 3 files created above **
*********************************

******************************************************
** Clean up 3 files so that they are ready to merge **
******************************************************

*INDIVIDUAL FILE
use "$path/Senegal_Women_Final.dta", clear
set more off
set seed 98765

replace pnid = substr(pnid,2,4)
replace ccid = substr(ccid,2,4)
replace fpid = substr(fpid,2,4)
replace imid = substr(imid,2,4)
replace mcid = substr(mcid,2,4)
replace hivid = substr(hivid,2,4)
replace rxid = substr(rxid,2,4)

*recode selection of non-existant facilities (things deleted from facility file)
foreach x in pnid ccid fpid imid mcid hivid rxid{
replace `x'="9993" if `x'=="0046" 
replace `x'="9993" if `x'=="0048" 
replace `x'="9993" if `x'=="0052" 
replace `x'="9993" if `x'=="0099" 
replace `x'="9993" if `x'=="0122" 
replace `x'="9993" if `x'=="0030" 
replace `x'="9993" if `x'=="0057" 
replace `x'="9993" if `x'=="0073" 
replace `x'="9993" if `x'=="0140" 
replace `x'="9993" if `x'=="0132" 
replace `x'="9993" if `x'=="0151" 
replace `x'="9993" if `x'=="0167" 
replace `x'="9993" if `x'=="0180" 
replace `x'="9993" if `x'=="0192" 
replace `x'="9993" if `x'=="0202" 
replace `x'="9993" if `x'=="0292"
replace `x'="9993" if `x'=="0297"
replace `x'="9993" if `x'=="0302"
replace `x'="9993" if `x'=="0372"   
replace `x'="9993" if `x'=="0373" 
replace `x'="9993" if `x'=="0390"
replace `x'="9993" if `x'=="0399" 
replace `x'="9993" if `x'=="0428"
replace `x'="9993" if `x'=="0436"
replace `x'="9993" if `x'=="0450" 
replace `x'="9993" if `x'=="0452" 
replace `x'="9993" if `x'=="0467" 
replace `x'="9993" if `x'=="0475" 
replace `x'="9993" if `x'=="0485" 
replace `x'="9993" if `x'=="0488"
replace `x'="9993" if `x'=="0493" 
replace `x'="9993" if `x'=="0497" 
replace `x'="9993" if `x'=="0519" 
replace `x'="9993" if `x'=="0521" 
replace `x'="9993" if `x'=="0523" 
replace `x'="9993" if `x'=="0531" 
replace `x'="9993" if `x'=="0532" 
replace `x'="9993" if `x'=="0545"
replace `x'="9993" if `x'=="0548" 
replace `x'="9993" if `x'=="0907" 
replace `x'="9993" if `x'=="0912"  
replace `x'="9993" if `x'=="5002"
replace `x'="9993" if `x'=="5056"
replace `x'="9993" if `x'=="5068"
replace `x'="9993" if `x'=="5085"
replace `x'="9993" if `x'=="5093"
replace `x'="9993" if `x'=="5105"
replace `x'="9993" if `x'=="5165"
replace `x'="9993" if `x'=="5174"
replace `x'="9993" if `x'=="5269"
replace `x'="9993" if `x'=="5275"
replace `x'="9993" if `x'=="5295"
replace `x'="9993" if `x'=="5313"
replace `x'="9993" if `x'=="5327"
replace `x'="9993" if `x'=="5337"
replace `x'="9993" if `x'=="5343"
replace `x'="9993" if `x'=="5350"
replace `x'="9993" if `x'=="5352"
replace `x'="9993" if `x'=="5357"
replace `x'="9993" if `x'=="5363"
replace `x'="9993" if `x'=="5388"
replace `x'="9993" if `x'=="5432"
replace `x'="9993" if `x'=="5447"
replace `x'="9993" if `x'=="5467"
replace `x'="9993" if `x'=="5488"
replace `x'="9993" if `x'=="5492"
replace `x'="9993" if `x'=="5509"
replace `x'="9993" if `x'=="5907" 
}
ta pnid if pnid=="9993"
ta ccid if ccid=="9993"
ta fpid if fpid=="9993"
ta imid if imid=="9993"
ta mcid if mcid=="9993"
ta hivid if hivid=="9993"
ta rxid if rxid=="9993"

order indid location_code pnid ccid fpid imid mcid hivid rxid

keep indid - rxid Dakar Guediawaye Pikine Mbao Mbour Kaolack age eduL0-eduL4 edu_cont muslim homekids prego child2009 partner otherwives /*
*/ paccomphf1 paccomphf2 paccomphf3 paccomphf4 paccomphf5 page peduL0 peduL1 peduL2 peduL3 peduL4 /*
*/ pwork worknow newsmag radio tv cphone internet ses1 owncar ownscooter ownbicycle owntrans fpmesany /*
*/ sexfreq0 sexfreq1 sexfreq2 sexfreq3 sexfreq4 pregpos morchld nomorchld undchld pregprob pmorchld pnomorchld /*
*/ pundchld idealkids uptogod 

	*9990 means selected a facility that we don't have information on
	*9991 means that they didn't visit a facility at all
	*9992 means that they were never asked the question
	
foreach x in pnid ccid fpid imid mcid hivid rxid {
*ta `x'
replace `x' ="9990" if `x' =="9993"
replace `x' ="9990" if `x' =="9994"
replace `x' ="9990" if `x' =="9995"
replace `x' ="9990" if `x' =="9997"
replace `x' ="9990" if `x' =="9998"
replace `x' ="9990" if `x' =="9999"
}

sort location_code indid

*Merge in Cluster-facility variables

merge m:1 location_code using "$path/Senegal_Cluster_KM1.dta"

gen no_hf=0
replace no_hf=1 if _merge==1
replace no_hf=1 if num_public==0 & num_private==0

gen no_rx=0
replace no_rx=1 if _merge==1
replace no_rx=1 if num_pharmacy==0

foreach x of varlist num_public-prb_rx_mult {
replace `x'=0 if `x'==.
}  

drop _merge edu_cont nomorchld-pregprob pnomorchld-uptogod letter 

*Clean up individual variables that I know I will use:

gen agesq=age*age

drop if fpmesany==.

replace sexfreq0=1 if sexfreq0==.    /*missings have never had sex*/
replace sexfreq1=0 if sexfreq1==.
replace sexfreq2=0 if sexfreq2==.
replace sexfreq3=0 if sexfreq3==.
replace sexfreq4=0 if sexfreq4==.

xi i.ses1
drop ses1

replace morchld=0 if morchld==.      /* missings are steralized, missing answer, or cannot have more children*/

drop if partner==.

replace pmorchld=0 if pmorchld==. & partner==1   /* missing indicate wife cannot have children */

foreach x of varlist otherwives pmorchld-pwork{
drop if partner==1 & `x'==.
replace `x'=0 if partner==0
}
*drop if partner==1 & otherwives==.
*drop if partner==1 & paccomphf1==.
*drop if partner==1 & page==.
*drop if partner==1 & pwork==.
*drop if partner==1 & pmorchld==.

foreach x of varlist pregpos worknow-ownbicycle{
drop if `x'==.
}


*replace nomorchld=0 if nomorchld==.						/*pregnant or cannot have children*/
*replace pnomorchld=0 if partner==1 & pnomorchld==.		/*pregnant or cannot have children*/
*replace pregprob=0 if pregprob==.						/*pregnant or cannot have children*/

su 
di _N

save "$path/main.dta", replace

*FACILITY FILE (simply cleans up facility file a bit)
use "$path/Senegal_Facility.dta", clear
set more off

drop iday-iyear openy offers1-vols22 consultfp1-consultfp10 daysfp1-sellt3 consentfp1-consentfp10 iecobs1-iectt pricefp1-soutmfp8 /*
*/ f54-f63 rxnneed1-rxnneed8 fppats
replace facid = substr(facid,2,4)
gsort facid

gen public=0 
replace public=1 if facvol==1|facvol==3

gen private=0 
replace private=1 if facvol==2|facvol==4

gen pharmacy=0
replace pharmacy=1 if facvol==5

gen highvol=0 
replace highvol=1 if facvol==1|facvol==2

gen lowvol=0
replace lowvol=1 if facvol==3|facvol==4

replace factype=16 if factype==96 & facvol==3
replace factype=26 if factype==96 & facvol==4
replace factype=16 if factype==99 & facvol==1
replace factype=16 if factype==99 & facvol==3
replace factype=26 if factype==99 & facvol==4
recode factype 14=16

su fage if pharmacy==0
replace fage=r(mean) if fage==. & participate==1 & pharmacy==0

su fage if pharmacy==1
replace fage=r(mean) if fage==. & participate==1 & pharmacy==1

replace openall=round(runiform()) if openall==. & participate==1

su hours
replace hours=r(mean) if hours==. & participate==1

replace fpsocial=0 if fpsocial==. & participate==1     /*very few facilities supply have such a program*/

su nnurse
replace nnurse=r(mean) if nnurse==. & participate==1 & pharmacy==0 

replace anyiec=round(runiform()*.75) if anyiec==. & participate==1

replace commtlk=round(runiform()) if commtlk==. & participate==1 & pharmacy==0

replace fp_protocol1=0 if fp_protocol1==. & participate==1 & pharmacy==0     /*Missing if they provide NO FP services at all*/
replace fp_protocol2=0 if fp_protocol2==. & participate==1 & pharmacy==0 

replace electric=1 if electric==. & participate==1 & pharmacy==0 
replace pwater=1 if pwater==. & participate==1 & pharmacy==0 
replace toilet=1 if toilet==. & participate==1 & pharmacy==0 
replace backgen=1 if backgen==. & participate==1 & pharmacy==0 

foreach x of varlist phone - locana {
replace `x'=round(runiform()) if `x'==. & participate==1 & pharmacy==0
}

su pharhours
replace pharhours=r(mean) if pharhours==. & participate==1 & pharmacy==1

replace fptrained=round(runiform()) if fptrained==. & participate==1 & pharmacy==1

replace fpstaff=round(runiform()) if fpstaff==. & participate==1 & pharmacy==1

order facid factype public - lowvol participate fage - fpsocial totsell anyiec any_sout

su

foreach x of varlist fage-totnorx {
replace `x'=0 if `x'==.
}
su

save "$path/Senegal_Facility_new.dta", replace

*****************
** Check Merge **
*****************

*Make sure non-choices are eliminated above
use "$path/main.dta", clear

* Many people select facilities that we do not have coordinates for and are therefore not in the location
* file; therefore, I recode those choices here
foreach x in pnid ccid fpid imid mcid hivid rxid{
replace `x'="9990" if `x'=="0014" 
replace `x'="9990" if `x'=="0015"
replace `x'="9990" if `x'=="0032" 
replace `x'="9990" if `x'=="0201" 
replace `x'="9990" if `x'=="0204" 
replace `x'="9990" if `x'=="0207"  
replace `x'="9990" if `x'=="0213" 
replace `x'="9990" if `x'=="0214"
replace `x'="9990" if `x'=="0216" 
replace `x'="9990" if `x'=="0217" 
replace `x'="9990" if `x'=="0218" 
replace `x'="9990" if `x'=="0219" 
replace `x'="9990" if `x'=="0220" 
replace `x'="9990" if `x'=="5129" 
replace `x'="9990" if `x'=="5190"
replace `x'="9990" if `x'=="5315" 
replace `x'="9990" if `x'=="5373"
replace `x'="9990" if `x'=="5382" 
replace `x'="9990" if `x'=="5384" 
}

save "$path/main.dta", replace

*************************
** Merge in Facilities **
*************************

* Make sure non-choices are included
* Make sure all individual (line 76) and facility (line 98) variables are included

use "$path/main.dta", clear

*include the set of alternatives for every person, along with the distances
joinby location_code using "$path/location_fac_distance.dta"

order indid facid
sort indid facid

*merge in characteristics of each facility
merge m:1 facid using "$path/Senegal_Facility_new.dta"
drop if _merge==2 	/*(facilities without coordinates)*/
drop _merge

sort indid facid
expand 3 if indid!=indid[_n+1], generate(no_choice)

sort indid facid no_choice

replace facid="9990" if no_choice==1 & no_choice[_n-1]==0
replace facid="9991" if facid[_n-1]=="9990"

order indid facid location_code pnid ccid fpid imid mcid hivid rxid

foreach x of varlist distance-totnorx {
replace `x'=0 if no_choice==1
}
replace hf=1 if no_choice==1
drop no_choice

save "$path/merge_all.dta", replace




*Maternal Care Choice
use "$path/merge_all.dta", clear

drop pnid ccid fpid imid hivid rxid

drop if hf==0

gen choice_1=1
replace choice_1=2 if mcid=="9990"
replace choice_1=3 if mcid=="9991"

ta choice_1

gen choice_2=0
replace choice_2=1 if mcid==facid

ta choice_2

save "$path/MaternalCareChoice.dta", replace






