clear
set more off
#delimit;

*** The ABBGH data can be found at: 

http://www.stanford.edu/~nbloom/index_files/Page315.htm ***;


use "E:\abbgh_data.dta", clear;

*** The following code is the same as in ABBGH, which assigns the ABBGH instruments and dummy variables ***;

global RD    = "rd_yUSA rd_yUSA_2 rd_yFRA rd_yFRA_2"; 
global RDTFP = "rd_yUSA rd_yUSA_2 tfpUSA tfpUSA_2 rd_yFRA rd_yFRA_2 tfpFRA tfpFRA_2 tfpFRAdum"; 
global IMP   = "imp_yUSA imp_yUSA_2 imp_yFRA imp_yFRA_2";
global EXP   = "exp_yUSA exp_yUSA_2 exp_yFRA exp_yFRA_2";
global LIMU  = "muUt muUt2 liUSA liUSA_2 muFt muFt2 liFRA liFRA_2";

global RD1    = "rd_yUSA1 rd_yUSA1_2 rd_yFRA1 rd_yFRA1_2"; 
global RDTFP1 = "rd_yUSA1 rd_yUSA1_2 tfpUSA1 tfpUSA1_2 rd_yFRA1 rd_yFRA1_2 tfpFRA1 tfpFRA1_2 tfpFRA1dum"; 
global IMP1   = "imp_yUSA1 imp_yUSA1_2 imp_yFRA1 imp_yFRA1_2";
global EXP1   = "exp_yUSA1 exp_yUSA1_2 exp_yFRA1 exp_yFRA1_2";
global LIMU1  = "muUt muUt2 liUSA1 liUSA1_2 muFt muFt2 liFRA1 liFRA1_2";

global POL1 = "SMPhighD SMPmedD car per brew";
global POL2 = "tele phar text raz steel ord";

global Xex "yr* iii*";

global X "Lc_2 Fl1Lc_2 Fl2Lc_2 Fl3Lc_2 Fl4Lc_2";

global XF   "L LeF   L_2 $Xex ici lucas unilev gec pilk gkn btr sandn";
global XFnn "L LeFnn L_2 $Xex ici lucas unilev gec pilk gkn btr sandn";

global XFc   "Lc LceF   Lc_2 $Xex";
global XFnnc "Lc LceFnn Lc_2 $Xex";

global XFa   "ALPHA ALPHAeF   ALPHA_2 $Xex ici lucas unilev gec pilk gkn btr sandn";
global XFnna "ALPHA ALPHAeFnn ALPHA_2 $Xex ici lucas unilev gec pilk gkn btr sandn";


*** The following code is to show sunfigures 1a and 1b ***;

twoway (scatter patcw Lc if year<1983, mlabel(sic2) mcolor(black) scheme(s1mono) xtitle("Competition 1973-1982") ytitle("Citation Weighted Patents 1973-1982") plotregion(style(none)) legend(off));

twoway (scatter patcw Lc if year>1982, mlabel(sic2) mcolor(black) scheme(s1mono) xtitle("Competition 1983-1994") ytitle("Citation Weighted Patents 1983-1994") plotregion(style(none)) legend(off));


*** The following code is to perform the Chow test ***;

* first stage *;
reg Lc $RDTFP $IMP1 $EXP1 $LIMU1 $POL1 $POL2 $Xex;
predict LceF    ,resid;

gen d1=1 if year>1982;
replace d1=0 if year<1983;
gen dLc=d1*Lc;
gen dLc_2=d1*Lc_2;

* regression with control function;
poisson patcw Lc LceF Lc_2 $Xex dLc dLc_2;
test dLc dLc_2;
drop LceF d1 dLc dLc_2;


*** The following code is to test the innovation-competition relationship during 1973-1982 ***;
* first stage *;
reg Lc $RDTFP $IMP1 $EXP1 $LIMU1 $POL1 $POL2 $Xex if year<1983;
predict LceF    ,resid;

* second stage;
poisson patcw Lc LceF Lc_2 $Xex if year<1983;
test Lc Lc_2;

* since the null hypothesis is rejected we can see the innovation-competition relationship in the following graph;
gen curvecontrol = exp(_b[_cons] + _b[Lc]*Lc + _b[Lc_2]*Lc_2 );
twoway (scatter curvecontrol Lc, ms(x) mcolor(black) sort), scheme(s1mono) xtitle("Competition") ytitle("Citation Weighted Patents") plotregion(style(none));
drop LceF curvecontrol;


*** The following code is to test the innovation-competition relationship during 1983-1994 ***;
* first stage *;
reg Lc $RDTFP $IMP1 $EXP1 $LIMU1 $POL1 $POL2 $Xex if year>1982;
predict LceF    ,resid;

* second stage;
poisson patcw Lc LceF Lc_2 $Xex if year>1982;
test Lc Lc_2;
drop LceF;


*** The following code is to perform the sup-Wald test ***;
* first stage *;
reg Lc $RDTFP $IMP1 $EXP1 $LIMU1 $POL1 $POL2 $Xex;
predict LceF    ,resid;

local i=1;
while `i'<=19	{;
			 gen y`i'=1973+`i';
			 gen dsw=1 if year>y`i';
			 replace dsw=0 if year<=y`i';
			 gen dswLc=dsw*Lc;
			 gen dswLc_2=dsw*Lc_2;
			 poisson patcw Lc LceF Lc_2 $Xex dswLc dswLc_2 if year>1973 & year<1994;
			 test dswLc dswLc_2;
			 drop dsw dswLc dswLc_2;
			 local i=`i'+1;
				};
drop LceF; 	
			
*** The following code is to test the innovation-competition relationship during 1973-1982 ***;
* first stage *;
reg Lc $RDTFP $IMP1 $EXP1 $LIMU1 $POL1 $POL2 $Xex if year<1981;
predict LceF    ,resid;

* second stage;
poisson patcw Lc LceF Lc_2 $Xex if year<1981;
test Lc Lc_2;

* since the null hypothesis is rejected we can see the innovation-competition relationship in the following graph;
gen curvecontrol = exp(_b[_cons] + _b[Lc]*Lc + _b[Lc_2]*Lc_2 );
twoway (scatter curvecontrol Lc, ms(x) mcolor(black) sort), scheme(s1mono) xtitle("Competition") ytitle("Citation Weighted Patents") plotregion(style(none));
drop LceF curvecontrol;


*** The following code is to test the innovation-competition relationship during 1983-1994 ***;
* first stage *;
reg Lc $RDTFP $IMP1 $EXP1 $LIMU1 $POL1 $POL2 $Xex if year>1980;
predict LceF    ,resid;

* second stage;
poisson patcw Lc LceF Lc_2 $Xex if year>1980;
test Lc Lc_2;
drop LceF;
