@Michael P. Clements, "Individual Forecaster Perceptions of the Persistence of Shocks to GDP", Journal of Applied Econometrics, forthcoming.
 Gauss program to produce results in paper. Uses the .csv data files recorded in readme.txt.
 Some of the variables below will need to be set to different values to generate all the results in the paper (for tables 4 and 5) .
 The code does not generate the figures.@ 
  
new;

outwidth 180;

format /RDN 12,4;
output file = prog1.out reset; 

all_resps = 0;   @1 = Include all respondents. O = only those who responded >12 times.
				 Including all respondents means that the aggregates match the SPF-produced series@  
res_i     = {};
res_pairs = {};
HAC       = 2;      @HAC = 0. Standard SEs. Otherwise HAC/HCSE@

cond_t = 0;	 @Bootstrapping regression. =1:condition random re-sampling of y_{it} on t@  
bothV  = 0;  @Bootstrapping regression. =0:bootstrap y only. =1 bootstrap y and x@ 	
boot10 = 1;  @Bootstrapping regression. =1:regn of 10-year on current quarterly. =0:regn of current annual on current quarterly@ 
bsDy   = 1;  @Bootstrapping shocks decomposition. =1: BS 10-year only. =2: BS annual only @ 


@*****************Loading output growth data from the SPF**********************************@ 
 @ All individuals 68:4 to 2018:3@ 
load xd[] = ..\jae_archive\Individual_RGDP.csv;
 xd = reshape(xd,8119,11);
load yd[] =	..\jae_archive\Individual_RGDP10.csv;
 yd = reshape(yd,8119,4);
 d = xd~yd;
@**************end Loading output growth data from the SPF**********************************@ 

d[.,1] = d[.,1] + d[.,2]/10;

d = d[.,1 3:11 15];
@Structure of d.  col 1 = date; col 2 = id;  cols 3 - 8 qly. 9 and 10 annual, 11 10-year annual average@  							

d = miss(d,-9999);
d= selif(d,d[.,1] .> 1991.4);

maxi= maxc(d[.,2]);	@highest respondent id@
resps = seqa(1,1,maxi);
nresps = resps~sumc((resps .eq d[.,2]')'); @ resp id: no of times each id responds@  
nids =  sumc(nresps[.,2] .gt 0);
ids = rev(sortc(nresps,2));
ids = ids[1:nids,.]; @ids with most responses: no of responses, to least.@ 

nf = sumc(ids[.,2] .gt 0);	 
                                 
if all_resps == 0;
nf = sumc(ids[.,2] .gt 11);	 @respondents filed 12 or more returns@
endif;					  


load y0[] = ..\jae_archive\ROUTPUTQvQd.csv;
y0 = reshape(y0,286,213);  @rows: 47:1 to 2018:2. cols: dates, vintages 65:4 to 2018:3@
y0 = miss(y0,-999);

/*Begin estimate an AR(1) on output growth*/
Dy = 100*( y0[2:rows(y0),cols(y0)]./y0[1:rows(y0)-1,cols(y0)] -1 );
xx = ones(rows(Dy)-1,1)~Dy[1:rows(Dy)-1,1];
beta = invpd(xx'xx)*xx'Dy[2:rows(Dy),1];
ee  = Dy[2:rows(Dy),1] - xx*beta;
@Estimated constant and AR(1) parameter is beta@;
@std of regression error is stdc(ee)@;
/*End estimate an AR(1) on output growth*/

noq = 107; @# surveys 92:1 to 18:3@	

idmatrix = miss(zeros(noq,nf),0);	@ identifiers of respondents@

@all for output growth@
f0   = miss(zeros(noq,nf),0);
f1   = miss(zeros(noq,nf),0);
f2   = miss(zeros(noq,nf),0);
f3   = miss(zeros(noq,nf),0);
f4   = miss(zeros(noq,nf),0);
fa1  = miss(zeros(noq,nf),0);
fa2  = miss(zeros(noq,nf),0);
f10  = miss(zeros(noq,nf),0);
fa1L  = miss(zeros(noq,nf),0);	@Level@
fa2L  = miss(zeros(noq,nf),0);	@Level@

@for a given row (= survey date), the elements in a given column of yoy, pdfm etc.
correspond to the same forecaster. But each column does not correspond to a specific
forecaster@;  

@output@
ydate = 1992.1;    og =	93;

    q=1; w=1;  dates = ydate;
    j=1; do while j <= rows(d);

			   		if d[j,1] == ydate;						   
             idmatrix[q,w]   = d[j,2];  
			f0[q,w]  = 100*(((d[j,4] / d[j,3])^4) - 1);
			f1[q,w]  = 100*(((d[j,5] / d[j,4])^4) - 1);
			f2[q,w]  = 100*(((d[j,6] / d[j,5])^4) - 1);
			f3[q,w]  = 100*(((d[j,7] / d[j,6])^4) - 1);
			f4[q,w]  = 100*(((d[j,8] / d[j,7])^4) - 1);

			fa2[q,w] = 100*((d[j,10] / d[j,9]) - 1);



q_s = round(10*(ydate - trunc(ydate)));	  @Quarter indicator: returns 1,2,3 or 4@
  if q_s == 1; @Q1@
  fa1[q,w]= ((4*d[j,9])/sumc(y0[83+q+og:83+q+og+3,13+q+og])) - 1;
  
              if d[j,1] == 1996.1; 
			  @96:1 vintage value for 95:4 missing - use the average of Q2 to Q4 instead @
              fa1[q,w]= ((4*d[j,9])/((4/3)*sumc(y0[83+q+og:83+q+og+2,13+q+og]))) - 1;			  
			  endif; 
		  
  elseif q_s == 2; @Q2@
  fa1[q,w]= ((4*d[j,9])/sumc(y0[83+q+og-1:83+q+og+2,13+q+og])) - 1;
  
  elseif q_s == 3; @Q3@
  fa1[q,w]= ((4*d[j,9])/sumc(y0[83+q+og-2:83+q+og+1,13+q+og])) - 1;

  elseif q_s == 4; @Q4@
  fa1[q,w]= ((4*d[j,9])/sumc(y0[83+q+og-3:83+q+og,13+q+og])) - 1;


endif;


			fa1[q,w]  = 100*fa1[q,w];

			f10[q,w]  = d[j,11];
			fa1L[q,w] = d[j,9];
			fa2L[q,w] = d[j,10];
	 
     	    w=w+1; 
			else; ydate = d[j,1]; q=q+1; j=j-1; w=1; dates = dates|ydate;    
			 endif;
			
	j=j+1;endo;

 /**********************Sorting forecasts by individual**********************/
 @Each column corresponds to the same forecaster, given by an element in the first
 column of ids[]@

   i_f0 = miss(zeros(noq,nf),0);        
   i_f1 = miss(zeros(noq,nf),0);        
   i_f2 = miss(zeros(noq,nf),0);        
   i_f3 = miss(zeros(noq,nf),0);        
   i_f4 = miss(zeros(noq,nf),0);        
   i_fa1 = miss(zeros(noq,nf),0);       
   i_fa2 = miss(zeros(noq,nf),0);       
   i_f10 = miss(zeros(noq,nf),0);       
   i_fa1L = miss(zeros(noq,nf),0);       
   i_fa2L = miss(zeros(noq,nf),0);       

  q=1; do while q <= noq;
	w=1;
	do while w <= nf;
	     		
				   j=1; do while j <= nf;

				   		
				            if idmatrix[q,j] == ids[w,1];
							   i_f0[q,w]      =  f0[q,j];
							   i_f1[q,w]      =  f1[q,j];
							   i_f2[q,w]      =  f2[q,j];
							   i_f3[q,w]      =  f3[q,j];
							   i_f4[q,w]      =  f4[q,j];
							   i_fa1[q,w]     =  fa1[q,j];
							   i_fa2[q,w]     =  fa2[q,j];
							   i_f10[q,w]     =  f10[q,j];
							   i_fa1L[q,w]     =  fa1L[q,j];
							   i_fa2L[q,w]     =  fa2L[q,j];
						   
							j = nf+1; 
						    endif;
				   j=j+1; endo;
	w=w+1;	endo;
  q=q+1; endo;


@calculation of the median forecasts@
mf10  =  miss(zeros(noq,1),0);
mf0   =  miss(zeros(noq,1),0);
mf4   =  miss(zeros(noq,1),0);

mfa1L =  miss(zeros(noq,1),0); 	  @levels@
mfa2L =  miss(zeros(noq,1),0); 	  @levels@
mfa1 =  miss(zeros(noq,1),0); 	  @g.r.@
mfa2 =  miss(zeros(noq,1),0); 	  @g.r.@

s = 1; do while s .le noq;
mf10[s,1] = median(packr(i_f10[s,.]')); 
mf0[s,1]  = median(packr(i_f0[s,.]')); 
mf4[s,1]  = median(packr(i_f4[s,.]')); 

mfa1L[s,1]  = median(packr(i_fa1L[s,.]')); 
mfa2L[s,1]  = median(packr(i_fa2L[s,.]')); 
mfa1[s,1]  = median(packr(i_fa1[s,.]')); 
mfa2[s,1]  = median(packr(i_fa2[s,.]')); 
s=s+1; endo;

@end calculation of the median forecasts@

q1seq =  seqa(1,4,27);	   

mf10_q1 = mf10[q1seq,1];
mf0_q1  =  mf0[q1seq,1]; 
mf4_q1  =  mf4[q1seq,1]; 

mfa1L_q1  =  mfa1L[q1seq,1]; 
mfa2L_q1  =  mfa2L[q1seq,1]; 
mfa1_q1  =  mfa1[q1seq,1]; 
mfa2_q1  =  mfa2[q1seq,1]; 

Z10m   = (mf10_q1[2:27]-mf10_q1[1:26])~(mf0_q1[2:27]-mf4_q1[1:26]);
ZAm    = (mfa1_q1[2:27]-mfa2_q1[1:26])~(mf0_q1[2:27]-mf4_q1[1:26]);
Z10Am  = (mf10_q1[2:27]-mf10_q1[1:26])~(mfa1_q1[2:27]-mfa2_q1[1:26]);

format /RDN 8,2; 

BOOTy  = {};
BOOTx  = {};
BOOTa  = {};

@Disagreement estimates@
@Standard deviations across all indviduals, for each time period@
@Standard deviations of forecasts, and of forecast revisions@ 

d10 = i_f10[q1seq,.];
da	= i_fa1[q1seq,.];
dq =  i_f0[q1seq,.];
disag = miss(zeros(27,3),0);
meani = miss(zeros(27,3),0);

q1seq =  seqa(1,4,27);	   

d10_rev = i_f10[seqa(5,4,26),.] - i_f10[seqa(1,4,26),.];
da_rev	= i_fa1[seqa(5,4,26),.] - i_fa2[seqa(1,4,26),.];
dq_rev =  i_f0[seqa(5,4,26),.]  -  i_f4[seqa(1,4,26),.];
disag_rev = miss(zeros(26,3),0);
meani_rev = miss(zeros(26,3),0);

j=1; do while j .le 27;
disag[j,.] = stdc(packr(d10[j,.]'))~stdc(packr(da[j,.]'))~stdc(packr(dq[j,.]'));
meani[j,.] = meanc(packr(d10[j,.]'))~meanc(packr(da[j,.]'))~meanc(packr(dq[j,.]'));
j=j+1; endo;

j=1; do while j .le 26;
disag_rev[j,.] = stdc(packr(d10_rev[j,.]'))~stdc(packr(da_rev[j,.]'))~stdc(packr(dq_rev[j,.]'));
meani_rev[j,.] = meanc(packr(d10_rev[j,.]'))~meanc(packr(da_rev[j,.]'))~meanc(packr(dq_rev[j,.]'));
j=j+1; endo;

res_4 = {};

j = 1; do while j .le nf;

f10_q1 = i_f10[q1seq,j];
f0_q1  = i_f0[q1seq,j]; 
f4_q1  = i_f4[q1seq,j]; 

fa1L_q1 = i_fa1L[q1seq,j];
fa2L_q1 = i_fa2L[q1seq,j];

fa1_q1 = i_fa1[q1seq,j];
fa2_q1 = i_fa2[q1seq,j];

Z10  = (f10_q1[2:27]-f10_q1[1:26])~(f0_q1[2:27]-f4_q1[1:26]);	      @short given by current quarter, long 10-year average @
ZA   = (fa1_q1[2:27]-fa2_q1[1:26])~(f0_q1[2:27]-f4_q1[1:26]);	      @short given by current quarter, current-year average gr @
Z10A = (f10_q1[2:27]-f10_q1[1:26])~(fa1_q1[2:27]-fa2_q1[1:26]);	      @short given by current year, long 10-year average @

nr10 = rows(packr(Z10));
nrA = rows(packr(ZA));
nr10A = rows(packr(Z10A));

n_pre08 = rows(packr(Z10[1:15,.]))/nr10;  @proportion of forecasts made 93 to 2007 (inclusive), i.e., pre Crisis@  

if (nr10 .ge 10) .and (nrA .ge 10) .and (nr10A .ge 10);

BOOTy = BOOTy~(f10_q1[2:27]-f10_q1[1:26]);
BOOTa = BOOTa~(fa1_q1[2:27]-fa2_q1[1:26]);
BOOTx = BOOTx~(f0_q1[2:27]-f4_q1[1:26]);

resA = ids[j,1]~nr10~LHR(Z10,HAC)~LHR(ZA,HAC)~LHR(Z10A,HAC)~perm_tran2((f0_q1[2:27]-f4_q1[1:26]),fa1_q1[2:27]-fa2_q1[1:26],(f10_q1[2:27]-f10_q1[1:26]))~n_pre08;
res_i = res_i|resA;

@set elements of consensus corresponding to individual missings to missings@
 Z10mM   =Z10m   ; 
 Z10mM   =Z10m   ; 
  ZAmM   = ZAm   ; 
  ZAmM   = ZAm   ; 
  Z10AmM = Z10Am ; 
  Z10AmM = Z10Am ;
  
  mf0M  =   mf0_q1[2:27]-mf4_q1[1:26];
  mfaM  =  mfa1_q1[2:27]-mfa2_q1[1:26];
  mf10M  = mf10_q1[2:27]-mf10_q1[1:26];

  w0i    =	 f0_q1[2:27]-f4_q1[1:26];
  w1i    =  fa1_q1[2:27]-fa2_q1[1:26];
  w10i   =  f10_q1[2:27]-f10_q1[1:26];

s=1; do while s .le 26;
if ismiss(Z10[s,1]); Z10mM[s,1]   = miss(0,0); endif;
if ismiss(Z10[s,2]); Z10mM[s,2]   = miss(0,0); endif;
if ismiss(ZA[s,1]);   ZAmM[s,1]   = miss(0,0); endif;
if ismiss(ZA[s,2]);   ZAmM[s,2]   = miss(0,0); endif;
if ismiss(Z10A[s,1]); Z10AmM[s,1] = miss(0,0); endif;
if ismiss(Z10A[s,2]); Z10AmM[s,2] = miss(0,0); endif;

if ismiss(w0i[s,1]);   mf0M[s,1]	=  miss(0,0); endif;
if ismiss(w1i[s,1]);   mfaM[s,1]	=  miss(0,0); endif;
if ismiss(w10i[s,1]); mf10M[s,1]	=  miss(0,0); endif;
s=s+1;endo;

resB = LHR(Z10mM,HAC)~LHR(ZAmM,HAC)~LHR(Z10AmM,HAC)~perm_tran2(mf0M,mfaM,mf10M);

@individual: consensus[time periods=individual]: consensus/individual : individual/consensus @ 
res_4 = res_4|(ids[j,1]~nr10~LHR(Z10,HAC)~LHR(Z10mM,HAC)~LHR(ZA,HAC)~LHR(ZAmM,HAC));

res_pairs = res_pairs|(resA[.,1:cols(resA)]~resB);

endif;

j=j+1; endo;

res_4 =  rev(sortc(res_4,2));
res_4 = res_4|(meanc(res_4)')|(stdc(res_4)')|(sumc(res_4 .gt 2)')|(sumc(res_4 .lt -2)');
format /RDN 8,3;
"Table 3 (in paper)";
"The Effects of Participation. For each individual, the consensus estimate is based only on the "
"consensus forecasts for the periods the particular individual was active"; 
tex_table(res_4);


@add results for median@
res_iOnly = res_i; @without adding means, etc@

res_i = res_i|(miss(0,0)~rows(packr(Z10m))~LHR(Z10m,HAC)~LHR(ZAm,HAC)~LHR(Z10Am,HAC)~perm_tran2((mf0_q1[2:27]-mf4_q1[1:26]),mfa1_q1[2:27]-mfa2_q1[1:26],(mf10_q1[2:27]-mf10_q1[1:26]))~miss(0,0));

res_i = rev(sortc(res_i,2)); 

res_pairs = rev(sortc(res_pairs,2));

format /RDN 8,2; 

 "Individual Summary Stat: mean, var, min, max, valid. [.ge 10 forecast obs] of the beta estimates and the Krane parameters ";
{vnam, mean, var, std, min, max, valid, mis} = dstat(0,selif(res_pairs[.,3 5 7 10:13],res_pairs[.,2] .ge 10));

 "Individual Summary Stat: mean, var, min, max, valid. [.ge 15 forecast obs] of the beta estimates and the Krane parameters";
{vnam, mean, var, std, min, max, valid, mis} = dstat(0,selif(res_pairs[.,3 5 7 10:13],res_pairs[.,2] .ge 15));

nn = rows(res_i);

"Results: Regressions: 10yr&current_qtr, current_ann&current_qtr, 10yr&current_ann. Permanent / transitory: theta, v_e, v_w, v_u";

n4p = sumc(res_i[2:nn,4] .gt 2);
n6p = sumc(res_i[2:nn,6] .gt 2);
n8p = sumc(res_i[2:nn,8] .gt 2);

n4m = sumc(res_i[2:nn,4] .lt -2);
n6m = sumc(res_i[2:nn,6] .lt -2);
n8m = sumc(res_i[2:nn,8] .lt -2);
stdc3 = stdc(res_i[2:nn,3]);
stdc5 = stdc(res_i[2:nn,5]);
stdc10_15 = stdc(res_i[2:nn,10:15]);

means = meanc(res_i[2:nn,1:16])';
stdcs = stdc(res_i[2:nn,1:16])';
maxs =  maxc(res_i[2:nn,1:16])';
mins =  minc(res_i[2:nn,1:16])';

cols(means);
cols(res_i);

aug_res_i = res_i|means|stdcs|maxs|mins
|(miss(zeros(1,3),0)~n4p~miss(0,0)~n6p~miss(0,0)~n8p~miss(zeros(1,8),0))
|(miss(zeros(1,3),0)~n4m~miss(0,0)~n6m~miss(0,0)~n8m~miss(zeros(1,8),0));

format /RDN 8, 3;
"Table 1 (in paper)";	   
tex_table(aug_res_i[.,1:6 10:cols(aug_res_i)]);

"Spearman - correlation between beta and proportion of sample pre-2007";
res_iOnly = rev(sortc(res_iOnly,2)); 


format /RDN 8, 3;

rhoC  =  res_iOnly[.,10];
Vrcq  =  res_iOnly[.,11] + res_iOnly[.,12] +res_iOnly[.,13];
VeR  =  res_iOnly[.,11]./Vrcq;
VwR  =  res_iOnly[.,12]./Vrcq;
VuR  =  res_iOnly[.,13]./Vrcq;

spear_res = miss(zeros(1,2),0);
spear_res = spearman(rankindx(res_iOnly[.,3],1),rankindx(res_iOnly[.,16],1));
spear_res = spear_res~spearman(rankindx(res_iOnly[.,5],1),rankindx(res_iOnly[.,16],1));
spear_res = spear_res~spearman(rankindx(res_iOnly[.,14],1),rankindx(res_iOnly[.,16],1))~spearman(rankindx(res_iOnly[.,15],1),rankindx(res_iOnly[.,16],1));
spear_res = spear_res~spearman(rankindx(rhoC,1),rankindx(res_iOnly[.,16],1))~spearman(rankindx(VeR,1),rankindx(res_iOnly[.,16],1))~spearman(rankindx(VwR,1),rankindx(res_iOnly[.,16],1))~spearman(rankindx(VuR,1),rankindx(res_iOnly[.,16],1));

"Table 6. (In Paper) Spearman results. Perceptions and the Great Recession";
tex_table(spear_res);

"Table 2. (In Paper). ";
"Table of proportion of variance of revisions to current-quarter growth due to various shocks";
 tab1 = res_iOnly[.,1]~VeR~VwR~VuR; 

means =meanc(tab1)';
stdcs = stdc(tab1)';
maxs =  maxc(tab1)';
mins =  minc(tab1)';
tab1 = tab1|means|stdcs|maxs|mins;
tex_table(tab1); 
 
format /RDN 8,3;	

@Bootstrapping@
@bootstrapping with 10-year revisions on current, or annual or current@
if boot10;
bootRES = bs(BOOTy,BOOTx,cond_t,bothV);
else;
bootRES = bs(BOOTa,BOOTx,cond_t,bothV);
endif;

nB = rows(bootRES);
tabd = {};
bb = 1; do while bb .le cols(bootRES);


meanW = sortc(bootRES[.,bb],1);
mean1  = meanW[round(0.005*nB),1]~meanW[round(0.995*nB),1];
mean5  = meanW[round(0.025*nB),1]~meanW[round(0.975*nB),1];
mean10 = meanW[round(0.05*nB),1]~meanW[round(0.95*nB),1];

tabd = tabd~(mean1|mean5|mean10);
bb=bb+1;endo; 

" Table 4 (In paper)"; 
"............ BS the estimated regression parameter. 1%, 5% 10% (2-sided)";
tex_table(tabd);


@bootstrapping output shock decomposition@

{res1,res2,res3,res4,res5,res6} = bsDECOMP(BOOTy,BOOTa,BOOTx,bothV);

"Table 5. (In paper. First 4 columns if bsDy=2. Columns 5 to 8 if bsDy=1 ";
"................BS the shock decomposition .................";

param = 1; do while param .le 6;
tabd = {};
if param .== 1;	 res = res1;  endif;
if param .== 2;	 res = res2;  endif;
if param .== 3;	 res = res3;  endif;
if param .== 4;	 res = res4;  endif;
if param .== 5;	 res = res5;  endif;
if param .== 6;	 res = res6;  endif;

nB = rows(res);
bb = 1; do while bb .le 4;

meanW = sortc(res[.,bb],1);
mean1  = meanW[round(0.005*nB),1]~meanW[round(0.995*nB),1];
mean5  = meanW[round(0.025*nB),1]~meanW[round(0.975*nB),1];
mean10 = meanW[round(0.05*nB),1]~meanW[round(0.95*nB),1];

tabd = tabd~(mean1|mean5|mean10);
bb=bb+1;endo; 

tex_table(tabd);

param = param + 1; endo;


/*********************Procedures**********************/

Proc(1) = bs(y,x,allt,bv);
Local b, c, r, Nc, Nr, rowy, rowx, n1, n1x, bsrepy, bsrepx, bs_res, rep, Nrep, rn, state, state1, j, ally, allx, by, bx;
by = y;
bx = x;
Nrep = 1000;
state = 7;
state1 = 8;
@Nrep = 1;@
Nr = rows(by);
Nc = cols(by);
bs_res = miss(zeros(Nrep,5),0);
bsrepy  = miss(zeros(Nr,Nc),0);
bsrepx  = miss(zeros(Nr,Nc),0);

ally = miss(0,0);
allx = miss(0,0);
j=1; do while j .le Nc;
ally = ally|by[.,j];
allx = allx|bx[.,j];
j=j+1; endo; 

rep = 1; do while rep <= Nrep;
r=1; do while r <= Nr;
	 if allt;
	 rowy = packr(by[r,.]'); n1  = rows(rowy);	 @randomly select y_{it} from all i for that t@
	 rowx = packr(bx[r,.]'); n1x = rows(rowx);	 @randomly select x_{it} from all i for that t@
	 else;
	 rowy = packr(ally);	 n1  = rows(rowy);     @randomly select y_{it} from all i and t@
	 rowx = packr(allx);	 n1x = rows(rowx);     @randomly select x_{it} from all i and t@
	 endif;
	 c = 1; do while c <= Nc;
	 	  if ismiss(by[r,c]);
		  bsrepy[r,c] = miss(0,0); 
		  else;
		  {rn,state} = rndu(1,1,state);
		  bsrepy[r,c] = rowy[ceil(n1*rn),1];
		  endif;
	 	  if ismiss(bx[r,c]);
		  bsrepx[r,c] = miss(0,0); 
		  else;
		  {rn,state1} = rndu(1,1,state1);
		  bsrepx[r,c] = rowx[ceil(n1x*rn),1];
		  endif;

	 c=c+1; endo;
r=r+1;endo;

 b = miss(zeros(27,2),0);

 j=1; do while j .le 27;
 if bv == 1; 
 {b[j,.]} = LHR(bsrepy[.,j]~bsrepx[.,j],2) ;
 else;
 {b[j,.]} = LHR(bsrepy[.,j]~x[.,j],2) ;
 endif;
 j=j+1; endo;

 bs_res[rep,.] =  meanc(b[.,1])~stdc(b[.,1])~maxc(b[.,1])~median(b[.,1])~minc(b[.,1]);

rep = rep + 1; endo; 

RETP(bs_res);

Endp;

Proc(6) = bsDECOMP(y,a,x,bv);
@Only bootstrapping 10-year revisions, "y"@
Local b, c, r, Nc, Nr, rowy, rowa, n1, n1a, bsrepy, bsrepa, bs_res1, bs_res2, bs_res3, bs_res4, bs_res5, bs_res6, rep, Nrep, rn, state, state1, j, by, ba, test; 
by = y;
ba = a;
Nrep = 1000;
state = 7;
state1 = 8;
@Nrep = 1;@
Nr = rows(by);
Nc = cols(by);
bs_res1 = miss(zeros(Nrep,5),0);	   
bs_res2 = miss(zeros(Nrep,5),0);
bs_res3 = miss(zeros(Nrep,5),0);
bs_res4 = miss(zeros(Nrep,5),0);
bs_res5 = miss(zeros(Nrep,5),0);
bs_res6 = miss(zeros(Nrep,5),0);
bsrepy  = miss(zeros(Nr,Nc),0);
bsrepa  = miss(zeros(Nr,Nc),0);

rep = 1; do while rep <= Nrep;
r=1; do while r <= Nr;
	 rowy = packr(by[r,.]'); n1  = rows(rowy);	 @randomly select y_{it} from all i for that t@
 	 rowa = packr(ba[r,.]'); n1a = rows(rowa);	 @randomly select a_{it} from all i for that t@

	 c = 1; do while c <= Nc;
	 	  if ismiss(by[r,c]);
		  bsrepy[r,c] = miss(0,0); 
		  else;
		  {rn,state} = rndu(1,1,state);
		  bsrepy[r,c] = rowy[ceil(n1*rn),1];
		  endif;
	 	  if ismiss(ba[r,c]);
		  bsrepa[r,c] = miss(0,0); 
		  else;
		  {rn,state} = rndu(1,1,state);
		  bsrepa[r,c] = rowa[ceil(n1a*rn),1];
		  endif;

	 c=c+1; endo;
r=r+1;endo;

 b = miss(zeros(27,7),0);

 j=1; do while j .le 27;

 	  if bsDy == 1;
	       {b[j,.]} = perm_tran2(x[.,j],ba[.,j],bsrepy[.,j]);  		@10-year reshuffled@

	  elseif bsDy == 2;
    	   {b[j,.]} = perm_tran2(x[.,j],bsrepa[.,j],by[.,j]);		  @annual reshuffled@


	  endif;
	  
  
 j=j+1; endo;

 bs_res1[rep,.] =  meanc(b[.,2])~stdc(b[.,2])~maxc(b[.,2])~median(b[.,2])~minc(b[.,2]);
 bs_res2[rep,.] =  meanc(b[.,3])~stdc(b[.,3])~maxc(b[.,3])~median(b[.,3])~minc(b[.,3]);
 bs_res3[rep,.] =  meanc(b[.,4])~stdc(b[.,4])~maxc(b[.,4])~median(b[.,4])~minc(b[.,4]);
 bs_res4[rep,.] =  meanc(b[.,5])~stdc(b[.,5])~maxc(b[.,5])~median(b[.,5])~minc(b[.,5]);
 bs_res5[rep,.] =  meanc(b[.,6])~stdc(b[.,6])~maxc(b[.,6])~median(b[.,6])~minc(b[.,6]);
 bs_res6[rep,.] =  meanc(b[.,7])~stdc(b[.,7])~maxc(b[.,7])~median(b[.,7])~minc(b[.,7]);

rep = rep + 1; endo; 

RETP(bs_res1,bs_res2,bs_res3,bs_res4,bs_res5,bs_res6);

Endp;

PROC(1) = perm_tran2(rc,ra,r10);
@ Assumes theta = 1 to identify the shocks @
/* Inputs:
   revision between Q1 survey forecasts of current quarter growth.
   revision between Q1 survey forecasts of current year growth
   revision between Q1 survey forecasts of current 10-year annual average */
Local Z1, Z2, Z, rho, e, u, w, v_e, v_u, v_w, psi;

Z1 = 2.5*rc - ra;
Z2 = -2.4*rc + 2.5*ra - r10;
Z =  packr(Z1~Z2~rc);
psi = invpd(Z[.,2]'Z[.,2])*(Z[.,2]'Z[.,1]); 

rho = (2.4*psi + 2.5)/(1 + 2.4*psi);
u = -Z[.,2]/(2.4*(1-rho));
e = (2/3)*(Z[.,1] - (2.5 - rho)*u);
w = Z[.,3] - u - e;

v_e = (stdc(packr(e)))^2;
v_w = (stdc(packr(w)))^2;
v_u = (stdc(packr(u)))^2;

RETP(rows(Z)~rho~v_e~v_w~v_u~((3.85*v_w + 0.1*v_e + rho*0.1*v_u)/(v_w + v_e + v_u))~((2.5*v_w + v_u*rho + v_e)/(v_w + v_e + v_u)));
ENDP;


PROC(1) = LHR(Z,H);
Local y,x,n,b,e,k,s_sq, eM, nM, lhs, rhs, p, W, wi, w1, w2;
nM = rows(Z);
lhs = Z[.,1];
rhs = ones(nM,1)~Z[.,2];
Z = packr(Z);
n= rows(Z);
y = Z[.,1];
x = ones(n,1)~Z[.,2];
b = invpd(x'x)*x'y;
k = cols(x);
e = y - x*b;		 
eM = lhs - rhs*b;

  @following code corrects for missings and calculates HAC@
  w = packr(eM~lhs~rhs);
  s_sq = (1/(n-k))*(w[.,1].*w[.,3:k+2])'(w[.,1].*w[.,3:k+2]); @HCSE@

	 if H .ne 0; 
      p=1; do while p < H;
	  wi =  1-(p/H);
	  w1 = packr(eM[1+p:nM,1]~rhs[1+p:nM,.]~eM[1:nM-p,1]~rhs[1:nM-p,.]);
	  w2 = packr(eM[1+p:nM,1]~rhs[1:nM-p,.]~eM[1:nM-p,1]~rhs[1+p:nM,.]);
	 
      s_sq = s_sq + wi*(1/rows(w1))*(w1[.,1].*w1[.,2:k+1])'(w1[.,k+2].*w1[.,k+3:2*k+2])
                  + wi*(1/rows(w2))*(w2[.,1].*w2[.,2:k+1])'(w2[.,k+2].*w2[.,k+3:2*k+2]);
      @Bartlett weights@ 
      p = p+1; endo;
     endif;

  w = packr(rhs);
  s_sq = n*invpd(w'w)*s_sq*invpd(w'w);

Retp(b[2,1]~(b[2,1]/SQRT(s_sq[2,2])));
Endp;

PROC(1) = LHR3(Z,H);
Local y,x,n,b,e,k,s_sq, eM, nM, lhs, rhs, p, W, wi, w1, w2;
nM = rows(Z);
lhs = Z[.,1];
rhs = ones(nM,1)~Z[.,2 3 4];
Z = packr(Z);
n= rows(Z);
y = Z[.,1];
x = ones(n,1)~Z[.,2:4];
b = invpd(x'x)*x'y;
k = cols(x);
e = y - x*b;		 
eM = lhs - rhs*b;

  @following code corrects for missings and calculates HAC@
  w = packr(eM~lhs~rhs);
  s_sq = (1/(n-k))*(w[.,1].*w[.,3:k+2])'(w[.,1].*w[.,3:k+2]); @HCSE@

	 if H .ne 0; 
      p=1; do while p < H;
	  wi =  1-(p/H);
	  w1 = packr(eM[1+p:nM,1]~rhs[1+p:nM,.]~eM[1:nM-p,1]~rhs[1:nM-p,.]);
	  w2 = packr(eM[1+p:nM,1]~rhs[1:nM-p,.]~eM[1:nM-p,1]~rhs[1+p:nM,.]);
	 
      s_sq = s_sq + wi*(1/rows(w1))*(w1[.,1].*w1[.,2:k+1])'(w1[.,k+2].*w1[.,k+3:2*k+2])
                  + wi*(1/rows(w2))*(w2[.,1].*w2[.,2:k+1])'(w2[.,k+2].*w2[.,k+3:2*k+2]);
      @Bartlett weights@ 
      p = p+1; endo;
     endif;

  w = packr(rhs);
  s_sq = n*invpd(w'w)*s_sq*invpd(w'w);
  
Retp(n~b[2,1]~(b[2,1]/SQRT(s_sq[2,2]))~b[3,1]~(b[3,1]/SQRT(s_sq[3,3]))~b[4,1]~(b[4,1]/SQRT(s_sq[4,4])));	  
Endp;

proc(1) = spearman(r1,r2);
local SpearS,R, d, n, Fr, Zstat;
n = rows(r1);
d = r1 - r2;
R = sumc(d.*d);
SpearS = 1 - (6*R)/(n*(n*n -1 ));

@Fisher transformation@
Fr = 0.5*ln((1+SpearS)/(1-SpearS));
Zstat = Fr * SQRT((n-3)/1.06);
retp(SpearS|cdfNc(Zstat));
endp;


@	Formats a Gauss matrix as a tex table@
proc(0) = tex_table(x);
local r,c,i,j;
r=rows(x);
c=cols(x);
"\\begin{table}";
"\\caption{} ";
"\\label{} ";
"\\begin{tabular}{} ";
"\\hline";
i=1; do while i <= r;
j=1; do while j <= c-1;
x[i,j];;" & ";;
j=j+1; endo;
x[i,c] " \\\\ ";
i=i+1;endo;
"\\hline";
"\\end{tabular} ";
"\\end{table} ";
retp;
endp;

end;
