%% This example code is used for estimating NKPC using GBSE

clear all; clc;
cd('..\')
addpath('.\auxiliary');
addpath('.\data');
addpath('.\example');

%% Data 
data = xlsread('replication_1998.csv'); %1998 vintage dataset
%data = xlsread('replication_2012.csv');  %2012 vintage dataset

p0 = data(5:end-1,2);
pp1 = data(6:end,2); %inf expectation
pm1 = data(4:end-2,2); %1-lag inflation
pm2 = data(3:end-3,2); %2-lag inflation
pm3 = data(2:end-4,2); %3-lag inflation
pm4 = data(1:end-5,2); %4-lag inflation


x0 = data(5:end-1,3);  %labor share
x1 = data(4:end-2,3); %1-lag labor share
x2 = data(3:end-3,3); %2-lag labor share

w1 = data(4:end-2,5); %1-lag wage inf
w2 = data(3:end-3,5); %2-lag wage inf

yd1 = data(4:end-2,4); %1-lag output gap
yd2 = data(3:end-3,4); %2-lag output gap

n   = size(p0,1);
Y    = [p0];
X    = [ ones(n,1) x0 pp1 pm1 ] ;
Z   = [ones(n,1) pm1 pm2 pm3 pm4 x1 x2 w1 w2 yd1 yd2 ];


%% GBSE Estimation(HAC)
omega = [1/3 1];
[theta_GBSE, se_GBSE, W_GBSE] = GBSE_est(X,Y,Z,omega);

%% display results
[theta_GBSE se_GBSE theta_GBSE./se_GBSE ]
