function [theta, se, W] = BSGMME_est(X,Y,Z,omega)

[n,p] = size(X);

zcompweexp = compweexp(Z,n);
W = zeros(n,n);           % n x n
   for t = 1:n  % row
      for s = t:n   % column
          wv = 0;
          for j = 1:t
              for k = 1:s
              nj   = n-j+1; nk = n-k+1;
              idx1 = (n/nj)^.5*(n/nk)^.5;
              idx1 = idx1/(j*k*pi^2);
              if (j==k)
                  idx2  = (omega(2)-omega(1))-(sin(2*pi*j*omega(2))-sin(2*pi*j*omega(1)))/(2*pi*j);
              else
                  idx21 = (sin((j-k)*omega(2)*pi)-sin((j-k)*omega(1)*pi))/((j-k)*pi);
                  idx22 = (sin((j+k)*omega(2)*pi)-sin((j+k)*omega(1)*pi))/((j+k)*pi);
                  idx2  = idx21 - idx22;
              end
              wv = wv + idx1*zcompweexp(t-j+1,s-k+1)*idx2;
              end
          end
          W(t,s) = wv;
          W(s,t) = W(t,s);    
      end
   end    
    
% gse estimates
theta = inv(X'*W*X)*(X'*W*Y);

% Compute the estimate for variance matrix
e = Y-X*theta;
Omega  = diag(e.^2);
Sigma  = (X'*W*X)/n^2;
Lambda = (X'*W*Omega*W*X)/n^3;
V_hat  = inv(Sigma)*Lambda*inv(Sigma);
%se_mds = sqrt(diag(V_hat/n));


% HAC
A=inv(X'*W*X/n^2);
u=(W*X).*(e*ones(1,p))./n;
[S, bandw] = longvar(u,0,'hacc_p',[]);
omega=A*S*A/n;
se = sqrt(diag(omega));
