function [theta se W] = BGMMSE_est(X,Y,Z,omega) %

[n,p] = size(X);
%Z = [ones(n,1) Z];
zz = zs(Z,n);
W = zeros(n,n);           % n x n
   for t = 1:n  % row
      for s = t:n   % column
          wv = 0;
          for j = 1:t
              for k = 1:s
              nj   = n-j+1; nk = n-k+1;
              idx1 = (n/nj)^.5*(n/nk)^.5;
              idx1 = idx1/(j*k*pi^2);
              if (j==k)
                  idx2  = (omega(2)-omega(1))-(sin(2*pi*j*omega(2))-sin(2*pi*j*omega(1)))/(2*pi*j);
              else
                  idx21 = (sin((j-k)*omega(2)*pi)-sin((j-k)*omega(1)*pi))/((j-k)*pi);
                  idx22 = (sin((j+k)*omega(2)*pi)-sin((j+k)*omega(1)*pi))/((j+k)*pi);
                  idx2  = idx21 - idx22;
              end
              wv = wv + idx1*zz(t-j+1,s-k+1)*idx2;
              end
          end
          W(t,s) = wv;
          W(s,t) = W(t,s);    
      end
   end    

% gse estimates
theta = inv(X'*W*X)*(X'*W*Y);

% % Compute the estimate for variance matrix
e = Y-X*theta;
Omega  = diag(e.^2);

% % HAC
A=inv(X'*W*X/n^2);
u=(W*X).*(e*ones(1,p))./n;
[S, bandw] = longvar(u,0,'hacc_p',[]);
omega=A*S*A/n;
se = sqrt(diag(omega));
end

function[weiexp]=zs(Z,n)

weiexp=ones(n,n);
for i=1:n
    for j=1+i:n
        aux1=(Z(i,:))*(Z(j,:))';
        weiexp(i,j)=aux1;
        weiexp(j,i)=weiexp(i,j);
    end
end

for i = 1:n
    weiexp(i,i)=(Z(i,:))*(Z(i,:))';
end
end
