function S = nws(g,nlag)

    %Newey-West HAC estimator
    
    %Inputs:
    %g      nxp matrix of variables for which long-run variance is to be computed
    %nlag   No. of lags (bandwidth)
    
    %Output:
    %S      pxp long-run variance estimate

    n = size(g,1);                  %Sample size
    
    g = g - repmat(mean(g),n,1);    %De-mean
    S_ = g'*g;                      %Initial estimate (lag 0)
    
    for l = 1:nlag; %For each lag
        weight = 1-l/(nlag+1); %Weight factor
        S_ = S_ + weight*(g(1:(n-l),:)'*g((l+1):n,:) + g((l+1):n,:)'*g(1:(n-l),:)); %Add weighted autocovariances
    end;
    
    S = S_/n;

end