% Generate idiosyncratic errors


function e = generroreffi(T,N,r,throw)

e = zeros(T+throw,N);% bin for the result
zeta = randn(T+throw,N);% pure error
rho=diag(unifrnd(0.3,0.8,[N,1]));% heterogenous coefficients for an AR(1) process
zeta_sigmas=diag(unifrnd(1,3,[N,1]));% variance of the pure error

for j=1:N
    e(1,j)= zeta(1,j);
    for t=2:T+throw
        e(t,j) = e(t-1,j)*rho(j,j)+zeta(t,j)*sqrt(zeta_sigmas(j,j));
    end
end

theta1=r*(eye(N)-rho'*rho)/zeta_sigmas;% variance adjustment term
e = e(throw+1:end,:)*sqrt(theta1);
end



    
