% Generate error structure

function e = generror(rho,beta,T,N)

throw = 20;                                    % initial obs to be discarded
lag = 8;

e1 = zeros(T+throw,N+2*lag);
v = randn(T+throw,N);

v1 = [v(:,end-(lag-1):end),v,v(:,1:lag)];

for j=1+lag:N+lag
    e1(1,j)= v1(1,j)+beta*(sum(v1(1,j-lag:j+lag))-v1(1,j));
    for t=2:T+throw
        e1(t,j) = e1(t-1,j)*rho+ v1(t,j)+beta*(sum(v1(t,j-lag:j+lag))-v1(t,j));
    end
end

e = e1(throw+1:end,lag+1:end-lag);                            % discarding initial obs
