% Estimation of factors and factor loadings
% Last checking: 05/20/2019
% X=set of predictors
% r=% of factors
% method=0: I(1) variable approach; method=1: I(0) variable approach
% output: estimated factors Fhat (T by r) and estimated factor loadings (N by r)

function [Fhat, Lhat, ehat, vk]=estimation_fac(X,r,method)
if method==0
 [T,N]=size(X);% X= T by N matrix of predictors
 X=demeaning(X);
 XX=X*X';% T by T variations
 XX1=X'*X;% N by N variations

  if T<=N % Factor --> Factor Loading
   % I(1) factor estimation    
   % Estimate Ordinary Principle Components (OPCE)
    
    [Fhat0,eigval,Fhat1]=svd(XX);% Singular value decomposition (svd is equivalent to eigenvalue decomposition when matrix is symmtrix real)
    Fhat=T*Fhat0(:,1:r);% Estimated I(1) factors
    Lhat=Fhat'*X/(T^2);% Estimated factor loadings
    Lhat=Lhat';% N by r estimated factor loadings
    Chat=Fhat*Lhat';% Estimated common component
    ehat=X-Chat;% Residual
    sigmahat=(1/T)*(ehat'*ehat);vk=(1/N)*trace(sigmahat);% Fitted terms for Bai and Ng's criteria
  else % Factor Loading --> Factor
    
    [Lhat0,eigval1,Lhat1]=svd(XX1);% Singular value decomposition (svd is equivalent to eigenvalue decomposition when matrix is symmtrix real)
    Lhat=sqrt(N)*Lhat0(:,1:r);% Estimated factor loadings
    Fhat=X*Lhat/N;% Estimated factor spaces
    Chat=Fhat*Lhat';% Estimated common component
    ehat=X-Chat;% Residual
    sigmahat=(1/T)*(ehat'*ehat);vk=(1/N)*trace(sigmahat);% Fitted terms for Bai and Ng's criteria
  end
 
 elseif method==1
 [T_1,N]=size(X);
 DX=X;% Differenced data
 DX=demeaning(DX);
 DXX=DX*DX';% T_1 by T_1 variation
 DXX1=DX'*DX;% N by N variation
     
  if T_1<=N % Factor --> Factor Loading
    
     % I(0) estimation
     % Estimate Ordinary Principle Components(OPCE)
    
    [DFhat0,Deigval,DFhat1]=svd(DXX);% Singular value decomposition (svd is equivalent to eigenvalue decomposition when matrix is symmtrix real)
    Fhat=sqrt(T_1)*DFhat0(:,1:r);% Estimated factors
    Lhat=Fhat'*DX/T_1;
    Lhat=Lhat';% Estimated factor loadings
    DChat=Fhat*Lhat';% Estimated common component
    ehat=DX-DChat;% Residual
    Dsigmahat=(1/T_1)*(ehat'*ehat);vk=(1/N)*trace(Dsigmahat);% Fitted terms for Bai and Ng's (2002) PC
    
  else % Factor Loading --> Factor
    
    [DLhat0,Deigval1,DLhat1]=svd(DXX1);% Singular value decomposition (svd is equivalent to eigenvalue decomposition when matrix is symmtrix real)
    Lhat=sqrt(N)*DLhat0(:,1:r);% Estimated factor loadings
    Fhat=DX*Lhat/N;% Estimated factors
    DChat=Fhat*Lhat';% Estimated common component
    ehat=DX-DChat;% Residual    
    Dsigmahat=(1/T_1)*(ehat'*ehat);vk=(1/N)*trace(Dsigmahat);% Fitted terms for Bai and Ng's (2002) PC
 end  
end
end