
clear
set more off

cd "$file"

use data_files/output/Original_Replication,clear
*Remove Missing Region Variables
drop if hv024==.

*Scale Weights
replace hiv05=hiv05/1000000 if hiv05!=.
replace hv005=hv005/1000000 if hv005!=.

***Create Regional Measures
gen hiv_prime=hiv03 if hv105>=15 & hv105<=49
egen hiv_region=wtmean(hiv_prime), weight(hiv05) by(country hv024)
*Scale Variable to be Measured in Percentage Points
gen hiv_scaled=hiv_region*100

*Generate Variables for Analysis
*Birth Year
replace hv007=hv007+8 if country==4
replace hv105=. if hv105>97
gen by=hv007-hv105

*Region Code
gen region=country*100+hv024

*Adjust Sex
replace hv104=. if hv104==9

*Schooling
gen yrschl=hv108 if hv108<30
gen anyschool=yrschl>=1 if yrschl!=.
gen primary=hv109>=2 if hv109<=5

*Grades Behind
gen ybehind=.
replace ybehind=hv105-6-yrschl
replace ybehind=0 if ybehind==(-1)
replace ybehind=. if ybehind<(-1)

********************************************************************************
*Weight Adjustment with Fortson Population (2007 CIA-Factbook)
*World Bank 2007 Populations Listed Below
sum hv005 if country==1
gen double adj_wgt=hv005*(14326203/r(sum)) if country==1
*15060000
sum hv005 if country==2
replace adj_wgt=hv005*(18060382/r(sum)) if country==2
*18350000
sum hv005 if country==3
replace adj_wgt=hv005*(18013409/r(sum)) if country==3
*18670000
sum hv005 if country==4
replace adj_wgt=hv005*(76511887/r(sum)) if country==4
*77720000
sum hv005 if country==5
replace adj_wgt=hv005*(22931299/r(sum)) if country==5
*22710000
sum hv005 if country==6
replace adj_wgt=hv005*(9947814/r(sum)) if country==6
*9374000
sum hv005 if country==7
replace adj_wgt=hv005*(36913721/r(sum)) if country==7
*38490000
sum hv005 if country==8
replace adj_wgt=hv005*(2125262/r(sum)) if country==8
*2106000
sum hv005 if country==9
replace adj_wgt=hv005*(13603181/r(sum)) if country==9
*13590000
sum hv005 if country==10
replace adj_wgt=hv005*(11995402/r(sum)) if country==10
*14020000
sum hv005 if country==11
replace adj_wgt=hv005*(12894865/r(sum)) if country==11
*13950000
sum hv005 if country==12
replace adj_wgt=hv005*(9907509/r(sum)) if country==12
*9711000
sum hv005 if country==13
replace adj_wgt=hv005*(12521851/r(sum)) if country==13
*11470000
sum hv005 if country==14
replace adj_wgt=hv005*((37149072-981754)/r(sum)) if country==14
*41070000
sum hv005 if country==15
replace adj_wgt=hv005*(11477447/r(sum)) if country==15
*12060000
