
*-----------------------------------
*
* Figure 4
*
*-----------------------------------

clear 
eststo clear

global file /*Add Replication Folder Location Here/replication_cls*/

cd "$file"

********************************************************************************

*-----------------------------------
* Figure 4
* Data: AllCountries_Post2000_Main
* SetUp: AllCountries_Post2000_SetUp
*-----------------------------------

***All Countries - Post-2000
run analysis_files/setup_code/AllCountries_Post2000_SetUp 

egen regfe=group(region hv007)

egen hiv_max=max(hiv_scaled),by(region)
forval i=1965/2010 {
	gen born`i'=by==`i'
	gen kb`i'=hiv_max*born`i'
	}
drop born*

********************************************************************************
***ART Extension

local yvar anyschool

*ART Reversal - Full Sample
reghdfe `yvar' kb1965-kb1978 kb1980-kb2008 age* i.hv104 i.hv025 [aw=adj_wgt] ///
	if by>=1965 & by<=2008 & age>=7 & age<=49,cluster(region) a(regfe by)
	
matrix `yvar'=J(44,5,.)
		
forval y=1965/1978 {
	estadd scalar b`y'=_b[kb`y']
	estadd scalar lb`y' =_b[kb`y'] - invttail(e(df_r),0.025)*_se[kb`y']
	estadd scalar ub`y' =_b[kb`y'] + invttail(e(df_r),0.025)*_se[kb`y']
	estadd scalar lb99`y' =_b[kb`y'] - invttail(e(df_r),0.005)*_se[kb`y']
	estadd scalar ub99`y' =_b[kb`y'] + invttail(e(df_r),0.005)*_se[kb`y']
	
	local r=`y'-1964
	matrix `yvar'[`r',1]=e(b`y')
	matrix `yvar'[`r',2]=e(lb`y')
	matrix `yvar'[`r',3]=e(ub`y')
	matrix `yvar'[`r',4]=e(lb99`y')
	matrix `yvar'[`r',5]=e(ub99`y')
	}
	
forval y=1980/2008 {
	estadd scalar b`y'=_b[kb`y']
	estadd scalar lb`y' =_b[kb`y'] - invttail(e(df_r),0.025)*_se[kb`y']
	estadd scalar ub`y' =_b[kb`y'] + invttail(e(df_r),0.025)*_se[kb`y']
	estadd scalar lb99`y' =_b[kb`y'] - invttail(e(df_r),0.005)*_se[kb`y']
	estadd scalar ub99`y' =_b[kb`y'] + invttail(e(df_r),0.005)*_se[kb`y']
	
	local r=`y'-1964
	matrix `yvar'[`r',1]=e(b`y')
	matrix `yvar'[`r',2]=e(lb`y')
	matrix `yvar'[`r',3]=e(ub`y')
	matrix `yvar'[`r',4]=e(lb99`y')
	matrix `yvar'[`r',5]=e(ub99`y')
	}
		
matlist anyschool
	