
*-----------------------------------
*
* Table A.9
*
*-----------------------------------

clear 
eststo clear

global file /*Add Replication Folder Location Here/replication_cls*/

cd "$file"

********************************************************************************

*-----------------------------------
* Table A.9
* Data: AllCountries_Post2000_Main
* SetUp: AllCountries_Post2000_SetUp
*-----------------------------------

***All Countries - Post-2000
run analysis_files/setup_code/AllCountries_Post2000_SetUp 

*Prep
gen young=by>=1992 if by!=.
gen key_scaled=hiv_scaled*young

egen regfe=group(region hv007)

*Child Labor Set Up
egen clwave=max(fam_work),by(hv000)
replace clwave=0 if clwave==.

gen paid=(nfam_work==1 | nfam_work==2) if nfam_work!=.

*Full Sample Means
sum ybehind paid fam_work if clwave==1 & age>=7 & age<=14 & hv104!=. [aw=adj_wgt]
sum ybehind if clwave==1 & age>=7 & age<=14 & nfam_work==0 & fam_work==0 & hv104!=. [aw=adj_wgt]

foreach yvar of varlist ybehind paid fam_work {
	eststo: qui reghdfe `yvar' key_scaled age* i.hv104 i.hv025 [aw=adj_wgt] ///
		if clwave==1 & age>=7 & age<=14,cluster(region) a(regfe by)
	estadd scalar Clusters=e(N_clust)
	}
eststo: qui reghdfe yb key_scaled age* i.hv104 i.hv025 [aw=adj_wgt] ///
	if nfam==0 & fam==0 & age>=7 & age<=14,cluster(region) a(regfe by)
estadd scalar Clusters=e(N_clust)

********************************************************************************
	
esttab * using analysis_files\output\table_a9.csv, stats(Clusters N) ///
	b(3) se(3) star(* 0.10 ** 0.05 *** 0.01) k(key_scaled) replace
eststo clear
