
*-----------------------------------
*
* Table A.5
*
*-----------------------------------

clear 
eststo clear

global file /*Add Replication Folder Location Here/replication_cls*/

cd "$file"

*-----------------------------------
* Table A.5
* Data: AllCountries_Post2000_Main
* SetUp: AllCountries_Post2000_SetUp
*-----------------------------------

***All Countries - Post-2000
run analysis_files/setup_code/AllCountries_Post2000_SetUp 

gen LATE=by>=1987 if by!=.
gen key_LATE=hiv_scaled*LATE

egen regfe=group(region hv007)

foreach yvar of varlist yrschl anysch primary {
	eststo: qui reghdfe `yvar' key_LATE age* i.hv104 i.hv025 [aw=adj_wgt] ///
		if by>=1965 & age>=15 & age<=49,cluster(region) a(regfe by)
	estadd scalar Clusters=e(N_clust)
	}
	
********************************************************************************

esttab * using analysis_files\output\table_a5.csv, ///
	stats(Clusters N) b(3) se(3) star(* 0.10 ** 0.05 *** 0.01) ///
	k(key_LATE) replace
eststo clear
