
*-----------------------------------
*
* Table A.3
*
*-----------------------------------

clear 
eststo clear

global file /*Add Replication Folder Location Here/replication_cls*/

cd "$file"

********************************************************************************

*-----------------------------------
* Table A.3 - Columns (1) and (2)
* Data: Original_Replication
* SetUp: Original_Replication_07SetUp
*-----------------------------------

* Original Population Weights
run analysis_files\setup_code\Original_Replication_07SetUp

***Fortson Baseline - Placebo
gen early=by>=1970 if by!=.
gen key_early=hiv_scaled*early

foreach yvar of varlist yrschl anysch primary {
	eststo: qui reghdfe `yvar' key_early [aw=adj_wgt] ///
		if by<1980 & hv105>=15 & hv105<=49,cluster(region) a(region hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)

	eststo: qui reghdfe `yvar' key_early [aw=adj_wgt] ///
		if by>=1965 & by<1980 & hv105>=15 & hv105<=49,cluster(region) a(region hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	}
*------------------------------------------------------------------------------

*-----------------------------------
* Table A.3 - Columns (3) - (6)
* Data: AllCountries_Post2000_Main
* SetUp: AllCountries_Post2000_SetUp
*-----------------------------------

***All Countries - Post-2000
run analysis_files/setup_code/AllCountries_Post2000_SetUp 

egen regfe=group(region hv007)

***Fortson New+Exp - Placebo
egen hiv_max=max(hiv_scaled),by(region)

gen early=by>=1970 if by!=.
gen key_early=hiv_scaled*early
gen key_emax=hiv_max*early

foreach yvar of varlist yrschl anysch primary {
	eststo: qui reghdfe `yvar' key_early age* [aw=adj_wgt] ///
		if by>=1965 & by<1980 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	
	eststo: qui reghdfe `yvar' key_emax age* [aw=adj_wgt] ///
		if by>=1965 & by<1980 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	}

drop early key_early key_emax

gen early=by>=1975 if by!=.
gen key_early=hiv_scaled*early
gen key_emax=hiv_max*early	

foreach yvar of varlist yrschl anysch primary {
	eststo: qui reghdfe `yvar' key_early age* [aw=adj_wgt] ///
		if by>=1965 & by<1985 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	
	eststo: qui reghdfe `yvar' key_emax age* [aw=adj_wgt] ///
		if by>=1965 & by<1985 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	}

*------------------------------------------------------------------------------

esttab * using analysis_files\output\table_a3.csv, stats(Clusters N) ///
	b(3) se(3) star(* 0.10 ** 0.05 *** 0.01) k(key_early key_emax) replace
eststo clear
