
*-----------------------------------
*
* Table A.12
*
*-----------------------------------

clear 
eststo clear

global file /*Add Replication Folder Location Here/replication_cls*/

cd "$file"

********************************************************************************

*-----------------------------------
* Table A.12
* Data: AllCountries_Post2000_Main
* SetUp: AllCountries_Post2000_SetUp
*-----------------------------------

***All Countries - Post-2000
run analysis_files/setup_code/AllCountries_Post2000_SetUp 

*Prep
gen young=by>=1980 if by!=.
gen key_scaled=hiv_scaled*young

egen hiv_max=max(hiv_scaled),by(region)
gen key_max=hiv_max*young

egen regfe=group(region hv007)

*Calculate Regional cutoffs
egen mean_scaled=mean(hiv_scaled),by(region)
bysort region: gen mark=_n
sum mean_scaled,d

local low1=r(p1)
local low5=r(p5)
local low10=r(p10)
local low25=r(p25)

local high25=r(p75)
local high10=r(p90)
local high5=r(p95)
local high1=r(p99)

*Output
foreach yvar of varlist yrschl anysch primary {
	eststo: qui reghdfe `yvar' key_scaled hiv_scaled age* [aw=adj_wgt] ///
		if by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	
	* --- Low ---
	eststo: qui reghdfe `yvar' key_scaled hiv_scaled age* [aw=adj_wgt] ///
		if mean_scaled>`low1' & by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	
	eststo: qui reghdfe `yvar' key_scaled hiv_scaled age* [aw=adj_wgt] ///
		if mean_scaled>`low5' & by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	
	eststo: qui reghdfe `yvar' key_scaled hiv_scaled age* [aw=adj_wgt] ///
		if mean_scaled>`low10' & by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	
	eststo: qui reghdfe `yvar' key_scaled hiv_scaled age* [aw=adj_wgt] ///
		if mean_scaled>`low25' & by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	
	* --- High ---
	eststo: qui reghdfe `yvar' key_scaled hiv_scaled age* [aw=adj_wgt] ///
		if mean_scaled<`high1' & by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	
	eststo: qui reghdfe `yvar' key_scaled hiv_scaled age* [aw=adj_wgt] ///
		if mean_scaled<`high5' & by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	
	eststo: qui reghdfe `yvar' key_scaled hiv_scaled age* [aw=adj_wgt] ///
		if mean_scaled<`high10' & by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	
	eststo: qui reghdfe `yvar' key_scaled hiv_scaled age* [aw=adj_wgt] ///
		if mean_scaled<`high25' & by>=1965 & age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	
	* --- Low + High ---
	eststo: qui reghdfe `yvar' key_scaled hiv_scaled age* [aw=adj_wgt] ///
		if mean_scaled>`low1' & mean_scaled<`high1' & by>=1965 ///
		& age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	
	eststo: qui reghdfe `yvar' key_scaled hiv_scaled age* [aw=adj_wgt] ///
		if mean_scaled>`low5' & mean_scaled<`high5' & by>=1965 ///
		& age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	
	eststo: qui reghdfe `yvar' key_scaled hiv_scaled age* [aw=adj_wgt] ///
		if mean_scaled>`low10' & mean_scaled<`high10' & by>=1965 ///
		& age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	
	eststo: qui reghdfe `yvar' key_scaled hiv_scaled age* [aw=adj_wgt] ///
		if mean_scaled>`low25' & mean_scaled<`high25' & by>=1965 ///
		& age>=15 & age<=49,cluster(region) a(regfe hv104 hv025 by)
	estadd scalar Clusters=e(N_clust)
	}

********************************************************************************
	
esttab * using analysis_files\output\table_a12.csv, stats(Clusters N) ///
	b(3) se(3) star(* 0.10 ** 0.05 *** 0.01) k(key_scaled hiv_scaled) replace
eststo clear
