
*-----------------------------------
*
* Figure A.2
*
*-----------------------------------

clear 
eststo clear

global file /*Add Replication Folder Location Here/replication_cls*/

cd "$file"

********************************************************************************

*-----------------------------------
* Figure A.2
* Data: AllCountries_Post2000_Main
* SetUp: AllCountries_Post2000_SetUp
*-----------------------------------

***All Countries - Post-2000
run analysis_files/setup_code/AllCountries_Post2000_SetUp 

egen regfe=group(region hv007)

egen hiv_max=max(hiv_scaled),by(region)
forval i=1965/2010 {
	gen born`i'=by==`i'
	gen kb`i'=hiv_max*born`i'
	}
drop born*

********************************************************************************

*Baseline Outcomes - Urban / Rural

foreach yvar of varlist yrschl anysch primary {
	reghdfe `yvar' kb1965-kb1978 kb1980-kb2000 age* [aw=adj_wgt] ///
		if by>=1965 & by<=2000 & age>=15 & age<=49 & hv025==1,cluster(region) a(regfe hv104 by)

	matrix urban_`yvar'=J(36,5,.)
		
	forval y=1965/1978 {
		estadd scalar ub`y'=_b[kb`y']
		estadd scalar ulb`y' =_b[kb`y'] - invttail(e(df_r),0.025)*_se[kb`y']
		estadd scalar uub`y' =_b[kb`y'] + invttail(e(df_r),0.025)*_se[kb`y']
		estadd scalar u99lb`y' =_b[kb`y'] - invttail(e(df_r),0.005)*_se[kb`y']
		estadd scalar u99ub`y' =_b[kb`y'] + invttail(e(df_r),0.005)*_se[kb`y']
		
		local r=`y'-1964
		matrix urban_`yvar'[`r',1]=e(ub`y')
		matrix urban_`yvar'[`r',2]=e(ulb`y')
		matrix urban_`yvar'[`r',3]=e(uub`y')
		matrix urban_`yvar'[`r',4]=e(u99lb`y')
		matrix urban_`yvar'[`r',5]=e(u99ub`y')
		}
		
	forval y=1980/2000 {
		estadd scalar ub`y'=_b[kb`y']
		estadd scalar ulb`y' =_b[kb`y'] - invttail(e(df_r),0.025)*_se[kb`y']
		estadd scalar uub`y' =_b[kb`y'] + invttail(e(df_r),0.025)*_se[kb`y']
		estadd scalar u99lb`y' =_b[kb`y'] - invttail(e(df_r),0.005)*_se[kb`y']
		estadd scalar u99ub`y' =_b[kb`y'] + invttail(e(df_r),0.005)*_se[kb`y']
		
		local r=`y'-1964
		matrix urban_`yvar'[`r',1]=e(ub`y')
		matrix urban_`yvar'[`r',2]=e(ulb`y')
		matrix urban_`yvar'[`r',3]=e(uub`y')
		matrix urban_`yvar'[`r',4]=e(u99lb`y')
		matrix urban_`yvar'[`r',5]=e(u99ub`y')
		}
		
	reghdfe `yvar' kb1965-kb1978 kb1980-kb2000 age* [aw=adj_wgt] ///
		if by>=1965 & by<=2000 & age>=15 & age<=49 & hv025==2,cluster(region) a(regfe hv104 by)

	matrix rural_`yvar'=J(36,5,.)
		
	forval y=1965/1978 {
		estadd scalar rb`y'=_b[kb`y']
		estadd scalar rlb`y' =_b[kb`y'] - invttail(e(df_r),0.025)*_se[kb`y']
		estadd scalar rub`y' =_b[kb`y'] + invttail(e(df_r),0.025)*_se[kb`y']
		estadd scalar r99lb`y' =_b[kb`y'] - invttail(e(df_r),0.005)*_se[kb`y']
		estadd scalar r99ub`y' =_b[kb`y'] + invttail(e(df_r),0.005)*_se[kb`y']
		
		local r=`y'-1964
		matrix rural_`yvar'[`r',1]=e(rb`y')
		matrix rural_`yvar'[`r',2]=e(rlb`y')
		matrix rural_`yvar'[`r',3]=e(rub`y')
		matrix rural_`yvar'[`r',4]=e(r99lb`y')
		matrix rural_`yvar'[`r',5]=e(r99ub`y')
		}
		
	forval y=1980/2000 {
		estadd scalar rb`y'=_b[kb`y']
		estadd scalar rlb`y' =_b[kb`y'] - invttail(e(df_r),0.025)*_se[kb`y']
		estadd scalar rub`y' =_b[kb`y'] + invttail(e(df_r),0.025)*_se[kb`y']
		estadd scalar r99lb`y' =_b[kb`y'] - invttail(e(df_r),0.005)*_se[kb`y']
		estadd scalar r99ub`y' =_b[kb`y'] + invttail(e(df_r),0.005)*_se[kb`y']
		
		local r=`y'-1964
		matrix rural_`yvar'[`r',1]=e(rb`y')
		matrix rural_`yvar'[`r',2]=e(rlb`y')
		matrix rural_`yvar'[`r',3]=e(rub`y')
		matrix rural_`yvar'[`r',4]=e(r99lb`y')
		matrix rural_`yvar'[`r',5]=e(r99ub`y')
		}
		eststo clear	
	}
	
matlist urban_yrschl
matlist rural_yrschl
	
matlist urban_anyschool
matlist rural_anyschool

matlist urban_primary
matlist rural_primary
