
*-----------------------------------
*
* Figure A.1
*
*-----------------------------------

clear 
eststo clear

global file /*Add Replication Folder Location Here/replication_cls*/

cd "$file"

********************************************************************************

*-----------------------------------
* Figure A.1
* Data: AllCountries_Post2000_Main
* SetUp: AllCountries_Post2000_SetUp
*-----------------------------------

***All Countries - Post-2000
run analysis_files/setup_code/AllCountries_Post2000_SetUp 

egen regfe=group(region hv007)

egen hiv_max=max(hiv_scaled),by(region)
forval i=1965/2010 {
	gen born`i'=by==`i'
	gen kb`i'=hiv_max*born`i'
	}
drop born*

*------------------------------------------------------------------------------

foreach yvar of varlist anyschool primary {

	eststo: qui reghdfe `yvar' kb1965-kb1978 kb1980-kb2000 age* [aw=adj_wgt] ///
		if hv104==1 & by>=1965 & by<=2000 & age>=15 & age<=49,cluster(region) a(regfe hv025 by)

	matrix male_`yvar'=J(36,5,.)
		
	forval y=1965/1978 {
		estadd scalar mb`y'=_b[kb`y']
		estadd scalar mlb`y' =_b[kb`y'] - invttail(e(df_r),0.025)*_se[kb`y']
		estadd scalar mub`y' =_b[kb`y'] + invttail(e(df_r),0.025)*_se[kb`y']
		estadd scalar m99lb`y' =_b[kb`y'] - invttail(e(df_r),0.005)*_se[kb`y']
		estadd scalar m99ub`y' =_b[kb`y'] + invttail(e(df_r),0.005)*_se[kb`y']
		
		local r=`y'-1964
		matrix male_`yvar'[`r',1]=e(mb`y')
		matrix male_`yvar'[`r',2]=e(mlb`y')
		matrix male_`yvar'[`r',3]=e(mub`y')
		matrix male_`yvar'[`r',4]=e(m99lb`y')
		matrix male_`yvar'[`r',5]=e(m99ub`y')
		}
		
	forval y=1980/2000 {
		estadd scalar mb`y'=_b[kb`y']
		estadd scalar mlb`y' =_b[kb`y'] - invttail(e(df_r),0.025)*_se[kb`y']
		estadd scalar mub`y' =_b[kb`y'] + invttail(e(df_r),0.025)*_se[kb`y']
		estadd scalar m99lb`y' =_b[kb`y'] - invttail(e(df_r),0.005)*_se[kb`y']
		estadd scalar m99ub`y' =_b[kb`y'] + invttail(e(df_r),0.005)*_se[kb`y']
		
		local r=`y'-1964
		matrix male_`yvar'[`r',1]=e(mb`y')
		matrix male_`yvar'[`r',2]=e(mlb`y')
		matrix male_`yvar'[`r',3]=e(mub`y')
		matrix male_`yvar'[`r',4]=e(m99lb`y')
		matrix male_`yvar'[`r',5]=e(m99ub`y')
		}

	
	****************************************************************************
	****************************************************************************
	
	eststo: qui reghdfe `yvar' kb1965-kb1978 kb1980-kb2000 age* [aw=adj_wgt] ///
		if hv104==2 & by>=1965 & by<=2000 & age>=15 & age<=49,cluster(region) a(regfe hv025 by)

	matrix female_`yvar'=J(36,5,.)
		
	forval y=1965/1978 {
		estadd scalar fb`y'=_b[kb`y']
		estadd scalar flb`y' =_b[kb`y'] - invttail(e(df_r),0.025)*_se[kb`y']
		estadd scalar fub`y' =_b[kb`y'] + invttail(e(df_r),0.025)*_se[kb`y']
		estadd scalar f99lb`y' =_b[kb`y'] - invttail(e(df_r),0.005)*_se[kb`y']
		estadd scalar f99ub`y' =_b[kb`y'] + invttail(e(df_r),0.005)*_se[kb`y']
		
		local r=`y'-1964
		matrix female_`yvar'[`r',1]=e(fb`y')
		matrix female_`yvar'[`r',2]=e(flb`y')
		matrix female_`yvar'[`r',3]=e(fub`y')
		matrix female_`yvar'[`r',4]=e(f99lb`y')
		matrix female_`yvar'[`r',5]=e(f99ub`y')
		}
		
	forval y=1980/2000 {
		estadd scalar fb`y'=_b[kb`y']
		estadd scalar flb`y' =_b[kb`y'] - invttail(e(df_r),0.025)*_se[kb`y']
		estadd scalar fub`y' =_b[kb`y'] + invttail(e(df_r),0.025)*_se[kb`y']
		estadd scalar f99lb`y' =_b[kb`y'] - invttail(e(df_r),0.005)*_se[kb`y']
		estadd scalar f99ub`y' =_b[kb`y'] + invttail(e(df_r),0.005)*_se[kb`y']
		
		local r=`y'-1964
		matrix female_`yvar'[`r',1]=e(fb`y')
		matrix female_`yvar'[`r',2]=e(flb`y')
		matrix female_`yvar'[`r',3]=e(fub`y')
		matrix female_`yvar'[`r',4]=e(f99lb`y')
		matrix female_`yvar'[`r',5]=e(f99ub`y')
		}
		eststo clear		
	}

********************************************************************************
***ART Extension

local yvar anyschool

*ART Reversal - Men
reghdfe `yvar' kb1965-kb1978 kb1980-kb2008 age* i.hv104 i.hv025 [aw=adj_wgt] ///
	if hv104==1 & by>=1965 & by<=2008 & age>=7 & age<=49,cluster(region) a(regfe by)
	
matrix male_art_`yvar'=J(44,5,.)
	
forval y=1965/1978 {
	estadd scalar mb`y'=_b[kb`y']
	estadd scalar mlb`y' =_b[kb`y'] - invttail(e(df_r),0.025)*_se[kb`y']
	estadd scalar mub`y' =_b[kb`y'] + invttail(e(df_r),0.025)*_se[kb`y']
	estadd scalar m99lb`y' =_b[kb`y'] - invttail(e(df_r),0.005)*_se[kb`y']
	estadd scalar m99ub`y' =_b[kb`y'] + invttail(e(df_r),0.005)*_se[kb`y']
	
	local r=`y'-1964
	matrix male_art_`yvar'[`r',1]=e(mb`y')
	matrix male_art_`yvar'[`r',2]=e(mlb`y')
	matrix male_art_`yvar'[`r',3]=e(mub`y')
	matrix male_art_`yvar'[`r',4]=e(m99lb`y')
	matrix male_art_`yvar'[`r',5]=e(m99ub`y')
	}
	
forval y=1980/2008 {
	estadd scalar mb`y'=_b[kb`y']
	estadd scalar mlb`y' =_b[kb`y'] - invttail(e(df_r),0.025)*_se[kb`y']
	estadd scalar mub`y' =_b[kb`y'] + invttail(e(df_r),0.025)*_se[kb`y']
	estadd scalar m99lb`y' =_b[kb`y'] - invttail(e(df_r),0.005)*_se[kb`y']
	estadd scalar m99ub`y' =_b[kb`y'] + invttail(e(df_r),0.005)*_se[kb`y']
	
	local r=`y'-1964
	matrix male_art_`yvar'[`r',1]=e(mb`y')
	matrix male_art_`yvar'[`r',2]=e(mlb`y')
	matrix male_art_`yvar'[`r',3]=e(mub`y')
	matrix male_art_`yvar'[`r',4]=e(m99lb`y')
	matrix male_art_`yvar'[`r',5]=e(m99ub`y')
	}
	
*ART Reversal - Women
reghdfe `yvar' kb1965-kb1978 kb1980-kb2008 age* i.hv104 i.hv025 [aw=adj_wgt] ///
	if hv104==2 & by>=1965 & by<=2008 & age>=7 & age<=49,cluster(region) a(regfe by)
	
matrix female_art_`yvar'=J(44,5,.)
	
forval y=1965/1978 {
	estadd scalar fb`y'=_b[kb`y']
	estadd scalar flb`y' =_b[kb`y'] - invttail(e(df_r),0.025)*_se[kb`y']
	estadd scalar fub`y' =_b[kb`y'] + invttail(e(df_r),0.025)*_se[kb`y']
	estadd scalar f99lb`y' =_b[kb`y'] - invttail(e(df_r),0.005)*_se[kb`y']
	estadd scalar f99ub`y' =_b[kb`y'] + invttail(e(df_r),0.005)*_se[kb`y']
	
	local r=`y'-1964
	matrix female_art_`yvar'[`r',1]=e(fb`y')
	matrix female_art_`yvar'[`r',2]=e(flb`y')
	matrix female_art_`yvar'[`r',3]=e(fub`y')
	matrix female_art_`yvar'[`r',4]=e(f99lb`y')
	matrix female_art_`yvar'[`r',5]=e(f99ub`y')
	}
	
forval y=1980/2008 {
	estadd scalar fb`y'=_b[kb`y']
	estadd scalar flb`y' =_b[kb`y'] - invttail(e(df_r),0.025)*_se[kb`y']
	estadd scalar fub`y' =_b[kb`y'] + invttail(e(df_r),0.025)*_se[kb`y']
	estadd scalar f99lb`y' =_b[kb`y'] - invttail(e(df_r),0.005)*_se[kb`y']
	estadd scalar f99ub`y' =_b[kb`y'] + invttail(e(df_r),0.005)*_se[kb`y']
	
	local r=`y'-1964
	matrix female_art_`yvar'[`r',1]=e(fb`y')
	matrix female_art_`yvar'[`r',2]=e(flb`y')
	matrix female_art_`yvar'[`r',3]=e(fub`y')
	matrix female_art_`yvar'[`r',4]=e(f99lb`y')
	matrix female_art_`yvar'[`r',5]=e(f99ub`y')
	}
eststo clear		
	
matlist male_anyschool
matlist female_anyschool

matlist male_primary
matlist female_primary

***************************
	
matlist male_art_anyschool
matlist female_art_anyschool
	