%% ABG replication -- prints output to tables

delete('ABGRep_Tables.out')
diary('ABGRep_Tables.out')

%% Heteroskedasticity Tests

disp('HETEROSKEDASTICITY TESTS USING OBSERVED DATA')
disp('********************************************')
disp(blanks(1))

disp('ABGs 1dp growth & ABG sample')
disp('============================')
disp(blanks(1))
load HET_1dp_abg.mat
disp(['White Test and p-value ' num2str(white_obs) ])
disp(blanks(1))
disp('MSS Tests and p-values (1st column is quantile)')
disp(mss_obs)
disp(blanks(1))
clear white_obs mss_obs

disp('ABGs 1dp growth & Extended sample')
disp('=================================')
disp(blanks(1))
load HET_1dp_ext.mat
disp(['White Test and p-value ' num2str(white_obs) ])
disp(blanks(1))
disp('MSS Tests and p-values (1st column is quantile)')
disp(mss_obs)
disp(blanks(1))
clear white_obs mss_obs

disp('GDPC1 1qtr growth & ABG sample')
disp('==============================')
disp(blanks(1))
load HET_1qtr_abg.mat
disp(['White Test and p-value ' num2str(white_obs) ])
disp(blanks(1))
disp('MSS Tests and p-values (1st column is quantile)')
disp(mss_obs)
disp(blanks(1))
clear white_obs mss_obs

disp('GDPC1 1qtr growth & Extended sample')
disp('===================================')
disp(blanks(1))
load HET_1qtr_ext.mat
disp(['White Test and p-value ' num2str(white_obs) ])
disp(blanks(1))
disp('MSS Tests and p-values (1st column is quantile)')
disp(mss_obs)
disp(blanks(1))
clear white_obs mss_obs

disp('GDPC1 4qtr growth & ABG sample')
disp('==============================')
disp(blanks(1))
load HET_4qtr_abg.mat
disp(['White Test and p-value ' num2str(white_obs) ])
disp(blanks(1))
disp('MSS Tests and p-values (1st column is quantile)')
disp(mss_obs)
disp(blanks(1))
clear white_obs mss_obs

disp('GDPC1 4qtr growth & Extended sample')
disp('===================================')
disp(blanks(1))
load HET_4qtr_ext.mat
disp(['White Test and p-value ' num2str(white_obs) ])
disp(blanks(1))
disp('MSS Tests and p-values (1st column is quantile)')
disp(mss_obs)
disp(blanks(1))
clear white_obs mss_obs

disp('HETEROSKEDASTICITY TESTS USING PSEUDO DATA')
disp('******************************************')
disp(blanks(1))

disp('ABGs 1dp growth & ABG sample')
disp('============================')
disp(blanks(1))
load HET_1dp_abg.mat
disp(['White Test and p-value ' num2str(white_ps) ])
disp(blanks(1))
disp('MSS Tests and p-values (1st column is quantile)')
disp(mss_ps)
disp(blanks(1))
clear white_ps mss_ps

disp('ABGs 1dp growth & Extended sample')
disp('=================================')
disp(blanks(1))
load HET_1dp_ext.mat
disp(['White Test and p-value ' num2str(white_ps) ])
disp(blanks(1))
disp('MSS Tests and p-values (1st column is quantile)')
disp(mss_ps)
disp(blanks(1))
clear white_ps mss_ps

disp('GDPC1 1qtr growth & ABG sample')
disp('==============================')
disp(blanks(1))
load HET_1qtr_abg.mat
disp(['White Test and p-value ' num2str(white_ps) ])
disp(blanks(1))
disp('MSS Tests and p-values (1st column is quantile)')
disp(mss_ps)
disp(blanks(1))
clear white_ps mss_ps

disp('GDPC1 1qtr growth & Extended sample')
disp('===================================')
disp(blanks(1))
load HET_1qtr_ext.mat
disp(['White Test and p-value ' num2str(white_ps) ])
disp(blanks(1))
disp('MSS Tests and p-values (1st column is quantile)')
disp(mss_ps)
disp(blanks(1))
clear white_ps mss_ps

disp('GDPC1 4qtr growth & ABG sample')
disp('==============================')
disp(blanks(1))
load HET_4qtr_abg.mat
disp(['White Test and p-value ' num2str(white_ps) ])
disp(blanks(1))
disp('MSS Tests and p-values (1st column is quantile)')
disp(mss_ps)
disp(blanks(1))
clear white_ps mss_ps

disp('GDPC1 4qtr growth & Extended sample')
disp('===================================')
disp(blanks(1))
load HET_4qtr_ext.mat
disp(['White Test and p-value ' num2str(white_ps) ])
disp(blanks(1))
disp('MSS Tests and p-values (1st column is quantile)')
disp(mss_ps)
disp(blanks(1))
clear white_ps mss_ps

%% Uncertainty bands for QR coefficients

disp('QR UNCERTAINTY BANDS FOR PARAMETERS ON NFCI FROM BLOCK BOOTSTRAP')
disp('****************************************************************')
disp(blanks(1))

disp('Observed Data (GDPC1 growth rate) ABG Sample')
disp('============================================')
disp(blanks(1))
load EST_1qtr_abg.mat
load BB_1qtr_abg.mat
disp('   Estimate     5th      33rd      50th      67th      95th' )
disp('    ----------------------------------------------------------')
disp([ qObs(2,:)' OBS_BB(:,:,2) ])
disp(blanks(1))
clear OBS_BB PS_BB qObs qPs pOBS pPS pCHT sw_gm sw_nm sw_gps sw_nps

disp('Observed Data (GDPC1 growth rate) Extended Sample')
disp('=================================================')
disp(blanks(1))
load EST_1qtr_ext.mat
load BB_1qtr_ext.mat
disp('   Estimate     5th      33rd      50th      67th      95th' )
disp('    ----------------------------------------------------------')
disp([ qObs(2,:)' OBS_BB(:,:,2) ])
disp(blanks(1))
clear OBS_BB PS_BB qObs qPs pOBS pPS pCHT sw_gm sw_nm sw_gps sw_np

disp('Pseudo Data (GDPC1 growth rate) ABG Sample')
disp('===========================================')
disp(blanks(1))
load EST_1qtr_abg.mat
load BB_1qtr_abg.mat
disp('   Estimate     5th      33rd      50th      67th      95th' )
disp('    ----------------------------------------------------------')
disp([ qPs(2,:)' PS_BB(:,:,2) ])
disp(blanks(1))
clear OBS_BB PS_BB qObs qPs pOBS pPS pCHT sw_gm sw_nm sw_gps sw_nps

disp('Pseudo (GDPC1 growth rate) Extended Sample')
disp('==========================================')
disp(blanks(1))
load EST_1qtr_ext.mat
load BB_1qtr_ext.mat
disp('   Estimate     5th      33rd      50th      67th      95th' )
disp('    ----------------------------------------------------------')
disp([ qPs(2,:)' PS_BB(:,:,2) ])
disp(blanks(1))
clear OBS_BB PS_BB qObs qPs pOBS pPS pCHT sw_gm sw_nm sw_gps sw_nps XX

%% Estimates with Covid Dummy

disp('ESTIMATES WITH COVID-19 DUMMY')
disp('*****************************')
disp(blanks(1))

disp('GDPC1 1qtr growth - Observed Data')
disp('=================================')
disp(blanks(1))
load EST_Dummy.mat
load BB_Dummy.mat
disp('NFCI')
disp('   Estimate     5th      33rd      50th      67th      95th' )
disp('    ----------------------------------------------------------')
disp([ qObs(2,:)' OBS_BB(:,:,2) ])
disp(blanks(1))
disp('Covid Dummy')
disp('   Estimate     5th      33rd      50th      67th      95th' )
disp('    ----------------------------------------------------------')
disp([ qObs(4,:)' OBS_BB(:,:,4) ])
disp(blanks(1))

disp('GDPC1 1qtr growth - Pseudo Data')
disp('=================================')
disp(blanks(1))
load EST_Dummy.mat
load BB_Dummy.mat
disp('NFCI')
disp('   Estimate     5th      33rd      50th      67th      95th' )
disp('    ----------------------------------------------------------')
disp([ qPs(2,:)' PS_BB(:,:,2) ])
disp(blanks(1))
disp('Covid Dummy')
disp('   Estimate     5th      33rd      50th      67th      95th' )
disp('    ----------------------------------------------------------')
disp([ qPs(4,:)' PS_BB(:,:,4) ])
disp(blanks(1))

