%% ABG Rep -- load raw data and write to single .mat file

clear all 

%% Load & Plot Data (downloaded 14/01/2022 - NFCI aggregated by averaging)

DAT = xlsread('GDPC1.xlsx', 'Data') ;                               % Real GDP 1972Q1 - 2021Q3
g1GDP = 100*((DAT(5:end,1)./DAT(4:end-1,1)).^4 - 1)  ;              % 1 qtr GDP growth rate 1973Q1 - 2021Q3
g4GDP = 100*((DAT(5:end,1)./DAT(1:end-4,1)) - 1)  ;                 % 4 qtr GDP growth rate 1973Q1 - 2021Q3
clear DAT
NFCI = xlsread('NFCI.xlsx', 'Data') ;                               % NCFI 1973Q1 - 2021Q3      
ABGgGDP = xlsread('A191RL1Q225SBEA.xlsx', 'Data') ;                 % ABG's GDP growth rate 1973Q1 - 2021Q3
T = size(g1GDP,1) ;
QTR = [datetime(1973,01,01):calmonths(3):datetime(2021,07,01)]' ;

% Compare GDP growth series
gGDPround = round(g1GDP,1) ;
gGDPdiff = ABGgGDP - gGDPround ;
figure('position', [100, 100, 700, 500]) ;
yyaxis left 
plot(QTR,g1GDP,'b-','linewidth',1)
ylabel('Output Growth')
yyaxis right
bar(QTR,gGDPdiff)
ylabel('Difference')
ylim([-1 1])
title('GDP Growth and Difference Between ABG Series and Our Series')

% Plot Data
figure('position', [100, 100, 900, 900])
subplot(2,2,1)
plot(QTR,ABGgGDP)
title('ABGs GDP Growth: 1973Q1 - 2020Q4')
subplot(2,2,2)
plot(QTR,g1GDP)
title('1 qtr GDP Growth: 1973Q1 - 2020Q4')
subplot(2,2,3)
plot(QTR,g4GDP)
title('4 qtr GDP Growth: 1973Q1 - 2020Q4')
subplot(2,2,4)
plot(QTR,NFCI)
title('NFCI: 1973Q1 - 2020Q4')

%% Save Data to File 1973Q1 - 2020Q4
save('ABGRep.mat', 'QTR', 'ABGgGDP', 'g1GDP', 'g4GDP', 'NFCI')


