%% Modified version of ABG's code VulnerabilityBands.m to also estimate using pseudo data
% Set d_flag = 0 to use (standardized) observed data or d_flag = 1 to use psuedo data
% Also need to set s_flag for sample 

%% Clear workspace, set file paths and graphics settings
clear
close all

s_flag = 1 ;                % 0 = ABG sample, 1 = Extended Sample
d_flag = 1 ;                % 0 = Observed data, 1 = Pseudo data
h = 1 ;                     % set equal to 1 or 4 for horizon

QQ = 0.05:0.05:0.95 ;       % Quantiles to estimate in quantile regressions
nDrawsBoot = 1000 ;         % number of bootstrap replications
nLagsBootVAR = 4 ;          % of lags to use in approximating VAR

%% Load data 

load('DataVulnerability.mat', 'X', 'Time', 'Mnem')

% If using ABG sample remove observations after 2015Q4
num_ext = 23 ;                              % Data extended to 2021Q3, 23 observations past end of ABG sample
if s_flag == 0 ;
    X = X(1:end-num_ext,:) ;
end ;

if d_flag == 0 ;                            % Use (standardized) observed data
    X = zscore(X) ;
elseif d_flag == 1 ;                        % Use pseudo data
    XR = X ;
    T = length(XR);
    gr = tiedrank(XR(:,1))/(T+1) ;          % ranks: output growth
    nr = tiedrank(XR(:,2))/(T+1) ;          % ranks: NFCI
    gps = norminv(gr,0,1) ;                 % pseudo data: output growth
    nps = norminv(nr,0,1) ;                 % pseudo data: lagged NFCI
    X = [gps nps ] ;
end ;

% Construct average growth rates
y = X(:, strcmp(Mnem, 'A191RL1Q225SBEA'));
Yh(:, h) = filter(ones(1, h) / h, 1, y) ;
Yh(1:(h - 1), h) = NaN ;

%% Estimate quantile regressions, generate bootstrapped confidence bands

% Quantile regressions include both GDP and NFCI
Res = QRboot(X(:, strcmp(Mnem, 'NFCI')), y, h, 1, QQ,...
             nDrawsBoot, nLagsBootVAR);

% Store results for coefficients on NFCI

j = 2 ;             % Pick NFCI coefficient

BQ  = Res.BQ(j,:,h) ;
B2  = Res.B2(j,h) ;
bBQ = squeeze(Res.bBQ(j,:,h,:)) ;
bB2 = squeeze(Res.bB2(j,h,:)) ;
QQ = Res.QQ ;

%% Save objects to files to produce figures / tables
if s_flag == 0 && d_flag == 0 ; 
    save('ABGBands_abg_obs.mat','BQ','B2','bBQ','bB2','QQ') ;
elseif s_flag == 0 && d_flag == 1 ;
    save('ABGBands_abg_ps.mat','BQ','B2','bBQ','bB2','QQ') ;
elseif s_flag == 1 && d_flag == 0 ; 
    save('ABGBands_ext_obs.mat','BQ','B2','bBQ','bB2','QQ') ;
elseif s_flag == 1 && d_flag == 1 ;
    save('ABGBands_ext_ps.mat','BQ','B2','bBQ','bB2','QQ') ;
end ;


