#======================================================================#
# This is the R code for presenting the simulation result of the paper:
# "A Distributional Synthetic Control Method for Policy Evaluation"
# This version: January 10, 2020
#=======================================================================#
rm(list=ls())
library(Matrix)
library(quadprog)

#-------------------------------------------------------------------------------
# (1) Load Data (Format: T x (q x R), T=T0+10, m=length(tau), R=# of replications)
#-------------------------------------------------------------------------------
dirpath="E:/Research/SyntheticControl/Revision2/Simulation/"

Trt11111=read.csv(paste0(dirpath,"Trt_S1M1T1N1n1.csv"));  Syn011111=read.csv(paste0(dirpath,"Syn0_S1M1T1N1n1.csv"));  Syn11111=read.csv(paste0(dirpath,"Syn_S1M1T1N1n1.csv"));  
Trt11112=read.csv(paste0(dirpath,"Trt_S1M1T1N1n2.csv"));  Syn011112=read.csv(paste0(dirpath,"Syn0_S1M1T1N1n2.csv"));  Syn11112=read.csv(paste0(dirpath,"Syn_S1M1T1N1n2.csv"));  
Trt11121=read.csv(paste0(dirpath,"Trt_S1M1T1N2n1.csv"));  Syn011121=read.csv(paste0(dirpath,"Syn0_S1M1T1N2n1.csv"));  Syn11121=read.csv(paste0(dirpath,"Syn_S1M1T1N2n1.csv"));  
Trt11122=read.csv(paste0(dirpath,"Trt_S1M1T1N2n2.csv"));  Syn011122=read.csv(paste0(dirpath,"Syn0_S1M1T1N2n2.csv"));  Syn11122=read.csv(paste0(dirpath,"Syn_S1M1T1N2n2.csv"));  
Trt11211=read.csv(paste0(dirpath,"Trt_S1M1T2N1n1.csv"));  Syn011211=read.csv(paste0(dirpath,"Syn0_S1M1T2N1n1.csv"));  Syn11211=read.csv(paste0(dirpath,"Syn_S1M1T2N1n1.csv"));  
Trt11212=read.csv(paste0(dirpath,"Trt_S1M1T2N1n2.csv"));  Syn011212=read.csv(paste0(dirpath,"Syn0_S1M1T2N1n2.csv"));  Syn11212=read.csv(paste0(dirpath,"Syn_S1M1T2N1n2.csv"));  
Trt11221=read.csv(paste0(dirpath,"Trt_S1M1T2N2n1.csv"));  Syn011221=read.csv(paste0(dirpath,"Syn0_S1M1T2N2n1.csv"));  Syn11221=read.csv(paste0(dirpath,"Syn_S1M1T2N2n1.csv"));  
Trt11222=read.csv(paste0(dirpath,"Trt_S1M1T2N2n2.csv"));  Syn011222=read.csv(paste0(dirpath,"Syn0_S1M1T2N2n2.csv"));  Syn11222=read.csv(paste0(dirpath,"Syn_S1M1T2N2n2.csv"));  
Trt12111=read.csv(paste0(dirpath,"Trt_S1M2T1N1n1.csv"));  Syn012111=read.csv(paste0(dirpath,"Syn0_S1M2T1N1n1.csv"));  Syn12111=read.csv(paste0(dirpath,"Syn_S1M2T1N1n1.csv"));  
Trt12112=read.csv(paste0(dirpath,"Trt_S1M2T1N1n2.csv"));  Syn012112=read.csv(paste0(dirpath,"Syn0_S1M2T1N1n2.csv"));  Syn12112=read.csv(paste0(dirpath,"Syn_S1M2T1N1n2.csv"));  
Trt12121=read.csv(paste0(dirpath,"Trt_S1M2T1N2n1.csv"));  Syn012121=read.csv(paste0(dirpath,"Syn0_S1M2T1N2n1.csv"));  Syn12121=read.csv(paste0(dirpath,"Syn_S1M2T1N2n1.csv"));  
Trt12122=read.csv(paste0(dirpath,"Trt_S1M2T1N2n2.csv"));  Syn012122=read.csv(paste0(dirpath,"Syn0_S1M2T1N2n2.csv"));  Syn12122=read.csv(paste0(dirpath,"Syn_S1M2T1N2n2.csv"));  
Trt12211=read.csv(paste0(dirpath,"Trt_S1M2T2N1n1.csv"));  Syn012211=read.csv(paste0(dirpath,"Syn0_S1M2T2N1n1.csv"));  Syn12211=read.csv(paste0(dirpath,"Syn_S1M2T2N1n1.csv"));  
Trt12212=read.csv(paste0(dirpath,"Trt_S1M2T2N1n2.csv"));  Syn012212=read.csv(paste0(dirpath,"Syn0_S1M2T2N1n2.csv"));  Syn12212=read.csv(paste0(dirpath,"Syn_S1M2T2N1n2.csv"));  
Trt12221=read.csv(paste0(dirpath,"Trt_S1M2T2N2n1.csv"));  Syn012221=read.csv(paste0(dirpath,"Syn0_S1M2T2N2n1.csv"));  Syn12221=read.csv(paste0(dirpath,"Syn_S1M2T2N2n1.csv"));  
Trt12222=read.csv(paste0(dirpath,"Trt_S1M2T2N2n2.csv"));  Syn012222=read.csv(paste0(dirpath,"Syn0_S1M2T2N2n2.csv"));  Syn12222=read.csv(paste0(dirpath,"Syn_S1M2T2N2n2.csv"));  

Trt_11111=Trt11111[2:ncol(Trt11111)]; Syn0_11111=Syn011111[2:ncol(Syn011111)]; Syn_11111=Syn11111[2:ncol(Syn11111)];  
Trt_11112=Trt11112[2:ncol(Trt11112)]; Syn0_11112=Syn011112[2:ncol(Syn011112)]; Syn_11112=Syn11112[2:ncol(Syn11112)];  
Trt_11121=Trt11121[2:ncol(Trt11121)]; Syn0_11121=Syn011121[2:ncol(Syn011121)]; Syn_11121=Syn11121[2:ncol(Syn11121)];  
Trt_11122=Trt11122[2:ncol(Trt11122)]; Syn0_11122=Syn011122[2:ncol(Syn011122)]; Syn_11122=Syn11122[2:ncol(Syn11122)];  
Trt_11211=Trt11211[2:ncol(Trt11211)]; Syn0_11211=Syn011211[2:ncol(Syn011211)]; Syn_11211=Syn11211[2:ncol(Syn11211)];  
Trt_11212=Trt11212[2:ncol(Trt11212)]; Syn0_11212=Syn011212[2:ncol(Syn011212)]; Syn_11212=Syn11212[2:ncol(Syn11212)];  
Trt_11221=Trt11221[2:ncol(Trt11221)]; Syn0_11221=Syn011221[2:ncol(Syn011221)]; Syn_11221=Syn11221[2:ncol(Syn11221)];  
Trt_11222=Trt11222[2:ncol(Trt11222)]; Syn0_11222=Syn011222[2:ncol(Syn011222)]; Syn_11222=Syn11222[2:ncol(Syn11222)];  
Trt_12111=Trt12111[2:ncol(Trt12111)]; Syn0_12111=Syn012111[2:ncol(Syn012111)]; Syn_12111=Syn12111[2:ncol(Syn12111)];  
Trt_12112=Trt12112[2:ncol(Trt12112)]; Syn0_12112=Syn012112[2:ncol(Syn012112)]; Syn_12112=Syn12112[2:ncol(Syn12112)];  
Trt_12121=Trt12121[2:ncol(Trt12121)]; Syn0_12121=Syn012121[2:ncol(Syn012121)]; Syn_12121=Syn12121[2:ncol(Syn12121)];  
Trt_12122=Trt12122[2:ncol(Trt12122)]; Syn0_12122=Syn012122[2:ncol(Syn012122)]; Syn_12122=Syn12122[2:ncol(Syn12122)];  
Trt_12211=Trt12211[2:ncol(Trt12211)]; Syn0_12211=Syn012211[2:ncol(Syn012211)]; Syn_12211=Syn12211[2:ncol(Syn12211)];  
Trt_12212=Trt12212[2:ncol(Trt12212)]; Syn0_12212=Syn012212[2:ncol(Syn012212)]; Syn_12212=Syn12212[2:ncol(Syn12212)];  
Trt_12221=Trt12221[2:ncol(Trt12221)]; Syn0_12221=Syn012221[2:ncol(Syn012221)]; Syn_12221=Syn12221[2:ncol(Syn12221)];  
Trt_12222=Trt12222[2:ncol(Trt12222)]; Syn0_12222=Syn012222[2:ncol(Syn012222)]; Syn_12222=Syn12222[2:ncol(Syn12222)];  


Trt21111=read.csv(paste0(dirpath,"Trt_S2M1T1N1n1.csv"));  Syn021111=read.csv(paste0(dirpath,"Syn0_S2M1T1N1n1.csv"));  Syn21111=read.csv(paste0(dirpath,"Syn_S2M1T1N1n1.csv"));  
Trt21112=read.csv(paste0(dirpath,"Trt_S2M1T1N1n2.csv"));  Syn021112=read.csv(paste0(dirpath,"Syn0_S2M1T1N1n2.csv"));  Syn21112=read.csv(paste0(dirpath,"Syn_S2M1T1N1n2.csv"));  
Trt21121=read.csv(paste0(dirpath,"Trt_S2M1T1N2n1.csv"));  Syn021121=read.csv(paste0(dirpath,"Syn0_S2M1T1N2n1.csv"));  Syn21121=read.csv(paste0(dirpath,"Syn_S2M1T1N2n1.csv"));  
Trt21122=read.csv(paste0(dirpath,"Trt_S2M1T1N2n2.csv"));  Syn021122=read.csv(paste0(dirpath,"Syn0_S2M1T1N2n2.csv"));  Syn21122=read.csv(paste0(dirpath,"Syn_S2M1T1N2n2.csv"));  
Trt21211=read.csv(paste0(dirpath,"Trt_S2M1T2N1n1.csv"));  Syn021211=read.csv(paste0(dirpath,"Syn0_S2M1T2N1n1.csv"));  Syn21211=read.csv(paste0(dirpath,"Syn_S2M1T2N1n1.csv"));  
Trt21212=read.csv(paste0(dirpath,"Trt_S2M1T2N1n2.csv"));  Syn021212=read.csv(paste0(dirpath,"Syn0_S2M1T2N1n2.csv"));  Syn21212=read.csv(paste0(dirpath,"Syn_S2M1T2N1n2.csv"));  
Trt21221=read.csv(paste0(dirpath,"Trt_S2M1T2N2n1.csv"));  Syn021221=read.csv(paste0(dirpath,"Syn0_S2M1T2N2n1.csv"));  Syn21221=read.csv(paste0(dirpath,"Syn_S2M1T2N2n1.csv"));  
Trt21222=read.csv(paste0(dirpath,"Trt_S2M1T2N2n2.csv"));  Syn021222=read.csv(paste0(dirpath,"Syn0_S2M1T2N2n2.csv"));  Syn21222=read.csv(paste0(dirpath,"Syn_S2M1T2N2n2.csv"));  
Trt22111=read.csv(paste0(dirpath,"Trt_S2M2T1N1n1.csv"));  Syn022111=read.csv(paste0(dirpath,"Syn0_S2M2T1N1n1.csv"));  Syn22111=read.csv(paste0(dirpath,"Syn_S2M2T1N1n1.csv"));  
Trt22112=read.csv(paste0(dirpath,"Trt_S2M2T1N1n2.csv"));  Syn022112=read.csv(paste0(dirpath,"Syn0_S2M2T1N1n2.csv"));  Syn22112=read.csv(paste0(dirpath,"Syn_S2M2T1N1n2.csv"));  
Trt22121=read.csv(paste0(dirpath,"Trt_S2M2T1N2n1.csv"));  Syn022121=read.csv(paste0(dirpath,"Syn0_S2M2T1N2n1.csv"));  Syn22121=read.csv(paste0(dirpath,"Syn_S2M2T1N2n1.csv"));  
Trt22122=read.csv(paste0(dirpath,"Trt_S2M2T1N2n2.csv"));  Syn022122=read.csv(paste0(dirpath,"Syn0_S2M2T1N2n2.csv"));  Syn22122=read.csv(paste0(dirpath,"Syn_S2M2T1N2n2.csv"));  
Trt22211=read.csv(paste0(dirpath,"Trt_S2M2T2N1n1.csv"));  Syn022211=read.csv(paste0(dirpath,"Syn0_S2M2T2N1n1.csv"));  Syn22211=read.csv(paste0(dirpath,"Syn_S2M2T2N1n1.csv"));  
Trt22212=read.csv(paste0(dirpath,"Trt_S2M2T2N1n2.csv"));  Syn022212=read.csv(paste0(dirpath,"Syn0_S2M2T2N1n2.csv"));  Syn22212=read.csv(paste0(dirpath,"Syn_S2M2T2N1n2.csv"));  
Trt22221=read.csv(paste0(dirpath,"Trt_S2M2T2N2n1.csv"));  Syn022221=read.csv(paste0(dirpath,"Syn0_S2M2T2N2n1.csv"));  Syn22221=read.csv(paste0(dirpath,"Syn_S2M2T2N2n1.csv"));  
Trt22222=read.csv(paste0(dirpath,"Trt_S2M2T2N2n2.csv"));  Syn022222=read.csv(paste0(dirpath,"Syn0_S2M2T2N2n2.csv"));  Syn22222=read.csv(paste0(dirpath,"Syn_S2M2T2N2n2.csv"));  

Trt_21111=Trt21111[2:ncol(Trt21111)]; Syn0_21111=Syn021111[2:ncol(Syn021111)]; Syn_21111=Syn21111[2:ncol(Syn21111)];  
Trt_21112=Trt21112[2:ncol(Trt21112)]; Syn0_21112=Syn021112[2:ncol(Syn021112)]; Syn_21112=Syn21112[2:ncol(Syn21112)];  
Trt_21121=Trt21121[2:ncol(Trt21121)]; Syn0_21121=Syn021121[2:ncol(Syn021121)]; Syn_21121=Syn21121[2:ncol(Syn21121)];  
Trt_21122=Trt21122[2:ncol(Trt21122)]; Syn0_21122=Syn021122[2:ncol(Syn021122)]; Syn_21122=Syn21122[2:ncol(Syn21122)];  
Trt_21211=Trt21211[2:ncol(Trt21211)]; Syn0_21211=Syn021211[2:ncol(Syn021211)]; Syn_21211=Syn21211[2:ncol(Syn21211)];  
Trt_21212=Trt21212[2:ncol(Trt21212)]; Syn0_21212=Syn021212[2:ncol(Syn021212)]; Syn_21212=Syn21212[2:ncol(Syn21212)];  
Trt_21221=Trt21221[2:ncol(Trt21221)]; Syn0_21221=Syn021221[2:ncol(Syn021221)]; Syn_21221=Syn21221[2:ncol(Syn21221)];  
Trt_21222=Trt21222[2:ncol(Trt21222)]; Syn0_21222=Syn021222[2:ncol(Syn021222)]; Syn_21222=Syn21222[2:ncol(Syn21222)];  
Trt_22111=Trt22111[2:ncol(Trt22111)]; Syn0_22111=Syn022111[2:ncol(Syn022111)]; Syn_22111=Syn22111[2:ncol(Syn22111)];  
Trt_22112=Trt22112[2:ncol(Trt22112)]; Syn0_22112=Syn022112[2:ncol(Syn022112)]; Syn_22112=Syn22112[2:ncol(Syn22112)];  
Trt_22121=Trt22121[2:ncol(Trt22121)]; Syn0_22121=Syn022121[2:ncol(Syn022121)]; Syn_22121=Syn22121[2:ncol(Syn22121)];  
Trt_22122=Trt22122[2:ncol(Trt22122)]; Syn0_22122=Syn022122[2:ncol(Syn022122)]; Syn_22122=Syn22122[2:ncol(Syn22122)];  
Trt_22211=Trt22211[2:ncol(Trt22211)]; Syn0_22211=Syn022211[2:ncol(Syn022211)]; Syn_22211=Syn22211[2:ncol(Syn22211)];  
Trt_22212=Trt22212[2:ncol(Trt22212)]; Syn0_22212=Syn022212[2:ncol(Syn022212)]; Syn_22212=Syn22212[2:ncol(Syn22212)];  
Trt_22221=Trt22221[2:ncol(Trt22221)]; Syn0_22221=Syn022221[2:ncol(Syn022221)]; Syn_22221=Syn22221[2:ncol(Syn22221)];  
Trt_22222=Trt22222[2:ncol(Trt22222)]; Syn0_22222=Syn022222[2:ncol(Syn022222)]; Syn_22222=Syn22222[2:ncol(Syn22222)];  


#-----------------------------------------------------------------------------
# (2) Compute the pre-intervetion MSPEs & the post-intervention squared biases
#-----------------------------------------------------------------------------
# Probability-index vector of quantiles
tau=c(0.01,0.05,0.1,0.3,0.5,0.7,0.9,0.95,0.99)
m=length(tau)
R=100

S_type=1
while(S_type<=2){
M_type=1
while(M_type<=2){

# Four cases
if(S_type==1 & M_type==1){case=1} # case1:=(no structural break,no poor matching)
if(S_type==1 & M_type==2){case=2} # case2:=(no structural break,poor matching)
if(S_type==2 & M_type==1){case=3} # case3:=(structural break,no poor matching)
if(S_type==2 & M_type==2){case=4} # case4:=(structural break,poor matching)

	
T_type=1
while(T_type<=2){
N_type=1
while(N_type<=2){
n_type=1
while(n_type<=2){

# Sample sizes
if(T_type==1){T0=50}  # shorter pre-intervention duration
if(T_type==2){T0=100} # longer pre-intervention duration
if(N_type==1){N=50}   # smaller number of units
if(N_type==2){N=100}  # larger number of units
if(n_type==1){n=50}   # smaller number of subunits
if(n_type==2){n=100}  # larger number of subunits
T=T0+10               # length of time series

# Matrices to be saved
Mtrx_Trt=matrix(0,T,(R*m))   # Simulated acutal quantial time series
Mtrx_Syn0=matrix(0,T,(R*m))  # Simulated counterfactutal quantial time series (conventional)
Mtrx_Syn=matrix(0,T,(R*m))   # Simulated counterfactutal quantial time series (proposed)

Mtrx_Trt=get(paste0("Trt_",S_type,M_type,T_type,N_type,n_type))
Mtrx_Syn0=get(paste0("Syn0_",S_type,M_type,T_type,N_type,n_type))
Mtrx_Syn=get(paste0("Syn_",S_type,M_type,T_type,N_type,n_type))

RMSPEpre0=matrix(0,R,m)
RMSPEpre=matrix(0,R,m)
Bias0=matrix(0,R,m)
Bias=matrix(0,R,m)

r=1
while(r<=R){
q=1
while(q<=m){
# Pre-intervention MSPEs
RMSPEpre0[r,q]=mean((Mtrx_Trt[1:T0,((r-1)*m+q)]-Mtrx_Syn0[1:T0,((r-1)*m+q)])^2)^0.5
RMSPEpre[r,q]=mean((Mtrx_Trt[1:T0,((r-1)*m+q)]-Mtrx_Syn[1:T0,((r-1)*m+q)])^2)^0.5

# Post-intervention effect 
delta=2*seq(1,T-T0,1)*exp(tau[q])

# Post-intervention effect estimates
deltahat0=Mtrx_Trt[(T0+1):T,((r-1)*m+q)]-Mtrx_Syn0[(T0+1):T,((r-1)*m+q)]
deltahat=Mtrx_Trt[(T0+1):T,((r-1)*m+q)]-Mtrx_Syn[(T0+1):T,((r-1)*m+q)]
Bias0[r,q]=mean(deltahat0/delta-1)
Bias[r,q]=mean(deltahat/delta-1)
q=q+1}
r=r+1}

cat("Case=",case,"T0=",T0,"N=",N,"n=",n,"\n")
cat("RMSPEpre0","RMSPEpre","Bias0","Bias","\n")

rmse=paste0("RMSE",S_type,M_type,T_type,N_type,n_type)
assign(rmse,colMeans(RMSPEpre))
rmse0=paste0("RMSE0",S_type,M_type,T_type,N_type,n_type)
assign(rmse0,colMeans(RMSPEpre0))
bias=paste0("Bias",S_type,M_type,T_type,N_type,n_type)
assign(bias,colMeans(Bias))
bias0=paste0("Bias0",S_type,M_type,T_type,N_type,n_type)
assign(bias0,colMeans(Bias0))

n_type=n_type+1}
N_type=N_type+1}
T_type=T_type+1}
M_type=M_type+1}
S_type=S_type+1}


RMSE11111=get(paste0("RMSE",1,1,1,1,1)); RMSE21111=get(paste0("RMSE",2,1,1,1,1)); 
RMSE11121=get(paste0("RMSE",1,1,1,2,1)); RMSE21121=get(paste0("RMSE",2,1,1,2,1)); 
RMSE11211=get(paste0("RMSE",1,1,2,1,1)); RMSE21211=get(paste0("RMSE",2,1,2,1,1)); 
RMSE11221=get(paste0("RMSE",1,1,2,2,1)); RMSE21221=get(paste0("RMSE",2,1,2,2,1)); 
RMSE12111=get(paste0("RMSE",1,2,1,1,1)); RMSE22111=get(paste0("RMSE",2,2,1,1,1)); 
RMSE12121=get(paste0("RMSE",1,2,1,2,1)); RMSE22121=get(paste0("RMSE",2,2,1,2,1)); 
RMSE12211=get(paste0("RMSE",1,2,2,1,1)); RMSE22211=get(paste0("RMSE",2,2,2,1,1)); 
RMSE12221=get(paste0("RMSE",1,2,2,2,1)); RMSE22221=get(paste0("RMSE",2,2,2,2,1)); 
RMSE11112=get(paste0("RMSE",1,1,1,1,2)); RMSE21112=get(paste0("RMSE",2,1,1,1,2)); 
RMSE11122=get(paste0("RMSE",1,1,1,2,2)); RMSE21122=get(paste0("RMSE",2,1,1,2,2)); 
RMSE11212=get(paste0("RMSE",1,1,2,1,2)); RMSE21212=get(paste0("RMSE",2,1,2,1,2)); 
RMSE11222=get(paste0("RMSE",1,1,2,2,2)); RMSE21222=get(paste0("RMSE",2,1,2,2,2)); 
RMSE12112=get(paste0("RMSE",1,2,1,1,2)); RMSE22112=get(paste0("RMSE",2,2,1,1,2)); 
RMSE12122=get(paste0("RMSE",1,2,1,2,2)); RMSE22122=get(paste0("RMSE",2,2,1,2,2)); 
RMSE12212=get(paste0("RMSE",1,2,2,1,2)); RMSE22212=get(paste0("RMSE",2,2,2,1,2)); 
RMSE12222=get(paste0("RMSE",1,2,2,2,2)); RMSE22222=get(paste0("RMSE",2,2,2,2,2)); 

RMSE011111=get(paste0("RMSE0",1,1,1,1,1)); RMSE021111=get(paste0("RMSE0",2,1,1,1,1));
RMSE011121=get(paste0("RMSE0",1,1,1,2,1)); RMSE021121=get(paste0("RMSE0",2,1,1,2,1));
RMSE011211=get(paste0("RMSE0",1,1,2,1,1)); RMSE021211=get(paste0("RMSE0",2,1,2,1,1));
RMSE011221=get(paste0("RMSE0",1,1,2,2,1)); RMSE021221=get(paste0("RMSE0",2,1,2,2,1));
RMSE012111=get(paste0("RMSE0",1,2,1,1,1)); RMSE022111=get(paste0("RMSE0",2,2,1,1,1));
RMSE012121=get(paste0("RMSE0",1,2,1,2,1)); RMSE022121=get(paste0("RMSE0",2,2,1,2,1));
RMSE012211=get(paste0("RMSE0",1,2,2,1,1)); RMSE022211=get(paste0("RMSE0",2,2,2,1,1));
RMSE012221=get(paste0("RMSE0",1,2,2,2,1)); RMSE022221=get(paste0("RMSE0",2,2,2,2,1));
RMSE011112=get(paste0("RMSE0",1,1,1,1,2)); RMSE021112=get(paste0("RMSE0",2,1,1,1,2));
RMSE011122=get(paste0("RMSE0",1,1,1,2,2)); RMSE021122=get(paste0("RMSE0",2,1,1,2,2));
RMSE011212=get(paste0("RMSE0",1,1,2,1,2)); RMSE021212=get(paste0("RMSE0",2,1,2,1,2));
RMSE011222=get(paste0("RMSE0",1,1,2,2,2)); RMSE021222=get(paste0("RMSE0",2,1,2,2,2));
RMSE012112=get(paste0("RMSE0",1,2,1,1,2)); RMSE022112=get(paste0("RMSE0",2,2,1,1,2));
RMSE012122=get(paste0("RMSE0",1,2,1,2,2)); RMSE022122=get(paste0("RMSE0",2,2,1,2,2));
RMSE012212=get(paste0("RMSE0",1,2,2,1,2)); RMSE022212=get(paste0("RMSE0",2,2,2,1,2));
RMSE012222=get(paste0("RMSE0",1,2,2,2,2)); RMSE022222=get(paste0("RMSE0",2,2,2,2,2));

Bias11111=get(paste0("Bias",1,1,1,1,1)); Bias21111=get(paste0("Bias",2,1,1,1,1));
Bias11121=get(paste0("Bias",1,1,1,2,1)); Bias21121=get(paste0("Bias",2,1,1,2,1));
Bias11211=get(paste0("Bias",1,1,2,1,1)); Bias21211=get(paste0("Bias",2,1,2,1,1));
Bias11221=get(paste0("Bias",1,1,2,2,1)); Bias21221=get(paste0("Bias",2,1,2,2,1));
Bias12111=get(paste0("Bias",1,2,1,1,1)); Bias22111=get(paste0("Bias",2,2,1,1,1));
Bias12121=get(paste0("Bias",1,2,1,2,1)); Bias22121=get(paste0("Bias",2,2,1,2,1));
Bias12211=get(paste0("Bias",1,2,2,1,1)); Bias22211=get(paste0("Bias",2,2,2,1,1));
Bias12221=get(paste0("Bias",1,2,2,2,1)); Bias22221=get(paste0("Bias",2,2,2,2,1));
Bias11112=get(paste0("Bias",1,1,1,1,2)); Bias21112=get(paste0("Bias",2,1,1,1,2));
Bias11122=get(paste0("Bias",1,1,1,2,2)); Bias21122=get(paste0("Bias",2,1,1,2,2));
Bias11212=get(paste0("Bias",1,1,2,1,2)); Bias21212=get(paste0("Bias",2,1,2,1,2));
Bias11222=get(paste0("Bias",1,1,2,2,2)); Bias21222=get(paste0("Bias",2,1,2,2,2));
Bias12112=get(paste0("Bias",1,2,1,1,2)); Bias22112=get(paste0("Bias",2,2,1,1,2));
Bias12122=get(paste0("Bias",1,2,1,2,2)); Bias22122=get(paste0("Bias",2,2,1,2,2));
Bias12212=get(paste0("Bias",1,2,2,1,2)); Bias22212=get(paste0("Bias",2,2,2,1,2));
Bias12222=get(paste0("Bias",1,2,2,2,2)); Bias22222=get(paste0("Bias",2,2,2,2,2));

Bias011111=get(paste0("Bias0",1,1,1,1,1)); Bias021111=get(paste0("Bias0",2,1,1,1,1));
Bias011121=get(paste0("Bias0",1,1,1,2,1)); Bias021121=get(paste0("Bias0",2,1,1,2,1));
Bias011211=get(paste0("Bias0",1,1,2,1,1)); Bias021211=get(paste0("Bias0",2,1,2,1,1));
Bias011221=get(paste0("Bias0",1,1,2,2,1)); Bias021221=get(paste0("Bias0",2,1,2,2,1));
Bias012111=get(paste0("Bias0",1,2,1,1,1)); Bias022111=get(paste0("Bias0",2,2,1,1,1));
Bias012121=get(paste0("Bias0",1,2,1,2,1)); Bias022121=get(paste0("Bias0",2,2,1,2,1));
Bias012211=get(paste0("Bias0",1,2,2,1,1)); Bias022211=get(paste0("Bias0",2,2,2,1,1));
Bias012221=get(paste0("Bias0",1,2,2,2,1)); Bias022221=get(paste0("Bias0",2,2,2,2,1));
Bias011112=get(paste0("Bias0",1,1,1,1,2)); Bias021112=get(paste0("Bias0",2,1,1,1,2));
Bias011122=get(paste0("Bias0",1,1,1,2,2)); Bias021122=get(paste0("Bias0",2,1,1,2,2));
Bias011212=get(paste0("Bias0",1,1,2,1,2)); Bias021212=get(paste0("Bias0",2,1,2,1,2));
Bias011222=get(paste0("Bias0",1,1,2,2,2)); Bias021222=get(paste0("Bias0",2,1,2,2,2));
Bias012112=get(paste0("Bias0",1,2,1,1,2)); Bias022112=get(paste0("Bias0",2,2,1,1,2));
Bias012122=get(paste0("Bias0",1,2,1,2,2)); Bias022122=get(paste0("Bias0",2,2,1,2,2));
Bias012212=get(paste0("Bias0",1,2,2,1,2)); Bias022212=get(paste0("Bias0",2,2,2,1,2));
Bias012222=get(paste0("Bias0",1,2,2,2,2)); Bias022222=get(paste0("Bias0",2,2,2,2,2));

 RMSE11 =cbind( RMSE11111, RMSE11112, RMSE11121, RMSE11122, RMSE11211, RMSE11212, RMSE11221, RMSE11222)
 RMSE12 =cbind( RMSE12111, RMSE12112, RMSE12121, RMSE12122, RMSE12211, RMSE12212, RMSE12221, RMSE12222)
RMSE011 =cbind(RMSE011111,RMSE011112,RMSE011121,RMSE011122,RMSE011211,RMSE011212,RMSE011221,RMSE011222)
RMSE012 =cbind(RMSE012111,RMSE012112,RMSE012121,RMSE012122,RMSE012211,RMSE012212,RMSE012221,RMSE012222)
 Bias11 =cbind( Bias11111, Bias11112, Bias11121, Bias11122, Bias11211, Bias11212, Bias11221, Bias11222)
 Bias12 =cbind( Bias12111, Bias12112, Bias12121, Bias12122, Bias12211, Bias12212, Bias12221, Bias12222)
Bias011 =cbind(Bias011111,Bias011112,Bias011121,Bias011122,Bias011211,Bias011212,Bias011221,Bias011222)
Bias012 =cbind(Bias012111,Bias012112,Bias012121,Bias012122,Bias012211,Bias012212,Bias012221,Bias012222)

 RMSE21 =cbind( RMSE21111, RMSE21112, RMSE21121, RMSE21122, RMSE21211, RMSE21212, RMSE21221, RMSE21222)
 RMSE22 =cbind( RMSE22111, RMSE22112, RMSE22121, RMSE22122, RMSE22211, RMSE22212, RMSE22221, RMSE22222)
RMSE021 =cbind(RMSE021111,RMSE021112,RMSE021121,RMSE021122,RMSE021211,RMSE021212,RMSE021221,RMSE021222)
RMSE022 =cbind(RMSE022111,RMSE022112,RMSE022121,RMSE022122,RMSE022211,RMSE022212,RMSE022221,RMSE022222)
 Bias21 =cbind( Bias21111, Bias21112, Bias21121, Bias21122, Bias21211, Bias21212, Bias21221, Bias21222)
 Bias22 =cbind( Bias22111, Bias22112, Bias22121, Bias22122, Bias22211, Bias22212, Bias22221, Bias22222)
Bias021 =cbind(Bias021111,Bias021112,Bias021121,Bias021122,Bias021211,Bias021212,Bias021221,Bias021222)
Bias022 =cbind(Bias022111,Bias022112,Bias022121,Bias022122,Bias022211,Bias022212,Bias022221,Bias022222)

mtrx11=cbind(RMSE011,RMSE11)
mtrx12=cbind(RMSE012,RMSE12)
mtrx13=cbind(RMSE021,RMSE21)
mtrx14=cbind(RMSE022,RMSE22)

mtrx21=cbind(Bias011,Bias11)
mtrx22=cbind(Bias012,Bias12)
mtrx23=cbind(Bias021,Bias21)
mtrx24=cbind(Bias022,Bias22)

#mtrx1=rbind(mtrx11,mtrx12,mtrx13,mtrx14) 
#mtrx2=rbind(mtrx21,mtrx22,mtrx23,mtrx24) 

# Table A.1 (RMSPEs)
print(round(mtrx11,3))
print(round(mtrx12,3))
print(round(mtrx13,3))
print(round(mtrx14,3))

# Table A.2 (biases)
print(round(mtrx21,3))
print(round(mtrx22,3))
print(round(mtrx23,3))
print(round(mtrx24,3))


#--------------------------------------------------------------
# (3) Compare the actual and estimated intervention effects
#--------------------------------------------------------------
T_type=1
while(T_type<=2){
N_type=1
while(N_type<=2){
n_type=1
while(n_type<=2){
M_type=1
while(M_type<=2){
S_type=1
while(S_type<=2){

if(T_type==1){T0=50}   # shorter pre-intervention duration
if(T_type==2){T0=100}  # longer pre-intervention duration

T=T0+10               # length of time series
Mtrx_Trt=get(paste0("Trt_",S_type,M_type,T_type,N_type,n_type))
Mtrx_Syn0=get(paste0("Syn0_",S_type,M_type,T_type,N_type,n_type))
Mtrx_Syn=get(paste0("Syn_",S_type,M_type,T_type,N_type,n_type))

MtrxTrt=matrix(0,T,m)    # average of the R random draws 
MtrxSyn0=matrix(0,T,m)
MtrxSyn=matrix(0,T,m)
TrueEff=matrix(0,T,m)
EstEff0=matrix(0,T,m)
EstEff=matrix(0,T,m)
q=1
while(q<=m){
MxTrt=matrix(0,T,R)
MxSyn0=matrix(0,T,R)
MxSyn=matrix(0,T,R)
r=1
while(r<=R){
MxTrt[,r]=Mtrx_Trt[,((r-1)*m+q)]
MxSyn0[,r]=Mtrx_Syn0[,((r-1)*m+q)]
MxSyn[,r]=Mtrx_Syn[,((r-1)*m+q)]
r=r+1}
MtrxTrt[,q]=rowMeans(MxTrt)
MtrxSyn0[,q]=rowMeans(MxSyn0)
MtrxSyn[,q]=rowMeans(MxSyn)
TrueEff[,q]=c(rep(0,T0),2*seq(1,T-T0,1))*exp(tau[q])
EstEff0[,q]=MtrxTrt[,q]-MtrxSyn0[,q]
EstEff[,q]=MtrxTrt[,q]-MtrxSyn[,q]
q=q+1}

if(S_type==1 & M_type==1){
TrueEff11=TrueEff
EstEff11=EstEff
EstEff011=EstEff0}

if(S_type==1 & M_type==2){
TrueEff12=TrueEff
EstEff12=EstEff
EstEff012=EstEff0}

if(S_type==2 & M_type==1){
TrueEff21=TrueEff
EstEff21=EstEff
EstEff021=EstEff0}

if(S_type==2 & M_type==2){
TrueEff22=TrueEff
EstEff22=EstEff
EstEff022=EstEff0}

S_type=S_type+1}
M_type=M_type+1}

# Plot the simulated actual and counterfactual time series
# case1:=(no structural break,no poor matching)
# case2:=(no structural break,poor matching)
# case3:=(structural break,no poor matching)
# case4:=(structural break,poor matching)
 mt1=expression("(a) Case1:" ~ tau ~ "=0.1")
 mt2=expression("(b) Case1:" ~ tau ~ "=0.5")
 mt3=expression("(c) Case1:" ~ tau ~ "=0.9")
 mt4=expression("(d) Case2:" ~ tau ~ "=0.1")
 mt5=expression("(e) Case2:" ~ tau ~ "=0.5")
 mt6=expression("(f) Case2:" ~ tau ~ "=0.9")
 mt7=expression("(g) Case3:" ~ tau ~ "=0.1")
 mt8=expression("(h) Case3:" ~ tau ~ "=0.5")
 mt9=expression("(i) Case3:" ~ tau ~ "=0.9")
mt10=expression("(j) Case4:" ~ tau ~ "=0.1")
mt11=expression("(k) Case4:" ~ tau ~ "=0.5")
mt12=expression("(l) Case4:" ~ tau ~ "=0.9")

# Figure 1 & Figures A.1-A.7
{pdf(paste("E:/Research/SyntheticControl/Revision2","/sim",T_type,N_type,n_type,".pdf",sep=""))
par(mfrow=c(4,3),mar=c(2,2,2,2))

# case 1
matplot(cbind(TrueEff11[,3],EstEff11[,3],EstEff011[,3]),main=mt1,type="l",lty=c(1,2,4),col=c(2,4,1),lwd=c(3,3,3),cex=1,xlab=" ",ylab=" ")
legend("topleft",legend=c("actual","proposed","conventional"),lty=c(1,2,4),col=c(2,4,1),lwd=c(3,3,3),bty="n",cex=1,y.intersp=1)
abline(v=T0+1,lty=5,lwd=2,col="darkblue")
matplot(cbind(TrueEff11[,5],EstEff11[,5],EstEff011[,5]),main=mt2,type="l",lty=c(1,2,4),col=c(2,4,1),lwd=c(3,3,3),cex=1,xlab=" ",ylab=" ")
abline(v=T0+1,lty=5,lwd=2,col="darkblue")
matplot(cbind(TrueEff11[,7],EstEff11[,7],EstEff011[,7]),main=mt3,type="l",lty=c(1,2,4),col=c(2,4,1),lwd=c(3,3,3),cex=1,xlab=" ",ylab=" ")
abline(v=T0+1,lty=5,lwd=2,col="darkblue")

# case 2
matplot(cbind(TrueEff12[,3],EstEff12[,3],EstEff012[,3]),main=mt4,type="l",lty=c(1,2,4),col=c(2,4,1),lwd=c(3,3,3),cex=1,xlab=" ",ylab=" ")
abline(v=T0+1,lty=5,lwd=2,col="darkblue")
matplot(cbind(TrueEff12[,5],EstEff12[,5],EstEff012[,5]),main=mt5,type="l",lty=c(1,2,4),col=c(2,4,1),lwd=c(3,3,3),cex=1,xlab=" ",ylab=" ")
abline(v=T0+1,lty=5,lwd=2,col="darkblue")
matplot(cbind(TrueEff12[,7],EstEff12[,7],EstEff012[,7]),main=mt6,type="l",lty=c(1,2,4),col=c(2,4,1),lwd=c(3,3,3),cex=1,xlab=" ",ylab=" ")
abline(v=T0+1,lty=5,lwd=2,col="darkblue")

# case 3
matplot(cbind(TrueEff21[,3],EstEff21[,3],EstEff021[,3]),main=mt7,type="l",lty=c(1,2,4),col=c(2,4,1),lwd=c(3,3,3),cex=1,xlab=" ",ylab=" ")
abline(v=T0+1,lty=5,lwd=2,col="darkblue")
matplot(cbind(TrueEff21[,5],EstEff21[,5],EstEff021[,5]),main=mt8,type="l",lty=c(1,2,4),col=c(2,4,1),lwd=c(3,3,3),cex=1,xlab=" ",ylab=" ")
abline(v=T0+1,lty=5,lwd=2,col="darkblue")
matplot(cbind(TrueEff21[,7],EstEff21[,7],EstEff021[,7]),main=mt9,type="l",lty=c(1,2,4),col=c(2,4,1),lwd=c(3,3,3),cex=1,xlab=" ",ylab=" ")
abline(v=T0+1,lty=5,lwd=2,col="darkblue")

# case 4
matplot(cbind(TrueEff22[,3],EstEff22[,3],EstEff022[,3]),main=mt10,type="l",lty=c(1,2,4),col=c(2,4,1),lwd=c(3,3,3),cex=1,xlab=" ",ylab=" ")
abline(v=T0+1,lty=5,lwd=2,col="darkblue")
matplot(cbind(TrueEff22[,5],EstEff22[,5],EstEff022[,5]),main=mt11,type="l",lty=c(1,2,4),col=c(2,4,1),lwd=c(3,3,3),cex=1,xlab=" ",ylab=" ")
abline(v=T0+1,lty=5,lwd=2,col="darkblue")
matplot(cbind(TrueEff22[,7],EstEff22[,7],EstEff022[,7]),main=mt12,type="l",lty=c(1,2,4),col=c(2,4,1),lwd=c(3,3,3),cex=1,xlab=" ",ylab=" ")
abline(v=T0+1,lty=5,lwd=2,col="darkblue")


par(mfrow=c(1,1))
dev.off()}

n_type=n_type+1}
N_type=N_type+1}
T_type=T_type+1}






