
% This program can be used to compute the coverage probabilities
% reported in Table 5 of Chen and Lee (2017).

clear;

rng(1,'twister');

load data_file;  % replace the filename here with that of the file holding
                 % the output from the Matlab program 'simulation_3endog_MIO'

tau=0.5; % change here for other quantile indices
c=1.2;   % change here for other bandwidth scales

q_tau = norminv(tau);
H_S_ratio = (normpdf(q_tau)^2)/(1+2*q_tau*q_tau);
hn =(1.96^(2/3))*((1.5/N*H_S_ratio)^(1/3));
h_Hall_Sheath=hn*c;
cover=zeros(k,R);

for i=1:R
unobs=mvnrnd(mu,cov,N);
instr =randn(N,k-1);
d1 = normcdf(instr(:,1)+unobs(:,2)); d2 = 2*normcdf(instr(:,2)+unobs(:,3));
d3 = 1.5*normcdf(instr(:,3)+unobs(:,4));
datax=[ones(N,1) d1 d2 d3];
h=datax*gamma;
y=datax*beta + h.*unobs(:,1);
z=[ones(N,1) instr];
e_hat = y-datax*bhat(:,i);
kern =normpdf(e_hat/h_Hall_Sheath)/h_Hall_Sheath;
k_x = repmat(kern,1,k).*datax;
s_hat = sqrt(diag(inv(k_x'*z*inv(z'*z)*z'*k_x)*tau*(1-tau)));
CI=[bhat(:,i)-1.96*s_hat bhat(:,i)+1.96*s_hat];
cover(:,i) = (beta_tau<=CI(:,2))&(beta_tau>=CI(:,1));
end

disp(['Coverage probability of 95% CI for theta(' num2str(tau) ') based on bandwidth rule h = c*Hall_Sheather_bandwidth with c=' num2str(c)]);
disp(mean(cover,2));

