
% This program can be used to reproduce the simulation results reported in 
% Tables 7 and 8 of Chen and Lee (2017) on the performance of the inverse
% QR estimation approach.  

clear;

rng(1,'twister');

N = 100; % sample size
R = 100; % simulation repetitions

beta = ones(4,1);
k=length(beta);
bhat=zeros(k,R);

tau=0.5; % change here for different quantile indices

mu =zeros(1,k);
corr = [0.4 0.6 -0.2];
cov= 0.25*[1 corr;corr' eye(k-1)];

gamma=[0.5;1;0.25;0.15];
beta_tau=beta+norminv(tau,0,sqrt(cov(1,1)))*gamma;

obj_v=zeros(R,1);
rtime=zeros(R,1);
ncount=zeros(R,1);
grid_number=zeros(R,1);

step=0.05; % change here for different step size used in the grid search

for i=1:R
disp(['simulation repetition ' num2str(i)]);
unobs=mvnrnd(mu,cov,N);
instr =randn(N,k-1);
d1 = normcdf(instr(:,1)+unobs(:,2)); d2 = 2*normcdf(instr(:,2)+unobs(:,3));
d3 = 1.5*normcdf(instr(:,3)+unobs(:,4)); 
datax=[ones(N,1) d1 d2 d3];
h=datax*gamma;
y=datax*beta + h.*unobs(:,1);
z=[ones(N,1) instr];
Q=z*inv(z'*z/N)*(z')/(tau*(1-tau));

[b,var] = Two_stage_LS(y,datax,z,1);
bnd=[b-10*sqrt(diag(var)) b+10*sqrt(diag(var))];

grid1 = bnd(2,1):step:bnd(2,2);
grid2 = bnd(3,1):step:bnd(3,2);
grid3 = bnd(4,1):step:bnd(4,2);

grid_number(i)=length(grid1)*length(grid2)*length(grid3);
alpha_grid = zeros(3,grid_number(i));

m=1;
for i1=1:length(grid1)
for i2=1:length(grid2)
for i3=1:length(grid3)

alpha_grid(1,m)=grid1(i1);
alpha_grid(2,m)=grid2(i2);
alpha_grid(3,m)=grid3(i3);

m=m+1;
 
end
end
end

timeval=tic;
[bhat(:,i), obj_v(i)]=inv_qr(y,[d1 d2 d3],ones(N,1),instr,tau,alpha_grid);
rtime(i)=toc(timeval);

end

bias = bhat-repmat(beta_tau,1,R);
disp('mean bias:');disp(mean(bias,2)');
disp('median bias:');disp(median(bias,2)');
disp('RMSE:');disp(sqrt(mean(bias.*bias,2))');
disp('MAE:');disp(median(abs(bias),2)');
disp('standard deviation'); disp((sqrt(mean((bhat-mean(bhat,2)).^2,2)))');
disp('time: mean min median max'); disp([mean(rtime) min(rtime) median(rtime) max(rtime)]); 

