
% This program consists of codes for generating the simulation data used in 
% all the simulation studies of Chen and Lee (2017) on the performance of 
% the MIO based IVQR GMM estimation approach.

clear;

rng(1,'twister');

N = 100; % sample size
R = 100; % simulation repetitions

beta = ones(4,1);
k=length(beta);
bhat=zeros(k,R);

tau=0.25; % change here for different quantile indices

mu =zeros(1,k);
corr = [0.4 0.6 -0.2];
cov= 0.25*[1 corr;corr' eye(k-1)];

gamma=[0.5;1;0.25;0.15];
beta_tau=beta+norminv(tau,0,sqrt(cov(1,1)))*gamma;

gap=zeros(R,1);
rtime=zeros(R,1);
ncount=zeros(R,1);


for i=1:R
disp(['simulation repetition ' num2str(i)]);
unobs=mvnrnd(mu,cov,N);
instr =randn(N,k-1);
d1 = normcdf(instr(:,1)+unobs(:,2)); d2 = 2*normcdf(instr(:,2)+unobs(:,3));
d3 = 1.5*normcdf(instr(:,3)+unobs(:,4)); 
datax=[ones(N,1) d1 d2 d3];
h=datax*gamma;
y=datax*beta + h.*unobs(:,1);
z=[ones(N,1) instr];

[b,var] = Two_stage_LS(y,datax,z,1);
bnd=[b-10*sqrt(diag(var)) b+10*sqrt(diag(var))];
Q=z*inv(z'*z/N)*(z')/(tau*(1-tau));

% Change the last argument in the call to IVQR_MIO for solving alternative MIO
% formulations. See the specification of the function IVQR_MIO.

[bhat(:,i),obj_v(i),gap(i),rtime(i),ncount(i)] = IVQR_MIO(y,datax,Q,tau,3600,0,bnd,1); 
end


bias = bhat-repmat(beta_tau,1,R);
disp('mean bias:');disp(mean(bias,2)');
disp('median bias:');disp(median(bias,2)');
disp('RMSE:');disp(sqrt(mean(bias.*bias,2))');
disp('MAE:');disp(median(abs(bias),2)');
disp('standard deviation'); disp((sqrt(mean((bhat-mean(bhat,2)).^2,2)))');
disp('time: mean min median max'); disp([mean(rtime) min(rtime) median(rtime) max(rtime)]); 

