
% This function can be used to compute the inverse QR estimator of
% Chernozhukov and Hansen (2006). The outer optimization in the inverse QR
% procedure is based on the grid search method

function [bhat, obj_v_min]=inv_qr(y,D,X,Z,tau,alpha_grid)

% X should include intercept
% Z should not include intercept
% alpha_grid: (d by g) matrix of grid points

x = [D,X];
z = [Z,X];

n = size(y,1); % sample size
d = size(D,2); % number of endogenous covariates
k = size(X,2); % number of exogenous covariates

g=size(alpha_grid,2);
betas = zeros(d+k,g);
obj_v = zeros(g,1);
z = [Z,X];

    for i = 1:g
            betas(:,i) = rq(z,y - D*alpha_grid(:,i),tau);
            obj_v(i) = norm([betas(1:d,i)]);
    end
    [obj_v_min, ind] = min(obj_v);
    bhat = [betas(d+1:end,ind);alpha_grid(:,ind)];
end

