
% This program can be used to reproduce the empirical results reported in
% Table 6 of Chen and Lee (2017).

clear;

load fish;

tau=0.75;
n=length(qty);
day_effect = [day1 day2 day3 day4]; 
%x = [ones(n,1) price];
x = [ones(n,1) price day_effect];
%z = [ones(n,1) stormy mixed];
z = [ones(n,1) stormy mixed day_effect];

% Use of the Hall-Sheath bandwidth choice (Koenker 1994)
q_tau = norminv(tau);
H_S_ratio = (normpdf(q_tau)^2)/(1+2*q_tau*q_tau);
h_Hall_Sheath =(1.96^(2/3))*((1.5/n*H_S_ratio)^(1/3));

Q=z*inv(z'*z/n)*(z')/(tau*(1-tau));
k=size(x,2);
b_hat = zeros(k,1);

[b,var] = Two_stage_LS(qty,x,z,1);
bnd=[b-10*sqrt(diag(var)) b+10*sqrt(diag(var))];

[b_hat,s_hat,obj_v,gap,rtime,ncount] = IVQR_GMM(qty,x,z,tau,0,0,bnd);

CI=[b_hat-1.96*s_hat b_hat+1.96*s_hat];

disp(['IVQR estimation at tau = ' num2str(tau)]);
disp('estimated demand elasticity :');
disp(b_hat(2));
disp('estimated standard error of demand elasticity :');
disp(s_hat(2));
disp('95% confidence interval of demand elasticity :');
disp(CI(2,:));



