
% This program can be used to compute the asymptotic standard error
% reported in Table 4 of Chen and Lee (2017).

clear;

rng(1,'twister');

tau=0.5; % change the value of tau for the standard error 
         % calculation at different quantile indices

N = 1000000;

beta = ones(4,1);
k=length(beta);
bhat=zeros(k,1);

mu =zeros(1,k);

corr = [0.4 0.6 -0.2];
cov= 0.25*[1 corr;corr' eye(k-1)];

coef=cov(1,2:end)*inv(cov(2:end,2:end));
sigma = sqrt(cov(1,1) - coef*cov(2:end,1));

gamma=[0.5;1;0.25;0.15];
beta_tau=beta+norminv(tau,0,0.5)*gamma;

unobs=mvnrnd(mu,cov,N);
instr =randn(N,k-1);
d1 = normcdf(instr(:,1)+unobs(:,2)); d2 = 2*normcdf(instr(:,2)+unobs(:,3));
d3 = 1.5*normcdf(instr(:,3)+unobs(:,4)); 
datax=[ones(N,1) d1 d2 d3];
h=datax*gamma;
y=datax*beta + h.*unobs(:,1);
z=[ones(N,1) instr];
X_gamma = datax*gamma;
e0= repmat( (normpdf(norminv(tau,0,0.5),coef*(unobs(:,2:end)'),sigma)./(X_gamma'))',1,k);
X=e0.*datax;
V=inv(X'*z*inv(z'*z)*z'*X)*N*tau*(1-tau);
stderr = sqrt(diag(V/100));

disp(['standard error of theta_hat(' num2str(tau) ') based on asymptotic approximation']);
disp(stderr);
