/*************************************************************
  SOME EXPLORATORY ANALYSIS (NOT IN PAP)
  LOOKING AT PATTERNS OF OVER AND UNDERREACTION
  ANDREW C. CHANG, 7/2021
   

*************************************************************/

clear all
set more off
capture log close

global Work = "d:\high-frequency-forecasts"
global Data "d:\high-frequency-forecasts\Data"

//use "$Data/public/hf_final_allobservations_public.dta", clear
import delimited "$Data/public/hf_final_allobservations_public.csv", clear

*******************************************************************************
** FORCE MINIMUM 1 BP REVISION BETWEEN OBSERVATIONS TO WEED OUT THIN TRADING **
*******************************************************************************

* Drop all observations of < 1 bp revision from previous forecast
foreach var in rgdp pcepilfe {

   preserve
         
   if "`var'"=="rgdp" {
      keep if variable=="GDP"
   }
   else {
      keep if variable=="Core PCE Inflation"
   }
 
   * Only takes two iterations to complete; run through obs twice
   forvalues i = 1/2 {
      *Due to machine precision issues, in the second clause it is < 0.00999 not < 0.01
      drop if !missing(`var'_rev) & abs(`var'_rev)<0.00999 & fore_dist!=0
      replace `var'_rev = `var'_fore-`var'_fore[_n+1] if fore_dist>0
      
   }
      
   tempfile new`var'
   save `new`var''
      
   restore

}

use `newrgdp', clear
append using `newpcepilfe'

generate panelvar = 0
replace panelvar = horizon if variable == "Core PCE Inflation"
replace panelvar = horizon + 4 if variable == "GDP"
//Convert string date into stata format date
generate temp = date(date, "DMY")
format temp %td
drop date
generate date = temp
format date %td
drop temp

xtset panelvar date
 
************************
* Check revison tendencies within FOMC cycle for GDP
************************


keep if variable == "GDP"
replace horizon = 3 if horizon  == -1   //Because using reshape you can't use a hypen in the resulting name
bysort fomc horizon weeks01: egen rgdp_totrev = total(rgdp_rev)  //Total revision within a fomc cycle by weeks01
replace horizon = horizon + 4 if weeks01 == 1  //For use in indexing, so horizon == 4 is nowcasts for weeks01==1
keep fomc horizon rgdp_totrev //date panelvar
duplicates drop
reshape wide rgdp_totrev, i(fomc) j(horizon)

//Convert string fomc into stata format date
generate temp = date(fomc, "DMY")
format temp %td
drop fomc
generate fomc = temp
format fomc %td
drop temp

generate panelvar = 1
xtset panelvar fomc


****
* Correlations of revisions at different horizonz, by near vs. far from FOMC 
****

pwcorr rgdp_totrev3 rgdp_totrev0 rgdp_totrev1 rgdp_totrev2 rgdp_totrev7 rgdp_totrev4 rgdp_totrev5 rgdp_totrev6, sig

summarize rgdp_totrev3 rgdp_totrev0 rgdp_totrev1 rgdp_totrev2 rgdp_totrev7 rgdp_totrev4 rgdp_totrev5 rgdp_totrev6


******
* Looking at whether innovation to either previous quarter or current quarter affects sum of future growth rates
******

* Format is totrev#& where #& indicates the sum of growth rates between horizon # and horizon &
* FAR FROM FOMC
generate rgdp_totrev02 = rgdp_totrev0 + rgdp_totrev1 + rgdp_totrev2
generate rgdp_totrev12 = rgdp_totrev1 + rgdp_totrev2
* NEAR FOMC
generate rgdp_totrev46 = rgdp_totrev4 + rgdp_totrev5 + rgdp_totrev6
generate rgdp_totrev56 = rgdp_totrev5 + rgdp_totrev6

* Regress future forecast revision sum on backcast or current quarter forecast revisions 
* Format is [near/far]_rgdp#_$% for using horizon # to forecast the average in growth rates from horizon $ to %
* FAR FROM FOMC
ivreg2 rgdp_totrev02 rgdp_totrev3, robust bw(12)
eststo far_rgdp3_02
ivreg2 rgdp_totrev12 rgdp_totrev0, robust bw(12)
eststo far_rgdp0_12
* NEAR FOMC
ivreg2 rgdp_totrev46 rgdp_totrev7, robust bw(12)
eststo near_rgdp7_46
ivreg2 rgdp_totrev56 rgdp_totrev4, robust bw(12)
eststo near_rgdp4_56

esttab far_rgdp3_02 far_rgdp0_12 near_rgdp7_46 near_rgdp4_56 ///
using ${Work}/results/latex/nonpap_regs/revisions/rev_rgdp_backtofutureavg.tex, ///
se ar2(2) replace ///
title("Predicting Average Future Horizon Revisions Based on Current or Backcast Revisions"\label{tab:revisionsavgRGDP}) /// 
mlabels(, none) ///
alignment(c) ///
nonumbers ///
nocons ///
collabels(none) ///
coeflabels( /// 
rgdp_totrev3 "\$\Delta \hat y@{GDP,t-1 | I(\tau)=0}\$"  ///
rgdp_totrev0 "\$\Delta \hat y@{GDP,t | I(\tau)=0}\$"  ///
rgdp_totrev7 "\$\Delta \hat y@{GDP,t-1 | I(\tau)=1}\$"  ///
rgdp_totrev4 "\$\Delta \hat y@{GDP,t | I(\tau)=1}\$") /// 
nostar ///
cells("b(fmt(2))" "se(fmt(2) par)" "placeholderrow")  ///
posthead("") ///
substitute(@ _) ///
fragment 	



