
/*************************************************************
   PUBLIC REGRESSION FILE FOR HF PAPER
   TJL, 05/2017

   Final MZ regressions for all variables of interest, in 
   accordance with Pre-Analysis plan finalized on 3/13/17.
   Also includes return-weighted z-scores reacted with
   FOMC dummy.
   

*************************************************************/

clear all
set more off
capture log close

global Data "$Work\Data"

log using ${Work}/results/logs/final/regs_final_public.log, replace

version 13.0

******************************************************* 
* COMBINE HF AND TB-ONLY DATASETS FOR HYPOTHESIS TEST *
* OF COEFFICIENT EQUALITY (CONSTANTS, REVISIONS)      *
*******************************************************

* This dataset has at most one forecast per day, without removing revisions < 1bps
//use "$Data/public/hf_final_allobservations_public.dta"
import delimited "$Data/public/hf_final_allobservations_public.csv"

*******************************************************************************
** FORCE MINIMUM 1 BP REVISION BETWEEN OBSERVATIONS TO WEED OUT THIN TRADING **
*******************************************************************************

* Drop all observations of < 1 bp revision from previous forecast
foreach var in rgdp pcepilfe {

   preserve
         
   if "`var'"=="rgdp" {
      keep if variable=="GDP"
   }
   else {
      keep if variable=="Core PCE Inflation"
   }
 
   * Only takes two iterations to complete; run through obs twice
   forvalues i = 1/2 {
      *Due to machine precision issues, in the second clause it is < 0.00999 not < 0.01
      drop if !missing(`var'_rev) & abs(`var'_rev)<0.00999 & fore_dist!=0
      replace `var'_rev = `var'_fore-`var'_fore[_n+1] if fore_dist>0
      
   }
      
   tempfile new`var'
   save `new`var''
      
   restore

}

use `newrgdp', clear
append using `newpcepilfe'

//Next block of code is to make use of 'append' feature
preserve
clear
import delimited "$Data/public/hf_final_tbonly_public.csv"
save "$Data/public/hf_final_tbonly_public.dta", replace
restore
	
append using "$Data/public/hf_final_tbonly_public.dta", gen(tbonly)


* Assign forecast distance of 1 day to all TB-only obs for equal weighting
replace fore_dist=1 if tbonly==1

* Generate high-frequency dummy
gen hfonly = (tbonly==0)



foreach var in rgdp pcepilfe {

     * Run loop through horizons -1 to 2
     forvalues i==-1/2 {
     
  
	*********************************
	* PRE-ANALYSIS PLAN: EQUATION 1 *
	* Baseline MZ             	*
	*********************************
	
	* Combined regression with HF and TB-only data
	reg `var'_err i.tbonly i.hfonly i.tbonly#c.`var'_rev if horizon==`i' & fore_dist>0 [pweight=fore_dist], nocons
	
	test 1.tbonly = 1.hfonly
	local pVal_HFvsTBOnly_cons = r(p)
	test 0.tbonly#`var'_rev = 1.tbonly#`var'_rev
	local pVal_HFvsTBOnly_rev = r(p)
	
	*parameter estimates and OLS standard errors from TB only regressions
	reg `var'_err `var'_rev if horizon == `i' & fore_dist > 0 & tbonly == 1
	
	*Store OLS parameter estimates from TB only regressions, and p-values from hypothesis tests of equality between HF regs and TB regs
	if `i'<0 {	
	eststo `var'neg1_hf_plus_tbonly, addscalars(pVal_HFvsTBOnly_cons `pVal_HFvsTBOnly_cons' pVal_HFvsTBOnly_rev `pVal_HFvsTBOnly_rev')
	}
	else {
	  eststo `var'`i'_hf_plus_tbonly, addscalars(pVal_HFvsTBOnly_cons `pVal_HFvsTBOnly_cons' pVal_HFvsTBOnly_rev `pVal_HFvsTBOnly_rev')
	}
	
	
    }
    
	*tabulate output for inflation
	if "`var'" == "pcepilfe" {
	
	esttab `var'neg1_hf_plus_tbonly `var'0_hf_plus_tbonly `var'1_hf_plus_tbonly ///
	using ${Work}/results/latex/regs_final/public/`var'_hf_plus_tbonly_public.tex, ///
	se ar2(2) replace scalar("placeholder p-values: " "pVal_HFvsTBOnly_rev \$H_{0}:\$\ High-Frequency Revision = " "placeholder3 Greenbook Revision   " "pVal_HFvsTBOnly_cons \$H_{0}:\$\ High-Frequency Constant = " "placeholder2 Greenbook Constant" ) sfmt(2) ///
	title("Greenbook-Only Inflation Regressions Do Not Show Evidence of Forecast Suboptimality, 2001-2011"\label{TablePcepilfeMZhfplustbonly}) ///
	mlabels(,none) ///
	nonumbers ///
	cons ///
	collabels(none) ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_cons "Constant") ///
	nostar ///
	cells("b(fmt(2))" "se(fmt(2) par)" "placeholderrow")  ///
	posthead("") ///
	fragment ///
	substitute(\_ _) ///
	
	}
	else {
	
	esttab `var'neg1_hf_plus_tbonly `var'0_hf_plus_tbonly `var'1_hf_plus_tbonly `var'2_hf_plus_tbonly ///
	using ${Work}/results/latex/regs_final/public/`var'_hf_plus_tbonly_public.tex, ///
	se ar2(2) replace scalar("placeholder p-values: " "pVal_HFvsTBOnly_rev \$H_{0}:\$\ High-Frequency Revision = " "placeholder3 Greenbook Revision   " "pVal_HFvsTBOnly_cons \$H_{0}:\$\ High-Frequency Constant = " "placeholder2 Greenbook Constant" ) sfmt(2) ///
	title("Greenbook-Only GDP Regressions are Similar to High-Frequency GDP Regressions, 2001-2011"\label{TableRGDPMZhfplustbonly}) ///
	mlabels(,none) ///
	alignment(c) ///
	nonumbers ///
	cons ///
	collabels(none) ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_cons "Constant") ///
	nostar ///
	cells("b(fmt(2))" "se(fmt(2) par)" "placeholderrow")  ///
	posthead("") ///
	fragment ///
	substitute(\_ _) ///
	
	}


}

**********************************************************************
** COMPUTE HIGH-FREQUENCY REGRESSIONS, STORE OUTPUT TO LATEX TABLES **
**********************************************************************

//use "$Data/public/hf_final_allobservations_public.dta", clear
import delimited "$Data/public/hf_final_allobservations_public.csv", clear

*******************************************************************************
** FORCE MINIMUM 1 BP REVISION BETWEEN OBSERVATIONS TO WEED OUT THIN TRADING **
*******************************************************************************

* Drop all observations of < 1 bp revision from previous forecast
foreach var in rgdp pcepilfe {

   preserve
         
   if "`var'"=="rgdp" {
      keep if variable=="GDP"
   }
   else {
      keep if variable=="Core PCE Inflation"
   }
 
   * Only takes two iterations to complete; run through obs twice
   forvalues i = 1/2 {
      *Due to machine precision issues, in the second clause it is < 0.00999 not < 0.01
      drop if !missing(`var'_rev) & abs(`var'_rev)<0.00999 & fore_dist!=0
      replace `var'_rev = `var'_fore-`var'_fore[_n+1] if fore_dist>0
      
   }
      
   tempfile new`var'
   save `new`var''
      
   restore

}

use `newrgdp', clear
append using `newpcepilfe'

generate panelvar = 0
replace panelvar = horizon if variable == "Core PCE Inflation"
replace panelvar = horizon + 4 if variable == "GDP"
//Convert string date into stata format date
generate temp = date(date, "DMY")
format temp %td
drop date
generate date = temp
format date %td
drop temp

xtset panelvar date

foreach var in rgdp pcepilfe {
    	
     disp "var: `var'"
     disp "horizon: `i'"
     local upp = upper("`var'")

     * Run loop through horizons -1 to 2
     
     forvalues i==-1/2 {

        disp "Horizon: `i'"
     
        local j = abs(`i')

	*********************************    
	* PRE-ANALYSIS PLAN: EQUATION 1 *    
	* Baseline MZ                   *
	*********************************
	
	reg `var'_err `var'_rev [pweight=fore_dist] if horizon==`i' & fore_dist>0   
	estat durbinalt, force robust lags(1/12)
	
	if `i'<0 {
  	    eststo `var'neg1_wgt_mz
        }
        else {
            eststo `var'`i'_wgt_mz
        }
	
	  *******************************************    
	  * ROBUSTNESS CHECK: DROP TOP 1% RESIDUALS *
	  *******************************************
	  
	  preserve
	  
	  predict resid if !missing(`var'_rev) & horizon==`i', residuals
	  gen resid_abs = abs(resid)
	  gsort - resid_abs
	  count if !missing(resid_abs)
	  scalar dropobs = floor(0.01*r(N))
	  if dropobs>0 {
		drop in 1/`=dropobs'
	  }
	  
	  reg `var'_err `var'_rev [pweight=fore_dist] if horizon==`i' & fore_dist>0 
	  estat durbinalt, force robust lags(1/12)
	  
	  if `i'<0 {
		eststo `var'neg1_wgt_mz_rob
	  }
	  else {
		eststo `var'`i'_wgt_mz_rob
	  }
	  
	  restore

	*********************************    
	* PRE-ANALYSIS PLAN: EQUATION 2 *    
	* Primary Equation              *
	*********************************
	
	xi: reg `var'_err i.weeks01*`var'_rev [pweight=fore_dist] if horizon==`i' & fore_dist>0
	estat durbinalt, force robust lags(1/12)
	
	if "`var'"=="rgdp" {
	 test _cons + _Iweeks01_1 = 0
	 eret2 scalar pVal_ConsPlusWeeks01 = r(p)
	 test rgdp_rev + _IweeXrgdp__1 = 0
	 eret2 scalar pVal_RevPlusWeeks01 = r(p)
	}
	else {
	 test _cons + _Iweeks01_1 = 0
	 eret2 scalar pVal_ConsPlusWeeks01 = r(p)
	 test pcepilfe_rev + _IweeXpcepi_1 = 0
	 eret2 scalar pVal_RevPlusWeeks01 = r(p)
	}
	
        
	if `i'<0 {
  	    eststo `var'neg1_wgt_mz_w
        }
        else {
            eststo `var'`i'_wgt_mz_w
        }
	
	  *******************************************    
	  * ROBUSTNESS CHECK: DROP TOP 1% RESIDUALS *
	  *******************************************
	  
	  preserve
	  
	  predict resid if !missing(`var'_rev) & horizon==`i', residuals
	  gen resid_abs = abs(resid)
	  gsort - resid_abs
	  count if !missing(resid_abs)
	  scalar dropobs = floor(0.01*r(N))
	  if dropobs>0 {
		disp "yup `i' `var'"
		drop in 1/`=dropobs'
	  }
	  
	  xi: reg `var'_err i.weeks01*`var'_rev [pweight=fore_dist] if horizon==`i' & fore_dist>0
	  estat durbinalt, force robust lags(1/12)
	  
	  if "`var'"=="rgdp" {
	    test _cons + _Iweeks01_1 = 0
	    eret2 scalar pVal_ConsPlusWeeks01 = r(p)
	    test rgdp_rev + _IweeXrgdp__1 = 0
	    eret2 scalar pVal_RevPlusWeeks01 = r(p)
	  }
	  else {
	    test _cons + _Iweeks01_1 = 0
	    eret2 scalar pVal_ConsPlusWeeks01 = r(p)
	    test pcepilfe_rev + _IweeXpcepi_1 = 0
	    eret2 scalar pVal_RevPlusWeeks01 = r(p)
	  }
        
	  if `i'<0 {
  	    eststo `var'neg1_wgt_mz_w_rob
          }
          else {
            eststo `var'`i'_wgt_mz_w_rob
          }
	  
	  restore

	**********************************    
	* PRE-ANALYSIS PLAN: EQUATION 3  *    
	* Alternate Equation, w/ z-Score *
	**********************************
		
	xi: reg `var'_err i.weeks01*`var'_rev i.weeks01|zscorexreturn [pweight=fore_dist] if horizon==`i' & fore_dist>0 
	estat durbinalt, force robust lags(1/12)
	
	if "`var'"=="rgdp" {
	 test _cons + _Iweeks01_1 = 0
	 eret2 scalar pVal_ConsPlusWeeks01 = r(p)
	 test rgdp_rev + _IweeXrgdp__1 = 0
	 eret2 scalar pVal_RevPlusWeeks01 = r(p)
	 test zscorexreturn + _IweeXzscor_1 = 0
	 eret2 scalar pVal_zScorePlusWeeks01 = r(p)	 
	}
	else {
	 test _cons + _Iweeks01_1 = 0
	 eret2 scalar pVal_ConsPlusWeeks01 = r(p)
	 test pcepilfe_rev + _IweeXpcepi_1 = 0
	 eret2 scalar pVal_RevPlusWeeks01 = r(p)
	 test zscorexreturn + _IweeXzscor_1 = 0
	 eret2 scalar pVal_zScorePlusWeeks01 = r(p)	 
	}	 
	 
	if `i'<0 {
  	    eststo `var'neg1_wgt_mz_wr
        }
        else {
            eststo `var'`i'_wgt_mz_wr
        }

	
	  *******************************************    
	  * ROBUSTNESS CHECK: DROP TOP 1% RESIDUALS *
	  *******************************************
	  
	  preserve
	  
	  predict resid if !missing(`var'_rev) & horizon==`i', residuals
	  gen resid_abs = abs(resid)
	  gsort - resid_abs
	  count if !missing(resid_abs)
	  scalar dropobs = floor(0.01*r(N))
	  if dropobs>0 {
		drop in 1/`=dropobs'	
	  }
	  
	  xi: reg `var'_err i.weeks01*`var'_rev i.weeks01|zscorexreturn [pweight=fore_dist] if horizon==`i' & fore_dist>0 
	  estat durbinalt, force robust lags(1/12)
	  
	  if "`var'"=="rgdp" {
	    test _cons + _Iweeks01_1 = 0
	    eret2 scalar pVal_ConsPlusWeeks01 = r(p)
	    test rgdp_rev + _IweeXrgdp__1 = 0
	    eret2 scalar pVal_RevPlusWeeks01 = r(p)
	    test zscorexreturn + _IweeXzscor_1 = 0
	    eret2 scalar pVal_zScorePlusWeeks01 = r(p)	 
	  }
	  else {
	    test _cons + _Iweeks01_1 = 0
	    eret2 scalar pVal_ConsPlusWeeks01 = r(p)
	    test pcepilfe_rev + _IweeXpcepi_1 = 0
	    eret2 scalar pVal_RevPlusWeeks01 = r(p)
	    test zscorexreturn + _IweeXzscor_1 = 0
	    eret2 scalar pVal_zScorePlusWeeks01 = r(p)	 
	  }	 
	 
	  if `i'<0 {
  	    eststo `var'neg1_wgt_mz_wr_rob
          }
          else {
            eststo `var'`i'_wgt_mz_wr_rob
          }
	  
	  restore
	  
    }
    
	************************************************************************
	* POST TABLES TO LATEX (SEPARATE TABLE FOR EACH VARIABLE AND EQUATION) *
	************************************************************************
	
	if "`var'"=="rgdp" {

	
	
	* BASELINE MZ OUTPUT *
	
	esttab `var'neg1_wgt_mz `var'0_wgt_mz `var'1_wgt_mz `var'2_wgt_mz ///
	using ${Work}/results/latex/regs_final/public/`var'_mz_public.tex, ///
	se ar2(2) replace ///
	title("Current Quarter GDP Forecasts Underrevised," "Further Ahead GDP Forecasts Were Too High from 2001-2011"\label{TableRGDPMZ}) /// 
	mlabels(, none) ///
	alignment(c) ///
	nonumbers ///
	cons ///
	collabels(none) ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_cons "Constant") /// 
	nostar ///
	cells("b(fmt(2))" "se(fmt(2) par)" "placeholderrow")  ///
	posthead("") ///
	fragment ///

	
	* BASELINE MZ, ROBUSTNESS CHECK OUTPUT *
	esttab `var'neg1_wgt_mz_rob `var'0_wgt_mz_rob `var'1_wgt_mz_rob `var'2_wgt_mz_rob ///
	using ${Work}/results/latex/regs_final/public/`var'_mz_robust_public.tex, ///
	se ar2(2) replace ///
	title("Outliers Have Little Effect on Average Inference of GDP Forecast Optimality, 2001-2011"\label{TableRGDPMZRob}) ///
	mlabels(, none) ///
	alignment(c) ///
	nonumbers ///
	cons ///
	collabels(none) ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_cons "Constant") ///
	nostar ///
	cells("b(fmt(2))" "se(fmt(2) par)" "placeholderrow")  ///
	posthead("") ///
	fragment ///
	
	* MZ WITH WEEKS01 (notation I(Tau)) OUTPUT*
	esttab `var'neg1_wgt_mz_w `var'0_wgt_mz_w `var'1_wgt_mz_w `var'2_wgt_mz_w ///
	using ${Work}/results/latex/regs_final/public/`var'_mz_w_public.tex, ///
	se ar2(2) replace scalars("placeholderrow p-values: ""pVal_ConsPlusWeeks01 \$H_{0}:\$\ Constant + \$I(\tau)\$ = 0" "pVal_RevPlusWeeks01 \$H_{0}:\$\ Revision + \$I(\tau) \times\$Revision = 0") sfmt(2) ///
	title("GDP Forecasts Made More than Two Weeks from a FOMC Meeting May Be Inefficient"\label{TableRGDPMZWeeks01}) ///
	mlabels("-1" "0" "1" "2", lhs("Forecast Horizon")) ///
	cons ///
	collabels(none) ///
	nonumbers ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_Iweeks01_1 "\$I(\tau)\$" ///
	_IweeXrgdp__1 "\$I(\tau) \times\$Revision" ///
	_cons "Constant") ///
	nostar ///
	cells("b(fmt(2))" "se(fmt(2) par)" "placeholderrow") ///
	fragment ///
	substitute(\_ _) ///


	
	* MZ WITH WEEKS01, ROBUSTNESS CHECK OUTPUT *
	esttab `var'neg1_wgt_mz_w_rob `var'0_wgt_mz_w_rob `var'1_wgt_mz_w_rob `var'2_wgt_mz_w_rob ///
	using ${Work}/results/latex/regs_final/public/`var'_mz_w_robust_public.tex, ///
	se ar2(2) replace scalars("placeholderrow p-values: ""pVal_ConsPlusWeeks01 \$H_{0}:\$\ Constant + \$I(\tau)\$ = 0" "pVal_RevPlusWeeks01 \$H_{0}:\$\ Revision + \$I(\tau) \times\$Revision = 0") sfmt(2) ///
	title("Outliers Also Have Little Effect on Inference on Time-Varying GDP Forecast Optimality, 2001-2011"\label{TableRGDPMZWeeks01Rob}) ///
	mlabels("-1" "0" "1" "2", lhs("Forecast Horizon")) ///
	cons ///
	collabels(none) ///
	nonumbers ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_Iweeks01_1 "\$I(\tau)\$" ///
	_IweeXrgdp__1 "\$I(\tau) \times\$Revision" ///
	_cons "Constant") ///
	nostar ///
	cells("b(fmt(2))" "se(fmt(2) par)" "placeholderrow") ///
	fragment ///
	substitute(\_ _) ///
	
	* MZ WITH WEEKS01 & ZSCOREXRETURN OUTPUT*
	
	esttab `var'neg1_wgt_mz_wr `var'0_wgt_mz_wr `var'1_wgt_mz_wr `var'2_wgt_mz_wr ///
	using ${Work}/results/latex/regs_final/public/`var'_mz_wr_public.tex, ///
	se ar2(2) replace /// 
	title("Previous Bloomberg Forecast Errors Predict the Staff's GDP Forecast Errors, 2001-2011"\label{TableRGDPMZWeeks01}) ///
	mlabels("-1" "0" "1" "2", lhs("Forecast Horizon")) ///
	cons ///
	collabels(none) ///
	nonumbers ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_Iweeks01_1 "\$I(\tau)\$" ///
	_IweeXrgdp__1 "\$I(\tau) \times\$Revision" ///
	zscorexreturn "\$news@\tau\$" ///
	_IweeXzscor_1 "\$I(\tau) \times news@\tau\$" ///
	_cons "Constant") ///
	nostar ///
	cells("b(fmt(2))" "se(fmt(2) par)" "placeholderrow") ///
	scalars("placeholderrow p-values: ""pVal_ConsPlusWeeks01 \$H@{0}:\$\ Constant + \$I(\tau)\$ = 0" "pVal_RevPlusWeeks01 \$H@{0}:\$\ Revision + \$I(\tau) \times\$Revision = 0" "pVal_zScorePlusWeeks01 \$H@{0}:\$\ \$news@\tau\$  + \$I(\tau) \times news@\tau\$ = 0") sfmt(2) ///
	substitute(@ _) ///
	fragment ///

	
	
	* MZ WITH WEEKS01 & ZSCOREXRETURN, ROBUSTNESS CHECK OUTPUT *
	esttab `var'neg1_wgt_mz_wr_rob `var'0_wgt_mz_wr_rob `var'1_wgt_mz_wr_rob `var'2_wgt_mz_wr_rob ///
	using ${Work}/results/latex/regs_final/public/`var'_mz_wr_robust_public.tex, ///
	se ar2(2) replace  ///
	title("Outliers Also Have Little Effect on Inference on Predictability of the Staff's GDP Forecast Errors Using Bloomberg Forecast Errors, 2001-2011"\label{TableRGDPZscoreRob}) ///
	mlabels("-1" "0" "1" "2", lhs("Forecast Horizon")) ///
	cons ///
	collabels(none) ///
	nonumbers ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_Iweeks01_1 "\$I(\tau)\$" ///
	_IweeXrgdp__1 "\$I(\tau) \times\$Revision" ///
	zscorexreturn "\$news@\tau\$" ///
	_IweeXzscor_1 "\$I(\tau) \times news@\tau\$" ///
	_cons "Constant") ///
	nostar ///
	cells("b(fmt(2))" "se(fmt(2) par)" "placeholderrow") ///
	scalars("placeholderrow p-values: ""pVal_ConsPlusWeeks01 \$H@{0}:\$\ Constant + \$I(\tau)\$ = 0" "pVal_RevPlusWeeks01 \$H@{0}:\$\ Revision + \$I(\tau) \times\$Revision = 0" "pVal_zScorePlusWeeks01 \$H@{0}:\$\ \$news@\tau\$  + \$I(\tau) \times news@\tau\$ = 0") sfmt(2) ///
	substitute(@ _) ///
	fragment ///
	
	}
	
	else {


	* BASELINE MZ OUTPUT * 
	esttab `var'neg1_wgt_mz `var'0_wgt_mz `var'1_wgt_mz ///
	using ${Work}/results/latex/regs_final/public/`var'_mz_public.tex, ///
	se ar2(2) replace ///
	title("Inflation Forecasts, On Average, Overrevised, 2001-2011"\label{TablePcepilfeMZ}) /// 
	mlabels(,none) ///
	alignment(c) ///
	nonumbers ///
	cons ///
	collabels(none) ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_cons "Constant") /// 
	nostar ///
	cells("b(fmt(2))" "se(fmt(2) par)" "placeholderrow")  ///
	posthead("") ///
	fragment ///
	
	
	* BASELINE MZ, ROBUSTNESS CHECK OUTPUT *
	esttab `var'neg1_wgt_mz_rob `var'0_wgt_mz_rob `var'1_wgt_mz_rob ///
	using ${Work}/results/latex/regs_final/public/`var'_mz_robust_public.tex, ///
	se ar2(2) replace ///
	title("Outliers Have Little effect on Average Inference on Inflation Forecast Optimality, 2001-2011"\label{TablePcepilfeMZRob}) ///
	mlabels(,none) ///
	alignment(c) ///
	nonumbers ///
	cons ///
	collabels(none) ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_cons "Constant") /// 
	nostar ///
	cells("b(fmt(2))" "se(fmt(2) par)" "placeholderrow")  ///
	posthead("") ///
	fragment ///
	
	* For Core PCE Inflation, We Are Only Looking at Horizons from t=-1 to t=+1

	
	* MZ WITH WEEKS01 (notation I(Tau)) OUTPUT*
	esttab `var'neg1_wgt_mz_w `var'0_wgt_mz_w `var'1_wgt_mz_w ///
	using ${Work}/results/latex/regs_final/public/`var'_mz_w_public.tex, ///
	se ar2(2) replace scalars("placeholderrow p-values: ""pVal_ConsPlusWeeks01 \$H_{0}:\$\ Constant + \$I(\tau)\$ = 0" "pVal_RevPlusWeeks01 \$H_{0}:\$\ Revision + \$I(\tau) \times\$Revision = 0") sfmt(2) ///
	title("Inflation Forecasts Made Within Two Weeks of a FOMC Meeting Overrevised, 2001-2011"\label{TablePcepilfeMZWeeks01}) ///
	mlabels("-1" "0" "1" "2", lhs("Forecast Horizon")) ///
	cons ///
	collabels(none) ///
	nonumbers ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_Iweeks01_1 "\$I(\tau)\$" ///
	_IweeXpcepi_1 "\$I(\tau) \times\$Revision" ///
	_cons "Constant") ///
	nostar ///
	cells("b(fmt(2))" "se(fmt(2) par)" "placeholderrow") ///
	fragment ///
	substitute(\_ _) ///
	
	
	* MZ WITH WEEKS01, ROBUSTNESS CHECK OUTPUT *
	esttab `var'neg1_wgt_mz_w_rob `var'0_wgt_mz_w_rob `var'1_wgt_mz_w_rob ///
	using ${Work}/results/latex/regs_final/public/`var'_mz_w_robust_public.tex, ///
	se ar2(2) replace scalars("placeholderrow p-values: ""pVal_ConsPlusWeeks01 \$H_{0}:\$\ Constant + \$I(\tau)\$ = 0" "pVal_RevPlusWeeks01 \$H_{0}:\$\ Revision + \$I(\tau) \times\$Revision = 0") sfmt(2) ///
	title("Outliers Have Little Effect on Inference on Time-Varying Inflation Forecast Optimality, 2001-2011"\label{TablePcepilfeMZWeeks01Rob}) ///
	mlabels("-1" "0" "1", lhs("Forecast Horizon")) ///
	cons ///
	collabels(none) ///
	nonumbers ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_Iweeks01_1 "\$I(\tau)\$" ///
	_IweeXpcepi_1 "\$I(\tau) \times\$Revision" ///
	_cons "Constant") ///
	nostar ///
	cells("b(fmt(2))" "se(fmt(2) par)" "placeholderrow") ///
	fragment ///
	substitute(\_ _) ///
	

	* MZ WITH WEEKS01 & ZSCOREXRETURN OUTPUT, NW std errors *
	
	esttab `var'neg1_wgt_mz_wr `var'0_wgt_mz_wr `var'1_wgt_mz_wr ///
	using ${Work}/results/latex/regs_final/public/`var'_mz_wr_public.tex, ///
	se ar2(2) replace /// 
	title("Previous Bloomberg Forecast Errors Predict the Staff's Inflation Forecast Errors, 2001-2011"\label{TablePcepilfeMZWeeks01Zscore}) ///
	mlabels("-1" "0" "1", lhs("Forecast Horizon")) ///
	cons ///
	collabels(none) ///
	nonumbers ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_Iweeks01_1 "\$I(\tau)\$" ///
	_IweeXpcepi_1 "\$I(\tau) \times\$Revision" ///
	zscorexreturn "\$news@\tau\$" ///
	_IweeXzscor_1 "\$I(\tau) \times news@\tau\$" ///
	_cons "Constant") ///
	nostar ///
	cells("b(fmt(2))" "se(fmt(2) par)" "placeholderrow") ///
	scalars("placeholderrow p-values: ""pVal_ConsPlusWeeks01 \$H@{0}:\$\ Constant + \$I(\tau)\$ = 0" "pVal_RevPlusWeeks01 \$H@{0}:\$\ Revision + \$I(\tau) \times\$Revision = 0" "pVal_zScorePlusWeeks01 \$H@{0}:\$\ \$news@\tau\$  + \$I(\tau) \times news@\tau\$ = 0") sfmt(2) ///
	substitute(@ _) ///
	fragment ///

	* MZ WITH WEEKS01 & ZSCOREXRETURN, ROBUSTNESS CHECK OUTPUT *
	esttab `var'neg1_wgt_mz_wr_rob `var'0_wgt_mz_wr_rob `var'1_wgt_mz_wr_rob  ///
	using ${Work}/results/latex/regs_final/public/`var'_mz_wr_robust_public.tex, ///
	se ar2(2) replace ///
	title("Outliers Also Have Little Effect on Inference on Predictability of the Staff's Inflation Forecast Errors Using Bloomberg Forecast Errors, 2001-2011"\label{TablePcepilfeZscoreRob}) ///
	mlabels("-1" "0" "1", lhs("Forecast Horizon")) ///
	cons ///
	collabels(none) ///
	nonumbers ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_Iweeks01_1 "\$I(\tau)\$" ///
	_IweeXpcepi_1 "\$I(\tau) \times\$Revision" ///
	zscorexreturn "\$news@\tau\$" ///
	_IweeXzscor_1 "\$I(\tau) \times news@\tau\$" ///
	_cons "Constant") ///
	nostar ///
	cells("b(fmt(2))" "se(fmt(2) par)" "placeholderrow") ///
	scalars("placeholderrow p-values: ""pVal_ConsPlusWeeks01 \$H@{0}:\$\ Constant + \$I(\tau)\$ = 0" "pVal_RevPlusWeeks01 \$H@{0}:\$\ Revision + \$I(\tau) \times\$Revision = 0" "pVal_zScorePlusWeeks01 \$H@{0}:\$\ \$news@\tau\$  + \$I(\tau) \times news@\tau\$ = 0") sfmt(2) ///
	substitute(@ _) ///
	fragment ///

	}	

}



*********************************************************************
** COMPUTE TEALBOOK-ONLY REGRESSIONS, STORE OUTPUT TO LATEX TABLES **
*********************************************************************

use "$Data/public/hf_final_tbonly_public.dta", clear

foreach var in rgdp pcepilfe {
    	
     disp "var: `var'"
     disp "horizon: `i'"
     local upp = upper("`var'")

     * Run loop through horizons -1 to 2
     
     forvalues i==-1/2 {

        disp "Horizon: `i'"
     
        local j = abs(`i')
		
		
	*********************************    
	* PRE-ANALYSIS PLAN: EQUATION 1 *    
	* Baseline MZ                   *
	*********************************
	
	reg `var'_err `var'_rev if horizon==`i'    
	
	if `i'<0 {
  	    eststo `var'neg1_mz_tbonly
        }
        else {
            eststo `var'`i'_mz_tbonly
        }	
	

	
	
	  *******************************************    
	  * ROBUSTNESS CHECK: DROP TOP 1% RESIDUALS *
	  *******************************************
	  
	  preserve
	  
	  predict resid if !missing(`var'_rev) & horizon==`i', residuals
	  gen resid_abs = abs(resid)
	  gsort - resid_abs
	  count if !missing(resid_abs)
	  scalar dropobs = floor(0.01*r(N))
	  if dropobs>0 {
		drop in 1/`=dropobs'	
	  }
	  
	  reg `var'_err `var'_rev if horizon==`i'   
	 
	  if `i'<0 {
  	    eststo `var'neg1_mz_tbonly_rob
          }
          else {
            eststo `var'`i'_mz_tbonly_rob
          }
	  
	  restore
	
    }
    
	************************************************************************
	* POST TABLES TO LATEX (SEPARATE TABLE FOR EACH VARIABLE AND EQUATION) *
	************************************************************************
		
	if "`var'"=="rgdp" {
	
	* BASELINE MZ OUTPUT *
	esttab `var'neg1_mz_tbonly `var'0_mz_tbonly `var'1_mz_tbonly `var'2_mz_tbonly ///
	using ${Work}/results/latex/regs_final/public/`var'_mz_tbonly_public.tex, ///
	se ar2(2) replace ///
	title("Greenbook-Only GDP Regressions Are Similar to Between-Greenbook GDP Regressions, 2001-2011"\label{TableRGDPMZtbonly}) ///
	mtitles(  ///
	"Backcast" ///
	"Current Quarter" ///
	"One Quarter Ahead" ///
	"Two Quarters Ahead" ///
	) cons ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_cons "Constant") ///
	nostar ///
	b(a2) ///
	t(a2) ///
	
	* ROBUSTNESS CHECK *
	
	esttab `var'neg1_mz_tbonly_rob `var'0_mz_tbonly_rob `var'1_mz_tbonly_rob `var'2_mz_tbonly_rob ///
	using ${Work}/results/latex/regs_final/public/`var'_mz_tbonly_rob_public.tex, ///
	se ar2(2) replace ///
	title("`upp' Baseline MZ: Tealbooks Only, Robustness Check, Public Only"\label{tableRGDPMZtbonlyrob}) ///
	mtitles(  ///
	"Backcast" ///
	"Current Quarter" ///
	"One Quarter Ahead" ///
	"Two Quarters Ahead" ///
	) cons ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_cons "Constant") ///
	nostar ///
	b(a2) ///
	t(a2) ///
	
	}
	
	else {
	
	*Restricting horizons from t=-1 to t=+1 for core PCE inflation
	
	* BASELINE MZ OUTPUT *
	esttab `var'neg1_mz_tbonly `var'0_mz_tbonly `var'1_mz_tbonly ///
	using ${Work}/results/latex/regs_final/public/`var'_mz_tbonly_public.tex, ///
	se ar2(2) replace ///
	title("Greenbook-Only Inflation Regressions Do Not Show Evidence of Forecast Suboptimality, 2001-2011"\label{TablePcepilfeMZtbonly}) ///
	mtitles(  ///
	"Backcast" ///
	"Current Quarter" ///
	"One Quarter Ahead" ///
	) cons ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_cons "Constant") ///
	nostar ///
	b(a2) ///
	t(a2) ///
	
	* ROBUSTNESS CHECK *
	
	esttab `var'neg1_mz_tbonly_rob `var'0_mz_tbonly_rob `var'1_mz_tbonly_rob ///
	using ${Work}/results/latex/regs_final/public/`var'_mz_tbonly_rob_public.tex, ///
	se ar2(2) replace ///
	title("`upp' Baseline MZ: Tealbooks Only, Robustness Check, Public Only"\label{TablePcepilfeMZtbonlyrob}) ///
	mtitles(  ///
	"Backcast" ///
	"Current Quarter" ///
	"One Quarter Ahead" ///
	) cons ///
	coeflabels( ///
	`var'_rev "Revision" ///
	_cons "Constant") ///
	nostar ///
	b(a2) ///
	t(a2) ///
	
	}

}

**********************************************************************
** COMPUTE HIGH-FREQUENCY SUMMARY STATS, TEST FOR BIAS (NOT IN PAP), STORE OUTPUT TO LATEX TABLES **
**********************************************************************

global Work = "d:\high-frequency-forecasts"
global Data "d:\high-frequency-forecasts\Data"
clear all

//use "$Data/public/hf_final_allobservations_public.dta", clear
import delimited "$Data/public/hf_final_allobservations_public.csv", clear
//Do not remove <1bps revision from summary stats table


generate panelvar = 0
replace panelvar = horizon if variable == "Core PCE Inflation"
replace panelvar = horizon + 4 if variable == "GDP"
//Convert string date into stata format date
generate temp = date(date, "DMY")
format temp %td
drop date
generate date = temp
format date %td
drop temp

xtset panelvar date
sort variable
//use eret2 before eststo

foreach var in rgdp pcepilfe {

	forvalues i==-1/2 {
	
		if `i' == -1{
		generate `var'_err_neg1 = `var'_err if horizon == -1
		}
		else {
		generate `var'_err_`i' = `var'_err if horizon == `i'
		}
	
	}
	summarize rgdp_err 
	
	if  "`var'"=="rgdp" {
	summarize rgdp_err 
	
	eststo GDP: quietly estpost summarize ///
	`var'_err_neg1 `var'_err_0 `var'_err_1 `var'_err_2 
	
	esttab GDP using "${Work}/results/latex/regs_final/public/summary_stats/temp_`var'_sumstats.tex", replace ///
	cells("mean(pattern(1 1) fmt(2)) sd(pattern(1 1))" "min(pattern(1 1))" "max(pattern(1 1))" "count") ///
	label 
	}
	else {
	eststo Inflation: quietly estpost summarize ///
	`var'_err_neg1 `var'_err_0 `var'_err_1 `var'_err_2 
	
	esttab Inflation using "${Work}/results/latex/regs_final/public/summary_stats/temp_`var'_sumstats.tex", replace ///
	cells("mean(pattern(1 1) fmt(2)) sd(pattern(1 1) fmt(%10.2f))" "min(pattern(1 1) fmt(2))" "max(pattern(1 1) fmt(2))" "count") ///
	label 
	
	}
	

	
	matrix list r(coefs)
	matrix rename r(coefs) `var'_tempcoefs
	matrix list `var'_tempcoefs

	local rows = rowsof(`var'_tempcoefs)
	local columns = colsof(`var'_tempcoefs)
	
	forvalues i==1/`rows' {

		forvalues j==1/`columns' {
		
			matrix `var'_tempcoefs[`i',`j'] = round(`var'_tempcoefs[`i',`j'],0.01)
		
		}
	
	}
	
	matrix list `var'_tempcoefs
	
	esttab matrix(`var'_tempcoefs, transpose) using "${Work}/results/latex/regs_final/public/summary_stats/`var'_sumstats.tex", replace ///
	posthead("")  ///
	collabels(none) ///
	mlabels(,none) ///
	coeflabels(mean "Mean" sd "Std. Dev." min "Min." max "Max." count "N. Obs.") ///
	nonumbers ///
	nomtitles ///
	nodepvars ///
	nonotes ///
	fragment
	
}
	
	
log close

