
/*************************************************************
  This is the master Stata file for 
  "Raiders of the Lost High Frequency Forecasts: New Data and Evidence on the Efficiency of the Fed's Forecasting"
  Runs regs, charts, for public consumption.
  
  TJL, 03/20/2017
  
  Modified by Andrew C. Chang, Board of Governors of the Federal Reserve System, a.christopher.chang@gmail.com
  ORCID: 0000-0002-9769-789X
  
  This version: April 7, 2022
  
  Stata 13.0 (Linux or Windows)
  Expected estimation time: less than 10 minutes
  Required packages: eret2, estadd, estout, estpost, eststo, esttab, ivreg2, ranktest
*************************************************************/

clear all
set more off
global version = "13.0"

version ${version}
*set trace off

* Set work paths
global Work = "d:/high-frequency-forecasts"
global ado = "$Work/ado"
sysdir set PERSONAL "$ado/personal"
sysdir set PLUS "$ado/plus"
global Code = "$Work/Code/public"


* Run PAP regressions for paper
do "$Code/regs_final_public.do"

* Charts
do "$Code/figures_forecastplots.do"

* Non PAP regressions, on forecast smoothing
do "$Code/trendvsgrowth.do"

* Non PAP regs, clustered and newey
do "$Code/regs_final_public_clusteredstderr"

* Non PAP regs, using all observations (including those forecast revisions that are <1bps apart)
do "$Code/regs_final_public_allobs.do"

* Non PAP, RMSEs of univariate models 
do "$Code/UnivariatemodelandHFcompareGDP.do"
do "$Code/UnivariatemodelandHFcompareInflation.do"

* Non PAP, Testing asymmetric loss (quadquad)
do "$Code/asymmetricloss.do"

* Non PAP, using fixed event (Nordhaus 1987) type tests
do "$Code/regs_final_public_fixed_event.do"

* Compare SPF to HF forecasts
do "$Code/SPFandHFcompare.do"


cd ${Code}
!chmod 775 *.do

