
/*************************************************************
   Comparison of Univariate Models to HF Forecasts (Inflation)
   
   	Andrew C. Chang, March 24, 2022
	Board of Governors of the Federal Reserve System, a.christopher.chang@gmail.com
	ORCID: 0000-0002-9769-789X
   

*************************************************************/

clear all
set more off
capture log close

global Data "$Work\Data"
*global DataModified "d:\high-frequency-forecasts\Data - Modified\SPF"
global Charts "$Work/Figures"

local startqtr 143  //start of estimation sample, 1995:Q4
local endqtr 163    //end of estimation sample, 2000:Q4

log using ${Work}/results/logs/final/UnivariatemodelandHFcompareInflation.log, replace

version 13.0

import excel using "$Data/Real-time data/pconx_first_second_third.xlsx", firstrow sheet("DATA") cellrange(A5:D109) clear

keep Date Third
rename Third pcepilfe_3rd

* Stata format date
generate dateqtr = quarterly(Date,"YQ")
drop Date

tsset dateqtr

* Estimate AR(1), AR(4) models using 1986:Q1 - 2000:Q4 (Stata format quarters 104-163)
drop if dateqtr < `startqtr'


* AR(1)
*Univariate model in quarter t would have the 3rd BEA release from t-2
*So the AR(1) nowcast is a two step ahead prediction of the reg, the backcast is the one quarter ahead prediction 
regress L.pcepilfe_3rd L2.pcepilfe_3rd if dateqtr <= `endqtr', hc3
predict ar1_neg1  //Gives optimal linear prediction for the backcast

//Optimal prediction for the nowcast is two step ahead, so take the previous prediction * beta + alpha
matrix ar1coefficients = e(b)  //[1,1] is beta, [1,2] is alpha
scalar beta1 = ar1coefficients[1,1]
scalar alpha1 = ar1coefficients[1,2]
generate ar1_0 = ar1_neg1*beta1 + alpha1 //current quarter prediction
generate ar1_1 = ar1_0*beta1 + alpha1 //one quarter ahead prediction
*generate ar1_2 = ar1_1*beta1 + alpha1 //two quarter ahead prediction

* AR(4)
regress L.pcepilfe_3rd L(2/5).pcepilfe_3rd if dateqtr <= `endqtr', hc3
predict ar4_neg1
	
//Optimal prediction for the nowcast is two step ahead, so take the previous prediction * beta + alpha
matrix ar1coefficients = e(b)  //[1,1] to [1,4] is beta1 to beta4, [1,5] is alpha
scalar beta1 = ar1coefficients[1,1]
scalar beta2 = ar1coefficients[1,2]
scalar beta3 = ar1coefficients[1,3]
scalar beta4 = ar1coefficients[1,4]
scalar alpha1 = ar1coefficients[1,5]
generate ar4_0 = ar4_neg1*beta1 + L2.pcepilfe_3rd*beta2 + L3.pcepilfe_3rd*beta3 + L4.pcepilfe_3rd*beta4 + alpha1 //current quarter prediction
generate ar4_1 = ar4_0*beta1 + ar4_neg1*beta2 + L2.pcepilfe_3rd*beta3 + L3.pcepilfe_3rd*beta4 + alpha1 //one quarter ahead prediction
*generate ar4_2 = ar4_1*beta1 + ar4_0*beta2 + ar4_neg1*beta3 + L2.pcepilfe_3rd*beta4 + alpha1 //two quarter ahead prediction

* Forecast errors, actual - predicted
generate ar1_neg1_fe = L.pcepilfe_3rd - ar1_neg1
generate ar1_0_fe = pcepilfe_3rd - ar1_0
generate ar1_1_fe = F.pcepilfe_3rd - ar1_1
*generate ar1_2_fe = F2.pcepilfe_3rd - ar1_2

generate ar4_neg1_fe = L.pcepilfe_3rd - ar4_neg1
generate ar4_0_fe = pcepilfe_3rd - ar4_0
generate ar4_1_fe = F.pcepilfe_3rd - ar4_1
*generate ar4_2_fe = F2.pcepilfe_3rd - ar4_2

* MSEs
egen mse_ar1_neg1 = mean(ar1_neg1_fe^2) if dateqtr > `endqtr'
egen mse_ar1_0 = mean(ar1_0_fe^2) if dateqtr > `endqtr'
egen mse_ar1_1 = mean(ar1_1_fe^2) if dateqtr > `endqtr'
*egen mse_ar1_2 = mean(ar1_2_fe^2) if dateqtr > `endqtr'

* RMSEs, format of the variable is rmse_model_horizon
generate rmse_ar1_neg1 = sqrt(mse_ar1_neg1) if dateqtr > `endqtr'
generate rmse_ar1_0 = sqrt(mse_ar1_0) if dateqtr > `endqtr'
generate rmse_ar1_1 = sqrt(mse_ar1_1) if dateqtr > `endqtr'
*generate rmse_ar1_2 = sqrt(mse_ar1_2) if dateqtr > `endqtr'

egen mse_ar4_neg1 = mean(ar4_neg1_fe^2) if dateqtr > `endqtr'
egen mse_ar4_0 = mean(ar4_0_fe^2) if dateqtr > `endqtr'
egen mse_ar4_1 = mean(ar4_1_fe^2) if dateqtr > `endqtr'
*egen mse_ar4_2 = mean(ar4_2_fe^2) if dateqtr > `endqtr'

	
generate rmse_ar4_neg1 = sqrt(mse_ar4_neg1) if dateqtr > `endqtr'
generate rmse_ar4_0 = sqrt(mse_ar4_0) if dateqtr > `endqtr'
generate rmse_ar4_1 = sqrt(mse_ar4_1) if dateqtr > `endqtr'
*generate rmse_ar4_2 = sqrt(mse_ar4_2) if dateqtr > `endqtr'
	


