%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This script reads data from the specified Excel spreadsheet 
% and calculates the growth dates if required before storing 
% the whole history and forecasts vintages by variable
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for i = 1:size(PARAMS.variables,2) % Iterate over variables
    
    % Import data and calculate growth rate if required
    
    if ~strcmp(PARAMS.variables(i),'lc')
    
        [num,txt] =  xlsread(PARAMS.spreadsheet,cell2mat(PARAMS.variables(i)),PARAMS.data_range);
    
    elseif strcmp(PARAMS.variables(i),'lc') % Define consumption data as the residual of GDP and other components
        
        [num,txt] =  xlsread(PARAMS.spreadsheet,'ly',PARAMS.data_range);
        numy = num;
        [num,txt] =  xlsread(PARAMS.spreadsheet,'li',PARAMS.data_range);
        numi = num;
        [num,txt] =  xlsread(PARAMS.spreadsheet,'lg',PARAMS.data_range);
        numg = num;
        [num,txt] =  xlsread(PARAMS.spreadsheet,'lx',PARAMS.data_range);
        numx = num;
        [num,txt] =  xlsread(PARAMS.spreadsheet,'lm',PARAMS.data_range);
        numm = num;
        
        num = log(exp(numy)-(exp(numi)+exp(numg)+exp(numx)-exp(numm)));
        
    end
        
    if strcmp(PARAMS.var_growth(i),'qq')

        RAWDATA_level = exp(num);
        RAWDATA = 400*(RAWDATA_level(2:end,:)./RAWDATA_level(1:end-1,:)-1);
        dates = datenum(txt(3:end,1),'dd/mm/yyyy');

    elseif strcmp(PARAMS.var_growth(i),'yy')

        RAWDATA_level = exp(num);
        RAWDATA = 100*(RAWDATA_level(5:end,:)./RAWDATA_level(1:end-4,:)-1);
        dates = datenum(txt(6:end,1),'dd/mm/yyyy');

    elseif strcmp(PARAMS.var_growth(i),'level')

        RAWDATA_level = 100*num;
        RAWDATA=RAWDATA_level(2:end,:);
        dates = datenum(txt(3:end,1),'dd/mm/yyyy');

    end

    % Convert dates

    [MonthNum,MonthString] = month(dates);
    Year = num2str(year(dates));
    quarters(:,1:5) = [lower(MonthString(:,:)) Year(:,3:4)];


    % Create data structures using data within the specified time range

    vintages = txt(1,end-size(RAWDATA,2)+1:end);

    first_vintage_index = find(strncmp(vintages, PARAMS.start, 5));
    last_vintage_index = find(strncmp(vintages, PARAMS.end, 5))+PARAMS.delay+(PARAMS.horizons-1); 



    if size(first_vintage_index,1)*size(first_vintage_index,2) == 0

        first_vintage_index = 1;

    end


    if size(last_vintage_index,1)*size(last_vintage_index,2) == 0

        last_vintage_index = size(vintages,2);

    end


    for j = first_vintage_index:last_vintage_index % Iterate over vintages
        
        DATA_level.(sprintf(cell2mat(PARAMS.variables(i)))).(sprintf(cell2mat(vintages(1,j)))){:,1} = quarters;
        DATA_level.(sprintf(cell2mat(PARAMS.variables(i)))).(sprintf(cell2mat(vintages(1,j)))){:,2} = RAWDATA_level(:,j);
        
        DATA.(sprintf(cell2mat(PARAMS.variables(i)))).(sprintf(cell2mat(vintages(1,j)))){:,1} = quarters;
        DATA.(sprintf(cell2mat(PARAMS.variables(i)))).(sprintf(cell2mat(vintages(1,j)))){:,2} = RAWDATA(:,j);

    end
    
    
    clearvars -except PARAMS DATA*  ERRORS_STATS* RMSE* *RATIO* vintages
    
end


% Import 3-month corporate paper rate final data

[num,txt] =  xlsread(PARAMS.spreadsheet,'corporate paper final');

corporate3mfinaltxt = txt;
corporate3mfinalnum = num;


% Import recession horizon dummy



[num,txt] =  xlsread(PARAMS.spreadsheet,'recession_dummy',PARAMS.data_range);

vintages = txt(1,1:end);
dummies = num(1:end,1);

first_vintage_index = find(strncmp(vintages, PARAMS.start, 5));
last_vintage_index = find(strncmp(vintages, PARAMS.end, 5))+PARAMS.delay; 


if size(first_vintage_index,1)*size(first_vintage_index,2) == 0

    first_vintage_index = 1;

end

if size(last_vintage_index,1)*size(last_vintage_index,2) == 0

    last_vintage_index = size(vintages,2);

end

for j = 2:size(num,2) % Iterate over vintages
    
    for k = 1:size(dummies,1)
    
        PARAMS.recession_dummy.(sprintf(cell2mat(vintages(1,j-1)))){k,1} = num(k,j);

    end
    
end



% Import sample horizon dummy


[num,txt] =  xlsread(PARAMS.spreadsheet,'sample_dummy',PARAMS.data_range);

vintages = txt(1,1:end);
dummies = num(1:end,1);

first_vintage_index = find(strncmp(vintages, PARAMS.start, 5));
last_vintage_index = find(strncmp(vintages, PARAMS.end, 5))+PARAMS.delay; 


if size(first_vintage_index,1)*size(first_vintage_index,2) == 0

    first_vintage_index = 1;

end

if size(last_vintage_index,1)*size(last_vintage_index,2) == 0

    last_vintage_index = size(vintages,2);

end

for j = 2:size(num,2) % Iterate over vintages
    
    for k = 1:size(dummies,1)
    
        PARAMS.subsamples.All.(sprintf(cell2mat(vintages(1,j-1)))){k,1} = num(k,j);

    end
    
end



% Import IT period horizon dummy


[num,txt] =  xlsread(PARAMS.spreadsheet,'IT_dummy',PARAMS.data_range);

vintages = txt(1,1:end);
dummies = num(1:end,1);

first_vintage_index = find(strncmp(vintages, PARAMS.start, 5));
last_vintage_index = find(strncmp(vintages, PARAMS.end, 5))+PARAMS.delay; 


if size(first_vintage_index,1)*size(first_vintage_index,2) == 0

    first_vintage_index = 1;

end

if size(last_vintage_index,1)*size(last_vintage_index,2) == 0

    last_vintage_index = size(vintages,2);

end

for j = 2:size(num,2) % Iterate over vintages
    
    for k = 1:size(dummies,1)
    
        PARAMS.subsamples.IT.(sprintf(cell2mat(vintages(1,j-1)))){k,1} = num(k,j);

    end
    
end



% Import pre-IT period horizon dummy


[num,txt] =  xlsread(PARAMS.spreadsheet,'pre-IT_dummy',PARAMS.data_range);

vintages = txt(1,1:end);
dummies = num(1:end,1);

first_vintage_index = find(strncmp(vintages, PARAMS.start, 5));
last_vintage_index = find(strncmp(vintages, PARAMS.end, 5))+PARAMS.delay; 


if size(first_vintage_index,1)*size(first_vintage_index,2) == 0

    first_vintage_index = 1;

end

if size(last_vintage_index,1)*size(last_vintage_index,2) == 0

    last_vintage_index = size(vintages,2);

end

for j = 2:size(num,2) % Iterate over vintages
    
    for k = 1:size(dummies,1)
    
        PARAMS.subsamples.preIT.(sprintf(cell2mat(vintages(1,j-1)))){k,1} = num(k,j);

    end
    
end



% Import expansion period horizon dummy


[num,txt] =  xlsread(PARAMS.spreadsheet,'expansion_dummy',PARAMS.data_range);

vintages = txt(1,1:end);
dummies = num(1:end,1);

first_vintage_index = find(strncmp(vintages, PARAMS.start, 5));
last_vintage_index = find(strncmp(vintages, PARAMS.end, 5))+PARAMS.delay; 


if size(first_vintage_index,1)*size(first_vintage_index,2) == 0

    first_vintage_index = 1;

end

if size(last_vintage_index,1)*size(last_vintage_index,2) == 0

    last_vintage_index = size(vintages,2);

end

for j = 2:size(num,2) % Iterate over vintages
    
    for k = 1:size(dummies,1)
    
        PARAMS.subsamples.expansion.(sprintf(cell2mat(vintages(1,j-1)))){k,1} = num(k,j);

    end
    
end





