%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This program is used to calculate different statistics on the
% Bank of Canada Staff's economic forecasts
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Sections descriptions:
%
% Section 1 - Choose subsample
% Delete observations outside of the sample of interest
%
% Section 2 - Calculate forecast errors
% Calculate revisions and different error statistics
%
% Section 3 - Evaluate forecast bias
% Evaluates forecast bias according to the set parameters
%
% Section 4 - Calculate Ratios
% Calculates forecast error variance to unconditional series variance ratios 
% as well as noise-to-signal ratios according to the set parameters
%
% Section 5 - Compare forecasts
% Calculates RMSE ratios between benchmarks and Staff as well as Diebold-Mariano statistics
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

                 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Section 1 - Choose subsample
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

methods = fieldnames(RT_DATA);

for i = 1:size(methods,1) % Iterate over forecast methods
    
    variables = fieldnames(RT_DATA.(sprintf(cell2mat(methods(i,1)))));
    
    for j = 1:size(variables,1) % Iterate over variables
                
        jumps = fieldnames(RT_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))));
        
        for k = 1:size(jumps,1) % Iterate over jump-off dates

            vintages = fieldnames(RT_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))));
            
            for l = 1:size(vintages,1) % Iterate over vintages
                
                for h = 1:PARAMS.horizons % Iterate over horizons

                    if ~cell2mat(PARAMS.subsamples.(sprintf(PARAMS.subsample)).(sprintf(cell2mat(vintages(l,:))))(h,1))

                        try

                            RT_DATA.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))).(sprintf(cell2mat(vintages(l,1))))(1,h) = NaN;

                            RT_DATA_level.(sprintf(cell2mat(methods(i,1)))).(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(jumps(k,1)))).(sprintf(cell2mat(vintages(l,1))))(1,h) = NaN;

                            FINAL_DATA_level.(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(vintages(l,1))))(1,h) = NaN;

                            FINAL_DATA.(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(vintages(l,1))))(1,h) = NaN;

                            FINAL_LAST_DATA_level.(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(vintages(l,1))))(1,h) = NaN;

                            FINAL_LAST_DATA.(sprintf(cell2mat(variables(j,1)))).(sprintf(cell2mat(vintages(l,1))))(1,h) = NaN;

                        end
                    
                    end
                
                end
                
            end

            
        end    
        
    end
    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Section 2 - Calculate forecast errors
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Compute_Errors

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Section 3 - Evaluate forecast bias
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if and(not(strcmp(PARAMS.subsample,'recession')), not(strcmp(PARAMS.subsample,'expansion')))

    Eval_Bias

    Eval_Bias_control_rec

end
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Section 4 - Calculate Ratios and descriptive statistics
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Compute_Ratios

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Section 5 - Compare forecasts
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Compare_forecasts



clear DATA_level

clearvars -except PARAMS RT_DATA FC_DATA *MSE*DATA VAR_RATIO*DATA NTS_RATIO*DATA ERRORS_STATS* REV_DATA_level *L_DATA REV*_DATA REV_DATA rmse_ratio dm_stats hln*stats sup_model_rate VAR_* COV_*
