%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This script uses any Y input series and extends it forward
% for 12 quarters using an out of sample dynamic simulation
% from a MSM(2)-AR(4) process
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function Y_extended = MS2AR4_projection(Y)

addpath('./Scripts/MS_Regress_Files');

p = 4;

Y_reg = Y(p+1:end,1);

X_reg(:,1) = ones(size(Y_reg,1),1);

for lags = 1:p

    X_reg(:,lags+1) = Y(1+(p-lags):end-lags,1);
    
end

dep=Y_reg;                          % Defining dependent variable from .mat file
indep=X_reg;                        % Defining some explanatory variables
k=2;                                % Number of States
S=[1 0 0 0 0 0];                    % Defining which parts of the equation will switch states (column 1 and variance only)
advOpt.distrib='Normal';            % The Distribution assumption ('Normal', 't' or 'GED')
advOpt.std_method=1;                % Defining the method for calculation of standard errors. See pdf file for more details

[Spec_Out]=MS_Regress_Fit(dep,indep,k,S,advOpt); % Estimating the model
close;

Beta(2:5,1) = Spec_Out.Coeff.nS_Param{1,1};

Y_extended = Y;

for h = 1:12
    
    ini = Spec_Out.filtProb(end,:)';
    trans = Spec_Out.Coeff.p;
    
    prob = (trans^(h-1)*ini);
    
    Beta(1,1) = prob(1)*Spec_Out.Coeff.S_Param{1,1}(1,1)+prob(2)*Spec_Out.Coeff.S_Param{1,1}(1,2); 

    
    Y_temp = Y_extended;
    Y_temp(end+1,1) = Beta(1);

    for lags = 1:p
        
        Y_temp(end,1) = Y_temp(end,1) + Beta(lags+1)*Y_temp(end-lags,1);
        Y_extended = Y_temp;  
        
    end    
    
    clear Y_temp
    
end

rmpath('./Scripts/MS_Regress_Files');

clear Y_reg X_reg Beta

end