%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This script uses the data structures generated by Gen_RT_benchmark_data
% to build various econometric real-time forecasts at different jump-off delays
% for the specified horizons sorted by variable and vintage
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%
% Using real-time data

% Univariate models

variables=fieldnames(DATA);

for i = 1:size(variables,1) % Iterate over variables
    
    for j = [PARAMS.jump_off 99] % Iterate over jump-off delays
        
        if j == 99
            
            j = 'final';
           
        else
            
            j = num2str(j);
            
        end
    
        all_vintages = fieldnames(DATA.(sprintf(cell2mat(variables(i,1)))));
        vintages = all_vintages(1:end-(PARAMS.delay+(PARAMS.horizons-1)),:);

        for k = 1:size(vintages,1) % Iterate over vintages
        
            
            Y = INPUT_bench_DATA.(sprintf(cell2mat(variables(i,1)))).(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1)))){:,2};
        
            
            % Find index of nowcast 
            x = find(strncmp(INPUT_bench_DATA.(sprintf(cell2mat(variables(i,1)))).(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1)))){1}, vintages(k,1), 5));
           
            % AR(4)
            
            p = 4;
            ARp_projection;
                       
            RT_DATA.AR4.(sprintf(cell2mat(variables(i,1)))).(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1))))(1,1:PARAMS.horizons) = ...
               Y_extended(x:x+PARAMS.horizons-1,1)';
            
            % AO-RW
            
            p = 4;
            AORWp_projection;
                       
            RT_DATA.AORW4.(sprintf(cell2mat(variables(i,1)))).(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1))))(1,1:PARAMS.horizons) = ...
               Y_extended(x:x+PARAMS.horizons-1,1)';
           
           if PARAMS.test_no_ML ~= 1 % Do not run this part if you want to test without ML estimation.
           
               % MSM(2)-AR(4) (for GDP growth and inflation and bank rate)
           
               if (strcmp(variables(i),'ly') | strcmp(variables(i),'lpcpi') | strcmp(variables(i),'lpcpix') | strcmp(variables(i),'bankrate')) 
               Y_extended = MS2AR4_projection(Y);

               RT_DATA.MS2AR4.(sprintf(cell2mat(variables(i,1)))).(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1))))(1,1:PARAMS.horizons) = ...
                  Y_extended(x:x+PARAMS.horizons-1,1)';

               end

               % UCSV (for inflation, gdp and bank rate)

               if (strcmp(variables(i),'lpcpi') | strcmp(variables(i),'lpcpix') | strcmp(variables(i),'ly') | strcmp(variables(i),'bankrate'))      
                   UCSV_projection;

                   RT_DATA.UCSV.(sprintf(cell2mat(variables(i,1)))).(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1))))(1,1:PARAMS.horizons) = ...
                   Y_extended(x:x+PARAMS.horizons-1,1)';

               end

           end
           
           
           % GDP growth PC (for inflation)
           
           if (strcmp(variables(i),'lpcpi') | strcmp(variables(i),'lpcpix'))      
               p = 4;
               Ygdp = INPUT_bench_DATA.ly.(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1)))){:,2};
               GPC_projection;
               
               RT_DATA.GPC.(sprintf(cell2mat(variables(i,1)))).(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1))))(1,1:PARAMS.horizons) = ...
               Y_extended(x:x+PARAMS.horizons-1,1)';
               
           end
           

           % Random walk (for interest rates)
           
           if (strcmp(variables(i),'bankrate'))      
               RW_projection;
               
               RT_DATA.RW.(sprintf(cell2mat(variables(i,1)))).(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1))))(1,1:PARAMS.horizons) = ...
               Y_extended(x:x+PARAMS.horizons-1,1)';
               
           end
           
           
           % 2 per cent target (for inflation)
           
           if (strcmp(variables(i),'lpcpi') | strcmp(variables(i),'lpcpix'))     
                              
               RT_DATA.TARGET.(sprintf(cell2mat(variables(i,1)))).(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1))))(1,1:PARAMS.horizons) = ...
               2*ones(1,PARAMS.horizons);
               
           end
            
        end
    
    end
    
end


% Multivariate models

% VAR(4): gdp, inf, bank rate

for j = [PARAMS.jump_off 99] % Iterate over jump-off delays

    all_vintages = fieldnames(DATA.(sprintf(cell2mat(variables(i,1)))));
    vintages = all_vintages(1:end-(PARAMS.delay+(PARAMS.horizons-1)),:);
    
    if j == 99

        j = 'final';

    else

        j = num2str(j);

    end

    for k = 1:size(vintages,1) % Iterate over vintages

        Ygdp = INPUT_bench_DATA.ly.(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1)))){:,2};
        Yinf = INPUT_bench_DATA.lpcpi.(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1)))){:,2};
        Ycoreinf = INPUT_bench_DATA.lpcpix.(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1)))){:,2};
        Yr   = INPUT_bench_DATA.bankrate.(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1)))){:,2};
        
        Ytot = [Ygdp Yinf Yr];
        Ycore = [Ygdp Ycoreinf Yr];

        % Find index of nowcast 
        x = find(strncmp(INPUT_bench_DATA.ly.(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1)))){1}, vintages(k,1), 5));

        % VAR

        p = 4;
        
        Y = Ytot;
        
        VARp_projection;

        RT_DATA.VAR.ly.(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1))))(1,1:PARAMS.horizons) = ...
           Y_extended(x:x+PARAMS.horizons-1,1)';
       
        RT_DATA.VAR.lpcpi.(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1))))(1,1:PARAMS.horizons) = ...
           Y_extended(x:x+PARAMS.horizons-1,2)';
       
        RT_DATA.VAR.bankrate.(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1))))(1,1:PARAMS.horizons) = ...
           Y_extended(x:x+PARAMS.horizons-1,3)';
       
       
       
       Y = Ycore;
       
        VARp_projection;

        RT_DATA.VARc.ly.(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1))))(1,1:PARAMS.horizons) = ...
           Y_extended(x:x+PARAMS.horizons-1,1)';
       
        RT_DATA.VARc.lpcpix.(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1))))(1,1:PARAMS.horizons) = ...
           Y_extended(x:x+PARAMS.horizons-1,2)';
       
        RT_DATA.VARc.bankrate.(strrep(strcat('jump_',j),'-','m')).(sprintf(cell2mat(vintages(k,1))))(1,1:PARAMS.horizons) = ...
           Y_extended(x:x+PARAMS.horizons-1,3)';

    end

end





clearvars -except DATA_level PARAMS RT_DATA* FINAL*_DATA*  ERRORS_STATS* RMSE* *RATIO* REV_DATA* vintages


