%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This script uses the data structures generated by Read_Data.m 
% to generate RT input data structures with different jump-off delays
% for later use in real-time econometric forecasting. 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

variables=fieldnames(DATA);

PARAMS.jump_off = -1:2;  % The first jump-off is at t-1. Therefore, stopping max_jump at 2 implies that the last
                  % Staff forecast on which the models are conditionned is t+2 for that jump off delay.

for i = 1:size(variables,1) % Iterate over variables
    
    all_vintages = fieldnames(DATA.(sprintf(cell2mat(variables(i,1)))));
    vintages = all_vintages(1:end-(PARAMS.delay+(PARAMS.horizons-1)),:);

    for j = 1:size(vintages,1) % Iterate over vintages               
        
        for k = PARAMS.jump_off % Iterate over jump-off delays
            
            x = k + find(strncmp(DATA.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(vintages(j,1)))){1}, vintages(j), 5));            
            
            % Dates
            INPUT_bench_DATA.(sprintf(cell2mat(variables(i,1)))).(strrep(strcat('jump_',num2str(k)),'-','m')).(sprintf(cell2mat(vintages(j,1)))){:,1} = ...
                     DATA.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(vintages(j,1)))){:,1};         
                 
            
            % INPUT Data
            INPUT_bench_DATA.(sprintf(cell2mat(variables(i,1)))).(strrep(strcat('jump_',num2str(k)),'-','m')).(sprintf(cell2mat(vintages(j,1)))){:,2} = ...
                     DATA.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(vintages(j,1)))){2}(1:x,1);                 
                 
        end
        
        
        
        % Conditionning on t-1 of final vintage
        
        k = -1;
        
        x = k + find(strncmp(DATA.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(vintages(j,1)))){1}, vintages(j), 5));            

        % Dates
        INPUT_bench_DATA.(sprintf(cell2mat(variables(i,1)))).jump_final.(sprintf(cell2mat(vintages(j,1)))){:,1} = ...
                 DATA.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(vintages(j,1)))){:,1};         


        % INPUT Data
        INPUT_bench_DATA.(sprintf(cell2mat(variables(i,1)))).jump_final.(sprintf(cell2mat(vintages(j,1)))){:,2} = ...
                 DATA.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(vintages(size(vintages,1),1)))){2}(1:x,1);  
            
             
             
    end
    
end

clearvars -except PARAMS DATA* RT_DATA* INPUT_DATA FINAL*_DATA*  ERRORS_STATS* RMSE* *RATIO* *bench* REV_DATA* vintages


