%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This script uses the data structures generated by Read_Data.m 
% to build real-time forecasts and final release data structures 
% for the specified horizons sorted by variable and vintage 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

variables=fieldnames(DATA);

for i = 1:size(variables,1) % Iterate over variables
    
    all_vintages = fieldnames(DATA.(sprintf(cell2mat(variables(i,1)))));
    vintages = all_vintages(1:end-(PARAMS.delay+(PARAMS.horizons-1)),:);

    for j = 1:size(vintages,1) % Iterate over vintages
        
        x = find(strncmp(DATA.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(vintages(j,1)))){1}, vintages(j), 5));
        
        RT_DATA.Staff.(sprintf(cell2mat(variables(i,1)))).jump_0.(sprintf(cell2mat(vintages(j,1))))(1,1:PARAMS.horizons) = ...
            DATA.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(vintages(j,1)))){2}(x:x+PARAMS.horizons-1,1)';
        
        RT_DATA_level.Staff.(sprintf(cell2mat(variables(i,1)))).jump_0.(sprintf(cell2mat(vintages(j,1))))(1,1:PARAMS.horizons) = ... % Normalise by gdp in march 73
            (DATA_level.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(vintages(j,1)))){2}(x:x+PARAMS.horizons-1,1)/ ...
            DATA_level.ly.(sprintf(cell2mat(vintages(j,1)))){2}(1,1))';
        
        
        RT_DATA.Staff.(sprintf(cell2mat(variables(i,1)))).jump_final.(sprintf(cell2mat(vintages(j,1))))(1,1:PARAMS.horizons) = ... % For final vintage exercise
            RT_DATA.Staff.(sprintf(cell2mat(variables(i,1)))).jump_0.(sprintf(cell2mat(vintages(j,1))))(1,1:PARAMS.horizons);
        
        RT_DATA_level.Staff.(sprintf(cell2mat(variables(i,1)))).jump_final.(sprintf(cell2mat(vintages(j,1))))(1,1:PARAMS.horizons) = ...
            RT_DATA_level.Staff.(sprintf(cell2mat(variables(i,1)))).jump_0.(sprintf(cell2mat(vintages(j,1))))(1,1:PARAMS.horizons);
        
        
        for k = 1:PARAMS.horizons % Iterate over horizons
        
            if j+(k-1) <= size(vintages,1)+(PARAMS.horizons-1)
        
                FINAL_DATA.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(vintages(j,1))))(1,k) = ...
                    DATA.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(all_vintages(j+(k-1)+PARAMS.delay,1)))){2}(x+k-1,1)';
                
                FINAL_DATA_level.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(vintages(j,1))))(1,k) = ...
                    (DATA_level.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(all_vintages(j+k+(PARAMS.delay-1),1)))){2}(x+k-1,1)/ ...
                    DATA_level.ly.(sprintf(cell2mat(all_vintages(j+k+-1+PARAMS.delay,1)))){2}(1,1))';
                
                FINAL_LAST_DATA.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(vintages(j,1))))(1,k) = ... % For final vintage exercise
                    DATA.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(all_vintages(end,1)))){2}(x+k-1,1)';
                
                FINAL_LAST_DATA_level.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(vintages(j,1))))(1,k) = ...
                    (DATA_level.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(all_vintages(end,1)))){2}(x+k-1,1)/ ...
                    DATA_level.ly.(sprintf(cell2mat(all_vintages(end,1)))){2}(1,1))';
                
                if strcmp(variables(i),'bankrate') % Use appropriate series as reference for period in which 3-month corporate paper rate is policy rate variable
                    
                    if j > 45 && j < 102
                    
                        
                        FINAL_LAST_DATA.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(vintages(j,1))))(1,k) = ... % For final vintage exercise
                            corporate3mfinalnum(x+k-1,1)';
                    
              
                    end
                end
                
            end
            
        end
    
    end
    
end

clearvars -except PARAMS DATA* RT_DATA* FINAL*_DATA*  ERRORS_STATS* RMSE* *RATIO* vintages


