%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This script uses any Y input series and extends it forward
% for 12 quarters using an out of sample dynamic simulation
% from an AR(p) process, augmented with a contemporary gdp growth
% regresssor.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Y_reg = Y(p+1:end,1);

X_reg(:,1) = ones(size(Y_reg,1),1);

for lags = 1:p

    X_reg(:,lags+1) = Y(1+(p-lags):end-lags,1);
    
end

% Add GDP growth regressor
X_reg(:,end+1)=Ygdp(p+1:end,1);



Beta = regress(Y_reg,X_reg);

Y_extended = Y;

for h = 1:9
    
    Y_temp = Y_extended;
    Y_temp(end+1,1) = Beta(1);

    for lags = 1:p
        
        Y_temp(end,1) = Y_temp(end,1) + Beta(lags+1)*Y_temp(end-lags,1);        
        
    end    
    
    Y_temp(end,1) = Y_temp(end,1) + Beta(p+2)*RT_DATA.Staff.ly.jump_0.(sprintf(cell2mat(vintages(k,1))))(1,h);
    Y_extended = Y_temp;  
    
    clear Y_temp
    
end

clear Y_reg X_reg Beta