%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This script uses the forecast errors generated
% by Compute_Errors.m to calculate forecast error variance
% ratios for each variable and forecast horizons 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

methods = fieldnames(RT_DATA);

for m = 1:size(methods,1) % Iterate over forecast methods

    
    variables=fieldnames(REV_DATA.(sprintf(cell2mat(methods(m,1)))));

    for i = 1:size(variables,1) % Iterate over variables

        
        jumps = fieldnames(REV_DATA.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))));        
        
        for j = 1:size(jumps,1) % Iterate over jump-off delays        

            vintages = fieldnames(REV_DATA.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1)))));
            
            ERRORS_DATA.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1))))(:,:) = NaN(size(vintages,1),PARAMS.horizons);
            FINALSERIES_DATA.(sprintf(cell2mat(variables(i,1))))(:,:) = NaN(size(vintages,1),PARAMS.horizons);
            
            for k = 1:size(vintages,1) % Iterate over vintages

                
                max_horizon = size(REV_DATA.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))). ...
                    (sprintf(cell2mat(jumps(j,1)))).(sprintf(cell2mat(vintages(k,1)))),2);

                for l = 1:max_horizon % Iterate over horizons

                    % Organise data

                    ERRORS_DATA.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1))))(k,l) = ...
                        REV_DATA.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1)))).(sprintf(cell2mat(vintages(k,1))))(1,l);
                
                    RT_MATRIX_DATA.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1))))(k,l) = ...
                        RT_DATA.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1)))).(sprintf(cell2mat(vintages(k,1))))(1,l);
                    
                    FINALSERIES_DATA.(sprintf(cell2mat(variables(i,1))))(k,l) = ...
                        FINAL_DATA.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(vintages(k,1))))(1,l);
                    
                    
                end
                
            end


            % Calculate ERROR VARIANCE RATIOS

            for l = 1:PARAMS.horizons % Iterate over horizons

                VAR_RATIO_DATA.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1))))(1,l) = ...
                    nanvar(ERRORS_DATA.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1))))(:,l))./nanvar(FINALSERIES_DATA.(sprintf(cell2mat(variables(i,1))))(:,l));

                NTS_RATIO_DATA.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1))))(1,l) = ...
                    RMSE_DATA.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1))))(1,l)./nanvar(FINALSERIES_DATA.(sprintf(cell2mat(variables(i,1))))(:,l));

            end
            
            
            
            % Calculate variance and covariance



            VAR_FORECAST.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1)))) = ...
                nanvar(RT_MATRIX_DATA.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1)))));

            VAR_FINAL.(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1)))) = ...
                nanvar(FINALSERIES_DATA.(sprintf(cell2mat(variables(i,1)))));

            VAR_ERRORS.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1)))) = ...
                nanvar(ERRORS_DATA.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1)))));
          
            for l = 1:PARAMS.horizons % Iterate over horizons
    
                
                cov = nancov(RT_MATRIX_DATA.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1))))(:,l),ERRORS_DATA.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1))))(:,l));

                COV_FORECAST_ERRORS.(sprintf(cell2mat(methods(m,1)))).(sprintf(cell2mat(variables(i,1)))).(sprintf(cell2mat(jumps(j,1))))(1,l) = cov(1,2)

            end
            

            
            
        end

    end

end

clearvars -except DATA_level PARAMS FC_DATA RT_DATA FINAL_DATA* REV_DATA* REV*_DATA *MSE* ERRORS_STATS* *RATIO* *L_DATA VAR_* COV_*


